/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.taxonomy;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.facet.taxonomy.DocValuesOrdinalsReader;
import org.apache.lucene.facet.taxonomy.FloatTaxonomyFacets;
import org.apache.lucene.facet.taxonomy.OrdinalsReader;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.docvalues.DoubleDocValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.IntsRef;

public class TaxonomyFacetSumValueSource
extends FloatTaxonomyFacets {
    private final OrdinalsReader ordinalsReader;

    public TaxonomyFacetSumValueSource(TaxonomyReader taxoReader, FacetsConfig config, FacetsCollector fc, ValueSource valueSource) throws IOException {
        this(new DocValuesOrdinalsReader("$facets"), taxoReader, config, fc, valueSource);
    }

    public TaxonomyFacetSumValueSource(OrdinalsReader ordinalsReader, TaxonomyReader taxoReader, FacetsConfig config, FacetsCollector fc, ValueSource valueSource) throws IOException {
        super(ordinalsReader.getIndexFieldName(), taxoReader, config);
        this.ordinalsReader = ordinalsReader;
        this.sumValues(fc.getMatchingDocs(), fc.getKeepScores(), valueSource);
    }

    private final void sumValues(List<FacetsCollector.MatchingDocs> matchingDocs, boolean keepScores, ValueSource valueSource) throws IOException {
        FakeScorer scorer = new FakeScorer();
        HashMap<String, FakeScorer> context = new HashMap<String, FakeScorer>();
        if (keepScores) {
            context.put("scorer", scorer);
        }
        IntsRef scratch = new IntsRef();
        for (FacetsCollector.MatchingDocs hits : matchingDocs) {
            int doc;
            OrdinalsReader.OrdinalsSegmentReader ords = this.ordinalsReader.getReader(hits.context);
            int scoresIdx = 0;
            float[] scores = hits.scores;
            FunctionValues functionValues = valueSource.getValues(context, hits.context);
            DocIdSetIterator docs = hits.bits.iterator();
            while ((doc = docs.nextDoc()) != Integer.MAX_VALUE) {
                ords.get(doc, scratch);
                if (keepScores) {
                    scorer.docID = doc;
                    scorer.score = scores[scoresIdx++];
                }
                float value = (float)functionValues.doubleVal(doc);
                for (int i = 0; i < scratch.length; ++i) {
                    int n = scratch.ints[i];
                    this.values[n] = this.values[n] + value;
                }
            }
        }
        this.rollup();
    }

    public static class ScoreValueSource
    extends ValueSource {
        public FunctionValues getValues(Map context, LeafReaderContext readerContext) throws IOException {
            final Scorer scorer = (Scorer)context.get("scorer");
            if (scorer == null) {
                throw new IllegalStateException("scores are missing; be sure to pass keepScores=true to FacetsCollector");
            }
            return new DoubleDocValues(this){

                public double doubleVal(int document) {
                    try {
                        return scorer.score();
                    }
                    catch (IOException exception) {
                        throw new RuntimeException(exception);
                    }
                }
            };
        }

        public boolean equals(Object o) {
            return o == this;
        }

        public int hashCode() {
            return System.identityHashCode((Object)this);
        }

        public String description() {
            return "score()";
        }
    }

    private static final class FakeScorer
    extends Scorer {
        float score;
        int docID;

        FakeScorer() {
            super(null);
        }

        public float score() throws IOException {
            return this.score;
        }

        public int freq() throws IOException {
            throw new UnsupportedOperationException();
        }

        public int docID() {
            return this.docID;
        }

        public int nextDoc() throws IOException {
            throw new UnsupportedOperationException();
        }

        public int advance(int target) throws IOException {
            throw new UnsupportedOperationException();
        }

        public long cost() {
            return 0L;
        }

        public Weight getWeight() {
            throw new UnsupportedOperationException();
        }

        public Collection<Scorer.ChildScorer> getChildren() {
            throw new UnsupportedOperationException();
        }
    }
}

