/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.geohash;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FilteredDocIdSet;
import org.apache.lucene.spatial.DistanceUtils;
import org.apache.lucene.spatial.geohash.GeoHashUtils;
import org.apache.lucene.spatial.tier.DistanceFilter;

public class GeoHashDistanceFilter
extends DistanceFilter {
    private static final long serialVersionUID = 1L;
    private double lat;
    private double lng;
    private String geoHashField;

    public GeoHashDistanceFilter(Filter startingFilter, double lat, double lng, double miles, String geoHashField) {
        super(startingFilter, miles);
        this.lat = lat;
        this.lng = lng;
        this.geoHashField = geoHashField;
    }

    public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
        final String[] geoHashValues = FieldCache.DEFAULT.getStrings(reader, this.geoHashField);
        final int docBase = this.nextDocBase;
        this.nextDocBase += reader.maxDoc();
        return new FilteredDocIdSet(this.startingFilter.getDocIdSet(reader)){

            public boolean match(int doc) {
                double d;
                String geoHash = geoHashValues[doc];
                double[] coords = GeoHashUtils.decode(geoHash);
                double x = coords[0];
                double y = coords[1];
                Double cachedDistance = (Double)GeoHashDistanceFilter.this.distanceLookupCache.get(geoHash);
                if (cachedDistance != null) {
                    d = cachedDistance;
                } else {
                    d = DistanceUtils.getDistanceMi(GeoHashDistanceFilter.this.lat, GeoHashDistanceFilter.this.lng, x, y);
                    GeoHashDistanceFilter.this.distanceLookupCache.put(geoHash, d);
                }
                if (d < GeoHashDistanceFilter.this.distance) {
                    GeoHashDistanceFilter.this.distances.put(doc + docBase, d);
                    return true;
                }
                return false;
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GeoHashDistanceFilter)) {
            return false;
        }
        GeoHashDistanceFilter other = (GeoHashDistanceFilter)((Object)o);
        return this.startingFilter.equals(other.startingFilter) && this.distance == other.distance && this.lat == other.lat && this.lng == other.lng && this.geoHashField.equals(other.geoHashField);
    }

    public int hashCode() {
        int h = Double.valueOf(this.distance).hashCode();
        h ^= this.startingFilter.hashCode();
        h ^= Double.valueOf(this.lat).hashCode();
        h ^= Double.valueOf(this.lng).hashCode();
        return h ^= this.geoHashField.hashCode();
    }
}

