/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.tier;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.Filter;
import org.apache.lucene.spatial.tier.DistanceFilter;

public class DistanceFieldComparatorSource
extends FieldComparatorSource {
    private static final long serialVersionUID = 1L;
    private DistanceFilter distanceFilter;
    private DistanceScoreDocLookupComparator dsdlc;

    public DistanceFieldComparatorSource(Filter distanceFilter) {
        this.distanceFilter = (DistanceFilter)distanceFilter;
    }

    public void cleanUp() {
        this.distanceFilter = null;
        if (this.dsdlc != null) {
            this.dsdlc.cleanUp();
        }
        this.dsdlc = null;
    }

    public FieldComparator newComparator(String fieldname, int numHits, int sortPos, boolean reversed) throws IOException {
        this.dsdlc = new DistanceScoreDocLookupComparator(numHits);
        return this.dsdlc;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DistanceScoreDocLookupComparator
    extends FieldComparator {
        private double[] values;
        private double bottom;
        private int offset = 0;

        public DistanceScoreDocLookupComparator(int numHits) {
            this.values = new double[numHits];
        }

        public int compare(int slot1, int slot2) {
            double a = this.values[slot1];
            double b = this.values[slot2];
            if (a > b) {
                return 1;
            }
            if (a < b) {
                return -1;
            }
            return 0;
        }

        public void cleanUp() {
            DistanceFieldComparatorSource.this.distanceFilter = null;
        }

        public int compareBottom(int doc) {
            double v2 = DistanceFieldComparatorSource.this.distanceFilter.getDistance(doc + this.offset);
            if (this.bottom > v2) {
                return 1;
            }
            if (this.bottom < v2) {
                return -1;
            }
            return 0;
        }

        public void copy(int slot, int doc) {
            this.values[slot] = DistanceFieldComparatorSource.this.distanceFilter.getDistance(doc + this.offset);
        }

        public void setBottom(int slot) {
            this.bottom = this.values[slot];
        }

        public void setNextReader(IndexReader reader, int docBase) throws IOException {
            this.offset = docBase;
        }

        public Comparable<Double> value(int slot) {
            return this.values[slot];
        }
    }
}

