/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial;

import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.Rectangle;
import com.spatial4j.core.shape.Shape;
import org.apache.lucene.document.Field;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.valuesource.ReciprocalFloatFunction;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.spatial.query.SpatialArgs;

public abstract class SpatialStrategy {
    protected final SpatialContext ctx;
    private final String fieldName;

    public SpatialStrategy(SpatialContext ctx, String fieldName) {
        if (ctx == null) {
            throw new IllegalArgumentException("ctx is required");
        }
        this.ctx = ctx;
        if (fieldName == null || fieldName.length() == 0) {
            throw new IllegalArgumentException("fieldName is required");
        }
        this.fieldName = fieldName;
    }

    public SpatialContext getSpatialContext() {
        return this.ctx;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public abstract Field[] createIndexableFields(Shape var1);

    public abstract ValueSource makeDistanceValueSource(Point var1);

    public Query makeQuery(SpatialArgs args) {
        return new ConstantScoreQuery(this.makeFilter(args));
    }

    public abstract Filter makeFilter(SpatialArgs var1);

    public final ValueSource makeRecipDistanceValueSource(Shape queryShape) {
        Rectangle bbox = queryShape.getBoundingBox();
        double diagonalDist = this.ctx.getDistCalc().distance(this.ctx.makePoint(bbox.getMinX(), bbox.getMinY()), bbox.getMaxX(), bbox.getMaxY());
        double distToEdge = diagonalDist * 0.5;
        float c = (float)distToEdge * 0.1f;
        return new ReciprocalFloatFunction(this.makeDistanceValueSource(queryShape.getCenter()), 1.0f, c, c);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " field:" + this.fieldName + " ctx=" + this.ctx;
    }
}

