/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.prefix;

import com.spatial4j.core.shape.Shape;
import com.spatial4j.core.shape.SpatialRelation;
import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.spatial.prefix.AbstractVisitingPrefixTreeFilter;
import org.apache.lucene.spatial.prefix.tree.Cell;
import org.apache.lucene.spatial.prefix.tree.SpatialPrefixTree;
import org.apache.lucene.util.BitDocIdSet;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.FixedBitSet;

public class IntersectsPrefixTreeFilter
extends AbstractVisitingPrefixTreeFilter {
    private final boolean hasIndexedLeaves;

    public IntersectsPrefixTreeFilter(Shape queryShape, String fieldName, SpatialPrefixTree grid, int detailLevel, int prefixGridScanLevel, boolean hasIndexedLeaves) {
        super(queryShape, fieldName, grid, detailLevel, prefixGridScanLevel);
        this.hasIndexedLeaves = hasIndexedLeaves;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && this.hasIndexedLeaves == ((IntersectsPrefixTreeFilter)((Object)o)).hasIndexedLeaves;
    }

    public DocIdSet getDocIdSet(LeafReaderContext context, Bits acceptDocs) throws IOException {
        return new AbstractVisitingPrefixTreeFilter.VisitorTemplate(context, acceptDocs, this.hasIndexedLeaves){
            private FixedBitSet results;

            @Override
            protected void start() {
                this.results = new FixedBitSet(this.maxDoc);
            }

            @Override
            protected DocIdSet finish() {
                return new BitDocIdSet((BitSet)this.results);
            }

            @Override
            protected boolean visit(Cell cell) throws IOException {
                if (cell.getShapeRel() == SpatialRelation.WITHIN || cell.getLevel() == IntersectsPrefixTreeFilter.this.detailLevel) {
                    this.collectDocs(this.results);
                    return false;
                }
                return true;
            }

            @Override
            protected void visitLeaf(Cell cell) throws IOException {
                this.collectDocs(this.results);
            }

            @Override
            protected void visitScanned(Cell cell) throws IOException {
                if (IntersectsPrefixTreeFilter.this.queryShape.relate(cell.getShape()).intersects()) {
                    this.collectDocs(this.results);
                }
            }
        }.getDocIdSet();
    }
}

