/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.spatial4j.geo3d;

import org.apache.lucene.spatial.spatial4j.geo3d.Bounds;
import org.apache.lucene.spatial.spatial4j.geo3d.GeoBBox;
import org.apache.lucene.spatial.spatial4j.geo3d.GeoBBoxBase;
import org.apache.lucene.spatial.spatial4j.geo3d.GeoBBoxFactory;
import org.apache.lucene.spatial.spatial4j.geo3d.GeoPoint;
import org.apache.lucene.spatial.spatial4j.geo3d.GeoShape;
import org.apache.lucene.spatial.spatial4j.geo3d.Membership;
import org.apache.lucene.spatial.spatial4j.geo3d.Plane;
import org.apache.lucene.spatial.spatial4j.geo3d.SidedPlane;
import org.apache.lucene.spatial.spatial4j.geo3d.Vector;

public class GeoRectangle
extends GeoBBoxBase {
    public final double topLat;
    public final double bottomLat;
    public final double leftLon;
    public final double rightLon;
    public final double cosMiddleLat;
    public final GeoPoint ULHC;
    public final GeoPoint URHC;
    public final GeoPoint LRHC;
    public final GeoPoint LLHC;
    public final SidedPlane topPlane;
    public final SidedPlane bottomPlane;
    public final SidedPlane leftPlane;
    public final SidedPlane rightPlane;
    public final GeoPoint[] topPlanePoints;
    public final GeoPoint[] bottomPlanePoints;
    public final GeoPoint[] leftPlanePoints;
    public final GeoPoint[] rightPlanePoints;
    public final GeoPoint centerPoint;
    public final GeoPoint[] edgePoints;

    public GeoRectangle(double topLat, double bottomLat, double leftLon, double rightLon) {
        if (topLat > 1.5707963267948966 || topLat < -1.5707963267948966) {
            throw new IllegalArgumentException("Top latitude out of range");
        }
        if (bottomLat > 1.5707963267948966 || bottomLat < -1.5707963267948966) {
            throw new IllegalArgumentException("Bottom latitude out of range");
        }
        if (topLat < bottomLat) {
            throw new IllegalArgumentException("Top latitude less than bottom latitude");
        }
        if (leftLon < -Math.PI || leftLon > Math.PI) {
            throw new IllegalArgumentException("Left longitude out of range");
        }
        if (rightLon < -Math.PI || rightLon > Math.PI) {
            throw new IllegalArgumentException("Right longitude out of range");
        }
        double extent = rightLon - leftLon;
        if (extent < 0.0) {
            extent += Math.PI * 2;
        }
        if (extent > Math.PI) {
            throw new IllegalArgumentException("Width of rectangle too great");
        }
        this.topLat = topLat;
        this.bottomLat = bottomLat;
        this.leftLon = leftLon;
        this.rightLon = rightLon;
        double sinTopLat = Math.sin(topLat);
        double cosTopLat = Math.cos(topLat);
        double sinBottomLat = Math.sin(bottomLat);
        double cosBottomLat = Math.cos(bottomLat);
        double sinLeftLon = Math.sin(leftLon);
        double cosLeftLon = Math.cos(leftLon);
        double sinRightLon = Math.sin(rightLon);
        double cosRightLon = Math.cos(rightLon);
        this.ULHC = new GeoPoint(sinTopLat, sinLeftLon, cosTopLat, cosLeftLon);
        this.URHC = new GeoPoint(sinTopLat, sinRightLon, cosTopLat, cosRightLon);
        this.LRHC = new GeoPoint(sinBottomLat, sinRightLon, cosBottomLat, cosRightLon);
        this.LLHC = new GeoPoint(sinBottomLat, sinLeftLon, cosBottomLat, cosLeftLon);
        double middleLat = (topLat + bottomLat) * 0.5;
        double sinMiddleLat = Math.sin(middleLat);
        this.cosMiddleLat = Math.cos(middleLat);
        while (leftLon > rightLon) {
            rightLon += Math.PI * 2;
        }
        double middleLon = (leftLon + rightLon) * 0.5;
        double sinMiddleLon = Math.sin(middleLon);
        double cosMiddleLon = Math.cos(middleLon);
        this.centerPoint = new GeoPoint(sinMiddleLat, sinMiddleLon, this.cosMiddleLat, cosMiddleLon);
        this.topPlane = new SidedPlane((Vector)this.centerPoint, sinTopLat);
        this.bottomPlane = new SidedPlane((Vector)this.centerPoint, sinBottomLat);
        this.leftPlane = new SidedPlane((Vector)this.centerPoint, cosLeftLon, sinLeftLon);
        this.rightPlane = new SidedPlane((Vector)this.centerPoint, cosRightLon, sinRightLon);
        this.topPlanePoints = new GeoPoint[]{this.ULHC, this.URHC};
        this.bottomPlanePoints = new GeoPoint[]{this.LLHC, this.LRHC};
        this.leftPlanePoints = new GeoPoint[]{this.ULHC, this.LLHC};
        this.rightPlanePoints = new GeoPoint[]{this.URHC, this.LRHC};
        this.edgePoints = new GeoPoint[]{this.ULHC};
    }

    @Override
    public GeoBBox expand(double angle) {
        double newTopLat = this.topLat + angle;
        double newBottomLat = this.bottomLat - angle;
        double currentLonSpan = this.rightLon - this.leftLon;
        if (currentLonSpan < 0.0) {
            currentLonSpan += Math.PI * 2;
        }
        double newLeftLon = this.leftLon - angle;
        double newRightLon = this.rightLon + angle;
        if (currentLonSpan + 2.0 * angle >= Math.PI * 2) {
            newLeftLon = -Math.PI;
            newRightLon = Math.PI;
        }
        return GeoBBoxFactory.makeGeoBBox(newTopLat, newBottomLat, newLeftLon, newRightLon);
    }

    @Override
    public boolean isWithin(Vector point) {
        return this.topPlane.isWithin(point) && this.bottomPlane.isWithin(point) && this.leftPlane.isWithin(point) && this.rightPlane.isWithin(point);
    }

    @Override
    public boolean isWithin(double x, double y, double z) {
        return this.topPlane.isWithin(x, y, z) && this.bottomPlane.isWithin(x, y, z) && this.leftPlane.isWithin(x, y, z) && this.rightPlane.isWithin(x, y, z);
    }

    @Override
    public double getRadius() {
        double centerAngle = (this.rightLon - (this.rightLon + this.leftLon) * 0.5) * this.cosMiddleLat;
        double topAngle = this.centerPoint.arcDistance(this.URHC);
        double bottomAngle = this.centerPoint.arcDistance(this.LLHC);
        return Math.max(centerAngle, Math.max(topAngle, bottomAngle));
    }

    @Override
    public GeoPoint[] getEdgePoints() {
        return this.edgePoints;
    }

    @Override
    public GeoPoint getCenter() {
        return this.centerPoint;
    }

    @Override
    public boolean intersects(Plane p, GeoPoint[] notablePoints, Membership ... bounds) {
        return p.intersects(this.topPlane, notablePoints, this.topPlanePoints, bounds, this.bottomPlane, this.leftPlane, this.rightPlane) || p.intersects(this.bottomPlane, notablePoints, this.bottomPlanePoints, bounds, this.topPlane, this.leftPlane, this.rightPlane) || p.intersects(this.leftPlane, notablePoints, this.leftPlanePoints, bounds, this.rightPlane, this.topPlane, this.bottomPlane) || p.intersects(this.rightPlane, notablePoints, this.rightPlanePoints, bounds, this.leftPlane, this.topPlane, this.bottomPlane);
    }

    @Override
    public Bounds getBounds(Bounds bounds) {
        if (bounds == null) {
            bounds = new Bounds();
        }
        bounds.addLatitudeZone(this.topLat).addLatitudeZone(this.bottomLat).addLongitudeSlice(this.leftLon, this.rightLon);
        return bounds;
    }

    @Override
    public int getRelationship(GeoShape path) {
        int insideRectangle = this.isShapeInsideBBox(path);
        if (insideRectangle == 1) {
            return 2;
        }
        boolean insideShape = path.isWithin(this.ULHC);
        if (insideRectangle == 0 && insideShape) {
            return 2;
        }
        if (path.intersects(this.topPlane, this.topPlanePoints, this.bottomPlane, this.leftPlane, this.rightPlane) || path.intersects(this.bottomPlane, this.bottomPlanePoints, this.topPlane, this.leftPlane, this.rightPlane) || path.intersects(this.leftPlane, this.leftPlanePoints, this.topPlane, this.bottomPlane, this.rightPlane) || path.intersects(this.rightPlane, this.rightPlanePoints, this.leftPlane, this.topPlane, this.bottomPlane)) {
            return 2;
        }
        if (insideRectangle == 0) {
            return 1;
        }
        if (insideShape) {
            return 0;
        }
        return 3;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof GeoRectangle)) {
            return false;
        }
        GeoRectangle other = (GeoRectangle)o;
        return other.ULHC.equals(this.ULHC) && other.LRHC.equals(this.LRHC);
    }

    public int hashCode() {
        int result = this.ULHC.hashCode();
        result = 31 * result + this.LRHC.hashCode();
        return result;
    }

    public String toString() {
        return "GeoRectangle: {toplat=" + this.topLat + "(" + this.topLat * 180.0 / Math.PI + "), bottomlat=" + this.bottomLat + "(" + this.bottomLat * 180.0 / Math.PI + "), leftlon=" + this.leftLon + "(" + this.leftLon * 180.0 / Math.PI + "), rightlon=" + this.rightLon + "(" + this.rightLon * 180.0 / Math.PI + ")}";
    }
}

