/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.wordnet;

import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.wordnet.SynonymMap;

public class SynonymTokenFilter
extends TokenFilter {
    public static final String SYNONYM_TOKEN_TYPE = "SYNONYM";
    private final SynonymMap synonyms;
    private final int maxSynonyms;
    private String[] stack = null;
    private int index = 0;
    private AttributeSource.State current = null;
    private int todo = 0;
    private TermAttribute termAtt;
    private TypeAttribute typeAtt;
    private PositionIncrementAttribute posIncrAtt;

    public SynonymTokenFilter(TokenStream input, SynonymMap synonyms, int maxSynonyms) {
        super(input);
        if (input == null) {
            throw new IllegalArgumentException("input must not be null");
        }
        if (synonyms == null) {
            throw new IllegalArgumentException("synonyms must not be null");
        }
        if (maxSynonyms < 0) {
            throw new IllegalArgumentException("maxSynonyms must not be negative");
        }
        this.synonyms = synonyms;
        this.maxSynonyms = maxSynonyms;
        this.termAtt = (TermAttribute)this.addAttribute(TermAttribute.class);
        this.typeAtt = (TypeAttribute)this.addAttribute(TypeAttribute.class);
        this.posIncrAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
    }

    public final boolean incrementToken() throws IOException {
        while (this.todo > 0 && this.index < this.stack.length) {
            if (!this.createToken(this.stack[this.index++], this.current)) continue;
            --this.todo;
            return true;
        }
        if (!this.input.incrementToken()) {
            return false;
        }
        this.stack = this.synonyms.getSynonyms(this.termAtt.term());
        if (this.stack.length > this.maxSynonyms) {
            SynonymTokenFilter.randomize(this.stack);
        }
        this.index = 0;
        this.current = this.captureState();
        this.todo = this.maxSynonyms;
        return true;
    }

    protected boolean createToken(String synonym, AttributeSource.State current) {
        this.restoreState(current);
        this.termAtt.setTermBuffer(synonym);
        this.typeAtt.setType(SYNONYM_TOKEN_TYPE);
        this.posIncrAtt.setPositionIncrement(0);
        return true;
    }

    private static void randomize(Object[] arr) {
        int seed = 1234567;
        int randomState = 4 * seed + 1;
        int len = arr.length;
        for (int i = 0; i < len - 1; ++i) {
            int r = (randomState *= 663608941) % (len - i);
            if (r < 0) {
                r = -r;
            }
            Object tmp = arr[i];
            arr[i] = arr[i + r];
            arr[i + r] = tmp;
        }
    }

    public void reset() throws IOException {
        super.reset();
        this.stack = null;
        this.index = 0;
        this.current = null;
        this.todo = 0;
    }
}

