/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.sql.DataSource;
import org.apache.metamodel.AbstractDataContext;
import org.apache.metamodel.BatchUpdateScript;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.MetaModelHelper;
import org.apache.metamodel.UpdateCallback;
import org.apache.metamodel.UpdateScript;
import org.apache.metamodel.UpdateableDataContext;
import org.apache.metamodel.data.DataSet;
import org.apache.metamodel.data.EmptyDataSet;
import org.apache.metamodel.data.MaxRowsDataSet;
import org.apache.metamodel.data.ScalarFunctionDataSet;
import org.apache.metamodel.jdbc.FetchSizeCalculator;
import org.apache.metamodel.jdbc.JdbcBatchUpdateCallback;
import org.apache.metamodel.jdbc.JdbcCompiledQuery;
import org.apache.metamodel.jdbc.JdbcCompiledQueryLease;
import org.apache.metamodel.jdbc.JdbcDataSet;
import org.apache.metamodel.jdbc.JdbcMetadataLoader;
import org.apache.metamodel.jdbc.JdbcSchema;
import org.apache.metamodel.jdbc.JdbcSimpleUpdateCallback;
import org.apache.metamodel.jdbc.JdbcUpdateCallback;
import org.apache.metamodel.jdbc.JdbcUtils;
import org.apache.metamodel.jdbc.MetadataLoader;
import org.apache.metamodel.jdbc.dialects.DB2QueryRewriter;
import org.apache.metamodel.jdbc.dialects.DefaultQueryRewriter;
import org.apache.metamodel.jdbc.dialects.H2QueryRewriter;
import org.apache.metamodel.jdbc.dialects.HiveQueryRewriter;
import org.apache.metamodel.jdbc.dialects.HsqldbQueryRewriter;
import org.apache.metamodel.jdbc.dialects.IQueryRewriter;
import org.apache.metamodel.jdbc.dialects.MysqlQueryRewriter;
import org.apache.metamodel.jdbc.dialects.OracleQueryRewriter;
import org.apache.metamodel.jdbc.dialects.PostgresqlQueryRewriter;
import org.apache.metamodel.jdbc.dialects.SQLServerQueryRewriter;
import org.apache.metamodel.jdbc.dialects.SQLiteQueryRewriter;
import org.apache.metamodel.query.AggregateFunction;
import org.apache.metamodel.query.CompiledQuery;
import org.apache.metamodel.query.Query;
import org.apache.metamodel.query.SelectItem;
import org.apache.metamodel.schema.ColumnType;
import org.apache.metamodel.schema.ColumnTypeImpl;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.SuperColumnType;
import org.apache.metamodel.schema.TableType;
import org.apache.metamodel.util.FileHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcDataContext
extends AbstractDataContext
implements UpdateableDataContext {
    public static final String SYSTEM_PROPERTY_BATCH_UPDATES = "metamodel.jdbc.batch.updates";
    public static final String SYSTEM_PROPERTY_CONVERT_LOBS = "metamodel.jdbc.convert.lobs";
    public static final String SYSTEM_PROPERTY_COMPILED_QUERY_POOL_MAX_SIZE = "metamodel.jdbc.compiledquery.pool.max.size";
    public static final String SYSTEM_PROPERTY_COMPILED_QUERY_POOL_MIN_EVICTABLE_IDLE_TIME_MILLIS = "metamodel.jdbc.compiledquery.pool.idle.timeout";
    public static final String SYSTEM_PROPERTY_COMPILED_QUERY_POOL_TIME_BETWEEN_EVICTION_RUNS_MILLIS = "metamodel.jdbc.compiledquery.pool.eviction.period.millis";
    public static final String DATABASE_PRODUCT_POSTGRESQL = "PostgreSQL";
    public static final String DATABASE_PRODUCT_MYSQL = "MySQL";
    public static final String DATABASE_PRODUCT_HSQLDB = "HSQL Database Engine";
    public static final String DATABASE_PRODUCT_H2 = "H2";
    public static final String DATABASE_PRODUCT_SQLSERVER = "Microsoft SQL Server";
    public static final String DATABASE_PRODUCT_DB2 = "DB2";
    public static final String DATABASE_PRODUCT_DB2_PREFIX = "DB2/";
    public static final String DATABASE_PRODUCT_ORACLE = "Oracle";
    public static final String DATABASE_PRODUCT_HIVE = "Apache Hive";
    public static final String DATABASE_PRODUCT_SQLITE = "SQLite";
    public static final ColumnType COLUMN_TYPE_CLOB_AS_STRING = new ColumnTypeImpl("CLOB", SuperColumnType.LITERAL_TYPE, String.class, true);
    public static final ColumnType COLUMN_TYPE_BLOB_AS_BYTES = new ColumnTypeImpl("BLOB", SuperColumnType.BINARY_TYPE, byte[].class, true);
    private static final Logger logger = LoggerFactory.getLogger(JdbcDataContext.class);
    private final FetchSizeCalculator _fetchSizeCalculator;
    private final Connection _connection;
    private final DataSource _dataSource;
    private final TableType[] _tableTypes;
    private final String _catalogName;
    private final boolean _singleConnection;
    private final MetadataLoader _metadataLoader;
    private IQueryRewriter _queryRewriter;
    private final String _databaseProductName;
    private final String _databaseVersion;
    private final String _identifierQuoteString;
    private final boolean _supportsBatchUpdates;
    private final boolean _isDefaultAutoCommit;
    private final boolean _usesCatalogsAsSchemas;

    public JdbcDataContext(DataSource dataSource, TableType[] tableTypes, String catalogName) {
        this(dataSource, null, tableTypes, catalogName);
    }

    public JdbcDataContext(Connection connection, TableType[] tableTypes, String catalogName) {
        this(null, connection, tableTypes, catalogName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JdbcDataContext(DataSource dataSource, Connection connection, TableType[] tableTypes, String catalogName) {
        this._dataSource = dataSource;
        this._connection = connection;
        this._tableTypes = tableTypes;
        this._catalogName = catalogName;
        this._singleConnection = this._dataSource == null;
        this._fetchSizeCalculator = new FetchSizeCalculator(0x1000000);
        boolean supportsBatchUpdates = false;
        String identifierQuoteString = null;
        String databaseProductName = null;
        String databaseVersion = null;
        boolean usesCatalogsAsSchemas = false;
        Connection con = this.getConnection();
        try {
            this._isDefaultAutoCommit = con.getAutoCommit();
        }
        catch (SQLException e) {
            throw JdbcUtils.wrapException(e, "determine auto-commit behaviour");
        }
        try {
            DatabaseMetaData metaData = con.getMetaData();
            supportsBatchUpdates = this.supportsBatchUpdates(metaData);
            try {
                identifierQuoteString = metaData.getIdentifierQuoteString();
                if (identifierQuoteString != null) {
                    identifierQuoteString = identifierQuoteString.trim();
                }
            }
            catch (SQLException e) {
                logger.warn("could not retrieve identifier quote string from database metadata", (Throwable)e);
            }
            usesCatalogsAsSchemas = this.usesCatalogsAsSchemas(metaData);
            try {
                databaseProductName = metaData.getDatabaseProductName();
                databaseVersion = metaData.getDatabaseProductVersion();
            }
            catch (SQLException e) {
                logger.warn("Could not retrieve metadata: " + e.getMessage());
            }
        }
        catch (SQLException e) {
            logger.debug("Unexpected exception during JdbcDataContext initialization", (Throwable)e);
        }
        finally {
            this.closeIfNecessary(con);
        }
        this._databaseProductName = databaseProductName;
        this._databaseVersion = databaseVersion;
        logger.debug("Database product name: {}", (Object)this._databaseProductName);
        if (DATABASE_PRODUCT_MYSQL.equals(this._databaseProductName)) {
            this.setQueryRewriter(new MysqlQueryRewriter(this));
        } else if (DATABASE_PRODUCT_POSTGRESQL.equals(this._databaseProductName)) {
            this.setQueryRewriter(new PostgresqlQueryRewriter(this));
        } else if (DATABASE_PRODUCT_ORACLE.equals(this._databaseProductName)) {
            this.setQueryRewriter(new OracleQueryRewriter(this));
        } else if (DATABASE_PRODUCT_SQLSERVER.equals(this._databaseProductName)) {
            this.setQueryRewriter(new SQLServerQueryRewriter(this));
        } else if (DATABASE_PRODUCT_DB2.equals(this._databaseProductName) || this._databaseProductName != null && this._databaseProductName.startsWith(DATABASE_PRODUCT_DB2_PREFIX)) {
            this.setQueryRewriter(new DB2QueryRewriter(this));
        } else if (DATABASE_PRODUCT_HSQLDB.equals(this._databaseProductName)) {
            this.setQueryRewriter(new HsqldbQueryRewriter(this));
        } else if (DATABASE_PRODUCT_H2.equals(this._databaseProductName)) {
            this.setQueryRewriter(new H2QueryRewriter(this));
        } else if (DATABASE_PRODUCT_HIVE.equals(this._databaseProductName)) {
            this.setQueryRewriter(new HiveQueryRewriter(this));
        } else if (DATABASE_PRODUCT_SQLITE.equals(this._databaseProductName)) {
            this.setQueryRewriter(new SQLiteQueryRewriter(this));
        } else {
            this.setQueryRewriter(new DefaultQueryRewriter(this));
        }
        this._supportsBatchUpdates = supportsBatchUpdates;
        this._identifierQuoteString = identifierQuoteString;
        this._usesCatalogsAsSchemas = usesCatalogsAsSchemas;
        this._metadataLoader = new JdbcMetadataLoader(this, this._usesCatalogsAsSchemas, this._identifierQuoteString);
    }

    public JdbcDataContext(Connection connection) {
        this(connection, TableType.DEFAULT_TABLE_TYPES, null);
    }

    public JdbcDataContext(DataSource dataSource) {
        this(dataSource, TableType.DEFAULT_TABLE_TYPES, null);
    }

    private boolean supportsBatchUpdates(DatabaseMetaData metaData) {
        if ("true".equals(System.getProperty(SYSTEM_PROPERTY_BATCH_UPDATES))) {
            return true;
        }
        if ("false".equals(System.getProperty(SYSTEM_PROPERTY_BATCH_UPDATES))) {
            return false;
        }
        try {
            return metaData.supportsBatchUpdates();
        }
        catch (Exception e) {
            logger.warn("Could not determine if driver support batch updates, returning false", (Throwable)e);
            return false;
        }
    }

    private boolean usesCatalogsAsSchemas(DatabaseMetaData metaData) {
        boolean result = true;
        ResultSet rs = null;
        try {
            rs = metaData.getSchemas();
            while (rs.next() && result) {
                result = false;
            }
        }
        catch (SQLException e) {
            throw JdbcUtils.wrapException(e, "retrieve schema and catalog metadata");
        }
        finally {
            this.close(null);
        }
        return result;
    }

    public CompiledQuery compileQuery(Query query) {
        return new JdbcCompiledQuery(this, query);
    }

    public DataSet executeQuery(CompiledQuery compiledQuery, Object ... values) {
        DataSet dataSet;
        int valueArrayLength;
        JdbcCompiledQuery jdbcCompiledQuery = (JdbcCompiledQuery)compiledQuery;
        Query query = jdbcCompiledQuery.getQuery();
        int countMatches = jdbcCompiledQuery.getParameters().size();
        if (countMatches != (valueArrayLength = values.length)) {
            throw new MetaModelException("Number of parameters in query and number of values does not match.");
        }
        JdbcCompiledQueryLease lease = jdbcCompiledQuery.borrowLease();
        try {
            dataSet = this.execute(lease.getConnection(), query, lease.getStatement(), jdbcCompiledQuery, lease, values);
        }
        catch (SQLException e) {
            jdbcCompiledQuery.returnLease(lease);
            throw JdbcUtils.wrapException(e, "execute compiled query");
        }
        catch (RuntimeException e) {
            jdbcCompiledQuery.returnLease(lease);
            throw e;
        }
        return dataSet;
    }

    private DataSet execute(Connection connection, Query query, Statement statement, JdbcCompiledQuery compiledQuery, JdbcCompiledQueryLease lease, Object[] values) throws SQLException, MetaModelException {
        Integer maxRows = query.getMaxRows();
        List selectItems = query.getSelectClause().getItems();
        if (maxRows != null && maxRows == 0) {
            return new EmptyDataSet(selectItems);
        }
        if (MetaModelHelper.containsNonSelectScalaFunctions((Query)query)) {
            throw new MetaModelException("Scalar functions outside of SELECT clause is not supported for JDBC databases. Query rejected: " + query);
        }
        for (SelectItem selectItem : selectItems) {
            AggregateFunction aggregateFunction = selectItem.getAggregateFunction();
            if (aggregateFunction == null || this._queryRewriter.isAggregateFunctionSupported(aggregateFunction)) continue;
            throw new MetaModelException("Aggregate function '" + aggregateFunction.getFunctionName() + "' is not supported on this JDBC database. Query rejected: " + query);
        }
        if (this._databaseProductName.equals(DATABASE_PRODUCT_POSTGRESQL)) {
            try {
                connection.setAutoCommit(false);
            }
            catch (Exception e) {
                logger.warn("Could not disable auto-commit (PostgreSQL specific hack)", (Throwable)e);
            }
        }
        ResultSet resultSet = null;
        List scalarFunctionSelectItems = MetaModelHelper.getScalarFunctionSelectItems((Iterable)selectItems);
        Iterator it = scalarFunctionSelectItems.iterator();
        while (it.hasNext()) {
            SelectItem selectItem = (SelectItem)it.next();
            if (!this._queryRewriter.isScalarFunctionSupported(selectItem.getScalarFunction())) continue;
            it.remove();
        }
        Integer firstRow = query.getFirstRow();
        boolean postProcessFirstRow = false;
        if (firstRow != null) {
            if (this._queryRewriter.isFirstRowSupported()) {
                logger.debug("First row property will be treated by query rewriter");
            } else {
                postProcessFirstRow = true;
            }
        }
        boolean postProcessMaxRows = false;
        if (maxRows != null) {
            if (postProcessFirstRow) {
                maxRows = maxRows + (firstRow - 1);
                query = query.clone().setMaxRows(maxRows);
                logger.debug("Setting Max rows to {} because of post processing strategy of First row.", (Object)maxRows);
            }
            if (this._queryRewriter.isMaxRowsSupported()) {
                logger.debug("Max rows property will be treated by query rewriter");
            } else {
                try {
                    statement.setMaxRows(maxRows);
                }
                catch (SQLException e) {
                    if (logger.isInfoEnabled()) {
                        logger.info("setMaxRows(" + maxRows + ") was rejected.", (Throwable)e);
                    }
                    postProcessMaxRows = true;
                }
            }
        }
        JdbcDataSet dataSet = null;
        try {
            int fetchSize = this.getFetchSize(query, statement);
            logger.debug("Applying fetch_size={}", (Object)fetchSize);
            try {
                statement.setFetchSize(fetchSize);
            }
            catch (Exception e) {
                logger.info("Could not get or set fetch size on Statement: {}", (Object)e.getMessage());
            }
            if (lease == null) {
                String queryString = this._queryRewriter.rewriteQuery(query);
                logger.debug("Executing rewritten query: {}", (Object)queryString);
                resultSet = statement.executeQuery(queryString);
            } else {
                PreparedStatement preparedStatement = (PreparedStatement)statement;
                for (int i = 0; i < values.length; ++i) {
                    preparedStatement.setObject(i + 1, values[i]);
                }
                resultSet = preparedStatement.executeQuery();
            }
            try {
                resultSet.setFetchSize(fetchSize);
            }
            catch (Exception e) {
                logger.warn("Could not set fetch size on ResultSet: {}", (Object)e.getMessage());
            }
            if (postProcessFirstRow) {
                for (int i = 1; i < firstRow; ++i) {
                    if (resultSet.next()) continue;
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    return new EmptyDataSet(selectItems);
                }
            }
            dataSet = lease == null ? new JdbcDataSet(query, this, connection, statement, resultSet) : new JdbcDataSet(compiledQuery, lease, resultSet);
            if (postProcessMaxRows) {
                dataSet = new MaxRowsDataSet((DataSet)dataSet, maxRows.intValue());
            }
            if (!scalarFunctionSelectItems.isEmpty()) {
                dataSet = new ScalarFunctionDataSet(scalarFunctionSelectItems, (DataSet)dataSet);
                dataSet = MetaModelHelper.getSelection((List)selectItems, (DataSet)dataSet);
            }
        }
        catch (SQLException exception) {
            if (resultSet != null) {
                resultSet.close();
            }
            throw exception;
        }
        return dataSet;
    }

    public DataSet executeQuery(Query query) throws MetaModelException {
        DataSet dataSet;
        Statement statement;
        Connection connection = this.getConnection();
        try {
            statement = connection.createStatement(1003, 1007);
        }
        catch (SQLException e) {
            throw JdbcUtils.wrapException(e, "create statement for query");
        }
        try {
            dataSet = this.execute(connection, query, statement, null, null, null);
        }
        catch (SQLException e) {
            this.close(connection);
            throw JdbcUtils.wrapException(e, "execute query");
        }
        catch (RuntimeException e) {
            this.close(connection);
            throw e;
        }
        return dataSet;
    }

    private int getFetchSize(Query query, Statement statement) {
        try {
            int defaultFetchSize = statement.getFetchSize();
            if (DATABASE_PRODUCT_MYSQL.equals(this._databaseProductName) && defaultFetchSize == Integer.MIN_VALUE) {
                return defaultFetchSize;
            }
        }
        catch (Exception e) {
            logger.debug("Ignoring exception while getting fetch size", (Throwable)e);
        }
        return this._fetchSizeCalculator.getFetchSize(query);
    }

    public void close(Connection connection) {
        this.closeIfNecessary(connection);
    }

    @Deprecated
    public void close(Connection connection, ResultSet rs, Statement st) {
        this.close(connection);
        FileHelper.safeClose((Object[])new Object[]{rs, st});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getCatalogNames() {
        Connection connection = this.getConnection();
        DatabaseMetaData metaData = null;
        ResultSet rs = null;
        try {
            metaData = connection.getMetaData();
        }
        catch (SQLException e) {
            throw JdbcUtils.wrapException(e, "retrieve metadata");
        }
        logger.debug("Retrieving catalogs");
        ArrayList<String> catalogs = new ArrayList<String>();
        try {
            rs = metaData.getCatalogs();
            while (rs.next()) {
                String catalogName = rs.getString(1);
                logger.debug("Found catalogName: {}", (Object)catalogName);
                catalogs.add(catalogName);
            }
        }
        catch (SQLException e) {
            logger.error("Error retrieving catalog metadata", (Throwable)e);
        }
        finally {
            this.close(connection);
            logger.debug("Retrieved {} catalogs", (Object)catalogs.size());
        }
        return catalogs.toArray(new String[catalogs.size()]);
    }

    public Object getDelegate() {
        if (this._dataSource == null) {
            return this._connection;
        }
        return this._dataSource;
    }

    public Connection getConnection() {
        if (this._dataSource == null) {
            return this._connection;
        }
        try {
            return this._dataSource.getConnection();
        }
        catch (SQLException e) {
            throw JdbcUtils.wrapException(e, "establish connection");
        }
    }

    private void closeIfNecessary(Connection con) {
        if (con != null && this._dataSource != null) {
            FileHelper.safeClose((Object[])new Object[]{con});
        }
    }

    public String getDefaultSchemaName() {
        boolean found = false;
        String result = null;
        String[] schemaNames = this.getSchemaNames();
        if (schemaNames.length == 1) {
            result = schemaNames[0];
            found = true;
        }
        if (!found) {
            block23: {
                Connection connection = this.getConnection();
                try {
                    String username;
                    block24: {
                        DatabaseMetaData metaData = connection.getMetaData();
                        if (!found) {
                            StringTokenizer st;
                            int tokenCount;
                            String url;
                            block22: {
                                url = null;
                                try {
                                    url = metaData.getURL();
                                }
                                catch (SQLException e) {
                                    if (DATABASE_PRODUCT_HIVE.equals(this._databaseProductName)) break block22;
                                    throw e;
                                }
                            }
                            if (url != null && url.length() > 0 && schemaNames.length > 0 && (tokenCount = (st = new StringTokenizer(url, "/\\:")).countTokens()) > 0) {
                                for (int i = 1; i < tokenCount; ++i) {
                                    st.nextToken();
                                }
                                String lastToken = st.nextToken();
                                for (int i = 0; i < schemaNames.length && !found; ++i) {
                                    String schemaName = schemaNames[i];
                                    if (lastToken.indexOf(schemaName) == -1) continue;
                                    result = schemaName;
                                    found = true;
                                }
                            }
                        }
                        if (found) break block23;
                        username = null;
                        try {
                            username = metaData.getUserName();
                        }
                        catch (SQLException e) {
                            if (DATABASE_PRODUCT_HIVE.equals(this._databaseProductName)) break block24;
                            throw e;
                        }
                    }
                    if (username != null) {
                        for (int i = 0; i < schemaNames.length && !found; ++i) {
                            if (!username.equalsIgnoreCase(schemaNames[i])) continue;
                            result = schemaNames[i];
                            found = true;
                        }
                    }
                }
                catch (SQLException e) {
                    throw JdbcUtils.wrapException(e, "determine default schema name");
                }
                finally {
                    this.closeIfNecessary(connection);
                }
            }
            if (!found) {
                if (DATABASE_PRODUCT_POSTGRESQL.equalsIgnoreCase(this._databaseProductName)) {
                    result = this._catalogName == null ? "public" : this._catalogName;
                    found = true;
                }
                if (DATABASE_PRODUCT_HSQLDB.equalsIgnoreCase(this._databaseProductName)) {
                    result = this.findDefaultSchema("PUBLIC", schemaNames);
                }
                if (DATABASE_PRODUCT_SQLSERVER.equals(this._databaseProductName)) {
                    result = this.findDefaultSchema("dbo", schemaNames);
                }
                if (DATABASE_PRODUCT_HIVE.equals(this._databaseProductName)) {
                    result = this.findDefaultSchema("default", schemaNames);
                }
            }
        }
        return result;
    }

    private String findDefaultSchema(String defaultName, String[] schemaNames) {
        for (String schemaName : schemaNames) {
            if (!defaultName.equals(schemaName)) continue;
            return schemaName;
        }
        return null;
    }

    private Set<String> getSchemaSQLServerNames(DatabaseMetaData metaData) throws SQLException {
        HashSet<String> schemas = new HashSet<String>();
        ResultSet rs = metaData.getTables(this._catalogName, null, null, JdbcUtils.getTableTypesAsStrings(this._tableTypes));
        while (rs.next()) {
            schemas.add(rs.getString("TABLE_SCHEM"));
        }
        return schemas;
    }

    public JdbcDataContext setQueryRewriter(IQueryRewriter queryRewriter) {
        if (queryRewriter == null) {
            throw new IllegalArgumentException("Query rewriter cannot be null");
        }
        this._queryRewriter = queryRewriter;
        return this;
    }

    public IQueryRewriter getQueryRewriter() {
        return this._queryRewriter;
    }

    public String getIdentifierQuoteString() {
        return this._identifierQuoteString;
    }

    protected String[] getSchemaNamesInternal() {
        Connection connection = this.getConnection();
        try {
            DatabaseMetaData metaData = connection.getMetaData();
            Collection<Object> result = new ArrayList();
            if (DATABASE_PRODUCT_SQLSERVER.equals(this._databaseProductName)) {
                result = this.getSchemaSQLServerNames(metaData);
            } else if (this._usesCatalogsAsSchemas) {
                String[] catalogNames;
                for (String name : catalogNames = this.getCatalogNames()) {
                    logger.debug("Found catalogName: {}", (Object)name);
                    result.add(name);
                }
            } else {
                ResultSet rs = metaData.getSchemas();
                while (rs.next()) {
                    String schemaName = rs.getString(1);
                    logger.debug("Found schemaName: {}", (Object)schemaName);
                    result.add(schemaName);
                }
                rs.close();
            }
            if (DATABASE_PRODUCT_MYSQL.equals(this._databaseProductName)) {
                result.remove("information_schema");
            }
            if (result.isEmpty()) {
                logger.info("No schemas or catalogs found. Creating unnamed schema.");
                result.add(null);
            }
            String[] stringArray = result.toArray(new String[result.size()]);
            return stringArray;
        }
        catch (SQLException e) {
            throw JdbcUtils.wrapException(e, "get schema names");
        }
        finally {
            this.closeIfNecessary(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Schema getSchemaByNameInternal(String name) {
        JdbcSchema schema = new JdbcSchema(name, this._metadataLoader);
        Connection connection = this.getConnection();
        try {
            this._metadataLoader.loadTables(schema, connection);
        }
        finally {
            this.close(connection);
        }
        return schema;
    }

    public FetchSizeCalculator getFetchSizeCalculator() {
        return this._fetchSizeCalculator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeUpdate(UpdateScript update) {
        JdbcUpdateCallback updateCallback = this._supportsBatchUpdates && update instanceof BatchUpdateScript ? new JdbcBatchUpdateCallback(this) : new JdbcSimpleUpdateCallback(this);
        try {
            if (this.isSingleConnection() && this.isDefaultAutoCommit()) {
                Connection connection = this._connection;
                synchronized (connection) {
                    update.run((UpdateCallback)updateCallback);
                }
            } else {
                update.run((UpdateCallback)updateCallback);
            }
            updateCallback.close(true);
        }
        catch (RuntimeException e) {
            updateCallback.close(false);
            throw e;
        }
    }

    protected boolean isSingleConnection() {
        return this._singleConnection;
    }

    protected boolean isDefaultAutoCommit() {
        return this._isDefaultAutoCommit;
    }

    protected boolean isQualifiedPathDelim(char c) {
        if (this._identifierQuoteString == null || this._identifierQuoteString.length() == 0) {
            return super.isQualifiedPathDelim(c);
        }
        return c == '.' || c == this._identifierQuoteString.charAt(0);
    }

    public TableType[] getTableTypes() {
        return this._tableTypes;
    }

    public String getCatalogName() {
        return this._catalogName;
    }

    public String getDatabaseProductName() {
        return this._databaseProductName;
    }

    public String getDatabaseVersion() {
        return this._databaseVersion;
    }
}

