/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.metamodel.ConnectionException;
import org.apache.metamodel.DataContext;
import org.apache.metamodel.factory.DataContextFactory;
import org.apache.metamodel.factory.DataContextProperties;
import org.apache.metamodel.factory.ResourceFactoryRegistry;
import org.apache.metamodel.jdbc.JdbcDataContext;
import org.apache.metamodel.schema.TableType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcDataContextFactory
implements DataContextFactory {
    private static final Logger logger = LoggerFactory.getLogger(JdbcDataContextFactory.class);
    public static final String PROPERTY_TYPE = "jdbc";

    public boolean accepts(DataContextProperties properties, ResourceFactoryRegistry resourceFactoryRegistry) {
        return PROPERTY_TYPE.equals(properties.getDataContextType());
    }

    public DataContext create(DataContextProperties properties, ResourceFactoryRegistry resourceFactoryRegistry) throws ConnectionException {
        Connection connection;
        String driverClassName = properties.getDriverClassName();
        if (driverClassName != null) {
            try {
                Class.forName(driverClassName);
            }
            catch (ClassNotFoundException e) {
                logger.warn("Failed to initialize driver class: {}", (Object)driverClassName, (Object)e);
            }
        }
        TableType[] tableTypes = properties.getTableTypes() == null ? TableType.DEFAULT_TABLE_TYPES : properties.getTableTypes();
        String catalogName = properties.getCatalogName();
        DataSource dataSource = properties.getDataSource();
        if (dataSource != null) {
            return new JdbcDataContext(dataSource, tableTypes, catalogName);
        }
        String url = properties.getUrl();
        String username = properties.getUsername();
        String password = properties.getPassword();
        try {
            connection = username != null ? DriverManager.getConnection(url, username, password) : DriverManager.getConnection(url);
        }
        catch (SQLException e) {
            throw new ConnectionException("Failed to open JDBC connection from URL: " + url, (Exception)e);
        }
        return new JdbcDataContext(connection, tableTypes, catalogName);
    }
}

