/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.jdbc;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.delete.AbstractRowDeletionBuilder;
import org.apache.metamodel.jdbc.JdbcUpdateCallback;
import org.apache.metamodel.jdbc.JdbcUtils;
import org.apache.metamodel.jdbc.dialects.IQueryRewriter;
import org.apache.metamodel.query.FilterItem;
import org.apache.metamodel.query.FromItem;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.util.FileHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class JdbcDeleteBuilder
extends AbstractRowDeletionBuilder {
    private static final Logger logger = LoggerFactory.getLogger(JdbcDeleteBuilder.class);
    private final JdbcUpdateCallback _updateCallback;
    private final IQueryRewriter _queryRewriter;
    private final boolean _inlineValues;

    public JdbcDeleteBuilder(JdbcUpdateCallback updateCallback, Table table, IQueryRewriter queryRewriter) {
        this(updateCallback, table, queryRewriter, false);
    }

    public JdbcDeleteBuilder(JdbcUpdateCallback updateCallback, Table table, IQueryRewriter queryRewriter, boolean inlineValues) {
        super(table);
        this._updateCallback = updateCallback;
        this._queryRewriter = queryRewriter;
        this._inlineValues = inlineValues;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() throws MetaModelException {
        String sql = this.createSqlStatement();
        logger.debug("Delete statement created: {}", (Object)sql);
        boolean reuseStatement = !this._inlineValues;
        PreparedStatement st = this._updateCallback.getPreparedStatement(sql, reuseStatement);
        try {
            if (reuseStatement) {
                int valueCounter = 1;
                List whereItems = this.getWhereItems();
                for (FilterItem whereItem : whereItems) {
                    if (!JdbcUtils.isPreparedParameterCandidate(whereItem)) continue;
                    Object operand = whereItem.getOperand();
                    this._queryRewriter.setStatementParameter(st, valueCounter, whereItem.getSelectItem().getColumn(), operand);
                    ++valueCounter;
                }
            }
            this._updateCallback.executePreparedStatement(st, reuseStatement);
            if (!this._inlineValues) return;
        }
        catch (SQLException e) {
            try {
                throw JdbcUtils.wrapException(e, "execute delete statement: " + sql);
            }
            catch (Throwable throwable) {
                if (!this._inlineValues) throw throwable;
                FileHelper.safeClose((Object[])new Object[]{st});
                throw throwable;
            }
        }
        FileHelper.safeClose((Object[])new Object[]{st});
        return;
    }

    protected String createSqlStatement() {
        StringBuilder sb = new StringBuilder();
        sb.append("DELETE FROM ");
        sb.append(this._queryRewriter.rewriteFromItem(new FromItem(this.getTable())));
        sb.append(JdbcUtils.createWhereClause(this.getWhereItems(), this._queryRewriter, this._inlineValues));
        return sb.toString();
    }
}

