/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.jdbc;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.metamodel.DataContext;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.data.AbstractDataSet;
import org.apache.metamodel.data.DataSet;
import org.apache.metamodel.data.Row;
import org.apache.metamodel.data.WrappingDataSet;
import org.apache.metamodel.query.Query;
import org.apache.metamodel.query.SelectItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SplitQueriesDataSet
extends AbstractDataSet
implements WrappingDataSet {
    private static final Logger logger = LoggerFactory.getLogger(SplitQueriesDataSet.class);
    private final DataContext _dataContext;
    private Iterator<Query> _queryIterator;
    private DataSet _currentDataSet;
    private int _queryIndex = 0;

    public SplitQueriesDataSet(DataContext dataContext, List<Query> splitQueries) {
        super(SplitQueriesDataSet.getSelectItems(splitQueries));
        if (dataContext == null || splitQueries == null) {
            throw new IllegalArgumentException("Arguments cannot be null");
        }
        this._dataContext = dataContext;
        this._queryIterator = splitQueries.iterator();
    }

    private static List<SelectItem> getSelectItems(List<Query> splitQueries) {
        if (splitQueries.isEmpty()) {
            return new ArrayList<SelectItem>(0);
        }
        return splitQueries.get(0).getSelectClause().getItems();
    }

    public DataSet getWrappedDataSet() {
        return this._currentDataSet;
    }

    public void close() {
        if (this._currentDataSet != null) {
            logger.debug("currentDataSet.close()");
            this._currentDataSet.close();
        }
        this._currentDataSet = null;
        this._queryIterator = null;
    }

    public Row getRow() throws MetaModelException {
        if (this._currentDataSet != null) {
            return this._currentDataSet.getRow();
        }
        throw new IllegalStateException("No rows available. Either DataSet is closed or next() hasn't been called");
    }

    public boolean next() {
        boolean result = this._currentDataSet == null ? false : this._currentDataSet.next();
        if (!result && this._queryIterator.hasNext()) {
            if (this._currentDataSet != null) {
                logger.debug("currentDataSet.close()");
                this._currentDataSet.close();
            }
            Query q = this._queryIterator.next();
            this._currentDataSet = this._dataContext.executeQuery(q);
            if (logger.isDebugEnabled()) {
                ++this._queryIndex;
                logger.debug("Executing query #{}", (Object)this._queryIndex);
            }
            result = this.next();
        }
        return result;
    }
}

