/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.jdbc.dialects;

import org.apache.metamodel.jdbc.JdbcDataContext;
import org.apache.metamodel.jdbc.dialects.DefaultQueryRewriter;
import org.apache.metamodel.query.Query;

public abstract class OffsetFetchQueryRewriter
extends DefaultQueryRewriter {
    private final String databaseProductName;
    private final int databaseSupportedVersion;

    public OffsetFetchQueryRewriter(JdbcDataContext dataContext, int minSupportedVersion) {
        super(dataContext);
        this.databaseProductName = dataContext.getDatabaseProductName();
        this.databaseSupportedVersion = minSupportedVersion;
    }

    @Override
    public final boolean isFirstRowSupported() {
        return true;
    }

    @Override
    public final boolean isMaxRowsSupported() {
        return true;
    }

    @Override
    public String rewriteQuery(Query query) {
        String queryString = super.rewriteQuery(query);
        if (this.isSupportedVersion(this.databaseProductName, this.databaseSupportedVersion)) {
            Integer maxRows = query.getMaxRows();
            Integer firstRow = query.getFirstRow();
            if (maxRows != null && firstRow != null && queryString.indexOf("ORDER BY") >= 0) {
                queryString = queryString.replaceAll("TOP [0-9]+", "");
                queryString = queryString + " OFFSET " + (firstRow - 1) + " ROWS FETCH NEXT " + maxRows + " ROWS ONLY";
            }
        }
        return queryString;
    }
}

