/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.jdbc.dialects;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.apache.metamodel.jdbc.JdbcDataContext;
import org.apache.metamodel.jdbc.dialects.LimitOffsetQueryRewriter;
import org.apache.metamodel.query.FromItem;
import org.apache.metamodel.query.Query;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.ColumnType;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.Table;
import org.postgresql.util.PGobject;

public class PostgresqlQueryRewriter
extends LimitOffsetQueryRewriter {
    private final ObjectMapper jsonObjectMapper = new ObjectMapper();

    public PostgresqlQueryRewriter(JdbcDataContext dataContext) {
        super(dataContext);
    }

    @Override
    public ColumnType getColumnType(int jdbcType, String nativeType, Integer columnSize) {
        if (nativeType != null) {
            switch (nativeType) {
                case "bool": {
                    return ColumnType.BOOLEAN;
                }
                case "json": 
                case "jsonb": {
                    return ColumnType.MAP;
                }
            }
        }
        return super.getColumnType(jdbcType, nativeType, columnSize);
    }

    @Override
    public String rewriteColumnType(ColumnType columnType, Integer columnSize) {
        if (columnType == ColumnType.BLOB) {
            return "bytea";
        }
        if (columnType == ColumnType.BIT) {
            return "BOOLEAN";
        }
        if (columnType == ColumnType.DOUBLE) {
            return "double precision";
        }
        if (columnType == ColumnType.MAP) {
            return "jsonb";
        }
        return super.rewriteColumnType(columnType, columnSize);
    }

    @Override
    public void setStatementParameter(PreparedStatement st, int valueIndex, Column column, Object value) throws SQLException {
        switch (column.getNativeType()) {
            case "json": 
            case "jsonb": {
                assert (column.getType() == ColumnType.MAP);
                if (value == null) {
                    st.setObject(valueIndex, null);
                } else {
                    PGobject pgo = new PGobject();
                    pgo.setType(column.getNativeType());
                    if (value instanceof Map) {
                        try {
                            pgo.setValue(this.jsonObjectMapper.writeValueAsString(value));
                        }
                        catch (Exception e) {
                            throw new IllegalArgumentException("Unable to write value as JSON string: " + value);
                        }
                    } else {
                        pgo.setValue(value.toString());
                    }
                    st.setObject(valueIndex, pgo);
                }
                return;
            }
        }
        super.setStatementParameter(st, valueIndex, column, value);
    }

    @Override
    public Object getResultSetValue(ResultSet resultSet, int columnIndex, Column column) throws SQLException {
        if (column.getNativeType() != null) {
            switch (column.getNativeType()) {
                case "json": 
                case "jsonb": {
                    assert (column.getType() == ColumnType.MAP);
                    String stringValue = resultSet.getString(columnIndex);
                    if (stringValue == null) {
                        return null;
                    }
                    try {
                        return this.jsonObjectMapper.readValue(stringValue, Map.class);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("Unable to read string as JSON: " + stringValue);
                    }
                }
            }
        }
        return super.getResultSetValue(resultSet, columnIndex, column);
    }

    @Override
    protected String rewriteFromItem(Query query, FromItem item) {
        String schemaName;
        Schema schema;
        String result = super.rewriteFromItem(query, item);
        Table table = item.getTable();
        if (table != null && (schema = table.getSchema()) != null && (schemaName = schema.getName()) != null) {
            result = result.replaceFirst(schemaName, '\"' + schema.getName() + '\"');
        }
        return result;
    }
}

