/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.jdbc.dialects;

import org.apache.metamodel.jdbc.JdbcDataContext;
import org.apache.metamodel.jdbc.dialects.RowNumberQueryRewriter;
import org.apache.metamodel.query.Query;
import org.apache.metamodel.schema.ColumnType;

public class HiveQueryRewriter
extends RowNumberQueryRewriter {
    public HiveQueryRewriter(JdbcDataContext dataContext) {
        super(dataContext);
    }

    @Override
    public String rewriteQuery(Query query) {
        Integer maxRows = query.getMaxRows();
        Integer firstRow = query.getFirstRow();
        if (maxRows == null && (firstRow == null || firstRow == 1)) {
            return super.rewriteQuery(query);
        }
        if ((firstRow == null || firstRow == 1) && maxRows != null && maxRows > 0) {
            return super.rewriteQuery(query) + " LIMIT " + maxRows;
        }
        return this.getRowNumberSql(query, maxRows, firstRow);
    }

    @Override
    public String rewriteColumnType(ColumnType columnType, Integer columnSize) {
        if (columnType == ColumnType.INTEGER) {
            return "INT";
        }
        if (columnType == ColumnType.STRING) {
            return "STRING";
        }
        if (columnType == ColumnType.VARCHAR && columnSize == null) {
            return super.rewriteColumnType(columnType, 65535);
        }
        return super.rewriteColumnType(columnType, columnSize);
    }

    @Override
    public boolean isTransactional() {
        return false;
    }

    @Override
    public boolean isPrimaryKeySupported() {
        return false;
    }
}

