/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.pojo;

import java.util.ArrayList;
import org.apache.metamodel.ConnectionException;
import org.apache.metamodel.DataContext;
import org.apache.metamodel.factory.AbstractDataContextFactory;
import org.apache.metamodel.factory.DataContextProperties;
import org.apache.metamodel.factory.ResourceFactoryRegistry;
import org.apache.metamodel.factory.UnsupportedDataContextPropertiesException;
import org.apache.metamodel.pojo.ArrayTableDataProvider;
import org.apache.metamodel.pojo.PojoDataContext;
import org.apache.metamodel.util.SimpleTableDef;

public class PojoDataContextFactory
extends AbstractDataContextFactory {
    protected String getType() {
        return "pojo";
    }

    public DataContext create(DataContextProperties properties, ResourceFactoryRegistry resourceFactoryRegistry) throws UnsupportedDataContextPropertiesException, ConnectionException {
        ArrayList tableDataProviders;
        assert (this.accepts(properties, resourceFactoryRegistry));
        String schemaName = properties.getDatabaseName() != null ? properties.getDatabaseName() : "Schema";
        SimpleTableDef[] tableDefs = properties.getTableDefs();
        if (tableDefs == null) {
            tableDataProviders = new ArrayList();
        } else {
            tableDataProviders = new ArrayList(tableDefs.length);
            for (int i = 0; i < tableDefs.length; ++i) {
                ArrayTableDataProvider tableDataProvider = new ArrayTableDataProvider(tableDefs[i], new ArrayList<Object[]>());
                tableDataProviders.add(tableDataProvider);
            }
        }
        return new PojoDataContext(schemaName, tableDataProviders);
    }
}

