/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.credentials.provider.factory.strategies;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.internal.StaticCredentialsProvider;
import java.util.Map;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.processors.aws.credentials.provider.factory.CredentialPropertyDescriptors;
import org.apache.nifi.processors.aws.credentials.provider.factory.strategies.AbstractCredentialsStrategy;

public class AccessKeyPairCredentialsStrategy
extends AbstractCredentialsStrategy {
    public AccessKeyPairCredentialsStrategy() {
        super("Access Key Pair", new PropertyDescriptor[]{CredentialPropertyDescriptors.ACCESS_KEY, CredentialPropertyDescriptors.SECRET_KEY});
    }

    @Override
    public AWSCredentialsProvider getCredentialsProvider(Map<PropertyDescriptor, String> properties) {
        String accessKey = properties.get(CredentialPropertyDescriptors.ACCESS_KEY);
        String secretKey = properties.get(CredentialPropertyDescriptors.SECRET_KEY);
        BasicAWSCredentials creds = new BasicAWSCredentials(accessKey, secretKey);
        return new StaticCredentialsProvider((AWSCredentials)creds);
    }
}

