/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.s3;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.AbortMultipartUploadRequest;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.ListMultipartUploadsRequest;
import com.amazonaws.services.s3.model.MultipartUpload;
import com.amazonaws.services.s3.model.MultipartUploadListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.ObjectTagging;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.StorageClass;
import com.amazonaws.services.s3.model.Tag;
import com.amazonaws.services.s3.model.UploadPartRequest;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Stream;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.ReadsAttribute;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.DataUnit;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.io.InputStreamCallback;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.aws.s3.AbstractS3Processor;
import org.apache.nifi.processors.aws.s3.DeleteS3Object;
import org.apache.nifi.processors.aws.s3.FetchS3Object;
import org.apache.nifi.processors.aws.s3.ListS3;

@SupportsBatching
@SeeAlso(value={FetchS3Object.class, DeleteS3Object.class, ListS3.class})
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"Amazon", "S3", "AWS", "Archive", "Put"})
@CapabilityDescription(value="Puts FlowFiles to an Amazon S3 Bucket.\nThe upload uses either the PutS3Object method or the PutS3MultipartUpload method.  The PutS3Object method sends the file in a single synchronous call, but it has a 5GB size limit.  Larger files are sent using the PutS3MultipartUpload method.  This multipart process saves state after each step so that a large upload can be resumed with minimal loss if the processor or cluster is stopped and restarted.\nA multipart upload consists of three steps:\n  1) initiate upload,\n  2) upload the parts, and\n  3) complete the upload.\nFor multipart uploads, the processor saves state locally tracking the upload ID and parts uploaded, which must both be provided to complete the upload.\nThe AWS libraries select an endpoint URL based on the AWS region, but this can be overridden with the 'Endpoint Override URL' property for use with other S3-compatible endpoints.\nThe S3 API specifies that the maximum file size for a PutS3Object upload is 5GB. It also requires that parts in a multipart upload must be at least 5MB in size, except for the last part.  These limits establish the bounds for the Multipart Upload Threshold and Part Size properties.")
@DynamicProperty(name="The name of a User-Defined Metadata field to add to the S3 Object", value="The value of a User-Defined Metadata field to add to the S3 Object", description="Allows user-defined metadata to be added to the S3 object as key/value pairs", expressionLanguageScope=ExpressionLanguageScope.FLOWFILE_ATTRIBUTES)
@ReadsAttribute(attribute="filename", description="Uses the FlowFile's filename as the filename for the S3 object")
@WritesAttributes(value={@WritesAttribute(attribute="s3.bucket", description="The S3 bucket where the Object was put in S3"), @WritesAttribute(attribute="s3.key", description="The S3 key within where the Object was put in S3"), @WritesAttribute(attribute="s3.contenttype", description="The S3 content type of the S3 Object that put in S3"), @WritesAttribute(attribute="s3.version", description="The version of the S3 Object that was put to S3"), @WritesAttribute(attribute="s3.etag", description="The ETag of the S3 Object"), @WritesAttribute(attribute="s3.uploadId", description="The uploadId used to upload the Object to S3"), @WritesAttribute(attribute="s3.expiration", description="A human-readable form of the expiration date of the S3 object, if one is set"), @WritesAttribute(attribute="s3.sseAlgorithm", description="The server side encryption algorithm of the object"), @WritesAttribute(attribute="s3.usermetadata", description="A human-readable form of the User Metadata of the S3 object, if any was set")})
public class PutS3Object
extends AbstractS3Processor {
    public static final long MIN_S3_PART_SIZE = 0x3200000L;
    public static final long MAX_S3_PUTOBJECT_SIZE = 0x140000000L;
    public static final String PERSISTENCE_ROOT = "conf/state/";
    public static final String NO_SERVER_SIDE_ENCRYPTION = "None";
    public static final PropertyDescriptor EXPIRATION_RULE_ID = new PropertyDescriptor.Builder().name("Expiration Time Rule").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor CONTENT_TYPE = new PropertyDescriptor.Builder().name("Content Type").displayName("Content Type").description("Sets the Content-Type HTTP header indicating the type of content stored in the associated object. The value of this header is a standard MIME type.\nAWS S3 Java client will attempt to determine the correct content type if one hasn't been set yet. Users are responsible for ensuring a suitable content type is set when uploading streams. If no content type is provided and cannot be determined by the filename, the default content type \"application/octet-stream\" will be used.").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor STORAGE_CLASS = new PropertyDescriptor.Builder().name("Storage Class").required(true).allowableValues(new String[]{StorageClass.Standard.name(), StorageClass.ReducedRedundancy.name()}).defaultValue(StorageClass.Standard.name()).build();
    public static final PropertyDescriptor MULTIPART_THRESHOLD = new PropertyDescriptor.Builder().name("Multipart Threshold").description("Specifies the file size threshold for switch from the PutS3Object API to the PutS3MultipartUpload API.  Flow files bigger than this limit will be sent using the stateful multipart process.\nThe valid range is 50MB to 5GB.").required(true).defaultValue("5 GB").addValidator(StandardValidators.createDataSizeBoundsValidator((long)0x3200000L, (long)0x140000000L)).build();
    public static final PropertyDescriptor MULTIPART_PART_SIZE = new PropertyDescriptor.Builder().name("Multipart Part Size").description("Specifies the part size for use when the PutS3Multipart Upload API is used.\nFlow files will be broken into chunks of this size for the upload process, but the last part sent can be smaller since it is not padded.\nThe valid range is 50MB to 5GB.").required(true).defaultValue("5 GB").addValidator(StandardValidators.createDataSizeBoundsValidator((long)0x3200000L, (long)0x140000000L)).build();
    public static final PropertyDescriptor MULTIPART_S3_AGEOFF_INTERVAL = new PropertyDescriptor.Builder().name("Multipart Upload AgeOff Interval").description("Specifies the interval at which existing multipart uploads in AWS S3 will be evaluated for ageoff.  When processor is triggered it will initiate the ageoff evaluation if this interval has been exceeded.").required(true).defaultValue("60 min").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).build();
    public static final PropertyDescriptor MULTIPART_S3_MAX_AGE = new PropertyDescriptor.Builder().name("Multipart Upload Max Age Threshold").description("Specifies the maximum age for existing multipart uploads in AWS S3.  When the ageoff process occurs, any upload older than this threshold will be aborted.").required(true).defaultValue("7 days").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).build();
    public static final PropertyDescriptor SERVER_SIDE_ENCRYPTION = new PropertyDescriptor.Builder().name("server-side-encryption").displayName("Server Side Encryption").description("Specifies the algorithm used for server side encryption.").required(true).allowableValues(new String[]{"None", ObjectMetadata.AES_256_SERVER_SIDE_ENCRYPTION}).defaultValue("None").build();
    public static final PropertyDescriptor OBJECT_TAGS_PREFIX = new PropertyDescriptor.Builder().name("s3-object-tags-prefix").displayName("Object Tags Prefix").description("Specifies the prefix which would be scanned against the incoming FlowFile's attributes and the matching attribute's name and value would be considered as the outgoing S3 object's Tag name and Tag value respectively. For Ex: If the incoming FlowFile carries the attributes tagS3country, tagS3PII, the tag prefix to be specified would be 'tagS3'").required(false).addValidator(StandardValidators.NON_EMPTY_EL_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    public static final PropertyDescriptor REMOVE_TAG_PREFIX = new PropertyDescriptor.Builder().name("s3-object-remove-tags-prefix").displayName("Remove Tag Prefix").description("If set to 'True', the value provided for '" + OBJECT_TAGS_PREFIX.getDisplayName() + "' will be removed from the attribute(s) and then considered as the Tag name. For ex: If the incoming FlowFile carries the attributes tagS3country, tagS3PII and the prefix is set to 'tagS3' then the corresponding tag values would be 'country' and 'PII'").allowableValues(new AllowableValue[]{new AllowableValue("true", "True"), new AllowableValue("false", "False")}).defaultValue("false").build();
    public static final List<PropertyDescriptor> properties = Collections.unmodifiableList(Arrays.asList(KEY, BUCKET, CONTENT_TYPE, ACCESS_KEY, SECRET_KEY, CREDENTIALS_FILE, AWS_CREDENTIALS_PROVIDER_SERVICE, OBJECT_TAGS_PREFIX, REMOVE_TAG_PREFIX, STORAGE_CLASS, REGION, TIMEOUT, EXPIRATION_RULE_ID, FULL_CONTROL_USER_LIST, READ_USER_LIST, WRITE_USER_LIST, READ_ACL_LIST, WRITE_ACL_LIST, OWNER, CANNED_ACL, SSL_CONTEXT_SERVICE, ENDPOINT_OVERRIDE, SIGNER_OVERRIDE, MULTIPART_THRESHOLD, MULTIPART_PART_SIZE, MULTIPART_S3_AGEOFF_INTERVAL, MULTIPART_S3_MAX_AGE, SERVER_SIDE_ENCRYPTION, PROXY_CONFIGURATION_SERVICE, PROXY_HOST, PROXY_HOST_PORT, PROXY_USERNAME, PROXY_PASSWORD));
    static final String S3_BUCKET_KEY = "s3.bucket";
    static final String S3_OBJECT_KEY = "s3.key";
    static final String S3_CONTENT_TYPE = "s3.contenttype";
    static final String S3_UPLOAD_ID_ATTR_KEY = "s3.uploadId";
    static final String S3_VERSION_ATTR_KEY = "s3.version";
    static final String S3_ETAG_ATTR_KEY = "s3.etag";
    static final String S3_EXPIRATION_ATTR_KEY = "s3.expiration";
    static final String S3_STORAGECLASS_ATTR_KEY = "s3.storeClass";
    static final String S3_STORAGECLASS_META_KEY = "x-amz-storage-class";
    static final String S3_USERMETA_ATTR_KEY = "s3.usermetadata";
    static final String S3_API_METHOD_ATTR_KEY = "s3.apimethod";
    static final String S3_API_METHOD_PUTOBJECT = "putobject";
    static final String S3_API_METHOD_MULTIPARTUPLOAD = "multipartupload";
    static final String S3_SSE_ALGORITHM = "s3.sseAlgorithm";
    static final String S3_PROCESS_UNSCHEDULED_MESSAGE = "Processor unscheduled, stopping upload";
    private final Lock s3BucketLock = new ReentrantLock();
    private final AtomicLong lastS3AgeOff = new AtomicLong(0L);
    private final DateFormat logFormat = new SimpleDateFormat();

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return properties;
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return new PropertyDescriptor.Builder().name(propertyDescriptorName).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).dynamic(true).build();
    }

    protected File getPersistenceFile() {
        return new File(PERSISTENCE_ROOT + this.getIdentifier());
    }

    protected boolean localUploadExistsInS3(AmazonS3Client s3, String bucket, MultipartState localState) {
        ListMultipartUploadsRequest listRequest = new ListMultipartUploadsRequest(bucket);
        MultipartUploadListing listing = s3.listMultipartUploads(listRequest);
        for (MultipartUpload upload : listing.getMultipartUploads()) {
            if (!upload.getUploadId().equals(localState.getUploadId())) continue;
            return true;
        }
        return false;
    }

    protected synchronized MultipartState getLocalStateIfInS3(AmazonS3Client s3, String bucket, String s3ObjectKey) throws IOException {
        MultipartState currState = this.getLocalState(s3ObjectKey);
        if (currState == null) {
            return null;
        }
        if (this.localUploadExistsInS3(s3, bucket, currState)) {
            this.getLogger().info("Local state for {} loaded with uploadId {} and {} partETags", new Object[]{s3ObjectKey, currState.getUploadId(), currState.getPartETags().size()});
            return currState;
        }
        this.getLogger().info("Local state for {} with uploadId {} does not exist in S3, deleting local state", new Object[]{s3ObjectKey, currState.getUploadId()});
        this.persistLocalState(s3ObjectKey, null);
        return null;
    }

    protected synchronized MultipartState getLocalState(String s3ObjectKey) throws IOException {
        File persistenceFile = this.getPersistenceFile();
        if (persistenceFile.exists()) {
            String localSerialState;
            Properties props = new Properties();
            try (FileInputStream fis = new FileInputStream(persistenceFile);){
                props.load(fis);
            }
            catch (IOException ioe) {
                this.getLogger().warn("Failed to recover local state for {} due to {}. Assuming no local state and restarting upload.", new Object[]{s3ObjectKey, ioe.getMessage()});
                return null;
            }
            if (props.containsKey(s3ObjectKey) && (localSerialState = props.getProperty(s3ObjectKey)) != null) {
                try {
                    return new MultipartState(localSerialState);
                }
                catch (RuntimeException rte) {
                    this.getLogger().warn("Failed to recover local state for {} due to corrupt data in state.", new Object[]{s3ObjectKey, rte.getMessage()});
                    return null;
                }
            }
        }
        return null;
    }

    protected synchronized void persistLocalState(String s3ObjectKey, MultipartState currState) throws IOException {
        Throwable throwable;
        String currStateStr = currState == null ? null : currState.toString();
        File persistenceFile = this.getPersistenceFile();
        File parentDir = persistenceFile.getParentFile();
        if (!parentDir.exists() && !parentDir.mkdirs()) {
            throw new IOException("Persistence directory (" + parentDir.getAbsolutePath() + ") does not exist and could not be created.");
        }
        Properties props = new Properties();
        if (persistenceFile.exists()) {
            throwable = null;
            try (FileInputStream fis = new FileInputStream(persistenceFile);){
                props.load(fis);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        if (currStateStr != null) {
            currState.setTimestamp(System.currentTimeMillis());
            props.setProperty(s3ObjectKey, currStateStr);
        } else {
            props.remove(s3ObjectKey);
        }
        if (props.size() > 0) {
            try {
                throwable = null;
                try (FileOutputStream fos = new FileOutputStream(persistenceFile);){
                    props.store(fos, null);
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (IOException ioe) {
                this.getLogger().error("Could not store state {} due to {}.", new Object[]{persistenceFile.getAbsolutePath(), ioe.getMessage()});
            }
        } else if (persistenceFile.exists()) {
            try {
                Files.delete(persistenceFile.toPath());
            }
            catch (IOException ioe) {
                this.getLogger().error("Could not remove state file {} due to {}.", new Object[]{persistenceFile.getAbsolutePath(), ioe.getMessage()});
            }
        }
    }

    protected synchronized void removeLocalState(String s3ObjectKey) throws IOException {
        this.persistLocalState(s3ObjectKey, null);
    }

    private synchronized void ageoffLocalState(long ageCutoff) {
        File persistenceFile = this.getPersistenceFile();
        if (persistenceFile.exists()) {
            Properties props = new Properties();
            try (FileInputStream fis = new FileInputStream(persistenceFile);){
                props.load(fis);
            }
            catch (IOException ioe) {
                this.getLogger().warn("Failed to ageoff remove local state due to {}", new Object[]{ioe.getMessage()});
                return;
            }
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                MultipartState state;
                String key = (String)entry.getKey();
                String localSerialState = props.getProperty(key);
                if (localSerialState == null || (state = new MultipartState(localSerialState)).getTimestamp() >= ageCutoff) continue;
                this.getLogger().warn("Removing local state for {} due to exceeding ageoff time", new Object[]{key});
                try {
                    this.removeLocalState(key);
                }
                catch (IOException ioe) {
                    this.getLogger().warn("Failed to remove local state for {} due to {}", new Object[]{key, ioe.getMessage()});
                }
            }
        }
    }

    public void onTrigger(final ProcessContext context, ProcessSession session) {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        long startNanos = System.nanoTime();
        final String bucket = context.getProperty(BUCKET).evaluateAttributeExpressions(flowFile).getValue();
        final String key = context.getProperty(KEY).evaluateAttributeExpressions(flowFile).getValue();
        final String cacheKey = this.getIdentifier() + "/" + bucket + "/" + key;
        final AmazonS3Client s3 = (AmazonS3Client)this.getClient();
        final FlowFile ff = flowFile;
        final HashMap<String, String> attributes = new HashMap<String, String>();
        final String ffFilename = (String)ff.getAttributes().get(CoreAttributes.FILENAME.key());
        attributes.put(S3_BUCKET_KEY, bucket);
        attributes.put(S3_OBJECT_KEY, key);
        final Long multipartThreshold = context.getProperty(MULTIPART_THRESHOLD).asDataSize(DataUnit.B).longValue();
        final Long multipartPartSize = context.getProperty(MULTIPART_PART_SIZE).asDataSize(DataUnit.B).longValue();
        long now = System.currentTimeMillis();
        this.ageoffS3Uploads(context, s3, now, bucket);
        try {
            final FlowFile flowFileCopy = flowFile;
            session.read(flowFile, new InputStreamCallback(){

                /*
                 * Unable to fully structure code
                 */
                public void process(InputStream rawIn) throws IOException {
                    block62: {
                        in = new BufferedInputStream(rawIn);
                        var3_3 = null;
                        try {
                            objectMetadata = new ObjectMetadata();
                            objectMetadata.setContentDisposition(URLEncoder.encode(ff.getAttribute(CoreAttributes.FILENAME.key()), "UTF-8"));
                            objectMetadata.setContentLength(ff.getSize());
                            contentType = context.getProperty(PutS3Object.CONTENT_TYPE).evaluateAttributeExpressions(ff).getValue();
                            if (contentType != null) {
                                objectMetadata.setContentType(contentType);
                                attributes.put("s3.contenttype", contentType);
                            }
                            if ((expirationRule = context.getProperty(PutS3Object.EXPIRATION_RULE_ID).evaluateAttributeExpressions(ff).getValue()) != null) {
                                objectMetadata.setExpirationTimeRuleId(expirationRule);
                            }
                            userMetadata = new HashMap<String, String>();
                            for (Map.Entry<K, V> entry : context.getProperties().entrySet()) {
                                if (!((PropertyDescriptor)entry.getKey()).isDynamic()) continue;
                                value = context.getProperty((PropertyDescriptor)entry.getKey()).evaluateAttributeExpressions(ff).getValue();
                                userMetadata.put(((PropertyDescriptor)entry.getKey()).getName(), value);
                            }
                            serverSideEncryption = context.getProperty(PutS3Object.SERVER_SIDE_ENCRYPTION).getValue();
                            if (!serverSideEncryption.equals("None")) {
                                objectMetadata.setSSEAlgorithm(serverSideEncryption);
                                attributes.put("s3.sseAlgorithm", serverSideEncryption);
                            }
                            if (!userMetadata.isEmpty()) {
                                objectMetadata.setUserMetadata(userMetadata);
                            }
                            if (ff.getSize() <= multipartThreshold) {
                                request = new PutObjectRequest(bucket, key, (InputStream)in, objectMetadata);
                                request.setStorageClass(StorageClass.valueOf((String)context.getProperty(PutS3Object.STORAGE_CLASS).getValue()));
                                acl = PutS3Object.this.createACL(context, ff);
                                if (acl != null) {
                                    request.setAccessControlList(acl);
                                }
                                if ((cannedAcl = PutS3Object.this.createCannedACL(context, ff)) != null) {
                                    request.withCannedAcl(cannedAcl);
                                }
                                if (context.getProperty(PutS3Object.OBJECT_TAGS_PREFIX).isSet()) {
                                    request.setTagging(new ObjectTagging(PutS3Object.access$000(PutS3Object.this, context, flowFileCopy)));
                                }
                                try {
                                    result = s3.putObject(request);
                                    if (result.getVersionId() != null) {
                                        attributes.put("s3.version", result.getVersionId());
                                    }
                                    if (result.getETag() != null) {
                                        attributes.put("s3.etag", result.getETag());
                                    }
                                    if (result.getExpirationTime() != null) {
                                        attributes.put("s3.expiration", result.getExpirationTime().toString());
                                    }
                                    if (result.getMetadata().getRawMetadata().keySet().contains("x-amz-storage-class")) {
                                        attributes.put("s3.storeClass", result.getMetadata().getRawMetadataValue("x-amz-storage-class").toString());
                                    }
                                    if (userMetadata.size() > 0) {
                                        userMetaBldr = new StringBuilder();
                                        for (String userKey : userMetadata.keySet()) {
                                            userMetaBldr.append(userKey).append("=").append((String)userMetadata.get(userKey));
                                        }
                                        attributes.put("s3.usermetadata", userMetaBldr.toString());
                                    }
                                    attributes.put("s3.apimethod", "putobject");
                                    break block62;
                                }
                                catch (AmazonClientException e) {
                                    PutS3Object.access$100(PutS3Object.this).info("Failure completing upload flowfile={} bucket={} key={} reason={}", new Object[]{ffFilename, bucket, key, e.getMessage()});
                                    throw e;
                                }
                            }
                            try {
                                currentState = PutS3Object.this.getLocalStateIfInS3(s3, bucket, cacheKey);
                                if (currentState != null) {
                                    if (currentState.getPartETags().size() > 0) {
                                        lastETag = currentState.getPartETags().get(currentState.getPartETags().size() - 1);
                                        PutS3Object.access$200(PutS3Object.this).info("Resuming upload for flowfile='{}' bucket='{}' key='{}' uploadID='{}' filePosition='{}' partSize='{}' storageClass='{}' contentLength='{}' partsLoaded={} lastPart={}/{}", new Object[]{ffFilename, bucket, key, currentState.getUploadId(), currentState.getFilePosition(), currentState.getPartSize(), currentState.getStorageClass().toString(), currentState.getContentLength(), currentState.getPartETags().size(), Integer.toString(lastETag.getPartNumber()), lastETag.getETag()});
                                    } else {
                                        PutS3Object.access$300(PutS3Object.this).info("Resuming upload for flowfile='{}' bucket='{}' key='{}' uploadID='{}' filePosition='{}' partSize='{}' storageClass='{}' contentLength='{}' no partsLoaded", new Object[]{ffFilename, bucket, key, currentState.getUploadId(), currentState.getFilePosition(), currentState.getPartSize(), currentState.getStorageClass().toString(), currentState.getContentLength()});
                                    }
                                } else {
                                    currentState = new MultipartState();
                                    currentState.setPartSize(multipartPartSize);
                                    currentState.setStorageClass(StorageClass.valueOf((String)context.getProperty(PutS3Object.STORAGE_CLASS).getValue()));
                                    currentState.setContentLength(ff.getSize());
                                    PutS3Object.this.persistLocalState(cacheKey, currentState);
                                    PutS3Object.access$400(PutS3Object.this).info("Starting new upload for flowfile='{}' bucket='{}' key='{}'", new Object[]{ffFilename, bucket, key});
                                }
                            }
                            catch (IOException e) {
                                PutS3Object.access$500(PutS3Object.this).error("IOException initiating cache state while processing flow files: " + e.getMessage());
                                throw e;
                            }
                            if (currentState.getUploadId().isEmpty()) {
                                initiateRequest = new InitiateMultipartUploadRequest(bucket, key, objectMetadata);
                                initiateRequest.setStorageClass(currentState.getStorageClass());
                                acl = PutS3Object.this.createACL(context, ff);
                                if (acl != null) {
                                    initiateRequest.setAccessControlList(acl);
                                }
                                if ((cannedAcl = PutS3Object.this.createCannedACL(context, ff)) != null) {
                                    initiateRequest.withCannedACL(cannedAcl);
                                }
                                if (context.getProperty(PutS3Object.OBJECT_TAGS_PREFIX).isSet()) {
                                    initiateRequest.setTagging(new ObjectTagging(PutS3Object.access$000(PutS3Object.this, context, flowFileCopy)));
                                }
                                try {
                                    initiateResult = s3.initiateMultipartUpload(initiateRequest);
                                    currentState.setUploadId(initiateResult.getUploadId());
                                    currentState.getPartETags().clear();
                                    try {
                                        PutS3Object.this.persistLocalState(cacheKey, currentState);
                                    }
                                    catch (Exception e) {
                                        PutS3Object.access$600(PutS3Object.this).info("Exception saving cache state while processing flow file: " + e.getMessage());
                                        throw new ProcessException("Exception saving cache state", (Throwable)e);
                                    }
                                    PutS3Object.access$700(PutS3Object.this).info("Success initiating upload flowfile={} available={} position={} length={} bucket={} key={} uploadId={}", new Object[]{ffFilename, in.available(), currentState.getFilePosition(), currentState.getContentLength(), bucket, key, currentState.getUploadId()});
                                    if (initiateResult.getUploadId() == null) ** GOTO lbl124
                                    attributes.put("s3.uploadId", initiateResult.getUploadId());
                                }
                                catch (AmazonClientException e) {
                                    PutS3Object.access$800(PutS3Object.this).info("Failure initiating upload flowfile={} bucket={} key={} reason={}", new Object[]{ffFilename, bucket, key, e.getMessage()});
                                    throw e;
                                }
                            } else if (currentState.getFilePosition() > 0L) {
                                try {
                                    skipped = in.skip(currentState.getFilePosition());
                                    if (skipped != currentState.getFilePosition()) {
                                        PutS3Object.access$900(PutS3Object.this).info("Failure skipping to resume upload flowfile={} bucket={} key={} position={} skipped={}", new Object[]{ffFilename, bucket, key, currentState.getFilePosition(), skipped});
                                    }
                                }
                                catch (Exception e) {
                                    PutS3Object.access$1000(PutS3Object.this).info("Failure skipping to resume upload flowfile={} bucket={} key={} position={} reason={}", new Object[]{ffFilename, bucket, key, currentState.getFilePosition(), e.getMessage()});
                                    throw new ProcessException((Throwable)e);
                                }
                            }
lbl124:
                            // 5 sources

                            part = currentState.getPartETags().size() + 1;
                            while (currentState.getFilePosition() < currentState.getContentLength()) {
                                if (!PutS3Object.access$1100(PutS3Object.this)) {
                                    throw new IOException("Processor unscheduled, stopping upload flowfile=" + ffFilename + " part=" + part + " uploadId=" + currentState.getUploadId());
                                }
                                thisPartSize = Math.min(currentState.getPartSize(), currentState.getContentLength() - currentState.getFilePosition());
                                uploadRequest = new UploadPartRequest().withBucketName(bucket).withKey(key).withUploadId(currentState.getUploadId()).withInputStream((InputStream)in).withPartNumber(part).withPartSize(thisPartSize);
                                try {
                                    uploadPartResult = s3.uploadPart(uploadRequest);
                                    currentState.addPartETag(uploadPartResult.getPartETag());
                                    currentState.setFilePosition(currentState.getFilePosition() + thisPartSize);
                                    try {
                                        PutS3Object.this.persistLocalState(cacheKey, currentState);
                                    }
                                    catch (Exception e) {
                                        PutS3Object.access$1200(PutS3Object.this).info("Exception saving cache state processing flow file: " + e.getMessage());
                                    }
                                    PutS3Object.access$1300(PutS3Object.this).info("Success uploading part flowfile={} part={} available={} etag={} uploadId={}", new Object[]{ffFilename, part, in.available(), uploadPartResult.getETag(), currentState.getUploadId()});
                                }
                                catch (AmazonClientException e) {
                                    PutS3Object.access$1400(PutS3Object.this).info("Failure uploading part flowfile={} part={} bucket={} key={} reason={}", new Object[]{ffFilename, part, bucket, key, e.getMessage()});
                                    throw e;
                                }
                                ++part;
                            }
                            completeRequest = new CompleteMultipartUploadRequest(bucket, key, currentState.getUploadId(), currentState.getPartETags());
                            try {
                                completeResult = s3.completeMultipartUpload(completeRequest);
                                PutS3Object.access$1500(PutS3Object.this).info("Success completing upload flowfile={} etag={} uploadId={}", new Object[]{ffFilename, completeResult.getETag(), currentState.getUploadId()});
                                if (completeResult.getVersionId() != null) {
                                    attributes.put("s3.version", completeResult.getVersionId());
                                }
                                if (completeResult.getETag() != null) {
                                    attributes.put("s3.etag", completeResult.getETag());
                                }
                                if (completeResult.getExpirationTime() != null) {
                                    attributes.put("s3.expiration", completeResult.getExpirationTime().toString());
                                }
                                if (currentState.getStorageClass() != null) {
                                    attributes.put("s3.storeClass", currentState.getStorageClass().toString());
                                }
                                if (userMetadata.size() > 0) {
                                    userMetaBldr = new StringBuilder();
                                    for (String userKey : userMetadata.keySet()) {
                                        userMetaBldr.append(userKey).append("=").append((String)userMetadata.get(userKey));
                                    }
                                    attributes.put("s3.usermetadata", userMetaBldr.toString());
                                }
                                attributes.put("s3.apimethod", "multipartupload");
                            }
                            catch (AmazonClientException e) {
                                PutS3Object.access$1600(PutS3Object.this).info("Failure completing upload flowfile={} bucket={} key={} reason={}", new Object[]{ffFilename, bucket, key, e.getMessage()});
                                throw e;
                            }
                        }
                        catch (Throwable var4_6) {
                            var3_3 = var4_6;
                            throw var4_6;
                        }
                        finally {
                            if (in != null) {
                                if (var3_3 != null) {
                                    try {
                                        in.close();
                                    }
                                    catch (Throwable var4_5) {
                                        var3_3.addSuppressed(var4_5);
                                    }
                                } else {
                                    in.close();
                                }
                            }
                        }
                    }
                }
            });
            if (!attributes.isEmpty()) {
                flowFile = session.putAllAttributes(flowFile, attributes);
            }
            session.transfer(flowFile, REL_SUCCESS);
            String url = s3.getResourceUrl(bucket, key);
            long millis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNanos);
            session.getProvenanceReporter().send(flowFile, url, millis);
            this.getLogger().info("Successfully put {} to Amazon S3 in {} milliseconds", new Object[]{ff, millis});
            try {
                this.removeLocalState(cacheKey);
            }
            catch (IOException e) {
                this.getLogger().info("Error trying to delete key {} from cache: {}", new Object[]{cacheKey, e.getMessage()});
            }
        }
        catch (AmazonClientException | ProcessException pe) {
            if (pe.getMessage().contains(S3_PROCESS_UNSCHEDULED_MESSAGE)) {
                this.getLogger().info(pe.getMessage());
                session.rollback();
            }
            this.getLogger().error("Failed to put {} to Amazon S3 due to {}", new Object[]{flowFile, pe});
            flowFile = session.penalize(flowFile);
            session.transfer(flowFile, REL_FAILURE);
        }
    }

    protected void ageoffS3Uploads(ProcessContext context, AmazonS3Client s3, long now, String bucket) {
        MultipartUploadListing oldUploads = this.getS3AgeoffListAndAgeoffLocalState(context, s3, now, bucket);
        for (MultipartUpload upload : oldUploads.getMultipartUploads()) {
            this.abortS3MultipartUpload(s3, oldUploads.getBucketName(), upload);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MultipartUploadListing getS3AgeoffListAndAgeoffLocalState(ProcessContext context, AmazonS3Client s3, long now, String bucket) {
        long ageoff_interval = context.getProperty(MULTIPART_S3_AGEOFF_INTERVAL).asTimePeriod(TimeUnit.MILLISECONDS);
        Long maxAge = context.getProperty(MULTIPART_S3_MAX_AGE).asTimePeriod(TimeUnit.MILLISECONDS);
        long ageCutoff = now - maxAge;
        ArrayList<MultipartUpload> ageoffList = new ArrayList<MultipartUpload>();
        if (this.lastS3AgeOff.get() < now - ageoff_interval && this.s3BucketLock.tryLock()) {
            try {
                ListMultipartUploadsRequest listRequest = new ListMultipartUploadsRequest(bucket);
                MultipartUploadListing listing = s3.listMultipartUploads(listRequest);
                for (MultipartUpload upload : listing.getMultipartUploads()) {
                    long uploadTime = upload.getInitiated().getTime();
                    if (uploadTime >= ageCutoff) continue;
                    ageoffList.add(upload);
                }
                this.ageoffLocalState(ageCutoff);
                this.lastS3AgeOff.set(System.currentTimeMillis());
            }
            catch (AmazonClientException e) {
                if (e instanceof AmazonS3Exception && ((AmazonS3Exception)e).getStatusCode() == 403 && ((AmazonS3Exception)e).getErrorCode().equals("AccessDenied")) {
                    this.getLogger().warn("AccessDenied checking S3 Multipart Upload list for {}: {} ** The configured user does not have the s3:ListBucketMultipartUploads permission for this bucket, S3 ageoff cannot occur without this permission.  Next ageoff check time is being advanced by interval to prevent checking on every upload **", new Object[]{bucket, e.getMessage()});
                    this.lastS3AgeOff.set(System.currentTimeMillis());
                } else {
                    this.getLogger().error("Error checking S3 Multipart Upload list for {}: {}", new Object[]{bucket, e.getMessage()});
                }
            }
            finally {
                this.s3BucketLock.unlock();
            }
        }
        MultipartUploadListing result = new MultipartUploadListing();
        result.setBucketName(bucket);
        result.setMultipartUploads(ageoffList);
        return result;
    }

    protected void abortS3MultipartUpload(AmazonS3Client s3, String bucket, MultipartUpload upload) {
        String uploadKey = upload.getKey();
        String uploadId = upload.getUploadId();
        AbortMultipartUploadRequest abortRequest = new AbortMultipartUploadRequest(bucket, uploadKey, uploadId);
        try {
            s3.abortMultipartUpload(abortRequest);
            this.getLogger().info("Aborting out of date multipart upload, bucket {} key {} ID {}, initiated {}", new Object[]{bucket, uploadKey, uploadId, this.logFormat.format(upload.getInitiated())});
        }
        catch (AmazonClientException ace) {
            this.getLogger().info("Error trying to abort multipart upload from bucket {} with key {} and ID {}: {}", new Object[]{bucket, uploadKey, uploadId, ace.getMessage()});
        }
    }

    private List<Tag> getObjectTags(ProcessContext context, FlowFile flowFile) {
        String prefix = context.getProperty(OBJECT_TAGS_PREFIX).evaluateAttributeExpressions(flowFile).getValue();
        ArrayList<Tag> objectTags = new ArrayList<Tag>();
        Map attributesMap = flowFile.getAttributes();
        ((Stream)attributesMap.entrySet().stream().sequential()).filter(attribute -> ((String)attribute.getKey()).startsWith(prefix)).forEach(attribute -> {
            String tagKey = (String)attribute.getKey();
            String tagValue = (String)attribute.getValue();
            if (context.getProperty(REMOVE_TAG_PREFIX).asBoolean().booleanValue()) {
                tagKey = tagKey.replace(prefix, "");
            }
            objectTags.add(new Tag(tagKey, tagValue));
        });
        return objectTags;
    }

    static /* synthetic */ List access$000(PutS3Object x0, ProcessContext x1, FlowFile x2) {
        return x0.getObjectTags(x1, x2);
    }

    static /* synthetic */ ComponentLog access$100(PutS3Object x0) {
        return x0.getLogger();
    }

    static /* synthetic */ ComponentLog access$200(PutS3Object x0) {
        return x0.getLogger();
    }

    static /* synthetic */ ComponentLog access$300(PutS3Object x0) {
        return x0.getLogger();
    }

    static /* synthetic */ ComponentLog access$400(PutS3Object x0) {
        return x0.getLogger();
    }

    static /* synthetic */ ComponentLog access$500(PutS3Object x0) {
        return x0.getLogger();
    }

    static /* synthetic */ ComponentLog access$600(PutS3Object x0) {
        return x0.getLogger();
    }

    static /* synthetic */ ComponentLog access$700(PutS3Object x0) {
        return x0.getLogger();
    }

    static /* synthetic */ ComponentLog access$800(PutS3Object x0) {
        return x0.getLogger();
    }

    static /* synthetic */ ComponentLog access$900(PutS3Object x0) {
        return x0.getLogger();
    }

    static /* synthetic */ ComponentLog access$1000(PutS3Object x0) {
        return x0.getLogger();
    }

    static /* synthetic */ boolean access$1100(PutS3Object x0) {
        return x0.isScheduled();
    }

    static /* synthetic */ ComponentLog access$1200(PutS3Object x0) {
        return x0.getLogger();
    }

    static /* synthetic */ ComponentLog access$1300(PutS3Object x0) {
        return x0.getLogger();
    }

    static /* synthetic */ ComponentLog access$1400(PutS3Object x0) {
        return x0.getLogger();
    }

    static /* synthetic */ ComponentLog access$1500(PutS3Object x0) {
        return x0.getLogger();
    }

    static /* synthetic */ ComponentLog access$1600(PutS3Object x0) {
        return x0.getLogger();
    }

    protected static class MultipartState
    implements Serializable {
        private static final long serialVersionUID = 9006072180563519740L;
        private static final String SEPARATOR = "#";
        private String _uploadId;
        private Long _filePosition;
        private List<PartETag> _partETags;
        private Long _partSize;
        private StorageClass _storageClass;
        private Long _contentLength;
        private Long _timestamp;

        public MultipartState() {
            this._uploadId = "";
            this._filePosition = 0L;
            this._partETags = new ArrayList<PartETag>();
            this._partSize = 0L;
            this._storageClass = StorageClass.Standard;
            this._contentLength = 0L;
            this._timestamp = System.currentTimeMillis();
        }

        public MultipartState(String buf) {
            String[] fields = buf.split(SEPARATOR);
            this._uploadId = fields[0];
            this._filePosition = Long.parseLong(fields[1]);
            this._partETags = new ArrayList<PartETag>();
            for (String part : fields[2].split(",")) {
                if (part == null || part.isEmpty()) continue;
                String[] partFields = part.split("/");
                this._partETags.add(new PartETag(Integer.parseInt(partFields[0]), partFields[1]));
            }
            this._partSize = Long.parseLong(fields[3]);
            this._storageClass = StorageClass.fromValue((String)fields[4]);
            this._contentLength = Long.parseLong(fields[5]);
            this._timestamp = Long.parseLong(fields[6]);
        }

        public String getUploadId() {
            return this._uploadId;
        }

        public void setUploadId(String id) {
            this._uploadId = id;
        }

        public Long getFilePosition() {
            return this._filePosition;
        }

        public void setFilePosition(Long pos) {
            this._filePosition = pos;
        }

        public List<PartETag> getPartETags() {
            return this._partETags;
        }

        public void addPartETag(PartETag tag) {
            this._partETags.add(tag);
        }

        public Long getPartSize() {
            return this._partSize;
        }

        public void setPartSize(Long size) {
            this._partSize = size;
        }

        public StorageClass getStorageClass() {
            return this._storageClass;
        }

        public void setStorageClass(StorageClass aClass) {
            this._storageClass = aClass;
        }

        public Long getContentLength() {
            return this._contentLength;
        }

        public void setContentLength(Long length) {
            this._contentLength = length;
        }

        public Long getTimestamp() {
            return this._timestamp;
        }

        public void setTimestamp(Long timestamp) {
            this._timestamp = timestamp;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append(this._uploadId).append(SEPARATOR).append(this._filePosition.toString()).append(SEPARATOR);
            if (this._partETags.size() > 0) {
                boolean first = true;
                for (PartETag tag : this._partETags) {
                    if (!first) {
                        buf.append(",");
                    } else {
                        first = false;
                    }
                    buf.append(String.format("%d/%s", tag.getPartNumber(), tag.getETag()));
                }
            }
            buf.append(SEPARATOR).append(this._partSize.toString()).append(SEPARATOR).append(this._storageClass.toString()).append(SEPARATOR).append(this._contentLength.toString()).append(SEPARATOR).append(this._timestamp.toString());
            return buf.toString();
        }
    }
}

