/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.dbcp;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.lifecycle.OnDisabled;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.ConfigVerificationResult;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.controller.VerifiableControllerService;
import org.apache.nifi.dbcp.DBCPService;
import org.apache.nifi.dbcp.utils.DBCPProperties;
import org.apache.nifi.dbcp.utils.DataSourceConfiguration;
import org.apache.nifi.kerberos.KerberosUserService;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.reporting.InitializationException;
import org.apache.nifi.security.krb.KerberosAction;
import org.apache.nifi.security.krb.KerberosLoginException;
import org.apache.nifi.security.krb.KerberosUser;

public abstract class AbstractDBCPConnectionPool
extends AbstractControllerService
implements DBCPService,
VerifiableControllerService {
    protected volatile BasicDataSource dataSource;
    protected volatile KerberosUser kerberosUser;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ConfigVerificationResult> verify(ConfigurationContext context, ComponentLog verificationLogger, Map<String, String> variables) {
        ArrayList<ConfigVerificationResult> results = new ArrayList<ConfigVerificationResult>();
        KerberosUser kerberosUser = null;
        try {
            kerberosUser = this.getKerberosUser(context);
            if (kerberosUser != null) {
                results.add(new ConfigVerificationResult.Builder().verificationStepName("Configure Kerberos User").outcome(ConfigVerificationResult.Outcome.SUCCESSFUL).explanation("Successfully configured Kerberos user").build());
            }
        }
        catch (Exception e) {
            verificationLogger.error("Failed to configure Kerberos user", (Throwable)e);
            results.add(new ConfigVerificationResult.Builder().verificationStepName("Configure Kerberos User").outcome(ConfigVerificationResult.Outcome.FAILED).explanation("Failed to configure Kerberos user: " + e.getMessage()).build());
        }
        BasicDataSource basicDataSource = new BasicDataSource();
        try {
            DataSourceConfiguration configuration = this.getDataSourceConfiguration(context);
            this.configureDataSource(context, basicDataSource, configuration);
            results.add(new ConfigVerificationResult.Builder().verificationStepName("Configure Data Source").outcome(ConfigVerificationResult.Outcome.SUCCESSFUL).explanation("Successfully configured data source").build());
            try (Connection conn = this.getConnection(basicDataSource, kerberosUser);){
                results.add(new ConfigVerificationResult.Builder().verificationStepName("Establish Connection").outcome(ConfigVerificationResult.Outcome.SUCCESSFUL).explanation("Successfully established Database Connection").build());
            }
            catch (Exception e) {
                verificationLogger.error("Failed to establish Database Connection", (Throwable)e);
                results.add(new ConfigVerificationResult.Builder().verificationStepName("Establish Connection").outcome(ConfigVerificationResult.Outcome.FAILED).explanation("Failed to establish Database Connection: " + e.getMessage()).build());
            }
        }
        catch (Exception e) {
            Object message = "Failed to configure Data Source.";
            if (e.getCause() instanceof ClassNotFoundException) {
                message = (String)message + String.format("  Ensure changes to the '%s' property are applied before verifying", DBCPProperties.DB_DRIVER_LOCATION.getDisplayName());
            }
            verificationLogger.error((String)message, (Throwable)e);
            results.add(new ConfigVerificationResult.Builder().verificationStepName("Configure Data Source").outcome(ConfigVerificationResult.Outcome.FAILED).explanation((String)message + ": " + e.getMessage()).build());
        }
        finally {
            try {
                this.shutdown(basicDataSource, kerberosUser);
            }
            catch (SQLException e) {
                verificationLogger.error("Failed to shut down data source", (Throwable)e);
            }
        }
        return results;
    }

    @OnEnabled
    public void onConfigured(ConfigurationContext context) throws InitializationException {
        this.dataSource = new BasicDataSource();
        this.kerberosUser = this.getKerberosUser(context);
        this.loginKerberos(this.kerberosUser);
        DataSourceConfiguration configuration = this.getDataSourceConfiguration(context);
        this.configureDataSource(context, this.dataSource, configuration);
    }

    private void loginKerberos(KerberosUser kerberosUser) throws InitializationException {
        if (kerberosUser != null) {
            try {
                kerberosUser.login();
            }
            catch (KerberosLoginException e) {
                throw new InitializationException("Unable to authenticate Kerberos principal", (Throwable)e);
            }
        }
    }

    protected abstract Driver getDriver(String var1, String var2);

    protected abstract DataSourceConfiguration getDataSourceConfiguration(ConfigurationContext var1);

    protected void configureDataSource(ConfigurationContext context, BasicDataSource basicDataSource, DataSourceConfiguration configuration) {
        Driver driver = this.getDriver(configuration.getDriverName(), configuration.getUrl());
        basicDataSource.setDriver(driver);
        basicDataSource.setMaxWait(Duration.ofMillis(configuration.getMaxWaitMillis()));
        basicDataSource.setMaxTotal(configuration.getMaxTotal());
        basicDataSource.setMinIdle(configuration.getMinIdle());
        basicDataSource.setMaxIdle(configuration.getMaxIdle());
        basicDataSource.setMaxConn(Duration.ofMillis(configuration.getMaxConnLifetimeMillis()));
        basicDataSource.setDurationBetweenEvictionRuns(Duration.ofMillis(configuration.getTimeBetweenEvictionRunsMillis()));
        basicDataSource.setMinEvictableIdle(Duration.ofMillis(configuration.getMinEvictableIdleTimeMillis()));
        basicDataSource.setSoftMinEvictableIdle(Duration.ofMillis(configuration.getSoftMinEvictableIdleTimeMillis()));
        String validationQuery = configuration.getValidationQuery();
        if (StringUtils.isNotBlank((CharSequence)validationQuery)) {
            basicDataSource.setValidationQuery(validationQuery);
            basicDataSource.setTestOnBorrow(true);
        }
        basicDataSource.setUrl(configuration.getUrl());
        basicDataSource.setUsername(configuration.getUserName());
        basicDataSource.setPassword(configuration.getPassword());
        this.getConnectionProperties(context).forEach((arg_0, arg_1) -> ((BasicDataSource)basicDataSource).addConnectionProperty(arg_0, arg_1));
    }

    protected Map<String, String> getConnectionProperties(ConfigurationContext context) {
        return this.getDynamicProperties(context).stream().collect(Collectors.toMap(PropertyDescriptor::getName, s -> {
            PropertyValue propertyValue = context.getProperty(s);
            return propertyValue.evaluateAttributeExpressions().getValue();
        }));
    }

    protected List<PropertyDescriptor> getDynamicProperties(ConfigurationContext context) {
        return context.getProperties().keySet().stream().filter(PropertyDescriptor::isDynamic).collect(Collectors.toList());
    }

    protected KerberosUser getKerberosUser(ConfigurationContext context) {
        KerberosUserService kerberosUserService = (KerberosUserService)context.getProperty(DBCPProperties.KERBEROS_USER_SERVICE).asControllerService(KerberosUserService.class);
        KerberosUser kerberosUser = kerberosUserService != null ? kerberosUserService.createKerberosUser() : this.getKerberosUserByCredentials(context);
        return kerberosUser;
    }

    protected KerberosUser getKerberosUserByCredentials(ConfigurationContext context) {
        return null;
    }

    public Connection getConnection() throws ProcessException {
        return this.getConnection(this.dataSource, this.kerberosUser);
    }

    private Connection getConnection(BasicDataSource dataSource, KerberosUser kerberosUser) {
        try {
            Connection con;
            if (kerberosUser != null) {
                KerberosAction kerberosAction = new KerberosAction(kerberosUser, () -> ((BasicDataSource)dataSource).getConnection(), this.getLogger());
                con = (Connection)kerberosAction.execute();
            } else {
                con = dataSource.getConnection();
            }
            return con;
        }
        catch (SQLException e) {
            if (kerberosUser != null) {
                try {
                    this.getLogger().info("Error getting connection, performing Kerberos re-login");
                    kerberosUser.login();
                }
                catch (KerberosLoginException le) {
                    throw new ProcessException("Unable to authenticate Kerberos principal", (Throwable)le);
                }
            }
            throw new ProcessException((Throwable)e);
        }
    }

    @OnDisabled
    public void shutdown() throws SQLException {
        try {
            this.shutdown(this.dataSource, this.kerberosUser);
        }
        finally {
            this.kerberosUser = null;
            this.dataSource = null;
        }
    }

    private void shutdown(BasicDataSource dataSource, KerberosUser kerberosUser) throws SQLException {
        try {
            if (kerberosUser != null) {
                kerberosUser.logout();
            }
        }
        finally {
            if (dataSource != null) {
                dataSource.close();
            }
        }
    }
}

