/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.spring;

import org.apache.nifi.admin.service.AuditService;
import org.apache.nifi.cluster.event.EventManager;
import org.apache.nifi.cluster.firewall.ClusterNodeFirewall;
import org.apache.nifi.cluster.flow.DataFlowManagementService;
import org.apache.nifi.cluster.manager.HttpRequestReplicator;
import org.apache.nifi.cluster.manager.HttpResponseMapper;
import org.apache.nifi.cluster.manager.impl.WebClusterManager;
import org.apache.nifi.cluster.protocol.impl.ClusterManagerProtocolSenderListener;
import org.apache.nifi.cluster.protocol.impl.ClusterServicesBroadcaster;
import org.apache.nifi.encrypt.StringEncryptor;
import org.apache.nifi.io.socket.multicast.DiscoverableService;
import org.apache.nifi.io.socket.multicast.DiscoverableServiceImpl;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.OptimisticLockingManager;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class WebClusterManagerFactoryBean
implements FactoryBean,
ApplicationContextAware {
    private ApplicationContext applicationContext;
    private WebClusterManager clusterManager;
    private NiFiProperties properties;
    private StringEncryptor encryptor;
    private OptimisticLockingManager optimisticLockingManager;

    public Object getObject() throws Exception {
        if (this.properties.isClusterManager() && this.properties.isNode()) {
            throw new IllegalStateException("Application may be configured as a cluster manager or a node, but not both.");
        }
        if (!this.properties.isClusterManager()) {
            return null;
        }
        if (this.clusterManager == null) {
            HttpRequestReplicator requestReplicator = (HttpRequestReplicator)this.applicationContext.getBean("httpRequestReplicator", HttpRequestReplicator.class);
            HttpResponseMapper responseMapper = (HttpResponseMapper)this.applicationContext.getBean("httpResponseMapper", HttpResponseMapper.class);
            DataFlowManagementService dataFlowService = (DataFlowManagementService)this.applicationContext.getBean("dataFlowManagementService", DataFlowManagementService.class);
            ClusterManagerProtocolSenderListener senderListener = (ClusterManagerProtocolSenderListener)this.applicationContext.getBean("clusterManagerProtocolSenderListener", ClusterManagerProtocolSenderListener.class);
            this.clusterManager = new WebClusterManager(requestReplicator, responseMapper, dataFlowService, senderListener, this.properties, this.encryptor, this.optimisticLockingManager);
            if (this.properties.getClusterProtocolUseMulticast()) {
                ClusterServicesBroadcaster broadcaster = (ClusterServicesBroadcaster)this.applicationContext.getBean("clusterServicesBroadcaster", ClusterServicesBroadcaster.class);
                String clusterManagerProtocolServiceName = (String)this.applicationContext.getBean("clusterManagerProtocolServiceName", String.class);
                DiscoverableServiceImpl clusterManagerProtocolService = new DiscoverableServiceImpl(clusterManagerProtocolServiceName, this.properties.getClusterManagerProtocolAddress());
                broadcaster.addService((DiscoverableService)clusterManagerProtocolService);
                this.clusterManager.setServicesBroadcaster(broadcaster);
            }
            this.clusterManager.setEventManager((EventManager)this.applicationContext.getBean("nodeEventHistoryManager", EventManager.class));
            this.clusterManager.setClusterFirewall((ClusterNodeFirewall)this.applicationContext.getBean("clusterFirewall", ClusterNodeFirewall.class));
            this.clusterManager.setAuditService((AuditService)this.applicationContext.getBean("auditService", AuditService.class));
        }
        return this.clusterManager;
    }

    public Class getObjectType() {
        return WebClusterManager.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setProperties(NiFiProperties properties) {
        this.properties = properties;
    }

    public void setEncryptor(StringEncryptor encryptor) {
        this.encryptor = encryptor;
    }

    public void setOptimisticLockingManager(OptimisticLockingManager optimisticLockingManager) {
        this.optimisticLockingManager = optimisticLockingManager;
    }
}

