/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.manager.impl;

import com.sun.jersey.api.client.ClientResponse;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.StreamingOutput;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.admin.service.AuditService;
import org.apache.nifi.annotation.lifecycle.OnAdded;
import org.apache.nifi.annotation.lifecycle.OnConfigurationRestored;
import org.apache.nifi.annotation.lifecycle.OnRemoved;
import org.apache.nifi.cluster.BulletinsPayload;
import org.apache.nifi.cluster.HeartbeatPayload;
import org.apache.nifi.cluster.context.ClusterContext;
import org.apache.nifi.cluster.context.ClusterContextImpl;
import org.apache.nifi.cluster.event.Event;
import org.apache.nifi.cluster.event.EventManager;
import org.apache.nifi.cluster.firewall.ClusterNodeFirewall;
import org.apache.nifi.cluster.flow.ClusterDataFlow;
import org.apache.nifi.cluster.flow.DaoException;
import org.apache.nifi.cluster.flow.DataFlowManagementService;
import org.apache.nifi.cluster.flow.PersistedFlowState;
import org.apache.nifi.cluster.manager.HttpClusterManager;
import org.apache.nifi.cluster.manager.HttpRequestReplicator;
import org.apache.nifi.cluster.manager.HttpResponseMapper;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.cluster.manager.exception.ConflictingNodeIdException;
import org.apache.nifi.cluster.manager.exception.ConnectingNodeMutableRequestException;
import org.apache.nifi.cluster.manager.exception.DisconnectedNodeMutableRequestException;
import org.apache.nifi.cluster.manager.exception.IllegalClusterStateException;
import org.apache.nifi.cluster.manager.exception.IllegalNodeDeletionException;
import org.apache.nifi.cluster.manager.exception.IllegalNodeDisconnectionException;
import org.apache.nifi.cluster.manager.exception.IllegalNodeReconnectionException;
import org.apache.nifi.cluster.manager.exception.IneligiblePrimaryNodeException;
import org.apache.nifi.cluster.manager.exception.NoConnectedNodesException;
import org.apache.nifi.cluster.manager.exception.NoResponseFromNodesException;
import org.apache.nifi.cluster.manager.exception.NodeDisconnectionException;
import org.apache.nifi.cluster.manager.exception.NodeReconnectionException;
import org.apache.nifi.cluster.manager.exception.PrimaryRoleAssignmentException;
import org.apache.nifi.cluster.manager.exception.SafeModeMutableRequestException;
import org.apache.nifi.cluster.manager.exception.UnknownNodeException;
import org.apache.nifi.cluster.manager.exception.UriConstructionException;
import org.apache.nifi.cluster.manager.impl.ClusteredEventAccess;
import org.apache.nifi.cluster.node.Node;
import org.apache.nifi.cluster.protocol.ConnectionRequest;
import org.apache.nifi.cluster.protocol.ConnectionResponse;
import org.apache.nifi.cluster.protocol.Heartbeat;
import org.apache.nifi.cluster.protocol.NodeBulletins;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.cluster.protocol.ProtocolException;
import org.apache.nifi.cluster.protocol.ProtocolHandler;
import org.apache.nifi.cluster.protocol.StandardDataFlow;
import org.apache.nifi.cluster.protocol.impl.ClusterManagerProtocolSenderListener;
import org.apache.nifi.cluster.protocol.impl.ClusterServicesBroadcaster;
import org.apache.nifi.cluster.protocol.message.ConnectionRequestMessage;
import org.apache.nifi.cluster.protocol.message.ConnectionResponseMessage;
import org.apache.nifi.cluster.protocol.message.ControllerStartupFailureMessage;
import org.apache.nifi.cluster.protocol.message.DisconnectMessage;
import org.apache.nifi.cluster.protocol.message.HeartbeatMessage;
import org.apache.nifi.cluster.protocol.message.NodeBulletinsMessage;
import org.apache.nifi.cluster.protocol.message.PrimaryRoleAssignmentMessage;
import org.apache.nifi.cluster.protocol.message.ProtocolMessage;
import org.apache.nifi.cluster.protocol.message.ReconnectionFailureMessage;
import org.apache.nifi.cluster.protocol.message.ReconnectionRequestMessage;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.state.StateManagerProvider;
import org.apache.nifi.controller.ConfiguredComponent;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.Heartbeater;
import org.apache.nifi.controller.ProcessScheduler;
import org.apache.nifi.controller.ReportingTaskNode;
import org.apache.nifi.controller.ScheduledState;
import org.apache.nifi.controller.StandardFlowSerializer;
import org.apache.nifi.controller.ValidationContextFactory;
import org.apache.nifi.controller.exception.ComponentLifeCycleException;
import org.apache.nifi.controller.queue.DropFlowFileState;
import org.apache.nifi.controller.queue.ListFlowFileState;
import org.apache.nifi.controller.reporting.ClusteredReportingTaskNode;
import org.apache.nifi.controller.reporting.ReportingTaskInstantiationException;
import org.apache.nifi.controller.reporting.ReportingTaskProvider;
import org.apache.nifi.controller.reporting.StandardReportingInitializationContext;
import org.apache.nifi.controller.scheduling.QuartzSchedulingAgent;
import org.apache.nifi.controller.scheduling.SchedulingAgent;
import org.apache.nifi.controller.scheduling.StandardProcessScheduler;
import org.apache.nifi.controller.scheduling.TimerDrivenSchedulingAgent;
import org.apache.nifi.controller.service.ControllerServiceLoader;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.controller.service.ControllerServiceState;
import org.apache.nifi.controller.service.StandardControllerServiceProvider;
import org.apache.nifi.controller.state.SortedStateUtils;
import org.apache.nifi.controller.state.manager.StandardStateManagerProvider;
import org.apache.nifi.controller.status.ProcessGroupStatus;
import org.apache.nifi.controller.status.RemoteProcessGroupStatus;
import org.apache.nifi.controller.status.history.ComponentStatusRepository;
import org.apache.nifi.controller.status.history.StatusHistory;
import org.apache.nifi.controller.status.history.StatusHistoryUtil;
import org.apache.nifi.controller.status.history.StatusSnapshot;
import org.apache.nifi.diagnostics.GarbageCollection;
import org.apache.nifi.diagnostics.StorageUsage;
import org.apache.nifi.diagnostics.SystemDiagnostics;
import org.apache.nifi.encrypt.StringEncryptor;
import org.apache.nifi.engine.FlowEngine;
import org.apache.nifi.events.BulletinFactory;
import org.apache.nifi.events.VolatileBulletinRepository;
import org.apache.nifi.framework.security.util.SslContextFactory;
import org.apache.nifi.io.socket.multicast.DiscoverableService;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.logging.ControllerServiceLogObserver;
import org.apache.nifi.logging.LogLevel;
import org.apache.nifi.logging.LogObserver;
import org.apache.nifi.logging.LogRepository;
import org.apache.nifi.logging.LogRepositoryFactory;
import org.apache.nifi.logging.NiFiLog;
import org.apache.nifi.logging.ReportingTaskLogObserver;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.nar.NarCloseable;
import org.apache.nifi.nar.NarThreadContextClassLoader;
import org.apache.nifi.processor.SimpleProcessLogger;
import org.apache.nifi.processor.StandardValidationContextFactory;
import org.apache.nifi.registry.VariableRegistry;
import org.apache.nifi.registry.VariableRegistryFactory;
import org.apache.nifi.registry.VariableRegistryUtils;
import org.apache.nifi.remote.RemoteResourceManager;
import org.apache.nifi.remote.RemoteSiteListener;
import org.apache.nifi.remote.SocketRemoteSiteListener;
import org.apache.nifi.remote.cluster.ClusterNodeInformation;
import org.apache.nifi.remote.cluster.NodeInformant;
import org.apache.nifi.remote.cluster.NodeInformation;
import org.apache.nifi.remote.protocol.socket.ClusterManagerServerProtocol;
import org.apache.nifi.reporting.Bulletin;
import org.apache.nifi.reporting.BulletinRepository;
import org.apache.nifi.reporting.InitializationException;
import org.apache.nifi.reporting.ReportingInitializationContext;
import org.apache.nifi.reporting.ReportingTask;
import org.apache.nifi.reporting.Severity;
import org.apache.nifi.scheduling.SchedulingStrategy;
import org.apache.nifi.util.DomUtils;
import org.apache.nifi.util.FormatUtils;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.util.ObjectHolder;
import org.apache.nifi.util.ReflectionUtils;
import org.apache.nifi.web.OptimisticLockingManager;
import org.apache.nifi.web.Revision;
import org.apache.nifi.web.UpdateRevision;
import org.apache.nifi.web.api.dto.ComponentStateDTO;
import org.apache.nifi.web.api.dto.ControllerServiceDTO;
import org.apache.nifi.web.api.dto.ControllerServiceReferencingComponentDTO;
import org.apache.nifi.web.api.dto.DropRequestDTO;
import org.apache.nifi.web.api.dto.FlowFileSummaryDTO;
import org.apache.nifi.web.api.dto.FlowSnippetDTO;
import org.apache.nifi.web.api.dto.ListingRequestDTO;
import org.apache.nifi.web.api.dto.NodeDTO;
import org.apache.nifi.web.api.dto.ProcessGroupDTO;
import org.apache.nifi.web.api.dto.ProcessorDTO;
import org.apache.nifi.web.api.dto.QueueSizeDTO;
import org.apache.nifi.web.api.dto.RemoteProcessGroupContentsDTO;
import org.apache.nifi.web.api.dto.RemoteProcessGroupDTO;
import org.apache.nifi.web.api.dto.ReportingTaskDTO;
import org.apache.nifi.web.api.dto.StateEntryDTO;
import org.apache.nifi.web.api.dto.StateMapDTO;
import org.apache.nifi.web.api.dto.provenance.ProvenanceDTO;
import org.apache.nifi.web.api.dto.provenance.ProvenanceEventDTO;
import org.apache.nifi.web.api.dto.provenance.ProvenanceRequestDTO;
import org.apache.nifi.web.api.dto.provenance.ProvenanceResultsDTO;
import org.apache.nifi.web.api.dto.status.ClusterStatusHistoryDTO;
import org.apache.nifi.web.api.dto.status.NodeStatusHistoryDTO;
import org.apache.nifi.web.api.dto.status.StatusHistoryDTO;
import org.apache.nifi.web.api.dto.status.StatusSnapshotDTO;
import org.apache.nifi.web.api.entity.ComponentStateEntity;
import org.apache.nifi.web.api.entity.ControllerServiceEntity;
import org.apache.nifi.web.api.entity.ControllerServiceReferencingComponentsEntity;
import org.apache.nifi.web.api.entity.ControllerServicesEntity;
import org.apache.nifi.web.api.entity.DropRequestEntity;
import org.apache.nifi.web.api.entity.Entity;
import org.apache.nifi.web.api.entity.FlowSnippetEntity;
import org.apache.nifi.web.api.entity.ListingRequestEntity;
import org.apache.nifi.web.api.entity.ProcessGroupEntity;
import org.apache.nifi.web.api.entity.ProcessorEntity;
import org.apache.nifi.web.api.entity.ProcessorsEntity;
import org.apache.nifi.web.api.entity.ProvenanceEntity;
import org.apache.nifi.web.api.entity.ProvenanceEventEntity;
import org.apache.nifi.web.api.entity.RemoteProcessGroupEntity;
import org.apache.nifi.web.api.entity.RemoteProcessGroupsEntity;
import org.apache.nifi.web.api.entity.ReportingTaskEntity;
import org.apache.nifi.web.api.entity.ReportingTasksEntity;
import org.apache.nifi.web.security.user.NiFiUserDetails;
import org.apache.nifi.web.util.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class WebClusterManager
implements HttpClusterManager,
ProtocolHandler,
ControllerServiceProvider,
ReportingTaskProvider {
    public static final String ROOT_GROUP_ID_ALIAS = "root";
    public static final String BULLETIN_CATEGORY = "Clustering";
    private static final Logger logger = new NiFiLog(LoggerFactory.getLogger(WebClusterManager.class));
    private static final Logger heartbeatLogger = new NiFiLog(LoggerFactory.getLogger((String)"org.apache.nifi.cluster.heartbeat"));
    public static final String CLUSTER_CONTEXT_HTTP_HEADER = "X-ClusterContext";
    public static final String REQUEST_ID_HEADER = "X-RequestID";
    public static final String NCM_EXPECTS_HTTP_HEADER = "X-NcmExpects";
    public static final int NODE_CONTINUE_STATUS_CODE = 150;
    public static final String CLUSTER_INVALIDATE_USER_GROUP_HEADER = "X-ClusterInvalidateUserGroup";
    public static final String CLUSTER_INVALIDATE_USER_HEADER = "X-ClusterInvalidateUser";
    private static final int DEFAULT_CONNECTION_REQUEST_TRY_AGAIN_SECONDS = 5;
    public static final String DEFAULT_COMPONENT_STATUS_REPO_IMPLEMENTATION = "org.apache.nifi.controller.status.history.VolatileComponentStatusRepository";
    public static final Pattern PROCESSORS_URI_PATTERN = Pattern.compile("/nifi-api/controller/process-groups/(?:(?:root)|(?:[a-f0-9\\-]{36}))/processors");
    public static final Pattern PROCESSOR_URI_PATTERN = Pattern.compile("/nifi-api/controller/process-groups/(?:(?:root)|(?:[a-f0-9\\-]{36}))/processors/[a-f0-9\\-]{36}");
    public static final Pattern PROCESSOR_STATE_URI_PATTERN = Pattern.compile("/nifi-api/controller/process-groups/(?:(?:root)|(?:[a-f0-9\\-]{36}))/processors/[a-f0-9\\-]{36}/state");
    public static final Pattern CLUSTER_PROCESSOR_URI_PATTERN = Pattern.compile("/nifi-api/cluster/processors/[a-f0-9\\-]{36}");
    public static final Pattern REMOTE_PROCESS_GROUPS_URI_PATTERN = Pattern.compile("/nifi-api/controller/process-groups/(?:(?:root)|(?:[a-f0-9\\-]{36}))/remote-process-groups");
    public static final Pattern REMOTE_PROCESS_GROUP_URI_PATTERN = Pattern.compile("/nifi-api/controller/process-groups/(?:(?:root)|(?:[a-f0-9\\-]{36}))/remote-process-groups/[a-f0-9\\-]{36}");
    public static final Pattern PROCESS_GROUP_URI_PATTERN = Pattern.compile("/nifi-api/controller/process-groups/(?:(?:root)|(?:[a-f0-9\\-]{36}))");
    public static final Pattern TEMPLATE_INSTANCE_URI_PATTERN = Pattern.compile("/nifi-api/controller/process-groups/(?:(?:root)|(?:[a-f0-9\\-]{36}))/template-instance");
    public static final Pattern FLOW_SNIPPET_INSTANCE_URI_PATTERN = Pattern.compile("/nifi-api/controller/process-groups/(?:(?:root)|(?:[a-f0-9\\-]{36}))/snippet-instance");
    public static final String PROVENANCE_URI = "/nifi-api/controller/provenance";
    public static final Pattern PROVENANCE_QUERY_URI = Pattern.compile("/nifi-api/controller/provenance/[a-f0-9\\-]{36}");
    public static final Pattern PROVENANCE_EVENT_URI = Pattern.compile("/nifi-api/controller/provenance/events/[0-9]+");
    public static final Pattern COUNTERS_URI = Pattern.compile("/nifi-api/controller/counters/[a-f0-9\\-]{36}");
    public static final String CONTROLLER_SERVICES_URI = "/nifi-api/controller/controller-services/node";
    public static final Pattern CONTROLLER_SERVICE_URI_PATTERN = Pattern.compile("/nifi-api/controller/controller-services/node/[a-f0-9\\-]{36}");
    public static final Pattern CONTROLLER_SERVICE_STATE_URI_PATTERN = Pattern.compile("/nifi-api/controller/controller-services/node/[a-f0-9\\-]{36}/state");
    public static final Pattern CONTROLLER_SERVICE_REFERENCES_URI_PATTERN = Pattern.compile("/nifi-api/controller/controller-services/node/[a-f0-9\\-]{36}/references");
    public static final String REPORTING_TASKS_URI = "/nifi-api/controller/reporting-tasks/node";
    public static final Pattern REPORTING_TASK_URI_PATTERN = Pattern.compile("/nifi-api/controller/reporting-tasks/node/[a-f0-9\\-]{36}");
    public static final Pattern REPORTING_TASK_STATE_URI_PATTERN = Pattern.compile("/nifi-api/controller/reporting-tasks/node/[a-f0-9\\-]{36}/state");
    @Deprecated
    public static final Pattern QUEUE_CONTENTS_URI = Pattern.compile("/nifi-api/controller/process-groups/(?:(?:root)|(?:[a-f0-9\\-]{36}))/connections/[a-f0-9\\-]{36}/contents");
    public static final Pattern DROP_REQUESTS_URI = Pattern.compile("/nifi-api/controller/process-groups/(?:(?:root)|(?:[a-f0-9\\-]{36}))/connections/[a-f0-9\\-]{36}/drop-requests");
    public static final Pattern DROP_REQUEST_URI = Pattern.compile("/nifi-api/controller/process-groups/(?:(?:root)|(?:[a-f0-9\\-]{36}))/connections/[a-f0-9\\-]{36}/drop-requests/[a-f0-9\\-]{36}");
    public static final Pattern LISTING_REQUESTS_URI = Pattern.compile("/nifi-api/controller/process-groups/(?:(?:root)|(?:[a-f0-9\\-]{36}))/connections/[a-f0-9\\-]{36}/listing-requests");
    public static final Pattern LISTING_REQUEST_URI = Pattern.compile("/nifi-api/controller/process-groups/(?:(?:root)|(?:[a-f0-9\\-]{36}))/connections/[a-f0-9\\-]{36}/listing-requests/[a-f0-9\\-]{36}");
    private final NiFiProperties properties;
    private final HttpRequestReplicator httpRequestReplicator;
    private final HttpResponseMapper httpResponseMapper;
    private final DataFlowManagementService dataFlowManagementService;
    private final ClusterManagerProtocolSenderListener senderListener;
    private final OptimisticLockingManager optimisticLockingManager;
    private final StringEncryptor encryptor;
    private final Queue<Heartbeat> pendingHeartbeats = new ConcurrentLinkedQueue<Heartbeat>();
    private final ReentrantReadWriteLock resourceRWLock = new ReentrantReadWriteLock(true);
    private final ClusterManagerLock readLock = new ClusterManagerLock(this.resourceRWLock.readLock(), "Read");
    private final ClusterManagerLock writeLock = new ClusterManagerLock(this.resourceRWLock.writeLock(), "Write");
    private final Set<Node> nodes = new HashSet<Node>();
    private final ConcurrentMap<String, ReportingTaskNode> reportingTasks = new ConcurrentHashMap<String, ReportingTaskNode>();
    private StandardDataFlow cachedDataFlow = null;
    private NodeIdentifier primaryNodeId = null;
    private Timer heartbeatMonitor;
    private Timer heartbeatProcessor;
    private volatile ClusterServicesBroadcaster servicesBroadcaster = null;
    private volatile EventManager eventManager = null;
    private volatile ClusterNodeFirewall clusterFirewall = null;
    private volatile AuditService auditService = null;
    private volatile ControllerServiceProvider controllerServiceProvider = null;
    private final RemoteSiteListener remoteSiteListener;
    private final Integer remoteInputPort;
    private final Boolean remoteCommsSecure;
    private final BulletinRepository bulletinRepository;
    private final String instanceId;
    private final FlowEngine reportingTaskEngine;
    private final Map<NodeIdentifier, ComponentStatusRepository> componentMetricsRepositoryMap = new HashMap<NodeIdentifier, ComponentStatusRepository>();
    private final StandardProcessScheduler processScheduler;
    private final StateManagerProvider stateManagerProvider;
    private final long componentStatusSnapshotMillis;
    private final VariableRegistry variableRegistry;

    public WebClusterManager(HttpRequestReplicator httpRequestReplicator, HttpResponseMapper httpResponseMapper, DataFlowManagementService dataFlowManagementService, ClusterManagerProtocolSenderListener senderListener, NiFiProperties properties, StringEncryptor encryptor, OptimisticLockingManager optimisticLockingManager) {
        long snapshotMillis;
        if (httpRequestReplicator == null) {
            throw new IllegalArgumentException("HttpRequestReplicator may not be null.");
        }
        if (httpResponseMapper == null) {
            throw new IllegalArgumentException("HttpResponseMapper may not be null.");
        }
        if (dataFlowManagementService == null) {
            throw new IllegalArgumentException("DataFlowManagementService may not be null.");
        }
        if (senderListener == null) {
            throw new IllegalArgumentException("ClusterManagerProtocolSenderListener may not be null.");
        }
        if (properties == null) {
            throw new IllegalArgumentException("NiFiProperties may not be null.");
        }
        this.httpRequestReplicator = httpRequestReplicator;
        this.httpResponseMapper = httpResponseMapper;
        this.dataFlowManagementService = dataFlowManagementService;
        this.properties = properties;
        this.bulletinRepository = new VolatileBulletinRepository();
        this.instanceId = UUID.randomUUID().toString();
        this.senderListener = senderListener;
        this.encryptor = encryptor;
        this.optimisticLockingManager = optimisticLockingManager;
        senderListener.addHandler((ProtocolHandler)this);
        senderListener.setBulletinRepository(this.bulletinRepository);
        this.variableRegistry = this.createVariableRegistry(properties);
        String snapshotFrequency = properties.getProperty("nifi.components.status.snapshot.frequency", "5 mins");
        try {
            snapshotMillis = FormatUtils.getTimeDuration((String)snapshotFrequency, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            snapshotMillis = FormatUtils.getTimeDuration((String)"5 mins", (TimeUnit)TimeUnit.MILLISECONDS);
        }
        this.componentStatusSnapshotMillis = snapshotMillis;
        this.remoteInputPort = properties.getRemoteInputPort();
        if (this.remoteInputPort == null) {
            this.remoteSiteListener = null;
            this.remoteCommsSecure = null;
        } else {
            RemoteResourceManager.setServerProtocolImplementation((String)"SocketFlowFileProtocol", ClusterManagerServerProtocol.class);
            this.remoteCommsSecure = properties.isSiteToSiteSecure();
            if (this.remoteCommsSecure.booleanValue()) {
                SSLContext sslContext = SslContextFactory.createSslContext((NiFiProperties)properties, (boolean)false);
                if (sslContext == null) {
                    throw new IllegalStateException("NiFi Configured to allow Secure Site-to-Site communications but the Keystore/Truststore properties are not configured");
                }
                this.remoteSiteListener = new SocketRemoteSiteListener(this.remoteInputPort.intValue(), sslContext, (NodeInformant)this);
            } else {
                this.remoteSiteListener = new SocketRemoteSiteListener(this.remoteInputPort.intValue(), null, (NodeInformant)this);
            }
        }
        this.reportingTaskEngine = new FlowEngine(8, "Reporting Task Thread");
        try {
            this.stateManagerProvider = StandardStateManagerProvider.create((NiFiProperties)properties, (VariableRegistry)this.variableRegistry);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.processScheduler = new StandardProcessScheduler(new Heartbeater(){

            public void heartbeat() {
            }
        }, (ControllerServiceProvider)this, encryptor, this.stateManagerProvider, this.variableRegistry);
        this.processScheduler.setSchedulingAgent(SchedulingStrategy.TIMER_DRIVEN, (SchedulingAgent)new TimerDrivenSchedulingAgent(null, this.reportingTaskEngine, null, encryptor, this.variableRegistry));
        this.processScheduler.setSchedulingAgent(SchedulingStrategy.CRON_DRIVEN, (SchedulingAgent)new QuartzSchedulingAgent(null, this.reportingTaskEngine, null, encryptor, this.variableRegistry));
        this.processScheduler.setMaxThreadCount(SchedulingStrategy.TIMER_DRIVEN, 10);
        this.processScheduler.setMaxThreadCount(SchedulingStrategy.CRON_DRIVEN, 10);
        this.processScheduler.scheduleFrameworkTask((Runnable)new CaptureComponentMetrics(), "Capture Component Metrics", this.componentStatusSnapshotMillis, this.componentStatusSnapshotMillis, TimeUnit.MILLISECONDS);
        this.controllerServiceProvider = new StandardControllerServiceProvider((ProcessScheduler)this.processScheduler, this.bulletinRepository, this.stateManagerProvider, this.variableRegistry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws IOException {
        this.writeLock.lock();
        try {
            if (this.isRunning()) {
                throw new IllegalStateException("Instance is already started.");
            }
            try {
                this.heartbeatMonitor = new Timer("Heartbeat Monitor", true);
                this.heartbeatMonitor.schedule((TimerTask)new HeartbeatMonitoringTimerTask(), 0L, (long)(this.getHeartbeatMonitoringIntervalSeconds() * 1000));
                this.heartbeatProcessor = new Timer("Process Pending Heartbeats", true);
                int processPendingHeartbeatDelay = 1000 * Math.max(1, this.getClusterProtocolHeartbeatSeconds() / 2);
                this.heartbeatProcessor.schedule((TimerTask)new ProcessPendingHeartbeatsTask(), processPendingHeartbeatDelay, (long)processPendingHeartbeatDelay);
                this.httpRequestReplicator.start();
                this.senderListener.start();
                this.dataFlowManagementService.start();
                if (this.remoteSiteListener != null) {
                    this.remoteSiteListener.start();
                }
                if (!this.dataFlowManagementService.isFlowCurrent()) {
                    throw new IOException("Flow is not current.");
                }
                ClusterDataFlow clusterDataFlow = this.dataFlowManagementService.loadDataFlow();
                this.cachedDataFlow = clusterDataFlow.getDataFlow();
                this.primaryNodeId = clusterDataFlow.getPrimaryNodeId();
                byte[] serializedServices = clusterDataFlow.getControllerServices();
                if (serializedServices != null && serializedServices.length > 0) {
                    ControllerServiceLoader.loadControllerServices((ControllerServiceProvider)this, (InputStream)new ByteArrayInputStream(serializedServices), (StringEncryptor)this.encryptor, (BulletinRepository)this.bulletinRepository, (boolean)this.properties.getAutoResumeState());
                }
                if (this.servicesBroadcaster != null) {
                    this.servicesBroadcaster.start();
                }
                this.executeSafeModeTask();
                byte[] serializedReportingTasks = clusterDataFlow.getReportingTasks();
                if (serializedReportingTasks != null && serializedReportingTasks.length > 0) {
                    this.loadReportingTasks(serializedReportingTasks);
                }
                this.notifyComponentsConfigurationRestored();
            }
            catch (IOException ioe) {
                logger.warn("Failed to initialize cluster services due to: " + ioe, (Throwable)ioe);
                this.stop();
                throw ioe;
            }
        }
        finally {
            this.writeLock.unlock("START");
        }
    }

    public void stop() throws IOException {
        this.writeLock.lock();
        try {
            if (!this.isRunning()) {
                throw new IllegalArgumentException("Instance is already stopped.");
            }
            boolean encounteredException = false;
            if (this.isHeartbeatMonitorRunning()) {
                this.heartbeatMonitor.cancel();
                this.heartbeatMonitor = null;
            }
            if (this.heartbeatProcessor != null) {
                this.heartbeatProcessor.cancel();
                this.heartbeatProcessor = null;
            }
            if (this.httpRequestReplicator.isRunning()) {
                this.httpRequestReplicator.stop();
            }
            if (this.dataFlowManagementService.isRunning()) {
                this.dataFlowManagementService.stop();
            }
            if (this.remoteSiteListener != null) {
                this.remoteSiteListener.stop();
            }
            if (this.senderListener.isRunning()) {
                try {
                    this.senderListener.stop();
                }
                catch (IOException ioe) {
                    encounteredException = true;
                    logger.warn("Failed to shutdown protocol service due to: " + ioe, (Throwable)ioe);
                }
            }
            if (this.isBroadcasting()) {
                this.servicesBroadcaster.stop();
            }
            if (this.processScheduler != null) {
                this.processScheduler.shutdown();
            }
            if (encounteredException) {
                throw new IOException("Failed to shutdown Cluster Manager because one or more cluster services failed to shutdown.  Check the logs for details.");
            }
        }
        finally {
            this.writeLock.unlock("STOP");
        }
    }

    public boolean isRunning() {
        this.readLock.lock();
        try {
            boolean bl = this.isHeartbeatMonitorRunning() || this.httpRequestReplicator.isRunning() || this.senderListener.isRunning() || this.dataFlowManagementService.isRunning() || this.isBroadcasting();
            return bl;
        }
        finally {
            this.readLock.unlock("isRunning");
        }
    }

    public boolean canHandle(ProtocolMessage msg) {
        return ProtocolMessage.MessageType.CONNECTION_REQUEST == msg.getType() || ProtocolMessage.MessageType.HEARTBEAT == msg.getType() || ProtocolMessage.MessageType.CONTROLLER_STARTUP_FAILURE == msg.getType() || ProtocolMessage.MessageType.BULLETINS == msg.getType() || ProtocolMessage.MessageType.RECONNECTION_FAILURE == msg.getType();
    }

    public ProtocolMessage handle(final ProtocolMessage protocolMessage) throws ProtocolException {
        switch (protocolMessage.getType()) {
            case CONNECTION_REQUEST: {
                return this.handleConnectionRequest((ConnectionRequestMessage)protocolMessage);
            }
            case HEARTBEAT: {
                HeartbeatMessage heartbeatMessage = (HeartbeatMessage)protocolMessage;
                Heartbeat original = heartbeatMessage.getHeartbeat();
                NodeIdentifier originalNodeId = original.getNodeIdentifier();
                Heartbeat heartbeatWithDn = new Heartbeat(this.addRequestorDn(originalNodeId, heartbeatMessage.getRequestorDN()), original.isPrimary(), original.isConnected(), original.getPayload());
                this.handleHeartbeat(heartbeatWithDn);
                return null;
            }
            case CONTROLLER_STARTUP_FAILURE: {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        WebClusterManager.this.handleControllerStartupFailure((ControllerStartupFailureMessage)protocolMessage);
                    }
                }, "Handle Controller Startup Failure Message from " + ((ControllerStartupFailureMessage)protocolMessage).getNodeId()).start();
                return null;
            }
            case RECONNECTION_FAILURE: {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        WebClusterManager.this.handleReconnectionFailure((ReconnectionFailureMessage)protocolMessage);
                    }
                }, "Handle Reconnection Failure Message from " + ((ReconnectionFailureMessage)protocolMessage).getNodeId()).start();
                return null;
            }
            case BULLETINS: {
                NodeBulletinsMessage bulletinsMessage = (NodeBulletinsMessage)protocolMessage;
                this.handleBulletins(bulletinsMessage.getBulletins());
                return null;
            }
        }
        throw new ProtocolException("No handler defined for message type: " + protocolMessage.getType());
    }

    private void notifyComponentsConfigurationRestored() {
        Throwable throwable;
        NarCloseable nc;
        for (ControllerServiceNode serviceNode : this.getAllControllerServices()) {
            ControllerService service = serviceNode.getControllerServiceImplementation();
            nc = NarCloseable.withNarLoader();
            throwable = null;
            try {
                ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnConfigurationRestored.class, (Object)service, (Object[])new Object[0]);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (nc == null) continue;
                if (throwable != null) {
                    try {
                        nc.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                nc.close();
            }
        }
        for (ReportingTaskNode taskNode : this.getAllReportingTasks()) {
            ReportingTask task = taskNode.getReportingTask();
            nc = NarCloseable.withNarLoader();
            throwable = null;
            try {
                ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnConfigurationRestored.class, (Object)task, (Object[])new Object[0]);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (nc == null) continue;
                if (throwable != null) {
                    try {
                        nc.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    continue;
                }
                nc.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectionResponse requestConnection(ConnectionRequest request) {
        boolean lockObtained = this.writeLock.tryLock(3L, TimeUnit.SECONDS);
        if (!lockObtained) {
            int tryAgainSeconds = this.dataFlowManagementService.getRetrievalDelaySeconds() <= 0 ? 5 : this.dataFlowManagementService.getRetrievalDelaySeconds();
            String msg = "Connection requested from node, but manager was too busy to service request.  Instructing node to try again in " + tryAgainSeconds + " seconds.";
            this.addEvent(request.getProposedNodeIdentifier(), msg);
            this.addBulletin(request.getProposedNodeIdentifier(), Severity.INFO, msg);
            return new ConnectionResponse(tryAgainSeconds);
        }
        try {
            NodeIdentifier resolvedNodeIdentifier;
            try {
                resolvedNodeIdentifier = this.resolveProposedNodeIdentifier(request.getProposedNodeIdentifier());
            }
            catch (ConflictingNodeIdException e) {
                logger.info("Rejecting node {} from connecting to cluster because it provided a Node ID of {} but that Node ID already belongs to {}:{}", new Object[]{request.getProposedNodeIdentifier().getSocketAddress(), request.getProposedNodeIdentifier().getId(), e.getConflictingNodeAddress(), e.getConflictingNodePort()});
                ConnectionResponse connectionResponse = ConnectionResponse.createConflictingNodeIdResponse((String)(e.getConflictingNodeAddress() + ":" + e.getConflictingNodePort()));
                this.writeLock.unlock("requestConnection");
                return connectionResponse;
            }
            if (this.isBlockedByFirewall(resolvedNodeIdentifier.getSocketAddress())) {
                logger.info("Firewall blocked connection request from node " + resolvedNodeIdentifier);
                ConnectionResponse e = ConnectionResponse.createBlockedByFirewallResponse();
                return e;
            }
            Node node = this.getRawNode(resolvedNodeIdentifier.getId());
            if (node == null) {
                node = new Node(resolvedNodeIdentifier, Node.Status.CONNECTING);
                this.addEvent(node.getNodeId(), "Connection requested from new node.  Setting status to connecting.");
                this.nodes.add(node);
            } else {
                node.setStatus(Node.Status.CONNECTING);
                this.addEvent(resolvedNodeIdentifier, "Connection requested from existing node.  Setting status to connecting");
            }
            node.setConnectionRequestedTimestamp(new Date().getTime());
            node.setHeartbeat(null);
            if (this.dataFlowManagementService.isFlowCurrent()) {
                boolean primaryRole;
                if (this.cachedDataFlow == null) {
                    ClusterDataFlow clusterDataFlow = this.dataFlowManagementService.loadDataFlow();
                    this.cachedDataFlow = clusterDataFlow.getDataFlow();
                    this.primaryNodeId = clusterDataFlow.getPrimaryNodeId();
                }
                if (this.primaryNodeId == null || this.primaryNodeId.logicallyEquals(node.getNodeId())) {
                    this.setPrimaryNodeId(node.getNodeId());
                    this.addEvent(node.getNodeId(), "Setting primary role in connection response.");
                    primaryRole = true;
                } else {
                    primaryRole = false;
                }
                ConnectionResponse connectionResponse = new ConnectionResponse(node.getNodeId(), this.cachedDataFlow, primaryRole, this.remoteInputPort, this.remoteCommsSecure, this.instanceId);
                return connectionResponse;
            }
            int tryAgainSeconds = this.dataFlowManagementService.getRetrievalDelaySeconds() <= 0 ? 5 : this.dataFlowManagementService.getRetrievalDelaySeconds();
            this.addEvent(node.getNodeId(), "Connection requested from node, but manager was unable to obtain current flow.  Instructing node to try again in " + tryAgainSeconds + " seconds.");
            ConnectionResponse connectionResponse = new ConnectionResponse(tryAgainSeconds);
            return connectionResponse;
        }
        finally {
            this.writeLock.unlock("requestConnection");
        }
    }

    @Override
    public void requestReconnection(String nodeId, String userDn) throws UnknownNodeException, IllegalNodeReconnectionException {
        int tryAgainSeconds;
        boolean primaryRole;
        Node node = null;
        this.writeLock.lock();
        try {
            node = this.getRawNode(nodeId);
            logger.info("Request was made by {} to reconnect node {} to cluster", (Object)userDn, node == null ? nodeId : node);
            if (node == null) {
                throw new UnknownNodeException("Node does not exist.");
            }
            if (Node.Status.DISCONNECTED != node.getStatus()) {
                throw new IllegalNodeReconnectionException("Node must be disconnected before it can reconnect.");
            }
            node.setHeartbeat(null);
            if (!this.dataFlowManagementService.isFlowCurrent()) {
                String msg = "Reconnection requested for node, but manager was unable to obtain current flow.  Setting node to disconnected.";
                this.addEvent(node.getNodeId(), "Reconnection requested for node, but manager was unable to obtain current flow.  Setting node to disconnected.");
                this.addBulletin(node, Severity.WARNING, "Reconnection requested for node, but manager was unable to obtain current flow.  Setting node to disconnected.");
                throw new NodeReconnectionException("Manager was unable to obtain current flow to provide in reconnection request to node.  Try again in a few seconds.");
            }
            if (this.cachedDataFlow == null) {
                ClusterDataFlow clusterDataFlow = this.dataFlowManagementService.loadDataFlow();
                this.cachedDataFlow = clusterDataFlow.getDataFlow();
                this.primaryNodeId = clusterDataFlow.getPrimaryNodeId();
            }
            node.setStatus(Node.Status.CONNECTING);
            this.addEvent(node.getNodeId(), "Reconnection requested for node.  Setting status to connecting.");
            if (this.primaryNodeId == null || this.primaryNodeId.logicallyEquals(node.getNodeId())) {
                this.setPrimaryNodeId(node.getNodeId());
                this.addEvent(node.getNodeId(), "Setting primary role in reconnection request.");
                primaryRole = true;
            } else {
                primaryRole = false;
            }
            tryAgainSeconds = this.dataFlowManagementService.getRetrievalDelaySeconds() <= 0 ? 5 : this.dataFlowManagementService.getRetrievalDelaySeconds();
        }
        catch (IllegalNodeReconnectionException | NodeReconnectionException | UnknownNodeException une) {
            throw une;
        }
        catch (Exception ex) {
            logger.warn("Problem encountered issuing reconnection request to node " + node.getNodeId() + " due to: " + ex, (Throwable)ex);
            node.setStatus(Node.Status.DISCONNECTED);
            String eventMsg = "Problem encountered issuing reconnection request. Node will remain disconnected: " + ex;
            this.addEvent(node.getNodeId(), eventMsg);
            this.addBulletin(node, Severity.WARNING, eventMsg);
            throw new NodeReconnectionException("Problem encountered issuing reconnection request to " + node.getNodeId() + ". Node will remain disconnected: " + ex, ex);
        }
        finally {
            this.writeLock.unlock("requestReconnection");
        }
        this.requestReconnectionAsynchronously(node, primaryRole, 10, tryAgainSeconds);
    }

    private void requestReconnectionAsynchronously(final Node node, final boolean primaryRole, final int reconnectionAttempts, final int retrySeconds) {
        Thread reconnectionThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                for (int i = 0; i < reconnectionAttempts; ++i) {
                    ReconnectionRequestMessage request = new ReconnectionRequestMessage();
                    try {
                        WebClusterManager.this.readLock.lock();
                        try {
                            if (Node.Status.CONNECTING != node.getStatus()) {
                                return;
                            }
                            request.setNodeId(node.getNodeId());
                            request.setDataFlow(WebClusterManager.this.cachedDataFlow);
                            request.setPrimary(primaryRole);
                            request.setManagerRemoteSiteCommsSecure(WebClusterManager.this.remoteCommsSecure);
                            request.setManagerRemoteSiteListeningPort(WebClusterManager.this.remoteInputPort);
                            request.setInstanceId(WebClusterManager.this.instanceId);
                        }
                        finally {
                            WebClusterManager.this.readLock.unlock("Reconnect " + node.getNodeId());
                        }
                        WebClusterManager.this.senderListener.requestReconnection(request);
                        node.setConnectionRequestedTimestamp(System.currentTimeMillis());
                        return;
                    }
                    catch (Exception e) {
                        logger.warn("Problem encountered issuing reconnection request to node " + node.getNodeId() + " due to: " + e);
                        if (logger.isDebugEnabled()) {
                            logger.warn("", (Throwable)e);
                        }
                        WebClusterManager.this.addBulletin(node, Severity.WARNING, "Problem encountered issuing reconnection request to node " + node.getNodeId() + " due to: " + e);
                        try {
                            Thread.sleep(1000L * (long)retrySeconds);
                            continue;
                        }
                        catch (InterruptedException ie) {
                            break;
                        }
                    }
                }
                WebClusterManager.this.writeLock.lock();
                try {
                    if (Node.Status.CONNECTING == node.getStatus()) {
                        WebClusterManager.this.requestDisconnectionQuietly(node.getNodeId(), "Failed to issue Reconnection Request " + reconnectionAttempts + " times");
                    }
                }
                finally {
                    WebClusterManager.this.writeLock.unlock("Mark node as Disconnected as a result of reconnection failure");
                }
            }
        }, "Reconnect " + node.getNodeId());
        reconnectionThread.start();
    }

    private VariableRegistry createVariableRegistry(NiFiProperties properties) {
        VariableRegistry variableRegistry = VariableRegistryUtils.createVariableRegistry();
        try {
            VariableRegistry customRegistry = VariableRegistryFactory.getPropertiesInstance((Path[])properties.getVariableRegistryPropertiesPaths());
            variableRegistry.addRegistry(customRegistry);
        }
        catch (IOException ioe) {
            logger.error("Exception thrown while attempting to add properties to registry", (Throwable)ioe);
        }
        return variableRegistry;
    }

    private Map<String, ReportingTaskNode> loadReportingTasks(byte[] serialized) {
        HashMap<String, ReportingTaskNode> tasks;
        block33: {
            tasks = new HashMap<String, ReportingTaskNode>();
            try {
                Document document = this.parse(serialized);
                NodeList tasksNodes = document.getElementsByTagName("reportingTasks");
                Element tasksElement = (Element)tasksNodes.item(0);
                for (Element taskElement : DomUtils.getChildElementsByTagName((Element)tasksElement, (String)"reportingTask")) {
                    HashMap<PropertyDescriptor, String> resolvedProps;
                    ReportingTaskNode reportingTaskNode;
                    HashMap<String, String> properties = new HashMap<String, String>();
                    String taskId = DomUtils.getChild((Element)taskElement, (String)"id").getTextContent().trim();
                    String taskName = DomUtils.getChild((Element)taskElement, (String)"name").getTextContent().trim();
                    List schedulingStrategyNodeList = DomUtils.getChildElementsByTagName((Element)taskElement, (String)"schedulingStrategy");
                    String schedulingStrategyValue = SchedulingStrategy.TIMER_DRIVEN.name();
                    if (schedulingStrategyNodeList.size() == 1) {
                        String specifiedValue = ((Element)schedulingStrategyNodeList.get(0)).getTextContent();
                        try {
                            schedulingStrategyValue = SchedulingStrategy.valueOf((String)specifiedValue).name();
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Cannot start Reporting Task with id " + taskId + " because its Scheduling Strategy does not have a valid value", e);
                        }
                    }
                    SchedulingStrategy schedulingStrategy = SchedulingStrategy.valueOf((String)schedulingStrategyValue);
                    String taskSchedulingPeriod = DomUtils.getChild((Element)taskElement, (String)"schedulingPeriod").getTextContent().trim();
                    String taskClass = DomUtils.getChild((Element)taskElement, (String)"class").getTextContent().trim();
                    String scheduleStateValue = DomUtils.getChild((Element)taskElement, (String)"scheduledState").getTextContent().trim();
                    ScheduledState scheduledState = ScheduledState.valueOf((String)scheduleStateValue);
                    for (Element property : DomUtils.getChildElementsByTagName((Element)taskElement, (String)"property")) {
                        String name = DomUtils.getChildText((Element)property, (String)"name");
                        String value = DomUtils.getChildText((Element)property, (String)"value");
                        properties.put(name, value);
                    }
                    try {
                        reportingTaskNode = this.createReportingTask(taskClass, taskId, false);
                    }
                    catch (ReportingTaskInstantiationException e) {
                        logger.error("Unable to load reporting task {} due to {}", new Object[]{taskId, e});
                        if (!logger.isDebugEnabled()) continue;
                        logger.error("", (Throwable)e);
                        continue;
                    }
                    ReportingTask reportingTask = reportingTaskNode.getReportingTask();
                    SimpleProcessLogger componentLog = new SimpleProcessLogger(taskId, (Object)reportingTask);
                    StandardReportingInitializationContext config = new StandardReportingInitializationContext(taskId, taskName, schedulingStrategy, taskSchedulingPeriod, (ComponentLog)componentLog, (ControllerServiceProvider)this);
                    reportingTask.initialize((ReportingInitializationContext)config);
                    String annotationData = DomUtils.getChildText((Element)taskElement, (String)"annotationData");
                    if (annotationData != null) {
                        reportingTaskNode.setAnnotationData(annotationData.trim());
                    }
                    Throwable throwable = null;
                    try (NarCloseable narCloseable = NarCloseable.withNarLoader();){
                        resolvedProps = new HashMap<PropertyDescriptor, String>();
                        for (Map.Entry entry : properties.entrySet()) {
                            PropertyDescriptor descriptor = reportingTask.getPropertyDescriptor((String)entry.getKey());
                            if (entry.getValue() == null) {
                                resolvedProps.put(descriptor, descriptor.getDefaultValue());
                                continue;
                            }
                            resolvedProps.put(descriptor, (String)entry.getValue());
                        }
                    }
                    catch (Throwable throwable2) {
                        Throwable throwable3 = throwable2;
                        throw throwable2;
                    }
                    for (Map.Entry entry : resolvedProps.entrySet()) {
                        if (entry.getValue() == null) continue;
                        reportingTaskNode.setProperty(((PropertyDescriptor)entry.getKey()).getName(), (String)entry.getValue());
                    }
                    String comments = DomUtils.getChildText((Element)taskElement, (String)"comment");
                    if (comments != null) {
                        reportingTaskNode.setComments(comments);
                    }
                    reportingTaskNode.setScheduledState(scheduledState);
                    if (ScheduledState.RUNNING.equals((Object)scheduledState)) {
                        if (reportingTaskNode.isValid()) {
                            try {
                                this.processScheduler.schedule(reportingTaskNode);
                            }
                            catch (Exception exception) {
                                logger.error("Failed to start {} due to {}", (Object)reportingTaskNode, (Object)exception);
                                if (logger.isDebugEnabled()) {
                                    logger.error("", (Throwable)exception);
                                }
                            }
                        } else {
                            logger.error("Failed to start {} because it is invalid due to {}", (Object)reportingTaskNode, (Object)reportingTaskNode.getValidationErrors());
                        }
                    }
                    tasks.put(reportingTaskNode.getIdentifier(), reportingTaskNode);
                }
            }
            catch (IOException | NumberFormatException | ParserConfigurationException | InitializationException | DOMException | SAXException t) {
                logger.error("Unable to load reporting tasks due to {}", new Object[]{t});
                if (!logger.isDebugEnabled()) break block33;
                logger.error("", t);
            }
        }
        return tasks;
    }

    public ReportingTaskNode createReportingTask(String type, String id, boolean firstTimeAdded) throws ReportingTaskInstantiationException {
        if (type == null) {
            throw new NullPointerException();
        }
        ReportingTask task = null;
        ClassLoader ctxClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader detectedClassLoader = ExtensionManager.getClassLoader((String)type);
            Class<?> rawClass = detectedClassLoader == null ? Class.forName(type) : Class.forName(type, false, detectedClassLoader);
            Thread.currentThread().setContextClassLoader(detectedClassLoader);
            Class<ReportingTask> reportingTaskClass = rawClass.asSubclass(ReportingTask.class);
            ReportingTask reportingTaskObj = reportingTaskClass.newInstance();
            task = reportingTaskClass.cast(reportingTaskObj);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException t) {
            throw new ReportingTaskInstantiationException(type, (Throwable)t);
        }
        finally {
            if (ctxClassLoader != null) {
                Thread.currentThread().setContextClassLoader(ctxClassLoader);
            }
        }
        StandardValidationContextFactory validationContextFactory = new StandardValidationContextFactory((ControllerServiceProvider)this, this.variableRegistry);
        ClusteredReportingTaskNode taskNode = new ClusteredReportingTaskNode(task, id, (ProcessScheduler)this.processScheduler, new ClusteredEventAccess(this, this.auditService), this.bulletinRepository, this.controllerServiceProvider, (ValidationContextFactory)validationContextFactory, this.stateManagerProvider.getStateManager(id), null);
        taskNode.setName(task.getClass().getSimpleName());
        this.reportingTasks.put(id, (ReportingTaskNode)taskNode);
        if (firstTimeAdded) {
            try (NarCloseable x = NarCloseable.withNarLoader();){
                ReflectionUtils.invokeMethodsWithAnnotation(OnAdded.class, (Object)task, (Object[])new Object[0]);
                ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnConfigurationRestored.class, (Object)taskNode.getReportingTask(), (Object[])new Object[0]);
            }
            catch (Exception e) {
                throw new ComponentLifeCycleException("Failed to invoke On-Added Lifecycle methods of " + task, (Throwable)e);
            }
        }
        LogRepository logRepository = LogRepositoryFactory.getRepository((String)id);
        logRepository.addObserver("bulletin-observer", LogLevel.WARN, (LogObserver)new ReportingTaskLogObserver(this.getBulletinRepository(), (ReportingTaskNode)taskNode));
        return taskNode;
    }

    private Document parse(byte[] serialized) throws SAXException, ParserConfigurationException, IOException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        docFactory.setNamespaceAware(true);
        DocumentBuilder builder = docFactory.newDocumentBuilder();
        builder.setErrorHandler(new ErrorHandler(){

            @Override
            public void fatalError(SAXParseException err) throws SAXException {
                logger.error("Config file line " + err.getLineNumber() + ", col " + err.getColumnNumber() + ", uri " + err.getSystemId() + " :message: " + err.getMessage());
                if (logger.isDebugEnabled()) {
                    logger.error("Error Stack Dump", (Throwable)err);
                }
                throw err;
            }

            @Override
            public void error(SAXParseException err) throws SAXParseException {
                logger.error("Config file line " + err.getLineNumber() + ", col " + err.getColumnNumber() + ", uri " + err.getSystemId() + " :message: " + err.getMessage());
                if (logger.isDebugEnabled()) {
                    logger.error("Error Stack Dump", (Throwable)err);
                }
                throw err;
            }

            @Override
            public void warning(SAXParseException err) throws SAXParseException {
                logger.warn(" Config file line " + err.getLineNumber() + ", uri " + err.getSystemId() + " : message : " + err.getMessage());
                if (logger.isDebugEnabled()) {
                    logger.warn("Warning stack dump", (Throwable)err);
                }
                throw err;
            }
        });
        Document document = builder.parse(new ByteArrayInputStream(serialized));
        return document;
    }

    private void addBulletin(Node node, Severity severity, String msg) {
        this.addBulletin(node.getNodeId(), severity, msg);
    }

    private void addBulletin(NodeIdentifier nodeId, Severity severity, String msg) {
        this.bulletinRepository.addBulletin(BulletinFactory.createBulletin((String)BULLETIN_CATEGORY, (String)severity.toString(), (String)(nodeId.getApiAddress() + ":" + nodeId.getApiPort() + " -- " + msg)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestDisconnection(String nodeId, String userDn) throws UnknownNodeException, IllegalNodeDisconnectionException, NodeDisconnectionException {
        this.writeLock.lock();
        try {
            Node node = this.getNode(nodeId);
            if (node == null) {
                throw new UnknownNodeException("Node does not exist.");
            }
            this.requestDisconnection(node.getNodeId(), false, "User " + userDn + " Disconnected Node");
        }
        finally {
            this.writeLock.unlock("requestDisconnection(String)");
        }
    }

    private void requestDisconnectionQuietly(NodeIdentifier nodeId, String explanation) {
        try {
            this.requestDisconnection(nodeId, true, explanation);
        }
        catch (IllegalNodeDisconnectionException | NodeDisconnectionException clusterException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestDisconnection(NodeIdentifier nodeId, boolean ignoreNodeChecks, String explanation) throws IllegalNodeDisconnectionException, NodeDisconnectionException {
        this.writeLock.lock();
        try {
            Node node = this.getRawNode(nodeId.getId());
            if (node == null) {
                if (ignoreNodeChecks) {
                    DisconnectMessage request = new DisconnectMessage();
                    request.setNodeId(nodeId);
                    request.setExplanation(explanation);
                    this.addEvent(nodeId, "Disconnection requested due to " + explanation);
                    this.senderListener.disconnect(request);
                    this.addEvent(nodeId, "Node disconnected due to " + explanation);
                    this.addBulletin(nodeId, Severity.INFO, "Node disconnected due to " + explanation);
                    return;
                }
                throw new UnknownNodeException("Node does not exist");
            }
            if (!ignoreNodeChecks) {
                Set<NodeIdentifier> connectedNodes = this.getNodeIds(Node.Status.CONNECTED);
                if (connectedNodes.size() == 1 && connectedNodes.iterator().next().equals((Object)nodeId)) {
                    throw new IllegalNodeDisconnectionException("Node may not be disconnected because it is the only connected node in the cluster.");
                }
                if (this.isPrimaryNode(nodeId)) {
                    throw new IllegalNodeDisconnectionException("Node may not be disconnected because it is the primary node in the cluster.");
                }
            }
            node.setStatus(Node.Status.DISCONNECTED);
            this.notifyDataFlowManagementServiceOfNodeStatusChange();
            DisconnectMessage request = new DisconnectMessage();
            request.setNodeId(nodeId);
            request.setExplanation(explanation);
            this.addEvent(nodeId, "Disconnection requested due to " + explanation);
            this.senderListener.disconnect(request);
            this.addEvent(nodeId, "Node disconnected due to " + explanation);
            this.addBulletin(node, Severity.INFO, "Node disconnected due to " + explanation);
        }
        finally {
            this.writeLock.unlock("requestDisconnection(NodeIdentifier, boolean)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean assignPrimaryRole(NodeIdentifier nodeId) {
        this.writeLock.lock();
        try {
            PrimaryRoleAssignmentMessage msg = new PrimaryRoleAssignmentMessage();
            msg.setNodeId(nodeId);
            msg.setPrimary(true);
            logger.info("Attempting to assign primary role to node: " + nodeId);
            this.senderListener.assignPrimaryRole(msg);
            logger.info("Assigned primary role to node: " + nodeId);
            this.addBulletin(nodeId, Severity.INFO, "Node assigned primary role");
            boolean bl = true;
            return bl;
        }
        catch (ProtocolException ex) {
            logger.warn("Failed attempt to assign primary role to node " + nodeId + " due to " + (Object)((Object)ex));
            this.addBulletin(nodeId, Severity.ERROR, "Failed to assign primary role to node due to: " + (Object)((Object)ex));
            Node node = this.getRawNode(nodeId.getId());
            node.setStatus(Node.Status.DISCONNECTED);
            this.addEvent(node.getNodeId(), "Disconnected because of failed attempt to assign primary role.");
            this.addBulletin(nodeId, Severity.WARNING, "Node disconnected because of failed attempt to assign primary role");
            boolean bl = false;
            return bl;
        }
        finally {
            this.writeLock.unlock("assignPrimaryRole");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean revokePrimaryRole(NodeIdentifier nodeId) {
        this.writeLock.lock();
        try {
            PrimaryRoleAssignmentMessage msg = new PrimaryRoleAssignmentMessage();
            msg.setNodeId(nodeId);
            msg.setPrimary(false);
            logger.info("Attempting to revoke primary role from node: " + nodeId);
            this.senderListener.assignPrimaryRole(msg);
            logger.info("Revoked primary role from node: " + nodeId);
            this.addBulletin(nodeId, Severity.INFO, "Primary Role revoked from node");
            boolean bl = true;
            return bl;
        }
        catch (ProtocolException ex) {
            logger.warn("Failed attempt to revoke primary role from node " + nodeId + " due to " + (Object)((Object)ex));
            Node node = this.getRawNode(nodeId.getId());
            node.setStatus(Node.Status.DISCONNECTED);
            this.addEvent(node.getNodeId(), "Disconnected because of failed attempt to revoke primary role.");
            this.addBulletin(node, Severity.ERROR, "Node disconnected because of failed attempt to revoke primary role");
            boolean bl = false;
            return bl;
        }
        finally {
            this.writeLock.unlock("revokePrimaryRole");
        }
    }

    private NodeIdentifier addRequestorDn(NodeIdentifier nodeId, String dn) {
        return new NodeIdentifier(nodeId.getId(), nodeId.getApiAddress(), nodeId.getApiPort(), nodeId.getSocketAddress(), nodeId.getSocketPort(), nodeId.getSiteToSiteAddress(), nodeId.getSiteToSitePort(), nodeId.isSiteToSiteSecure(), dn);
    }

    private ConnectionResponseMessage handleConnectionRequest(ConnectionRequestMessage requestMessage) {
        NodeIdentifier proposedIdentifier = requestMessage.getConnectionRequest().getProposedNodeIdentifier();
        ConnectionRequest requestWithDn = new ConnectionRequest(this.addRequestorDn(proposedIdentifier, requestMessage.getRequestorDN()));
        ConnectionResponse response = this.requestConnection(requestWithDn);
        ConnectionResponseMessage responseMessage = new ConnectionResponseMessage();
        responseMessage.setConnectionResponse(response);
        return responseMessage;
    }

    private void handleControllerStartupFailure(ControllerStartupFailureMessage msg) {
        this.writeLock.lock();
        try {
            Node node = this.getRawNode(msg.getNodeId().getId());
            if (node != null) {
                node.setStatus(Node.Status.DISCONNECTED);
                this.addEvent(msg.getNodeId(), "Node could not join cluster because it failed to start up properly. Setting node to Disconnected. Node reported the following error: " + msg.getExceptionMessage());
                this.addBulletin(node, Severity.ERROR, "Node could not join cluster because it failed to start up properly. Setting node to Disconnected. Node reported the following error: " + msg.getExceptionMessage());
            }
        }
        finally {
            this.writeLock.unlock("handleControllerStartupFailure");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleReconnectionFailure(ReconnectionFailureMessage msg) {
        this.writeLock.lock();
        try {
            Node node = this.getRawNode(msg.getNodeId().getId());
            if (node != null) {
                node.setStatus(Node.Status.DISCONNECTED);
                String errorMsg = "Node could not rejoin cluster. Setting node to Disconnected. Node reported the following error: " + msg.getExceptionMessage();
                this.addEvent(msg.getNodeId(), errorMsg);
                this.addBulletin(node, Severity.ERROR, errorMsg);
            }
        }
        finally {
            this.writeLock.unlock("handleControllerStartupFailure");
        }
    }

    public ControllerServiceNode createControllerService(String type, String id, boolean firstTimeAdded) {
        ControllerServiceNode serviceNode = this.controllerServiceProvider.createControllerService(type, id, firstTimeAdded);
        LogRepository logRepository = LogRepositoryFactory.getRepository((String)id);
        logRepository.addObserver("bulletin-observer", LogLevel.WARN, (LogObserver)new ControllerServiceLogObserver(this.getBulletinRepository(), serviceNode));
        if (firstTimeAdded) {
            ControllerService service = serviceNode.getControllerServiceImplementation();
            try (NarCloseable nc = NarCloseable.withNarLoader();){
                ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnConfigurationRestored.class, (Object)service, (Object[])new Object[0]);
            }
        }
        return serviceNode;
    }

    public StateManagerProvider getStateManagerProvider() {
        return this.stateManagerProvider;
    }

    public ControllerService getControllerService(String serviceIdentifier) {
        return this.controllerServiceProvider.getControllerService(serviceIdentifier);
    }

    public ControllerServiceNode getControllerServiceNode(String id) {
        return this.controllerServiceProvider.getControllerServiceNode(id);
    }

    public boolean isControllerServiceEnabled(ControllerService service) {
        return this.controllerServiceProvider.isControllerServiceEnabled(service);
    }

    public boolean isControllerServiceEnabled(String serviceIdentifier) {
        return this.controllerServiceProvider.isControllerServiceEnabled(serviceIdentifier);
    }

    public boolean isControllerServiceEnabling(String serviceIdentifier) {
        return this.controllerServiceProvider.isControllerServiceEnabling(serviceIdentifier);
    }

    public String getControllerServiceName(String serviceIdentifier) {
        return this.controllerServiceProvider.getControllerServiceName(serviceIdentifier);
    }

    public void removeControllerService(ControllerServiceNode serviceNode) {
        this.controllerServiceProvider.removeControllerService(serviceNode);
    }

    public void enableControllerService(ControllerServiceNode serviceNode) {
        this.controllerServiceProvider.enableControllerService(serviceNode);
    }

    public void enableControllerServices(Collection<ControllerServiceNode> serviceNodes) {
        this.controllerServiceProvider.enableControllerServices(serviceNodes);
    }

    public void disableControllerService(ControllerServiceNode serviceNode) {
        this.controllerServiceProvider.disableControllerService(serviceNode);
    }

    public Set<ControllerServiceNode> getAllControllerServices() {
        return this.controllerServiceProvider.getAllControllerServices();
    }

    public void disableReferencingServices(ControllerServiceNode serviceNode) {
        this.controllerServiceProvider.disableReferencingServices(serviceNode);
    }

    public void enableReferencingServices(ControllerServiceNode serviceNode) {
        this.controllerServiceProvider.enableReferencingServices(serviceNode);
    }

    public void scheduleReferencingComponents(ControllerServiceNode serviceNode) {
        this.controllerServiceProvider.scheduleReferencingComponents(serviceNode);
    }

    public void unscheduleReferencingComponents(ControllerServiceNode serviceNode) {
        this.controllerServiceProvider.unscheduleReferencingComponents(serviceNode);
    }

    public void verifyCanEnableReferencingServices(ControllerServiceNode serviceNode) {
        this.controllerServiceProvider.verifyCanEnableReferencingServices(serviceNode);
    }

    public void verifyCanScheduleReferencingComponents(ControllerServiceNode serviceNode) {
        this.controllerServiceProvider.verifyCanScheduleReferencingComponents(serviceNode);
    }

    public void verifyCanDisableReferencingServices(ControllerServiceNode serviceNode) {
        this.controllerServiceProvider.verifyCanDisableReferencingServices(serviceNode);
    }

    public void verifyCanStopReferencingComponents(ControllerServiceNode serviceNode) {
        this.controllerServiceProvider.verifyCanStopReferencingComponents(serviceNode);
    }

    private byte[] serialize(Document doc) throws TransformerException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DOMSource domSource = new DOMSource(doc);
        StreamResult streamResult = new StreamResult(baos);
        TransformerFactory transformFactory = TransformerFactory.newInstance();
        Transformer transformer = transformFactory.newTransformer();
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        transformer.setOutputProperty("indent", "yes");
        transformer.transform(domSource, streamResult);
        return baos.toByteArray();
    }

    private byte[] serializeControllerServices() throws ParserConfigurationException, TransformerException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        docFactory.setNamespaceAware(true);
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document document = docBuilder.newDocument();
        Element rootElement = document.createElement("controllerServices");
        document.appendChild(rootElement);
        for (ControllerServiceNode serviceNode : this.getAllControllerServices()) {
            StandardFlowSerializer.addControllerService((Element)rootElement, (ControllerServiceNode)serviceNode, (StringEncryptor)this.encryptor);
        }
        return this.serialize(document);
    }

    private byte[] serializeReportingTasks() throws ParserConfigurationException, TransformerException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        docFactory.setNamespaceAware(true);
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document document = docBuilder.newDocument();
        Element rootElement = document.createElement("reportingTasks");
        document.appendChild(rootElement);
        for (ReportingTaskNode taskNode : this.getAllReportingTasks()) {
            StandardFlowSerializer.addReportingTask((Element)rootElement, (ReportingTaskNode)taskNode, (StringEncryptor)this.encryptor);
        }
        return this.serialize(document);
    }

    public void saveControllerServices() {
        try {
            this.dataFlowManagementService.updateControllerServices(this.serializeControllerServices());
        }
        catch (Exception e) {
            logger.error("Failed to save changes to NCM's Controller Services; changes may be lost on restart due to " + e);
            if (logger.isDebugEnabled()) {
                logger.error("", (Throwable)e);
            }
            this.getBulletinRepository().addBulletin(BulletinFactory.createBulletin((String)"Controller Services", (String)Severity.ERROR.name(), (String)"Failed to save changes to NCM's Controller Services; changes may be lost on restart. See logs for more details."));
        }
    }

    public void saveReportingTasks() {
        try {
            this.dataFlowManagementService.updateReportingTasks(this.serializeReportingTasks());
        }
        catch (Exception e) {
            logger.error("Failed to save changes to NCM's Reporting Tasks; changes may be lost on restart due to " + e);
            if (logger.isDebugEnabled()) {
                logger.error("", (Throwable)e);
            }
            this.getBulletinRepository().addBulletin(BulletinFactory.createBulletin((String)"Reporting Tasks", (String)Severity.ERROR.name(), (String)"Failed to save changes to NCM's Reporting Tasks; changes may be lost on restart. See logs for more details."));
        }
    }

    public Set<ReportingTaskNode> getAllReportingTasks() {
        this.readLock.lock();
        try {
            HashSet<ReportingTaskNode> hashSet = new HashSet<ReportingTaskNode>(this.reportingTasks.values());
            return hashSet;
        }
        finally {
            this.readLock.unlock("getReportingTasks");
        }
    }

    public ReportingTaskNode getReportingTaskNode(String taskId) {
        this.readLock.lock();
        try {
            ReportingTaskNode reportingTaskNode = (ReportingTaskNode)this.reportingTasks.get(taskId);
            return reportingTaskNode;
        }
        finally {
            this.readLock.unlock("getReportingTaskNode");
        }
    }

    public void startReportingTask(ReportingTaskNode reportingTaskNode) {
        reportingTaskNode.verifyCanStart();
        this.processScheduler.schedule(reportingTaskNode);
    }

    public void stopReportingTask(ReportingTaskNode reportingTaskNode) {
        reportingTaskNode.verifyCanStop();
        this.processScheduler.unschedule(reportingTaskNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeReportingTask(ReportingTaskNode reportingTaskNode) {
        this.writeLock.lock();
        try {
            ReportingTaskNode existing = (ReportingTaskNode)this.reportingTasks.get(reportingTaskNode.getIdentifier());
            if (existing == null || existing != reportingTaskNode) {
                throw new IllegalStateException("Reporting Task " + reportingTaskNode + " does not exist in this Flow");
            }
            reportingTaskNode.verifyCanDelete();
            try (NarCloseable x = NarCloseable.withNarLoader();){
                ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnRemoved.class, (Object)reportingTaskNode.getReportingTask(), (Object[])new Object[]{reportingTaskNode.getConfigurationContext()});
            }
            for (Map.Entry entry : reportingTaskNode.getProperties().entrySet()) {
                ControllerServiceNode serviceNode;
                String value;
                PropertyDescriptor descriptor = (PropertyDescriptor)entry.getKey();
                if (descriptor.getControllerServiceDefinition() == null || (value = entry.getValue() == null ? descriptor.getDefaultValue() : (String)entry.getValue()) == null || (serviceNode = this.controllerServiceProvider.getControllerServiceNode(value)) == null) continue;
                serviceNode.removeReference((ConfiguredComponent)reportingTaskNode);
            }
            this.reportingTasks.remove(reportingTaskNode.getIdentifier());
        }
        finally {
            this.writeLock.unlock("removeReportingTask");
        }
    }

    public void disableReportingTask(ReportingTaskNode reportingTask) {
        reportingTask.verifyCanDisable();
        this.processScheduler.disableReportingTask(reportingTask);
    }

    public void enableReportingTask(ReportingTaskNode reportingTask) {
        reportingTask.verifyCanEnable();
        this.processScheduler.enableReportingTask(reportingTask);
    }

    public void handleBulletins(NodeBulletins bulletins) {
        NodeIdentifier nodeIdentifier = bulletins.getNodeIdentifier();
        String nodeAddress = nodeIdentifier.getApiAddress() + ":" + nodeIdentifier.getApiPort();
        BulletinsPayload payload = BulletinsPayload.unmarshal((byte[])bulletins.getPayload());
        for (Bulletin bulletin : payload.getBulletins()) {
            bulletin.setNodeAddress(nodeAddress);
            this.bulletinRepository.addBulletin(bulletin);
        }
    }

    @Override
    public void handleHeartbeat(Heartbeat heartbeat) {
        if (heartbeat == null) {
            throw new IllegalArgumentException("Heartbeat may not be null.");
        }
        if (heartbeat.getNodeIdentifier() == null) {
            throw new IllegalArgumentException("Heartbeat does not contain a node ID.");
        }
        this.pendingHeartbeats.add(heartbeat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPendingHeartbeats() {
        this.writeLock.lock();
        try {
            Heartbeat aHeartbeat;
            HashMap<NodeIdentifier, Heartbeat> mostRecentHeartbeatsMap = new HashMap<NodeIdentifier, Heartbeat>();
            while ((aHeartbeat = this.pendingHeartbeats.poll()) != null) {
                mostRecentHeartbeatsMap.put(aHeartbeat.getNodeIdentifier(), aHeartbeat);
            }
            ArrayList mostRecentHeartbeats = new ArrayList(mostRecentHeartbeatsMap.values());
            if (mostRecentHeartbeats.isEmpty()) {
                return;
            }
            this.logNodes("Before Heartbeat Processing", heartbeatLogger);
            int numPendingHeartbeats = mostRecentHeartbeats.size();
            if (heartbeatLogger.isDebugEnabled()) {
                heartbeatLogger.debug(String.format("Handling %s heartbeat%s", numPendingHeartbeats, numPendingHeartbeats > 1 ? "s" : ""));
            }
            for (Heartbeat mostRecentHeartbeat : mostRecentHeartbeats) {
                try {
                    boolean heartbeatIndicatesNotYetConnected;
                    NodeIdentifier resolvedNodeIdentifier = this.resolveProposedNodeIdentifier(mostRecentHeartbeat.getNodeIdentifier());
                    Node node = this.getRawNode(resolvedNodeIdentifier.getId());
                    if (mostRecentHeartbeat.isPrimary() && !this.isPrimaryNode(resolvedNodeIdentifier)) {
                        this.addEvent(resolvedNodeIdentifier, "Heartbeat indicates node is running as primary node.  Revoking primary role because primary role is assigned to a different node.");
                        this.revokePrimaryRole(resolvedNodeIdentifier);
                    }
                    boolean bl = heartbeatIndicatesNotYetConnected = !mostRecentHeartbeat.isConnected();
                    if (this.isBlockedByFirewall(resolvedNodeIdentifier.getSocketAddress())) {
                        if (node == null) {
                            logger.info("Firewall blocked heartbeat received from unknown node " + resolvedNodeIdentifier + ".  Issuing disconnection request.");
                        } else {
                            this.addEvent(resolvedNodeIdentifier, "Firewall blocked received heartbeat.  Issuing disconnection request.");
                        }
                        this.requestDisconnectionQuietly(resolvedNodeIdentifier, "Blocked By Firewall");
                        continue;
                    }
                    if (node == null) {
                        Node newNode = new Node(resolvedNodeIdentifier, Node.Status.DISCONNECTED);
                        this.nodes.add(newNode);
                        this.addEvent(newNode.getNodeId(), "Received heartbeat from unknown node.  Issuing reconnection request.");
                        newNode.setHeartbeat(mostRecentHeartbeat);
                        this.requestReconnection(resolvedNodeIdentifier.getId(), "NCM Heartbeat Processing");
                        continue;
                    }
                    if (heartbeatIndicatesNotYetConnected) {
                        if (Node.Status.CONNECTED != node.getStatus()) continue;
                        this.addEvent(node.getNodeId(), "Received heartbeat from node that thinks it is not yet part of the cluster, though the Manager thought it was. Marking as Disconnected and issuing reconnection request.");
                        node.setHeartbeat(null);
                        node.setStatus(Node.Status.DISCONNECTED);
                        this.requestReconnection(resolvedNodeIdentifier.getId(), "NCM Heartbeat Processing");
                        continue;
                    }
                    if (Node.Status.DISCONNECTED == node.getStatus()) {
                        if (node.isHeartbeatDisconnection() || this.nodes.size() == 1) {
                            if (node.isHeartbeatDisconnection()) {
                                this.addEvent(resolvedNodeIdentifier, "Received heartbeat from node previously disconnected due to lack of heartbeat.  Issuing reconnection request.");
                            } else {
                                this.addEvent(resolvedNodeIdentifier, "Received heartbeat from node previously disconnected, but it is the only known node, so issuing reconnection request.");
                            }
                            node.setHeartbeat(mostRecentHeartbeat);
                            this.requestReconnection(resolvedNodeIdentifier.getId(), "NCM Heartbeat Processing");
                            continue;
                        }
                        heartbeatLogger.info("Ignoring received heartbeat from disconnected node " + resolvedNodeIdentifier + ".  Issuing disconnection request.");
                        this.requestDisconnectionQuietly(resolvedNodeIdentifier, "Received Heartbeat from Node, but Manager has already marked Node as Disconnected");
                        continue;
                    }
                    if (Node.Status.DISCONNECTING == node.getStatus()) continue;
                    if (Node.Status.CONNECTING == node.getStatus()) {
                        if (mostRecentHeartbeat.getCreatedTimestamp() < node.getConnectionRequestedTimestamp()) {
                            heartbeatLogger.info("Received heartbeat for node " + resolvedNodeIdentifier + " but ignoring because it was generated before the node was last asked to reconnect.");
                            continue;
                        }
                        node.setStatus(Node.Status.CONNECTED);
                        this.addEvent(resolvedNodeIdentifier, "Received first heartbeat from connecting node.  Setting node to connected.");
                        this.notifyDataFlowManagementServiceOfNodeStatusChange();
                        this.addBulletin(node, Severity.INFO, "Node Connected");
                    } else {
                        heartbeatLogger.info("Received heartbeat for node " + resolvedNodeIdentifier + ".");
                    }
                    node.setHeartbeat(mostRecentHeartbeat);
                }
                catch (Exception e) {
                    logger.error("Failed to process heartbeat from {}:{} due to {}", new Object[]{mostRecentHeartbeat.getNodeIdentifier().getApiAddress(), mostRecentHeartbeat.getNodeIdentifier().getApiPort(), e.toString()});
                    if (!logger.isDebugEnabled()) continue;
                    logger.error("", (Throwable)e);
                }
            }
            this.logNodes("After Heartbeat Processing", heartbeatLogger);
        }
        finally {
            this.writeLock.unlock("processPendingHeartbeats");
        }
    }

    private ComponentStatusRepository createComponentStatusRepository() {
        String implementationClassName = this.properties.getProperty("nifi.components.status.repository.implementation", DEFAULT_COMPONENT_STATUS_REPO_IMPLEMENTATION);
        if (implementationClassName == null) {
            throw new RuntimeException("Cannot create Component Status Repository because the NiFi Properties is missing the following property: nifi.components.status.repository.implementation");
        }
        try {
            return (ComponentStatusRepository)NarThreadContextClassLoader.createInstance((String)implementationClassName, ComponentStatusRepository.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Node> getNodes(Node.Status ... statuses) {
        HashSet<Node.Status> desiredStatusSet = new HashSet<Node.Status>();
        for (Node.Status status : statuses) {
            desiredStatusSet.add(status);
        }
        this.readLock.lock();
        try {
            HashSet<Node> clonedNodes = new HashSet<Node>();
            for (Node node : this.nodes) {
                if (!desiredStatusSet.isEmpty() && !desiredStatusSet.contains((Object)node.getStatus())) continue;
                clonedNodes.add(node.clone());
            }
            Set set = Collections.unmodifiableSet(clonedNodes);
            return set;
        }
        finally {
            this.readLock.unlock("getNodes(Status...)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node getNode(String nodeId) {
        this.readLock.lock();
        try {
            for (Node node : this.nodes) {
                if (!node.getNodeId().getId().equals(nodeId)) continue;
                Node node2 = node.clone();
                return node2;
            }
            Iterator<Node> iterator = null;
            return iterator;
        }
        finally {
            this.readLock.unlock("getNode(String)");
        }
    }

    @Override
    public Node getPrimaryNode() {
        this.readLock.lock();
        try {
            if (this.primaryNodeId == null) {
                Node node = null;
                return node;
            }
            Node node = this.getNode(this.primaryNodeId.getId());
            return node;
        }
        finally {
            this.readLock.unlock("getPrimaryNode");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteNode(String nodeId, String userDn) throws UnknownNodeException, IllegalNodeDeletionException {
        block6: {
            this.writeLock.lock();
            try {
                Node node = this.getNode(nodeId);
                if (node == null) {
                    throw new UnknownNodeException("Node does not exist.");
                }
                if (Node.Status.DISCONNECTED == node.getStatus()) {
                    this.nodes.remove(node);
                    if (this.eventManager != null) {
                        this.eventManager.clearEventHistory(node.getNodeId().getId());
                    }
                    logger.info("Removing node {} from cluster because this action was requested by {}", (Object)node, (Object)userDn);
                    break block6;
                }
                throw new IllegalNodeDeletionException("Node may not be deleted because it is not disconnected.");
            }
            finally {
                this.writeLock.unlock("deleteNode");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<NodeIdentifier> getNodeIds(Node.Status ... statuses) {
        this.readLock.lock();
        try {
            HashSet<NodeIdentifier> nodeIds = new HashSet<NodeIdentifier>();
            block3: for (Node node : this.nodes) {
                if (statuses == null || statuses.length == 0) {
                    nodeIds.add(node.getNodeId());
                    continue;
                }
                for (Node.Status status : statuses) {
                    if (node.getStatus() != status) continue;
                    nodeIds.add(node.getNodeId());
                    continue block3;
                }
            }
            HashSet<NodeIdentifier> hashSet = nodeIds;
            return hashSet;
        }
        finally {
            this.readLock.unlock("getNodeIds(Status...)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPrimaryNode(String nodeId, String userDn) throws UnknownNodeException, IneligiblePrimaryNodeException, PrimaryRoleAssignmentException {
        block10: {
            this.writeLock.lock();
            try {
                Node node = this.getNode(nodeId);
                if (node == null) {
                    throw new UnknownNodeException("Node does not exist.");
                }
                if (Node.Status.CONNECTED != node.getStatus()) {
                    throw new IneligiblePrimaryNodeException("Node must be connected before it can be assigned as the primary node.");
                }
                Node primaryNode = this.getPrimaryNode();
                if (primaryNode != null) {
                    if (primaryNode.getStatus() == Node.Status.DISCONNECTED) {
                        throw new PrimaryRoleAssignmentException("A disconnected, primary node exists.  Delete the node before assigning the primary role to a different node.");
                    }
                    if (this.revokePrimaryRole(primaryNode.getNodeId())) {
                        this.addEvent(primaryNode.getNodeId(), "Role revoked from this node as part of primary role reassignment.");
                    } else {
                        throw new PrimaryRoleAssignmentException("Failed to revoke primary role from node. Primary node is now disconnected. Delete the node before assigning the primary role to a different node.");
                    }
                }
                this.setPrimaryNodeId(node.getNodeId());
                if (this.assignPrimaryRole(node.getNodeId())) {
                    this.addEvent(node.getNodeId(), "Role assigned to this node as part of primary role reassignment. Action performed by " + userDn);
                    this.addBulletin(node, Severity.INFO, "Primary Role assigned to node by " + userDn);
                    break block10;
                }
                throw new PrimaryRoleAssignmentException("Cluster manager assigned primary role to node, but the node failed to accept the assignment.  Cluster manager disconnected node.");
            }
            finally {
                this.writeLock.unlock("setPrimaryNode");
            }
        }
    }

    private int getClusterProtocolHeartbeatSeconds() {
        return (int)FormatUtils.getTimeDuration((String)this.properties.getClusterProtocolHeartbeatInterval(), (TimeUnit)TimeUnit.SECONDS);
    }

    @Override
    public int getHeartbeatMonitoringIntervalSeconds() {
        return 4 * this.getClusterProtocolHeartbeatSeconds();
    }

    @Override
    public int getMaxHeartbeatGapSeconds() {
        return 8 * this.getClusterProtocolHeartbeatSeconds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Event> getNodeEvents(String nodeId) {
        this.readLock.lock();
        try {
            List<Event> events = null;
            EventManager eventMgr = this.eventManager;
            if (eventMgr != null) {
                events = eventMgr.getEvents(nodeId);
            }
            if (events == null) {
                List<Event> list = Collections.emptyList();
                return list;
            }
            List<Event> list = Collections.unmodifiableList(events);
            return list;
        }
        finally {
            this.readLock.unlock("getNodeEvents");
        }
    }

    @Override
    public NodeResponse applyRequest(String method, URI uri, Map<String, List<String>> parameters, Map<String, String> headers) throws NoConnectedNodesException, NoResponseFromNodesException, UriConstructionException, ConnectingNodeMutableRequestException, DisconnectedNodeMutableRequestException, SafeModeMutableRequestException {
        return this.applyRequest(method, uri, parameters, headers, this.getNodeIds(Node.Status.CONNECTED));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeResponse applyRequest(String method, URI uri, Map<String, List<String>> parameters, Map<String, String> headers, Set<NodeIdentifier> nodeIdentifiers) throws NoConnectedNodesException, NoResponseFromNodesException, UriConstructionException, ConnectingNodeMutableRequestException, DisconnectedNodeMutableRequestException, SafeModeMutableRequestException {
        boolean mutableRequest = this.canChangeNodeState(method, uri);
        ClusterManagerLock lock = mutableRequest ? this.writeLock : this.readLock;
        lock.lock();
        try {
            NodeResponse clientResponse;
            if (mutableRequest) {
                if (this.isInSafeMode()) {
                    throw new SafeModeMutableRequestException("Received a mutable request [" + method + " -- " + uri + "] while in safe mode");
                }
                if (!this.getNodeIds(Node.Status.DISCONNECTED, Node.Status.DISCONNECTING).isEmpty()) {
                    throw new DisconnectedNodeMutableRequestException("Received a mutable request [" + method + " -- " + uri + "] while a node is disconnected from the cluster");
                }
                if (!this.getNodeIds(Node.Status.CONNECTING).isEmpty()) {
                    throw new ConnectingNodeMutableRequestException("Received a mutable request [" + method + " -- " + uri + "] while a node is trying to connect to the cluster");
                }
            }
            if ((clientResponse = this.federateRequest(method, uri, parameters, null, headers, nodeIdentifiers)) == null) {
                if (mutableRequest) {
                    throw new NoConnectedNodesException(String.format("All nodes were disconnected as a result of applying request %s %s", method, uri));
                }
                throw new NoResponseFromNodesException("No nodes were able to process this request.");
            }
            NodeResponse nodeResponse = clientResponse;
            return nodeResponse;
        }
        finally {
            lock.unlock("applyRequest(String, URI, Map<String, List<String>>, Map<String, String>, Set<NodeIdentifier>");
        }
    }

    @Override
    public NodeResponse applyRequest(String method, URI uri, Object entity, Map<String, String> headers) throws NoConnectedNodesException, NoResponseFromNodesException, UriConstructionException, ConnectingNodeMutableRequestException, DisconnectedNodeMutableRequestException, SafeModeMutableRequestException {
        return this.applyRequest(method, uri, entity, headers, this.getNodeIds(Node.Status.CONNECTED));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeResponse applyRequest(String method, URI uri, Object entity, Map<String, String> headers, Set<NodeIdentifier> nodeIdentifiers) throws NoConnectedNodesException, NoResponseFromNodesException, UriConstructionException, ConnectingNodeMutableRequestException, DisconnectedNodeMutableRequestException, SafeModeMutableRequestException {
        boolean mutableRequest = this.canChangeNodeState(method, uri);
        ClusterManagerLock lock = mutableRequest ? this.writeLock : this.readLock;
        lock.lock();
        try {
            NodeResponse clientResponse;
            if (mutableRequest) {
                if (this.isInSafeMode()) {
                    throw new SafeModeMutableRequestException("Received a mutable request [" + method + " -- " + uri + "] while in safe mode");
                }
                if (!this.getNodeIds(Node.Status.DISCONNECTED, Node.Status.DISCONNECTING).isEmpty()) {
                    throw new DisconnectedNodeMutableRequestException("Received a mutable request [" + method + " -- " + uri + "] while a node is disconnected from the cluster");
                }
                if (!this.getNodeIds(Node.Status.CONNECTING).isEmpty()) {
                    throw new ConnectingNodeMutableRequestException("Received a mutable request [" + method + " -- " + uri + "] while a node is trying to connect to the cluster");
                }
            }
            if ((clientResponse = this.federateRequest(method, uri, null, entity, headers, nodeIdentifiers)) == null) {
                if (mutableRequest) {
                    throw new NoConnectedNodesException(String.format("All nodes were disconnected as a result of applying request %s %s", method, uri));
                }
                throw new NoResponseFromNodesException("No nodes were able to process this request.");
            }
            NodeResponse nodeResponse = clientResponse;
            return nodeResponse;
        }
        finally {
            lock.unlock("applyRequest(String, URI, Object, Map<String, String>, Set<NodeIdentifier>");
        }
    }

    public void setServicesBroadcaster(ClusterServicesBroadcaster servicesBroadcaster) {
        this.writeLock.lock();
        try {
            this.servicesBroadcaster = servicesBroadcaster;
        }
        finally {
            this.writeLock.unlock("setServicesBroadcaster");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addBroadcastedService(DiscoverableService service) {
        this.writeLock.lock();
        try {
            ClusterServicesBroadcaster broadcaster = this.servicesBroadcaster;
            if (broadcaster == null) {
                throw new IllegalStateException("Service broadcasting is not configured.");
            }
            boolean bl = broadcaster.addService(service);
            return bl;
        }
        finally {
            this.writeLock.unlock("addBroadcastedService");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeBroadcastedService(String serviceName) {
        this.writeLock.lock();
        try {
            ClusterServicesBroadcaster broadcaster = this.servicesBroadcaster;
            if (broadcaster == null) {
                throw new IllegalStateException("Service broadcasting is not configured.");
            }
            boolean bl = broadcaster.removeService(serviceName);
            return bl;
        }
        finally {
            this.writeLock.unlock("removeBroadcastedService");
        }
    }

    public boolean isBroadcastingConfigured() {
        this.readLock.lock();
        try {
            boolean bl = this.servicesBroadcaster != null;
            return bl;
        }
        finally {
            this.readLock.unlock("isBroadcastingConfigured");
        }
    }

    public boolean isBroadcasting() {
        this.readLock.lock();
        try {
            ClusterServicesBroadcaster broadcaster = this.servicesBroadcaster;
            boolean bl = broadcaster != null && broadcaster.isRunning();
            return bl;
        }
        finally {
            this.readLock.unlock("isBroadcasting");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvent(NodeIdentifier nodeId, String eventMsg) {
        this.writeLock.lock();
        try {
            Event event = new Event(nodeId.getId(), eventMsg);
            EventManager eventMgr = this.eventManager;
            if (eventMgr != null) {
                eventMgr.addEvent(event);
            }
            logger.info(String.format("Node Event: %s -- '%s'", nodeId, eventMsg));
        }
        finally {
            this.writeLock.unlock("addEvent");
        }
    }

    public void setEventManager(EventManager eventManager) {
        this.writeLock.lock();
        try {
            this.eventManager = eventManager;
        }
        finally {
            this.writeLock.unlock("setEventManager");
        }
    }

    public void setClusterFirewall(ClusterNodeFirewall clusterFirewall) {
        this.writeLock.lock();
        try {
            this.clusterFirewall = clusterFirewall;
        }
        finally {
            this.writeLock.unlock("setClusterFirewall");
        }
    }

    public boolean isFirewallConfigured() {
        this.readLock.lock();
        try {
            boolean bl = this.clusterFirewall != null;
            return bl;
        }
        finally {
            this.readLock.unlock("isFirewallConfigured");
        }
    }

    public void setAuditService(AuditService auditService) {
        this.writeLock.lock();
        try {
            this.auditService = auditService;
        }
        finally {
            this.writeLock.unlock("setAuditService");
        }
    }

    public boolean isAuditingConfigured() {
        this.readLock.lock();
        try {
            boolean bl = this.auditService != null;
            return bl;
        }
        finally {
            this.readLock.unlock("isAuditingConfigured");
        }
    }

    private boolean isPrimaryNode(NodeIdentifier nodeId) {
        this.readLock.lock();
        try {
            boolean bl = this.primaryNodeId != null && this.primaryNodeId.equals((Object)nodeId);
            return bl;
        }
        finally {
            this.readLock.unlock("isPrimaryNode");
        }
    }

    private boolean isInSafeMode() {
        this.readLock.lock();
        try {
            boolean bl = this.primaryNodeId == null || this.getRawNode(this.primaryNodeId.getId()) == null;
            return bl;
        }
        finally {
            this.readLock.unlock("isInSafeMode");
        }
    }

    private void setPrimaryNodeId(NodeIdentifier primaryNodeId) throws DaoException {
        this.writeLock.lock();
        try {
            this.dataFlowManagementService.updatePrimaryNode(primaryNodeId);
            this.primaryNodeId = primaryNodeId;
        }
        finally {
            this.writeLock.unlock("setPrimaryNodeId");
        }
    }

    private NodeResponse federateRequest(final String method, final URI uri, final Map<String, List<String>> parameters, final Object entity, Map<String, String> headers, final Set<NodeIdentifier> nodeIds) throws UriConstructionException {
        Object userDetailsObj;
        if (nodeIds.isEmpty()) {
            throw new NoConnectedNodesException("Cannot apply " + method + " request to " + uri + " because there are currently no connected Nodes");
        }
        logger.debug("Applying prototype request " + uri + " to nodes.");
        final PersistedFlowState originalPersistedFlowState = this.dataFlowManagementService.getPersistedFlowState();
        final boolean mutableRequest = this.canChangeNodeState(method, uri);
        final HashMap<String, String> headersWithUserDetails = new HashMap<String, String>(headers);
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null && (userDetailsObj = authentication.getPrincipal()) instanceof NiFiUserDetails) {
            String hexEncodedUserDetails = WebUtils.serializeObjectToHex((Serializable)((Serializable)userDetailsObj));
            headersWithUserDetails.put("X-ProxiedEntityUserDetails", hexEncodedUserDetails);
            headersWithUserDetails.remove("Authorization");
        }
        final ObjectHolder holder = new ObjectHolder(null);
        UpdateRevision federateRequest = new UpdateRevision(){

            public Revision execute(Revision currentRevision) {
                Revision updatedRevision;
                block12: {
                    Set<NodeResponse> nodeResponses;
                    HashMap<String, String> updatedHeaders = new HashMap<String, String>(headersWithUserDetails);
                    ClusterContextImpl clusterCtx = new ClusterContextImpl();
                    clusterCtx.setRequestSentByClusterManager(true);
                    clusterCtx.setRevision(currentRevision);
                    String serializedClusterCtx = WebUtils.serializeObjectToHex((Serializable)clusterCtx);
                    updatedHeaders.put(WebClusterManager.CLUSTER_CONTEXT_HTTP_HEADER, serializedClusterCtx);
                    if (mutableRequest) {
                        updatedHeaders.put(WebClusterManager.NCM_EXPECTS_HTTP_HEADER, "150-NodeContinue");
                        nodeResponses = entity == null ? WebClusterManager.this.httpRequestReplicator.replicate((Set<NodeIdentifier>)nodeIds, method, uri, parameters, updatedHeaders) : WebClusterManager.this.httpRequestReplicator.replicate((Set<NodeIdentifier>)nodeIds, method, uri, entity, updatedHeaders);
                        updatedHeaders.remove(WebClusterManager.NCM_EXPECTS_HTTP_HEADER);
                        for (NodeResponse response : nodeResponses) {
                            if (response.getStatus() == 150) continue;
                            String nodeDescription = response.getNodeId().getApiAddress() + ":" + response.getNodeId().getApiPort();
                            ClientResponse clientResponse = response.getClientResponse();
                            if (clientResponse == null) {
                                throw new IllegalClusterStateException("Node " + nodeDescription + " is unable to fulfill this request due to: Unexpected Response Code " + response.getStatus());
                            }
                            String nodeExplanation = (String)clientResponse.getEntity(String.class);
                            throw new IllegalClusterStateException("Node " + nodeDescription + " is unable to fulfill this request due to: " + nodeExplanation, response.getThrowable());
                        }
                        logger.debug("Setting Flow State to UNKNOWN due to mutable request to {} {}", (Object)method, (Object)uri);
                        WebClusterManager.this.notifyDataFlowManagmentServiceOfFlowStateChange(PersistedFlowState.UNKNOWN);
                    }
                    try {
                        nodeResponses = entity == null ? WebClusterManager.this.httpRequestReplicator.replicate((Set<NodeIdentifier>)nodeIds, method, uri, parameters, updatedHeaders) : WebClusterManager.this.httpRequestReplicator.replicate((Set<NodeIdentifier>)nodeIds, method, uri, entity, updatedHeaders);
                    }
                    catch (UriConstructionException uce) {
                        if (mutableRequest) {
                            WebClusterManager.this.notifyDataFlowManagmentServiceOfFlowStateChange(originalPersistedFlowState);
                        }
                        throw uce;
                    }
                    NodeResponse clientResponse = WebClusterManager.this.mergeResponses(uri, method, nodeResponses, mutableRequest);
                    holder.set((Object)clientResponse);
                    updatedRevision = null;
                    if (mutableRequest && clientResponse != null) {
                        try {
                            ClusterContext clusterContext;
                            block13: {
                                Serializable clusterContextObj;
                                String serializedClusterContext = (String)clientResponse.getClientResponse().getHeaders().getFirst((Object)WebClusterManager.CLUSTER_CONTEXT_HTTP_HEADER);
                                if (!StringUtils.isNotBlank((CharSequence)serializedClusterContext) || !((clusterContextObj = WebUtils.deserializeHexToObject((String)serializedClusterContext)) instanceof ClusterContext)) break block12;
                                clusterContext = (ClusterContext)clusterContextObj;
                                if (WebClusterManager.this.auditService != null) {
                                    try {
                                        WebClusterManager.this.auditService.addActions((Collection)clusterContext.getActions());
                                    }
                                    catch (Throwable t) {
                                        logger.warn("Unable to record actions: " + t.getMessage());
                                        if (!logger.isDebugEnabled()) break block13;
                                        logger.warn("", t);
                                    }
                                }
                            }
                            updatedRevision = clusterContext.getRevision();
                        }
                        catch (ClassNotFoundException cnfe) {
                            logger.warn("Classpath issue detected because failed to deserialize cluster context from node response due to: " + cnfe, (Throwable)cnfe);
                        }
                    }
                }
                return updatedRevision;
            }
        };
        if (mutableRequest) {
            this.optimisticLockingManager.setRevision(federateRequest);
        } else {
            federateRequest.execute(this.optimisticLockingManager.getLastModification().getRevision());
        }
        return (NodeResponse)holder.get();
    }

    private static boolean isProcessorsEndpoint(URI uri, String method) {
        return "GET".equalsIgnoreCase(method) && PROCESSORS_URI_PATTERN.matcher(uri.getPath()).matches();
    }

    private static boolean isProcessorEndpoint(URI uri, String method) {
        if (("GET".equalsIgnoreCase(method) || "PUT".equalsIgnoreCase(method)) && (PROCESSOR_URI_PATTERN.matcher(uri.getPath()).matches() || CLUSTER_PROCESSOR_URI_PATTERN.matcher(uri.getPath()).matches())) {
            return true;
        }
        return "POST".equalsIgnoreCase(method) && PROCESSORS_URI_PATTERN.matcher(uri.getPath()).matches();
    }

    private static boolean isProcessorStateEndpoint(URI uri, String method) {
        return "GET".equalsIgnoreCase(method) && PROCESSOR_STATE_URI_PATTERN.matcher(uri.getPath()).matches();
    }

    private static boolean isProcessGroupEndpoint(URI uri, String method) {
        return ("GET".equalsIgnoreCase(method) || "PUT".equalsIgnoreCase(method)) && PROCESS_GROUP_URI_PATTERN.matcher(uri.getPath()).matches();
    }

    private static boolean isTemplateEndpoint(URI uri, String method) {
        return "POST".equalsIgnoreCase(method) && TEMPLATE_INSTANCE_URI_PATTERN.matcher(uri.getPath()).matches();
    }

    private static boolean isFlowSnippetEndpoint(URI uri, String method) {
        return "POST".equalsIgnoreCase(method) && FLOW_SNIPPET_INSTANCE_URI_PATTERN.matcher(uri.getPath()).matches();
    }

    private static boolean isRemoteProcessGroupsEndpoint(URI uri, String method) {
        return "GET".equalsIgnoreCase(method) && REMOTE_PROCESS_GROUPS_URI_PATTERN.matcher(uri.getPath()).matches();
    }

    private static boolean isRemoteProcessGroupEndpoint(URI uri, String method) {
        if (("GET".equalsIgnoreCase(method) || "PUT".equalsIgnoreCase(method)) && REMOTE_PROCESS_GROUP_URI_PATTERN.matcher(uri.getPath()).matches()) {
            return true;
        }
        return "POST".equalsIgnoreCase(method) && REMOTE_PROCESS_GROUPS_URI_PATTERN.matcher(uri.getPath()).matches();
    }

    private static boolean isProvenanceQueryEndpoint(URI uri, String method) {
        if ("POST".equalsIgnoreCase(method) && PROVENANCE_URI.equals(uri.getPath())) {
            return true;
        }
        return "GET".equalsIgnoreCase(method) && PROVENANCE_QUERY_URI.matcher(uri.getPath()).matches();
    }

    private static boolean isProvenanceEventEndpoint(URI uri, String method) {
        return "GET".equalsIgnoreCase(method) && PROVENANCE_EVENT_URI.matcher(uri.getPath()).matches();
    }

    private static boolean isListFlowFilesEndpoint(URI uri, String method) {
        if (("GET".equalsIgnoreCase(method) || "DELETE".equalsIgnoreCase(method)) && LISTING_REQUEST_URI.matcher(uri.getPath()).matches()) {
            return true;
        }
        return "POST".equalsIgnoreCase(method) && LISTING_REQUESTS_URI.matcher(uri.getPath()).matches();
    }

    private static boolean isCountersEndpoint(URI uri) {
        return COUNTERS_URI.matcher(uri.getPath()).matches();
    }

    private static boolean isControllerServicesEndpoint(URI uri, String method) {
        return "GET".equalsIgnoreCase(method) && CONTROLLER_SERVICES_URI.equals(uri.getPath());
    }

    private static boolean isControllerServiceEndpoint(URI uri, String method) {
        if (("GET".equalsIgnoreCase(method) || "PUT".equalsIgnoreCase(method)) && CONTROLLER_SERVICE_URI_PATTERN.matcher(uri.getPath()).matches()) {
            return true;
        }
        return "POST".equalsIgnoreCase(method) && CONTROLLER_SERVICES_URI.equals(uri.getPath());
    }

    private static boolean isControllerServiceStateEndpoint(URI uri, String method) {
        return "GET".equalsIgnoreCase(method) && CONTROLLER_SERVICE_STATE_URI_PATTERN.matcher(uri.getPath()).matches();
    }

    private static boolean isControllerServiceReferenceEndpoint(URI uri, String method) {
        return ("GET".equalsIgnoreCase(method) || "PUT".equalsIgnoreCase(method)) && CONTROLLER_SERVICE_REFERENCES_URI_PATTERN.matcher(uri.getPath()).matches();
    }

    private static boolean isReportingTasksEndpoint(URI uri, String method) {
        return "GET".equalsIgnoreCase(method) && REPORTING_TASKS_URI.equals(uri.getPath());
    }

    private static boolean isReportingTaskEndpoint(URI uri, String method) {
        if (("GET".equalsIgnoreCase(method) || "PUT".equalsIgnoreCase(method)) && REPORTING_TASK_URI_PATTERN.matcher(uri.getPath()).matches()) {
            return true;
        }
        return "POST".equalsIgnoreCase(method) && REPORTING_TASKS_URI.equals(uri.getPath());
    }

    private static boolean isReportingTaskStateEndpoint(URI uri, String method) {
        return "GET".equalsIgnoreCase(method) && REPORTING_TASK_STATE_URI_PATTERN.matcher(uri.getPath()).matches();
    }

    private static boolean isDropRequestEndpoint(URI uri, String method) {
        if ("DELETE".equalsIgnoreCase(method) && QUEUE_CONTENTS_URI.matcher(uri.getPath()).matches()) {
            return true;
        }
        if (("GET".equalsIgnoreCase(method) || "DELETE".equalsIgnoreCase(method)) && DROP_REQUEST_URI.matcher(uri.getPath()).matches()) {
            return true;
        }
        return "POST".equalsIgnoreCase(method) && DROP_REQUESTS_URI.matcher(uri.getPath()).matches();
    }

    static boolean isResponseInterpreted(URI uri, String method) {
        return WebClusterManager.isProcessorsEndpoint(uri, method) || WebClusterManager.isProcessorEndpoint(uri, method) || WebClusterManager.isProcessorStateEndpoint(uri, method) || WebClusterManager.isRemoteProcessGroupsEndpoint(uri, method) || WebClusterManager.isRemoteProcessGroupEndpoint(uri, method) || WebClusterManager.isProcessGroupEndpoint(uri, method) || WebClusterManager.isTemplateEndpoint(uri, method) || WebClusterManager.isFlowSnippetEndpoint(uri, method) || WebClusterManager.isProvenanceQueryEndpoint(uri, method) || WebClusterManager.isProvenanceEventEndpoint(uri, method) || WebClusterManager.isControllerServicesEndpoint(uri, method) || WebClusterManager.isControllerServiceEndpoint(uri, method) || WebClusterManager.isControllerServiceReferenceEndpoint(uri, method) || WebClusterManager.isControllerServiceStateEndpoint(uri, method) || WebClusterManager.isReportingTasksEndpoint(uri, method) || WebClusterManager.isReportingTaskEndpoint(uri, method) || WebClusterManager.isReportingTaskStateEndpoint(uri, method) || WebClusterManager.isDropRequestEndpoint(uri, method) || WebClusterManager.isListFlowFilesEndpoint(uri, method);
    }

    private void mergeProcessorValidationErrors(ProcessorDTO processor, Map<NodeIdentifier, ProcessorDTO> processorMap) {
        HashMap<String, Set<NodeIdentifier>> validationErrorMap = new HashMap<String, Set<NodeIdentifier>>();
        for (Map.Entry<NodeIdentifier, ProcessorDTO> nodeEntry : processorMap.entrySet()) {
            NodeIdentifier nodeId = nodeEntry.getKey();
            ProcessorDTO nodeProcessor = nodeEntry.getValue();
            this.mergeValidationErrors(validationErrorMap, nodeId, nodeProcessor.getValidationErrors());
        }
        processor.setValidationErrors(this.normalizedMergedValidationErrors(validationErrorMap, processorMap.size()));
    }

    private void mergeComponentState(ComponentStateDTO componentState, Map<NodeIdentifier, ComponentStateDTO> componentStateMap) {
        List<StateEntryDTO> localStateEntries = new ArrayList();
        int totalStateEntries = 0;
        for (Map.Entry<NodeIdentifier, ComponentStateDTO> nodeEntry : componentStateMap.entrySet()) {
            ComponentStateDTO nodeComponentState = nodeEntry.getValue();
            NodeIdentifier nodeId = nodeEntry.getKey();
            String nodeAddress = nodeId.getApiAddress() + ":" + nodeId.getApiPort();
            StateMapDTO nodeLocalStateMap = nodeComponentState.getLocalState();
            if (nodeLocalStateMap.getState() == null) continue;
            totalStateEntries += nodeLocalStateMap.getTotalEntryCount();
            for (StateEntryDTO nodeStateEntry : nodeLocalStateMap.getState()) {
                nodeStateEntry.setClusterNodeId(nodeId.getId());
                nodeStateEntry.setClusterNodeAddress(nodeAddress);
                localStateEntries.add(nodeStateEntry);
            }
        }
        Collections.sort(localStateEntries, SortedStateUtils.getEntryDtoComparator());
        if (localStateEntries.size() > 500) {
            localStateEntries = localStateEntries.subList(0, 500);
        }
        componentState.getLocalState().setTotalEntryCount(totalStateEntries);
        componentState.getLocalState().setState(localStateEntries);
    }

    private void mergeProvenanceQueryResults(ProvenanceDTO provenanceDto, Map<NodeIdentifier, ProvenanceDTO> resultMap, Set<NodeResponse> problematicResponses) {
        ProvenanceResultsDTO results = provenanceDto.getResults();
        ProvenanceRequestDTO request = provenanceDto.getRequest();
        ArrayList<ProvenanceEventDTO> allResults = new ArrayList<ProvenanceEventDTO>(1024);
        HashSet<String> errors = new HashSet<String>();
        Date oldestEventDate = new Date();
        int percentageComplete = 0;
        boolean finished = true;
        long totalRecords = 0L;
        for (Map.Entry<NodeIdentifier, ProvenanceDTO> entry : resultMap.entrySet()) {
            NodeIdentifier nodeIdentifier = entry.getKey();
            String nodeAddress = nodeIdentifier.getApiAddress() + ":" + nodeIdentifier.getApiPort();
            ProvenanceDTO nodeDto = entry.getValue();
            ProvenanceResultsDTO nodeResultDto = nodeDto.getResults();
            if (nodeResultDto != null && nodeResultDto.getProvenanceEvents() != null) {
                totalRecords += nodeResultDto.getTotalCount().longValue();
                for (ProvenanceEventDTO eventDto : nodeResultDto.getProvenanceEvents()) {
                    eventDto.setClusterNodeId(nodeIdentifier.getId());
                    eventDto.setClusterNodeAddress(nodeAddress);
                    eventDto.setId(nodeIdentifier.getId() + eventDto.getId());
                    allResults.add(eventDto);
                }
            }
            if (nodeResultDto.getOldestEvent() != null && nodeResultDto.getOldestEvent().before(oldestEventDate)) {
                oldestEventDate = nodeResultDto.getOldestEvent();
            }
            if (nodeResultDto.getErrors() != null) {
                for (String error : nodeResultDto.getErrors()) {
                    errors.add(nodeAddress + " -- " + error);
                }
            }
            percentageComplete += nodeDto.getPercentCompleted().intValue();
            if (nodeDto.isFinished().booleanValue()) continue;
            finished = false;
        }
        percentageComplete /= resultMap.size();
        for (NodeResponse problematicResponse : problematicResponses) {
            NodeIdentifier problemNode = problematicResponse.getNodeId();
            String problemNodeAddress = problemNode.getApiAddress() + ":" + problemNode.getApiPort();
            errors.add(String.format("%s -- Request did not complete successfully (Status code: %s)", problemNodeAddress, problematicResponse.getStatus()));
        }
        Collections.sort(allResults, new Comparator<ProvenanceEventDTO>(){

            @Override
            public int compare(ProvenanceEventDTO o1, ProvenanceEventDTO o2) {
                int eventTimeComparison = o1.getEventTime().compareTo(o2.getEventTime());
                if (eventTimeComparison != 0) {
                    return -eventTimeComparison;
                }
                String nodeId1 = o1.getClusterNodeId();
                String nodeId2 = o2.getClusterNodeId();
                int nodeIdComparison = nodeId1 == null && nodeId2 == null ? 0 : (nodeId1 == null ? 1 : (nodeId2 == null ? -1 : -nodeId1.compareTo(nodeId2)));
                if (nodeIdComparison != 0) {
                    return nodeIdComparison;
                }
                return -Long.compare(o1.getEventId(), o2.getEventId());
            }
        });
        int maxResults = request.getMaxResults();
        List<Object> selectedResults = allResults.size() < maxResults ? allResults : allResults.subList(0, maxResults);
        if (errors.size() > 0) {
            results.setErrors(errors);
        }
        results.setTotalCount(Long.valueOf(totalRecords));
        results.setTotal(FormatUtils.formatCount((long)totalRecords));
        results.setProvenanceEvents(selectedResults);
        results.setOldestEvent(oldestEventDate);
        results.setGenerated(new Date());
        provenanceDto.setPercentCompleted(Integer.valueOf(percentageComplete));
        provenanceDto.setFinished(Boolean.valueOf(finished));
    }

    private void mergeRemoteProcessGroup(RemoteProcessGroupDTO remoteProcessGroup, Map<NodeIdentifier, RemoteProcessGroupDTO> remoteProcessGroupMap) {
        RemoteProcessGroupContentsDTO remoteProcessGroupContents = remoteProcessGroup.getContents();
        Boolean mergedIsTargetSecure = null;
        ArrayList<String> mergedAuthorizationIssues = new ArrayList<String>();
        HashSet mergedInputPorts = new HashSet();
        HashSet mergedOutputPorts = new HashSet();
        for (Map.Entry<NodeIdentifier, RemoteProcessGroupDTO> nodeEntry : remoteProcessGroupMap.entrySet()) {
            NodeIdentifier nodeId = nodeEntry.getKey();
            RemoteProcessGroupDTO nodeRemoteProcessGroupDto = nodeEntry.getValue();
            List nodeAuthorizationIssues = nodeRemoteProcessGroupDto.getAuthorizationIssues();
            if (nodeAuthorizationIssues != null && !nodeAuthorizationIssues.isEmpty()) {
                for (String nodeAuthorizationIssue : nodeAuthorizationIssues) {
                    mergedAuthorizationIssues.add(nodeId.getApiAddress() + ":" + nodeId.getApiPort() + " -- " + nodeAuthorizationIssue);
                }
            }
            Boolean nodeIsTargetSecure = nodeRemoteProcessGroupDto.isTargetSecure();
            if (mergedIsTargetSecure == null) {
                mergedIsTargetSecure = nodeIsTargetSecure;
            }
            RemoteProcessGroupContentsDTO nodeRemoteProcessGroupContentsDto = nodeRemoteProcessGroupDto.getContents();
            if (remoteProcessGroupContents == null || nodeRemoteProcessGroupContentsDto == null) continue;
            if (nodeRemoteProcessGroupContentsDto.getInputPorts() != null) {
                mergedInputPorts.addAll(nodeRemoteProcessGroupContentsDto.getInputPorts());
            }
            if (nodeRemoteProcessGroupContentsDto.getOutputPorts() == null) continue;
            mergedOutputPorts.addAll(nodeRemoteProcessGroupContentsDto.getOutputPorts());
        }
        if (remoteProcessGroupContents != null) {
            if (!mergedInputPorts.isEmpty()) {
                remoteProcessGroupContents.setInputPorts(mergedInputPorts);
            }
            if (!mergedOutputPorts.isEmpty()) {
                remoteProcessGroupContents.setOutputPorts(mergedOutputPorts);
            }
        }
        if (mergedIsTargetSecure != null) {
            remoteProcessGroup.setTargetSecure(mergedIsTargetSecure);
        }
        if (!mergedAuthorizationIssues.isEmpty()) {
            remoteProcessGroup.setAuthorizationIssues(mergedAuthorizationIssues);
        }
    }

    private void mergeControllerServiceReferences(Set<ControllerServiceReferencingComponentDTO> referencingComponents, Map<NodeIdentifier, Set<ControllerServiceReferencingComponentDTO>> referencingComponentMap) {
        HashMap<String, Integer> activeThreadCounts = new HashMap<String, Integer>();
        HashMap<String, String> states = new HashMap<String, String>();
        for (Map.Entry<NodeIdentifier, Set<ControllerServiceReferencingComponentDTO>> nodeEntry : referencingComponentMap.entrySet()) {
            Set<ControllerServiceReferencingComponentDTO> nodeReferencingComponents = nodeEntry.getValue();
            if (nodeReferencingComponents == null) continue;
            for (ControllerServiceReferencingComponentDTO nodeReferencingComponent : nodeReferencingComponents) {
                String state;
                if (nodeReferencingComponent.getActiveThreadCount() != null && nodeReferencingComponent.getActiveThreadCount() > 0) {
                    Integer current = (Integer)activeThreadCounts.get(nodeReferencingComponent.getId());
                    if (current == null) {
                        activeThreadCounts.put(nodeReferencingComponent.getId(), nodeReferencingComponent.getActiveThreadCount());
                    } else {
                        activeThreadCounts.put(nodeReferencingComponent.getId(), nodeReferencingComponent.getActiveThreadCount() + current);
                    }
                }
                if ((state = (String)states.get(nodeReferencingComponent.getId())) != null) continue;
                if (ControllerServiceState.DISABLING.name().equals(nodeReferencingComponent.getState())) {
                    states.put(nodeReferencingComponent.getId(), ControllerServiceState.DISABLING.name());
                    continue;
                }
                if (!ControllerServiceState.ENABLING.name().equals(nodeReferencingComponent.getState())) continue;
                states.put(nodeReferencingComponent.getId(), ControllerServiceState.ENABLING.name());
            }
        }
        for (ControllerServiceReferencingComponentDTO referencingComponent : referencingComponents) {
            String state;
            Integer activeThreadCount = (Integer)activeThreadCounts.get(referencingComponent.getId());
            if (activeThreadCount != null) {
                referencingComponent.setActiveThreadCount(activeThreadCount);
            }
            if ((state = (String)states.get(referencingComponent.getId())) == null) continue;
            referencingComponent.setState(state);
        }
    }

    private void mergeControllerService(ControllerServiceDTO controllerService, Map<NodeIdentifier, ControllerServiceDTO> controllerServiceMap) {
        HashMap<String, Set<NodeIdentifier>> validationErrorMap = new HashMap<String, Set<NodeIdentifier>>();
        Set referencingComponents = controllerService.getReferencingComponents();
        HashMap<NodeIdentifier, Set<ControllerServiceReferencingComponentDTO>> nodeReferencingComponentsMap = new HashMap<NodeIdentifier, Set<ControllerServiceReferencingComponentDTO>>();
        String state = null;
        for (Map.Entry<NodeIdentifier, ControllerServiceDTO> nodeEntry : controllerServiceMap.entrySet()) {
            NodeIdentifier nodeId = nodeEntry.getKey();
            ControllerServiceDTO nodeControllerService = nodeEntry.getValue();
            if (state == null) {
                if (ControllerServiceState.DISABLING.name().equals(nodeControllerService.getState())) {
                    state = ControllerServiceState.DISABLING.name();
                } else if (ControllerServiceState.ENABLING.name().equals(nodeControllerService.getState())) {
                    state = ControllerServiceState.ENABLING.name();
                }
            }
            for (ControllerServiceReferencingComponentDTO nodeReferencingComponents : nodeControllerService.getReferencingComponents()) {
                nodeReferencingComponentsMap.put(nodeId, nodeReferencingComponents.getReferencingComponents());
            }
            this.mergeValidationErrors(validationErrorMap, nodeId, nodeControllerService.getValidationErrors());
        }
        this.mergeControllerServiceReferences(referencingComponents, nodeReferencingComponentsMap);
        if (state != null) {
            controllerService.setState(state);
        }
        controllerService.setValidationErrors(this.normalizedMergedValidationErrors(validationErrorMap, controllerServiceMap.size()));
    }

    private void mergeReportingTask(ReportingTaskDTO reportingTask, Map<NodeIdentifier, ReportingTaskDTO> reportingTaskMap) {
        HashMap<String, Set<NodeIdentifier>> validationErrorMap = new HashMap<String, Set<NodeIdentifier>>();
        int activeThreadCount = 0;
        for (Map.Entry<NodeIdentifier, ReportingTaskDTO> nodeEntry : reportingTaskMap.entrySet()) {
            NodeIdentifier nodeId = nodeEntry.getKey();
            ReportingTaskDTO nodeReportingTask = nodeEntry.getValue();
            if (nodeReportingTask.getActiveThreadCount() != null) {
                activeThreadCount += nodeReportingTask.getActiveThreadCount().intValue();
            }
            this.mergeValidationErrors(validationErrorMap, nodeId, nodeReportingTask.getValidationErrors());
        }
        reportingTask.setActiveThreadCount(Integer.valueOf(activeThreadCount));
        reportingTask.setValidationErrors(this.normalizedMergedValidationErrors(validationErrorMap, reportingTaskMap.size()));
    }

    public void mergeValidationErrors(Map<String, Set<NodeIdentifier>> validationErrorMap, NodeIdentifier nodeId, Collection<String> nodeValidationErrors) {
        if (nodeValidationErrors != null) {
            for (String nodeValidationError : nodeValidationErrors) {
                Set<NodeIdentifier> nodeSet = validationErrorMap.get(nodeValidationError);
                if (nodeSet == null) {
                    nodeSet = new HashSet<NodeIdentifier>();
                    validationErrorMap.put(nodeValidationError, nodeSet);
                }
                nodeSet.add(nodeId);
            }
        }
    }

    public Set<String> normalizedMergedValidationErrors(Map<String, Set<NodeIdentifier>> validationErrorMap, int totalNodes) {
        HashSet<String> normalizedValidationErrors = new HashSet<String>();
        for (Map.Entry<String, Set<NodeIdentifier>> validationEntry : validationErrorMap.entrySet()) {
            String msg = validationEntry.getKey();
            Set<NodeIdentifier> nodeIds = validationEntry.getValue();
            if (nodeIds.size() == totalNodes) {
                normalizedValidationErrors.add(msg);
                continue;
            }
            for (NodeIdentifier nodeId : nodeIds) {
                normalizedValidationErrors.add(nodeId.getApiAddress() + ":" + nodeId.getApiPort() + " -- " + msg);
            }
        }
        return normalizedValidationErrors;
    }

    private void mergeListingRequests(ListingRequestDTO listingRequest, Map<NodeIdentifier, ListingRequestDTO> listingRequestMap) {
        Comparator<FlowFileSummaryDTO> comparator = new Comparator<FlowFileSummaryDTO>(){

            @Override
            public int compare(FlowFileSummaryDTO dto1, FlowFileSummaryDTO dto2) {
                int positionCompare = dto1.getPosition().compareTo(dto2.getPosition());
                if (positionCompare != 0) {
                    return positionCompare;
                }
                String address1 = dto1.getClusterNodeAddress();
                String address2 = dto2.getClusterNodeAddress();
                if (address1 == null && address2 == null) {
                    return 0;
                }
                if (address1 == null) {
                    return 1;
                }
                if (address2 == null) {
                    return -1;
                }
                return address1.compareTo(address2);
            }
        };
        TreeSet<FlowFileSummaryDTO> flowFileSummaries = new TreeSet<FlowFileSummaryDTO>(comparator);
        ListFlowFileState state = null;
        int numStepsCompleted = 0;
        int numStepsTotal = 0;
        int objectCount = 0;
        long byteCount = 0L;
        boolean finished = true;
        for (Map.Entry<NodeIdentifier, ListingRequestDTO> entry : listingRequestMap.entrySet()) {
            NodeIdentifier nodeIdentifier = entry.getKey();
            String nodeAddress = nodeIdentifier.getApiAddress() + ":" + nodeIdentifier.getApiPort();
            ListingRequestDTO nodeRequest = entry.getValue();
            ++numStepsTotal;
            if (Boolean.TRUE.equals(nodeRequest.getFinished())) {
                ++numStepsCompleted;
            }
            QueueSizeDTO nodeQueueSize = nodeRequest.getQueueSize();
            objectCount += nodeQueueSize.getObjectCount();
            byteCount += nodeQueueSize.getByteCount();
            if (!nodeRequest.getFinished().booleanValue()) {
                finished = false;
            }
            if (nodeRequest.getLastUpdated().after(listingRequest.getLastUpdated())) {
                listingRequest.setLastUpdated(nodeRequest.getLastUpdated());
            }
            ListFlowFileState nodeState = ListFlowFileState.valueOfDescription((String)nodeRequest.getState());
            if (state == null || state.compareTo((Enum)nodeState) > 0) {
                state = nodeState;
            }
            if (nodeRequest.getFlowFileSummaries() != null) {
                for (FlowFileSummaryDTO summaryDTO : nodeRequest.getFlowFileSummaries()) {
                    summaryDTO.setClusterNodeId(nodeIdentifier.getId());
                    summaryDTO.setClusterNodeAddress(nodeAddress);
                    flowFileSummaries.add(summaryDTO);
                    if (flowFileSummaries.size() <= listingRequest.getMaxResults()) continue;
                    flowFileSummaries.pollLast();
                }
            }
            if (nodeRequest.getFailureReason() == null) continue;
            listingRequest.setFailureReason(nodeRequest.getFailureReason());
        }
        ArrayList<FlowFileSummaryDTO> summaryDTOs = new ArrayList<FlowFileSummaryDTO>(flowFileSummaries);
        listingRequest.setFlowFileSummaries(summaryDTOs);
        int percentCompleted = numStepsTotal == 0 ? 1 : numStepsCompleted / numStepsTotal;
        listingRequest.setPercentCompleted(Integer.valueOf(percentCompleted));
        listingRequest.setFinished(Boolean.valueOf(finished));
        listingRequest.getQueueSize().setByteCount(byteCount);
        listingRequest.getQueueSize().setObjectCount(objectCount);
    }

    private void mergeDropRequests(DropRequestDTO dropRequest, Map<NodeIdentifier, DropRequestDTO> dropRequestMap) {
        boolean nodeWaiting = false;
        int originalCount = 0;
        long originalSize = 0L;
        int currentCount = 0;
        long currentSize = 0L;
        int droppedCount = 0;
        long droppedSize = 0L;
        DropFlowFileState state = null;
        boolean allFinished = true;
        String failureReason = null;
        for (Map.Entry<NodeIdentifier, DropRequestDTO> nodeEntry : dropRequestMap.entrySet()) {
            DropRequestDTO nodeDropRequest = nodeEntry.getValue();
            if (!nodeDropRequest.isFinished().booleanValue()) {
                allFinished = false;
            }
            if (nodeDropRequest.getFailureReason() != null) {
                failureReason = nodeDropRequest.getFailureReason();
            }
            currentCount += nodeDropRequest.getCurrentCount().intValue();
            currentSize += nodeDropRequest.getCurrentSize().longValue();
            droppedCount += nodeDropRequest.getDroppedCount().intValue();
            droppedSize += nodeDropRequest.getDroppedSize().longValue();
            if (nodeDropRequest.getOriginalCount() == null) {
                nodeWaiting = true;
            } else {
                originalCount += nodeDropRequest.getOriginalCount().intValue();
                originalSize += nodeDropRequest.getOriginalSize().longValue();
            }
            DropFlowFileState nodeState = DropFlowFileState.valueOfDescription((String)nodeDropRequest.getState());
            if (state != null && state.ordinal() <= nodeState.ordinal()) continue;
            state = nodeState;
        }
        dropRequest.setCurrentCount(Integer.valueOf(currentCount));
        dropRequest.setCurrentSize(Long.valueOf(currentSize));
        dropRequest.setCurrent(FormatUtils.formatCount((long)currentCount) + " / " + FormatUtils.formatDataSize((double)currentSize));
        dropRequest.setDroppedCount(Integer.valueOf(droppedCount));
        dropRequest.setDroppedSize(Long.valueOf(droppedSize));
        dropRequest.setDropped(FormatUtils.formatCount((long)droppedCount) + " / " + FormatUtils.formatDataSize((double)droppedSize));
        dropRequest.setFinished(Boolean.valueOf(allFinished));
        dropRequest.setFailureReason(failureReason);
        if (originalCount == 0) {
            dropRequest.setPercentCompleted(Integer.valueOf(allFinished ? 100 : 0));
        } else {
            dropRequest.setPercentCompleted(Integer.valueOf((int)((double)droppedCount / (double)originalCount * 100.0)));
        }
        if (!nodeWaiting) {
            dropRequest.setOriginalCount(Integer.valueOf(originalCount));
            dropRequest.setOriginalSize(Long.valueOf(originalSize));
            dropRequest.setOriginal(FormatUtils.formatCount((long)originalCount) + " / " + FormatUtils.formatDataSize((double)originalSize));
        }
        if (state != null) {
            dropRequest.setState(state.toString());
        }
    }

    private NodeResponse mergeResponses(URI uri, String method, Set<NodeResponse> nodeResponses, boolean mutableRequest) {
        HashMap<Object, Object> resultsMap;
        HashMap<NodeIdentifier, RemoteProcessGroupDTO> remoteProcessGroupMap;
        Map mergeMap;
        Object procId;
        Map<NodeIdentifier, ReportingTaskDTO> innerMap;
        ProcessorEntity nodeResponseEntity;
        HashMap<NodeIdentifier, ProcessorDTO> processorMap;
        ProcessorEntity responseEntity;
        NodeResponse clientResponse = null;
        HashSet<NodeResponse> problematicNodeResponses = new HashSet<NodeResponse>();
        HashMap<Node, NodeResponse> updatedNodesMap = new HashMap<Node, NodeResponse>();
        for (Map.Entry<NodeResponse, Node.Status> entry : this.httpResponseMapper.map(uri, nodeResponses).entrySet()) {
            NodeResponse nodeResponse = entry.getKey();
            Node.Status nodeStatus = entry.getValue();
            Node currentNode = this.getRawNode(nodeResponse.getNodeId().getId());
            Node updatedNode = currentNode.clone();
            updatedNode.setStatus(nodeStatus);
            updatedNodesMap.put(updatedNode, nodeResponse);
            if (nodeStatus == Node.Status.CONNECTED) {
                clientResponse = nodeResponse;
                continue;
            }
            if (nodeStatus != Node.Status.DISCONNECTED) continue;
            problematicNodeResponses.add(nodeResponse);
        }
        boolean hasClientResponse = clientResponse != null;
        boolean hasSuccessfulClientResponse = hasClientResponse && clientResponse.is2xx();
        HashSet<NodeResponse> nodeResponsesToDrain = new HashSet<NodeResponse>(updatedNodesMap.values());
        nodeResponsesToDrain.remove(clientResponse);
        if (hasSuccessfulClientResponse && WebClusterManager.isProcessorEndpoint(uri, method)) {
            responseEntity = (ProcessorEntity)clientResponse.getClientResponse().getEntity(ProcessorEntity.class);
            ProcessorDTO processor = responseEntity.getProcessor();
            processorMap = new HashMap<NodeIdentifier, ProcessorDTO>();
            for (NodeResponse nodeResponse : updatedNodesMap.values()) {
                if (problematicNodeResponses.contains(nodeResponse)) continue;
                nodeResponseEntity = nodeResponse == clientResponse ? responseEntity : (ProcessorEntity)nodeResponse.getClientResponse().getEntity(ProcessorEntity.class);
                ProcessorDTO nodeProcessor = nodeResponseEntity.getProcessor();
                processorMap.put(nodeResponse.getNodeId(), nodeProcessor);
            }
            this.mergeProcessorValidationErrors(processor, processorMap);
            clientResponse = new NodeResponse(clientResponse, (Entity)responseEntity);
        } else if (hasSuccessfulClientResponse && WebClusterManager.isProcessorsEndpoint(uri, method)) {
            responseEntity = (ProcessorsEntity)clientResponse.getClientResponse().getEntity(ProcessorsEntity.class);
            Set processors = responseEntity.getProcessors();
            processorMap = new HashMap();
            for (NodeResponse nodeResponse : updatedNodesMap.values()) {
                if (problematicNodeResponses.contains(nodeResponse)) continue;
                nodeResponseEntity = nodeResponse == clientResponse ? responseEntity : (ProcessorsEntity)nodeResponse.getClientResponse().getEntity(ProcessorsEntity.class);
                Set nodeProcessors = nodeResponseEntity.getProcessors();
                for (ProcessorDTO nodeProcessor : nodeProcessors) {
                    innerMap = (Map)processorMap.get(nodeProcessor.getId());
                    if (innerMap == null) {
                        innerMap = new HashMap<NodeIdentifier, ProcessorDTO>();
                        processorMap.put((NodeIdentifier)nodeProcessor.getId(), (ProcessorDTO)innerMap);
                    }
                    innerMap.put(nodeResponse.getNodeId(), (ReportingTaskDTO)nodeProcessor);
                }
            }
            for (ProcessorDTO processor : processors) {
                procId = processor.getId();
                mergeMap = (Map)processorMap.get(procId);
                this.mergeProcessorValidationErrors(processor, mergeMap);
            }
            clientResponse = new NodeResponse(clientResponse, (Entity)responseEntity);
        } else if (hasSuccessfulClientResponse && WebClusterManager.isProcessGroupEndpoint(uri, method)) {
            responseEntity = (ProcessGroupEntity)clientResponse.getClientResponse().getEntity(ProcessGroupEntity.class);
            ProcessGroupDTO responseDto = responseEntity.getProcessGroup();
            FlowSnippetDTO contents = responseDto.getContents();
            if (contents == null) {
                if (!nodeResponsesToDrain.isEmpty()) {
                    this.drainResponses(nodeResponsesToDrain);
                }
            } else {
                Object mergeMap2;
                HashMap processorMap2 = new HashMap();
                Iterator remoteProcessGroupMap2 = new HashMap();
                for (NodeResponse nodeResponse : updatedNodesMap.values()) {
                    Map<NodeIdentifier, RemoteProcessGroupDTO> innerMap2;
                    if (problematicNodeResponses.contains(nodeResponse)) continue;
                    ProcessorEntity nodeResponseEntity2 = nodeResponse == clientResponse ? responseEntity : (ProcessGroupEntity)nodeResponse.getClientResponse().getEntity(ProcessGroupEntity.class);
                    ProcessGroupDTO nodeProcessGroup = nodeResponseEntity2.getProcessGroup();
                    for (ProcessorDTO nodeProcessor : nodeProcessGroup.getContents().getProcessors()) {
                        innerMap2 = (HashMap<NodeIdentifier, ProcessorDTO>)processorMap2.get(nodeProcessor.getId());
                        if (innerMap2 == null) {
                            innerMap2 = new HashMap<NodeIdentifier, ProcessorDTO>();
                            processorMap2.put(nodeProcessor.getId(), innerMap2);
                        }
                        innerMap2.put(nodeResponse.getNodeId(), (RemoteProcessGroupDTO)nodeProcessor);
                    }
                    for (RemoteProcessGroupDTO nodeRemoteProcessGroup : nodeProcessGroup.getContents().getRemoteProcessGroups()) {
                        innerMap2 = (Map)remoteProcessGroupMap2.get(nodeRemoteProcessGroup.getId());
                        if (innerMap2 == null) {
                            innerMap2 = new HashMap();
                            remoteProcessGroupMap2.put(nodeRemoteProcessGroup.getId(), innerMap2);
                        }
                        innerMap2.put(nodeResponse.getNodeId(), nodeRemoteProcessGroup);
                    }
                }
                for (ProcessorDTO processor : contents.getProcessors()) {
                    String procId2 = processor.getId();
                    mergeMap2 = (Map)processorMap2.get(procId2);
                    this.mergeProcessorValidationErrors(processor, (Map<NodeIdentifier, ProcessorDTO>)mergeMap2);
                }
                for (RemoteProcessGroupDTO remoteProcessGroup : contents.getRemoteProcessGroups()) {
                    if (remoteProcessGroup.getContents() == null) continue;
                    String remoteProcessGroupId = remoteProcessGroup.getId();
                    mergeMap2 = (Map)remoteProcessGroupMap2.get(remoteProcessGroupId);
                    this.mergeRemoteProcessGroup(remoteProcessGroup, (Map<NodeIdentifier, RemoteProcessGroupDTO>)mergeMap2);
                }
            }
            clientResponse = new NodeResponse(clientResponse, (Entity)responseEntity);
        } else if (hasSuccessfulClientResponse && (WebClusterManager.isTemplateEndpoint(uri, method) || WebClusterManager.isFlowSnippetEndpoint(uri, method))) {
            responseEntity = (FlowSnippetEntity)clientResponse.getClientResponse().getEntity(FlowSnippetEntity.class);
            FlowSnippetDTO contents = responseEntity.getContents();
            if (contents == null) {
                if (!nodeResponsesToDrain.isEmpty()) {
                    this.drainResponses(nodeResponsesToDrain);
                }
            } else {
                Map mergeMap3;
                processorMap = new HashMap();
                Iterator<Object> remoteProcessGroupMap3 = new HashMap();
                for (NodeResponse nodeResponse : updatedNodesMap.values()) {
                    Map<NodeIdentifier, RemoteProcessGroupDTO> innerMap3;
                    if (problematicNodeResponses.contains(nodeResponse)) continue;
                    ProcessorEntity nodeResponseEntity3 = nodeResponse == clientResponse ? responseEntity : (FlowSnippetEntity)nodeResponse.getClientResponse().getEntity(FlowSnippetEntity.class);
                    FlowSnippetDTO nodeContents = nodeResponseEntity3.getContents();
                    for (ProcessorDTO nodeProcessor : nodeContents.getProcessors()) {
                        innerMap3 = (HashMap<NodeIdentifier, ProcessorDTO>)processorMap.get(nodeProcessor.getId());
                        if (innerMap3 == null) {
                            innerMap3 = new HashMap<NodeIdentifier, ProcessorDTO>();
                            processorMap.put((NodeIdentifier)nodeProcessor.getId(), (ProcessorDTO)innerMap3);
                        }
                        innerMap3.put(nodeResponse.getNodeId(), (RemoteProcessGroupDTO)nodeProcessor);
                    }
                    for (RemoteProcessGroupDTO nodeRemoteProcessGroup : nodeContents.getRemoteProcessGroups()) {
                        innerMap3 = (Map)remoteProcessGroupMap3.get(nodeRemoteProcessGroup.getId());
                        if (innerMap3 == null) {
                            innerMap3 = new HashMap();
                            remoteProcessGroupMap3.put(nodeRemoteProcessGroup.getId(), innerMap3);
                        }
                        innerMap3.put(nodeResponse.getNodeId(), nodeRemoteProcessGroup);
                    }
                }
                for (ProcessorDTO processor : contents.getProcessors()) {
                    String procId3 = processor.getId();
                    mergeMap3 = (Map)processorMap.get(procId3);
                    this.mergeProcessorValidationErrors(processor, mergeMap3);
                }
                for (RemoteProcessGroupDTO remoteProcessGroup : contents.getRemoteProcessGroups()) {
                    if (remoteProcessGroup.getContents() == null) continue;
                    String remoteProcessGroupId = remoteProcessGroup.getId();
                    mergeMap3 = (Map)remoteProcessGroupMap3.get(remoteProcessGroupId);
                    this.mergeRemoteProcessGroup(remoteProcessGroup, mergeMap3);
                }
            }
            clientResponse = new NodeResponse(clientResponse, (Entity)responseEntity);
        } else if (hasSuccessfulClientResponse && WebClusterManager.isRemoteProcessGroupEndpoint(uri, method)) {
            responseEntity = (RemoteProcessGroupEntity)clientResponse.getClientResponse().getEntity(RemoteProcessGroupEntity.class);
            RemoteProcessGroupDTO remoteProcessGroup = responseEntity.getRemoteProcessGroup();
            remoteProcessGroupMap = new HashMap<NodeIdentifier, RemoteProcessGroupDTO>();
            for (NodeResponse nodeResponse : updatedNodesMap.values()) {
                if (problematicNodeResponses.contains(nodeResponse)) continue;
                nodeResponseEntity = nodeResponse == clientResponse ? responseEntity : (RemoteProcessGroupEntity)nodeResponse.getClientResponse().getEntity(RemoteProcessGroupEntity.class);
                RemoteProcessGroupDTO nodeRemoteProcessGroup = nodeResponseEntity.getRemoteProcessGroup();
                remoteProcessGroupMap.put(nodeResponse.getNodeId(), nodeRemoteProcessGroup);
            }
            this.mergeRemoteProcessGroup(remoteProcessGroup, remoteProcessGroupMap);
            clientResponse = new NodeResponse(clientResponse, (Entity)responseEntity);
        } else if (hasSuccessfulClientResponse && WebClusterManager.isRemoteProcessGroupsEndpoint(uri, method)) {
            responseEntity = (RemoteProcessGroupsEntity)clientResponse.getClientResponse().getEntity(RemoteProcessGroupsEntity.class);
            Set remoteProcessGroups = responseEntity.getRemoteProcessGroups();
            remoteProcessGroupMap = new HashMap();
            for (NodeResponse nodeResponse : updatedNodesMap.values()) {
                if (problematicNodeResponses.contains(nodeResponse)) continue;
                nodeResponseEntity = nodeResponse == clientResponse ? responseEntity : (RemoteProcessGroupsEntity)nodeResponse.getClientResponse().getEntity(RemoteProcessGroupsEntity.class);
                Set nodeRemoteProcessGroups = nodeResponseEntity.getRemoteProcessGroups();
                for (RemoteProcessGroupDTO nodeRemoteProcessGroup : nodeRemoteProcessGroups) {
                    innerMap = (Map)remoteProcessGroupMap.get(nodeRemoteProcessGroup.getId());
                    if (innerMap == null) {
                        innerMap = new HashMap<NodeIdentifier, RemoteProcessGroupDTO>();
                        remoteProcessGroupMap.put((NodeIdentifier)nodeRemoteProcessGroup.getId(), (RemoteProcessGroupDTO)innerMap);
                    }
                    innerMap.put(nodeResponse.getNodeId(), (ReportingTaskDTO)nodeRemoteProcessGroup);
                }
            }
            for (RemoteProcessGroupDTO remoteProcessGroup : remoteProcessGroups) {
                String remoteProcessGroupId = remoteProcessGroup.getId();
                mergeMap = (Map)remoteProcessGroupMap.get(remoteProcessGroupId);
                this.mergeRemoteProcessGroup(remoteProcessGroup, mergeMap);
            }
            clientResponse = new NodeResponse(clientResponse, (Entity)responseEntity);
        } else if (hasSuccessfulClientResponse && WebClusterManager.isProvenanceQueryEndpoint(uri, method)) {
            responseEntity = (ProvenanceEntity)clientResponse.getClientResponse().getEntity(ProvenanceEntity.class);
            ProvenanceDTO query = responseEntity.getProvenance();
            resultsMap = new HashMap<NodeIdentifier, ProvenanceDTO>();
            for (NodeResponse nodeResponse : updatedNodesMap.values()) {
                if (problematicNodeResponses.contains(nodeResponse)) continue;
                nodeResponseEntity = nodeResponse == clientResponse ? responseEntity : (ProvenanceEntity)nodeResponse.getClientResponse().getEntity(ProvenanceEntity.class);
                ProvenanceDTO nodeQuery = nodeResponseEntity.getProvenance();
                resultsMap.put(nodeResponse.getNodeId(), nodeQuery);
            }
            this.mergeProvenanceQueryResults(query, resultsMap, problematicNodeResponses);
            clientResponse = new NodeResponse(clientResponse, (Entity)responseEntity);
        } else if (hasSuccessfulClientResponse && WebClusterManager.isProvenanceEventEndpoint(uri, method)) {
            responseEntity = (ProvenanceEventEntity)clientResponse.getClientResponse().getEntity(ProvenanceEventEntity.class);
            ProvenanceEventDTO event = responseEntity.getProvenanceEvent();
            NodeIdentifier nodeId = clientResponse.getNodeId();
            event.setClusterNodeId(nodeId.getId());
            event.setClusterNodeAddress(nodeId.getApiAddress() + ":" + nodeId.getApiPort());
            clientResponse = new NodeResponse(clientResponse, (Entity)responseEntity);
        } else if (hasSuccessfulClientResponse && WebClusterManager.isControllerServiceEndpoint(uri, method)) {
            responseEntity = (ControllerServiceEntity)clientResponse.getClientResponse().getEntity(ControllerServiceEntity.class);
            ControllerServiceDTO controllerService = responseEntity.getControllerService();
            resultsMap = new HashMap();
            for (NodeResponse nodeResponse : updatedNodesMap.values()) {
                if (problematicNodeResponses.contains(nodeResponse)) continue;
                nodeResponseEntity = nodeResponse == clientResponse ? responseEntity : (ControllerServiceEntity)nodeResponse.getClientResponse().getEntity(ControllerServiceEntity.class);
                ControllerServiceDTO nodeControllerService = nodeResponseEntity.getControllerService();
                resultsMap.put(nodeResponse.getNodeId(), nodeControllerService);
            }
            this.mergeControllerService(controllerService, resultsMap);
            clientResponse = new NodeResponse(clientResponse, (Entity)responseEntity);
        } else if (hasSuccessfulClientResponse && WebClusterManager.isControllerServicesEndpoint(uri, method)) {
            responseEntity = (ControllerServicesEntity)clientResponse.getClientResponse().getEntity(ControllerServicesEntity.class);
            Set controllerServices = responseEntity.getControllerServices();
            HashMap controllerServiceMap = new HashMap();
            for (NodeResponse nodeResponse : updatedNodesMap.values()) {
                if (problematicNodeResponses.contains(nodeResponse)) continue;
                nodeResponseEntity = nodeResponse == clientResponse ? responseEntity : (ControllerServicesEntity)nodeResponse.getClientResponse().getEntity(ControllerServicesEntity.class);
                Set nodeControllerServices = nodeResponseEntity.getControllerServices();
                for (ControllerServiceDTO nodeControllerService : nodeControllerServices) {
                    innerMap = (Map)controllerServiceMap.get(nodeControllerService.getId());
                    if (innerMap == null) {
                        innerMap = new HashMap();
                        controllerServiceMap.put(nodeControllerService.getId(), innerMap);
                    }
                    innerMap.put(nodeResponse.getNodeId(), (ReportingTaskDTO)nodeControllerService);
                }
            }
            for (ControllerServiceDTO controllerService : controllerServices) {
                procId = controllerService.getId();
                mergeMap = (Map)controllerServiceMap.get(procId);
                this.mergeControllerService(controllerService, mergeMap);
            }
            clientResponse = new NodeResponse(clientResponse, (Entity)responseEntity);
        } else if (hasSuccessfulClientResponse && WebClusterManager.isControllerServiceReferenceEndpoint(uri, method)) {
            responseEntity = (ControllerServiceReferencingComponentsEntity)clientResponse.getClientResponse().getEntity(ControllerServiceReferencingComponentsEntity.class);
            Set referencingComponents = responseEntity.getControllerServiceReferencingComponents();
            resultsMap = new HashMap();
            for (NodeResponse nodeResponse : updatedNodesMap.values()) {
                if (problematicNodeResponses.contains(nodeResponse)) continue;
                nodeResponseEntity = nodeResponse == clientResponse ? responseEntity : (ControllerServiceReferencingComponentsEntity)nodeResponse.getClientResponse().getEntity(ControllerServiceReferencingComponentsEntity.class);
                Set nodeReferencingComponents = nodeResponseEntity.getControllerServiceReferencingComponents();
                resultsMap.put(nodeResponse.getNodeId(), nodeReferencingComponents);
            }
            this.mergeControllerServiceReferences(referencingComponents, resultsMap);
            clientResponse = new NodeResponse(clientResponse, (Entity)responseEntity);
        } else if (hasSuccessfulClientResponse && WebClusterManager.isReportingTaskEndpoint(uri, method)) {
            responseEntity = (ReportingTaskEntity)clientResponse.getClientResponse().getEntity(ReportingTaskEntity.class);
            ReportingTaskDTO reportingTask = responseEntity.getReportingTask();
            resultsMap = new HashMap();
            for (NodeResponse nodeResponse : updatedNodesMap.values()) {
                if (problematicNodeResponses.contains(nodeResponse)) continue;
                nodeResponseEntity = nodeResponse == clientResponse ? responseEntity : (ReportingTaskEntity)nodeResponse.getClientResponse().getEntity(ReportingTaskEntity.class);
                ReportingTaskDTO nodeReportingTask = nodeResponseEntity.getReportingTask();
                resultsMap.put(nodeResponse.getNodeId(), nodeReportingTask);
            }
            this.mergeReportingTask(reportingTask, resultsMap);
            clientResponse = new NodeResponse(clientResponse, (Entity)responseEntity);
        } else if (hasSuccessfulClientResponse && WebClusterManager.isReportingTasksEndpoint(uri, method)) {
            responseEntity = (ReportingTasksEntity)clientResponse.getClientResponse().getEntity(ReportingTasksEntity.class);
            Set reportingTaskSet = responseEntity.getReportingTasks();
            HashMap reportingTaskMap = new HashMap();
            for (NodeResponse nodeResponse : updatedNodesMap.values()) {
                if (problematicNodeResponses.contains(nodeResponse)) continue;
                nodeResponseEntity = nodeResponse == clientResponse ? responseEntity : (ReportingTasksEntity)nodeResponse.getClientResponse().getEntity(ReportingTasksEntity.class);
                Set nodeReportingTasks = nodeResponseEntity.getReportingTasks();
                for (ReportingTaskDTO nodeReportingTask : nodeReportingTasks) {
                    innerMap = (Map)reportingTaskMap.get(nodeReportingTask.getId());
                    if (innerMap == null) {
                        innerMap = new HashMap();
                        reportingTaskMap.put(nodeReportingTask.getId(), innerMap);
                    }
                    innerMap.put(nodeResponse.getNodeId(), nodeReportingTask);
                }
            }
            for (ReportingTaskDTO reportingTask : reportingTaskSet) {
                procId = reportingTask.getId();
                mergeMap = (Map)reportingTaskMap.get(procId);
                this.mergeReportingTask(reportingTask, mergeMap);
            }
            clientResponse = new NodeResponse(clientResponse, (Entity)responseEntity);
        } else if (hasSuccessfulClientResponse && WebClusterManager.isDropRequestEndpoint(uri, method)) {
            responseEntity = (DropRequestEntity)clientResponse.getClientResponse().getEntity(DropRequestEntity.class);
            DropRequestDTO dropRequest = responseEntity.getDropRequest();
            resultsMap = new HashMap();
            for (NodeResponse nodeResponse : updatedNodesMap.values()) {
                if (problematicNodeResponses.contains(nodeResponse)) continue;
                nodeResponseEntity = nodeResponse == clientResponse ? responseEntity : (DropRequestEntity)nodeResponse.getClientResponse().getEntity(DropRequestEntity.class);
                DropRequestDTO nodeDropRequest = nodeResponseEntity.getDropRequest();
                resultsMap.put(nodeResponse.getNodeId(), nodeDropRequest);
            }
            this.mergeDropRequests(dropRequest, resultsMap);
            clientResponse = new NodeResponse(clientResponse, (Entity)responseEntity);
        } else if (hasSuccessfulClientResponse && WebClusterManager.isListFlowFilesEndpoint(uri, method)) {
            responseEntity = (ListingRequestEntity)clientResponse.getClientResponse().getEntity(ListingRequestEntity.class);
            ListingRequestDTO listingRequest = responseEntity.getListingRequest();
            resultsMap = new HashMap();
            for (NodeResponse nodeResponse : updatedNodesMap.values()) {
                if (problematicNodeResponses.contains(nodeResponse)) continue;
                nodeResponseEntity = nodeResponse == clientResponse ? responseEntity : (ListingRequestEntity)nodeResponse.getClientResponse().getEntity(ListingRequestEntity.class);
                ListingRequestDTO nodeListingRequest = nodeResponseEntity.getListingRequest();
                resultsMap.put(nodeResponse.getNodeId(), nodeListingRequest);
            }
            this.mergeListingRequests(listingRequest, resultsMap);
            clientResponse = new NodeResponse(clientResponse, (Entity)responseEntity);
        } else if (hasSuccessfulClientResponse && (WebClusterManager.isProcessorStateEndpoint(uri, method) || WebClusterManager.isControllerServiceStateEndpoint(uri, method) || WebClusterManager.isReportingTaskStateEndpoint(uri, method))) {
            responseEntity = (ComponentStateEntity)clientResponse.getClientResponse().getEntity(ComponentStateEntity.class);
            ComponentStateDTO componentState = responseEntity.getComponentState();
            resultsMap = new HashMap();
            for (NodeResponse nodeResponse : updatedNodesMap.values()) {
                if (problematicNodeResponses.contains(nodeResponse)) continue;
                nodeResponseEntity = nodeResponse == clientResponse ? responseEntity : (ComponentStateEntity)nodeResponse.getClientResponse().getEntity(ComponentStateEntity.class);
                ComponentStateDTO nodeComponentState = nodeResponseEntity.getComponentState();
                resultsMap.put(nodeResponse.getNodeId(), nodeComponentState);
            }
            this.mergeComponentState(componentState, resultsMap);
            clientResponse = new NodeResponse(clientResponse, (Entity)responseEntity);
        } else if (!nodeResponsesToDrain.isEmpty()) {
            this.drainResponses(nodeResponsesToDrain);
        }
        if (mutableRequest) {
            boolean someNodesFailedMissingCounter;
            boolean allNodesFailed = problematicNodeResponses.size() == nodeResponses.size();
            boolean bl = someNodesFailedMissingCounter = !problematicNodeResponses.isEmpty() && problematicNodeResponses.size() < nodeResponses.size() && this.isMissingCounter(problematicNodeResponses, uri);
            if (allNodesFailed || someNodesFailedMissingCounter) {
                for (Map.Entry updatedNodeEntry : updatedNodesMap.entrySet()) {
                    NodeResponse nodeResponse;
                    nodeResponse = (NodeResponse)updatedNodeEntry.getValue();
                    Node node = (Node)updatedNodeEntry.getKey();
                    if (!problematicNodeResponses.contains(nodeResponse)) continue;
                    node.setStatus(Node.Status.CONNECTED);
                    problematicNodeResponses.remove(nodeResponse);
                }
            }
            this.nodes.removeAll(updatedNodesMap.keySet());
            this.nodes.addAll(updatedNodesMap.keySet());
            this.notifyDataFlowManagementServiceOfNodeStatusChange();
            this.notifyDataFlowManagmentServiceOfFlowStateChange(PersistedFlowState.STALE);
            if (!problematicNodeResponses.isEmpty()) {
                if (problematicNodeResponses.size() < nodeResponses.size()) {
                    logger.warn(String.format("One or more nodes failed to process URI '%s'.  Requesting each node to disconnect from cluster.", uri));
                    this.disconnectNodes(problematicNodeResponses, "Failed to process URI " + uri);
                } else {
                    logger.warn("All nodes failed to process URI {}. As a result, no node will be disconnected from cluster", (Object)uri);
                }
            }
        }
        return clientResponse;
    }

    private boolean isMissingCounter(Set<NodeResponse> problematicNodeResponses, URI uri) {
        if (WebClusterManager.isCountersEndpoint(uri)) {
            boolean notFound = true;
            for (NodeResponse problematicResponse : problematicNodeResponses) {
                if (problematicResponse.getStatus() == 404) continue;
                notFound = false;
                break;
            }
            return notFound;
        }
        return false;
    }

    private void drainResponses(Collection<NodeResponse> nodeResponses) {
        if (nodeResponses.isEmpty()) {
            return;
        }
        ExecutorService executorService = Executors.newFixedThreadPool(this.properties.getClusterManagerProtocolThreads());
        ExecutorCompletionService<Object> completionService = new ExecutorCompletionService<Object>(executorService);
        for (final NodeResponse nodeResponse : nodeResponses) {
            if (nodeResponse.hasThrowable()) continue;
            completionService.submit(new Runnable(){

                @Override
                public void run() {
                    try (OutputStream drain = new OutputStream(){

                        @Override
                        public void write(int b) {
                        }
                    };){
                        ((StreamingOutput)nodeResponse.getResponse().getEntity()).write(drain);
                    }
                    catch (IOException | WebApplicationException ex) {
                        logger.info("Failed clearing out non-client response buffer due to: " + ex, ex);
                    }
                }
            }, null);
        }
        executorService.shutdown();
    }

    private void disconnectNodes(Set<NodeResponse> nodeResponses, final String explanation) {
        if (nodeResponses == null || nodeResponses.isEmpty()) {
            return;
        }
        ExecutorService executorService = Executors.newFixedThreadPool(this.properties.getClusterManagerProtocolThreads());
        ExecutorCompletionService<Object> completionService = new ExecutorCompletionService<Object>(executorService);
        for (final NodeResponse nodeResponse : nodeResponses) {
            completionService.submit(new Runnable(){

                @Override
                public void run() {
                    NodeIdentifier nodeId = nodeResponse.getNodeId();
                    int responseStatus = nodeResponse.getStatus();
                    URI requestUri = nodeResponse.getRequestUri();
                    StringBuilder msgBuilder = new StringBuilder();
                    msgBuilder.append("Requesting disconnection for node ").append(nodeId).append(" for request URI ").append(requestUri);
                    if (nodeResponse.hasThrowable()) {
                        msgBuilder.append(" because manager encountered exception when issuing request: ").append(nodeResponse.getThrowable());
                        ((NiFiLog)logger).getWrappedLog().info(msgBuilder.toString(), nodeResponse.getThrowable());
                        WebClusterManager.this.addEvent(nodeId, "Manager encountered exception when issuing request for URI " + requestUri);
                        WebClusterManager.this.addBulletin(nodeId, Severity.ERROR, "Manager encountered exception when issuing request for URI " + requestUri + "; node will be disconnected");
                    } else {
                        msgBuilder.append(" because HTTP response status was ").append(responseStatus);
                        logger.info(msgBuilder.toString());
                        WebClusterManager.this.addEvent(nodeId, "HTTP response status was unsuccessful (" + responseStatus + ") for request URI " + requestUri);
                        WebClusterManager.this.addBulletin(nodeId, Severity.ERROR, "HTTP response status was unsuccessful (" + responseStatus + ") for request URI " + requestUri);
                    }
                    WebClusterManager.this.requestDisconnectionQuietly(nodeId, explanation);
                }
            }, null);
        }
        executorService.shutdown();
    }

    private boolean isBlockedByFirewall(String ip) {
        if (this.isFirewallConfigured()) {
            return !this.clusterFirewall.isPermissible(ip);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Node> getRawNodes(Node.Status ... statuses) {
        this.readLock.lock();
        try {
            HashSet<Node> result = new HashSet<Node>();
            if (statuses == null || statuses.length == 0) {
                result.addAll(this.nodes);
            } else {
                block3: for (Node node : this.nodes) {
                    for (Node.Status status : statuses) {
                        if (node.getStatus() != status) continue;
                        result.add(node);
                        continue block3;
                    }
                }
            }
            HashSet<Node> hashSet = result;
            return hashSet;
        }
        finally {
            this.readLock.unlock("getRawNodes(Status...)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node getRawNode(String nodeId) {
        this.readLock.lock();
        try {
            for (Node node : this.nodes) {
                if (!node.getNodeId().getId().equals(nodeId)) continue;
                Node node2 = node;
                return node2;
            }
            Iterator<Node> iterator = null;
            return iterator;
        }
        finally {
            this.readLock.unlock("getRawNode(String)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NodeIdentifier resolveProposedNodeIdentifier(NodeIdentifier proposedNodeId) throws ConflictingNodeIdException {
        this.readLock.lock();
        try {
            for (Node node : this.nodes) {
                NodeIdentifier nodeId = node.getNodeId();
                boolean sameId = nodeId.equals((Object)proposedNodeId);
                boolean sameServiceCoordinates = nodeId.logicallyEquals(proposedNodeId);
                if (sameId && sameServiceCoordinates) {
                    NodeIdentifier nodeIdentifier = proposedNodeId;
                    return nodeIdentifier;
                }
                if (sameId && !sameServiceCoordinates) {
                    throw new ConflictingNodeIdException(nodeId.getId(), node.getNodeId().getApiAddress(), node.getNodeId().getApiPort());
                }
                if (sameId || !sameServiceCoordinates) continue;
                logger.debug(String.format("Using Node Identifier %s because proposed node identifier %s matches the service coordinates", nodeId, proposedNodeId));
                NodeIdentifier nodeIdentifier = new NodeIdentifier(nodeId.getId(), proposedNodeId.getApiAddress(), proposedNodeId.getApiPort(), proposedNodeId.getSocketAddress(), proposedNodeId.getSocketPort(), proposedNodeId.getSiteToSiteAddress(), proposedNodeId.getSiteToSitePort(), proposedNodeId.isSiteToSiteSecure());
                return nodeIdentifier;
            }
            NodeIdentifier nodeIdentifier = new NodeIdentifier(proposedNodeId.getId(), proposedNodeId.getApiAddress(), proposedNodeId.getApiPort(), proposedNodeId.getSocketAddress(), proposedNodeId.getSocketPort(), proposedNodeId.getSiteToSiteAddress(), proposedNodeId.getSiteToSitePort(), proposedNodeId.isSiteToSiteSecure());
            return nodeIdentifier;
        }
        finally {
            this.readLock.unlock("resolveProposedNodeIdentifier");
        }
    }

    private boolean isHeartbeatMonitorRunning() {
        this.readLock.lock();
        try {
            boolean bl = this.heartbeatMonitor != null;
            return bl;
        }
        finally {
            this.readLock.unlock("isHeartbeatMonitorRunning");
        }
    }

    private boolean canChangeNodeState(String method, URI uri) {
        return "DELETE".equalsIgnoreCase(method) || "POST".equalsIgnoreCase(method) || "PUT".equalsIgnoreCase(method);
    }

    private void notifyDataFlowManagementServiceOfNodeStatusChange() {
        this.writeLock.lock();
        try {
            logger.debug("Notifying DataFlow Management Service of current set of connected nodes.");
            this.dataFlowManagementService.setNodeIds(this.getNodeIds(Node.Status.CONNECTED));
        }
        finally {
            this.writeLock.unlock("notifyDataFlowManagementServiceOfNodeStatusChange");
        }
    }

    private void notifyDataFlowManagmentServiceOfFlowStateChange(PersistedFlowState newState) {
        this.writeLock.lock();
        try {
            logger.debug("Notifying DataFlow Management Service that flow state is " + (Object)((Object)newState));
            this.dataFlowManagementService.setPersistedFlowState(newState);
            if (newState != PersistedFlowState.CURRENT) {
                this.cachedDataFlow = null;
            }
        }
        finally {
            this.writeLock.unlock("notifyDataFlowManagementServiceOfFlowStateChange");
        }
    }

    private void logNodes(String header, Logger logger) {
        if (logger.isTraceEnabled()) {
            if (StringUtils.isNotBlank((CharSequence)header)) {
                logger.trace(header);
            }
            for (Node node : this.getNodes(new Node.Status[0])) {
                logger.trace(node.getNodeId() + " : " + (Object)((Object)node.getStatus()));
            }
        }
    }

    private void executeSafeModeTask() {
        new Thread(new Runnable(){
            private final long threadStartTime = System.currentTimeMillis();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                logger.info("Entering safe mode...");
                int safeModeSeconds = (int)FormatUtils.getTimeDuration((String)WebClusterManager.this.properties.getClusterManagerSafeModeDuration(), (TimeUnit)TimeUnit.SECONDS);
                long timeToElect = safeModeSeconds <= 0 ? Long.MAX_VALUE : this.threadStartTime + TimeUnit.MILLISECONDS.convert(safeModeSeconds, TimeUnit.SECONDS);
                boolean exitSafeMode = false;
                while (WebClusterManager.this.isRunning()) {
                    WebClusterManager.this.writeLock.lock();
                    try {
                        NodeIdentifier connectedNodeId;
                        Set<NodeIdentifier> connectedNodeIds;
                        long currentTime = System.currentTimeMillis();
                        if (timeToElect < currentTime && !(connectedNodeIds = WebClusterManager.this.getNodeIds(Node.Status.CONNECTED)).isEmpty() && WebClusterManager.this.assignPrimaryRole(connectedNodeId = connectedNodeIds.iterator().next())) {
                            try {
                                WebClusterManager.this.setPrimaryNodeId(connectedNodeId);
                                exitSafeMode = true;
                            }
                            catch (DaoException de) {
                                String message = String.format("Failed to persist primary node ID '%s' in cluster dataflow.", connectedNodeId);
                                logger.warn(message);
                                WebClusterManager.this.addBulletin(connectedNodeId, Severity.WARNING, message);
                                WebClusterManager.this.revokePrimaryRole(connectedNodeId);
                            }
                        }
                        if (!WebClusterManager.this.isInSafeMode()) {
                            exitSafeMode = true;
                            logger.info("Exiting safe mode because " + WebClusterManager.this.primaryNodeId + " has been assigned the primary role.");
                            break;
                        }
                    }
                    finally {
                        WebClusterManager.this.writeLock.unlock("executeSafeModeTask");
                    }
                    if (exitSafeMode) continue;
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ie) {
                        return;
                    }
                }
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterNodeInformation getNodeInformation() {
        this.readLock.lock();
        try {
            ArrayList<NodeInformation> nodeInfos = new ArrayList<NodeInformation>();
            for (Node node : this.getRawNodes(Node.Status.CONNECTED)) {
                Integer siteToSitePort;
                NodeIdentifier id = node.getNodeId();
                HeartbeatPayload heartbeat = node.getHeartbeatPayload();
                if (heartbeat == null || (siteToSitePort = id.getSiteToSitePort()) == null) continue;
                int flowFileCount = (int)heartbeat.getTotalFlowFileCount();
                NodeInformation nodeInfo = new NodeInformation(id.getSiteToSiteAddress(), siteToSitePort, id.getApiPort(), id.isSiteToSiteSecure(), flowFileCount);
                nodeInfos.add(nodeInfo);
            }
            ClusterNodeInformation clusterNodeInfo = new ClusterNodeInformation();
            clusterNodeInfo.setNodeInformation(nodeInfos);
            ClusterNodeInformation clusterNodeInformation = clusterNodeInfo;
            return clusterNodeInformation;
        }
        finally {
            this.readLock.unlock("getNodeInformation");
        }
    }

    @Override
    public BulletinRepository getBulletinRepository() {
        return this.bulletinRepository;
    }

    @Override
    public ProcessGroupStatus getProcessGroupStatus(String groupId) {
        Set<Node> connectedNodes = this.getNodes(Node.Status.CONNECTED);
        if (connectedNodes.isEmpty()) {
            throw new NoConnectedNodesException();
        }
        ProcessGroupStatus mergedProcessGroupStatus = null;
        for (Node node : connectedNodes) {
            NodeIdentifier nodeId = node.getNodeId();
            HeartbeatPayload nodeHeartbeatPayload = node.getHeartbeatPayload();
            if (nodeHeartbeatPayload == null) continue;
            ProcessGroupStatus nodeRootProcessGroupStatus = nodeHeartbeatPayload.getProcessGroupStatus();
            ProcessGroupStatus nodeProcessGroupStatus = groupId.equals(ROOT_GROUP_ID_ALIAS) ? nodeRootProcessGroupStatus : this.getProcessGroupStatus(nodeRootProcessGroupStatus, groupId);
            if (nodeProcessGroupStatus == null) continue;
            if (mergedProcessGroupStatus == null) {
                mergedProcessGroupStatus = nodeProcessGroupStatus.clone();
                if (mergedProcessGroupStatus.getRemoteProcessGroupStatus() == null) continue;
                for (RemoteProcessGroupStatus remoteProcessGroupStatus : mergedProcessGroupStatus.getRemoteProcessGroupStatus()) {
                    List nodeAuthorizationIssues = remoteProcessGroupStatus.getAuthorizationIssues();
                    if (nodeAuthorizationIssues.isEmpty()) continue;
                    ListIterator<String> iter = nodeAuthorizationIssues.listIterator();
                    while (iter.hasNext()) {
                        String Issue = (String)iter.next();
                        iter.set("[" + nodeId.getApiAddress() + ":" + nodeId.getApiPort() + "] -- " + Issue);
                    }
                    remoteProcessGroupStatus.setAuthorizationIssues(nodeAuthorizationIssues);
                }
                continue;
            }
            ProcessGroupStatus nodeClone = nodeProcessGroupStatus.clone();
            for (RemoteProcessGroupStatus remoteProcessGroupStatus : nodeClone.getRemoteProcessGroupStatus()) {
                List nodeAuthorizationIssues = remoteProcessGroupStatus.getAuthorizationIssues();
                if (nodeAuthorizationIssues.isEmpty()) continue;
                ListIterator<String> iter = nodeAuthorizationIssues.listIterator();
                while (iter.hasNext()) {
                    String Issue = (String)iter.next();
                    iter.set("[" + nodeId.getApiAddress() + ":" + nodeId.getApiPort() + "] -- " + Issue);
                }
                remoteProcessGroupStatus.setAuthorizationIssues(nodeAuthorizationIssues);
            }
            ProcessGroupStatus.merge((ProcessGroupStatus)mergedProcessGroupStatus, (ProcessGroupStatus)nodeClone);
        }
        return mergedProcessGroupStatus;
    }

    private ProcessGroupStatus getProcessGroupStatus(ProcessGroupStatus parent, String groupId) {
        if (parent.getId().equals(groupId)) {
            return parent;
        }
        for (ProcessGroupStatus child : parent.getProcessGroupStatus()) {
            ProcessGroupStatus matching = this.getProcessGroupStatus(child, groupId);
            if (matching == null) continue;
            return matching;
        }
        return null;
    }

    @Override
    public SystemDiagnostics getSystemDiagnostics() {
        Set<Node> connectedNodes = this.getNodes(Node.Status.CONNECTED);
        if (connectedNodes.isEmpty()) {
            throw new NoConnectedNodesException();
        }
        SystemDiagnostics clusterDiagnostics = null;
        for (Node node : connectedNodes) {
            SystemDiagnostics nodeDiagnostics;
            HeartbeatPayload nodeHeartbeatPayload = node.getHeartbeatPayload();
            if (nodeHeartbeatPayload == null || (nodeDiagnostics = nodeHeartbeatPayload.getSystemDiagnostics()) == null) continue;
            if (clusterDiagnostics == null) {
                clusterDiagnostics = nodeDiagnostics.clone();
                continue;
            }
            this.merge(clusterDiagnostics, nodeDiagnostics);
        }
        return clusterDiagnostics;
    }

    private void merge(SystemDiagnostics target, SystemDiagnostics sd) {
        LinkedHashMap targetGarbageCollection;
        LinkedHashMap targetContentRepoMap;
        target.setDaemonThreads(target.getDaemonThreads() + sd.getDaemonThreads());
        target.setTotalThreads(target.getTotalThreads() + sd.getTotalThreads());
        target.setTotalHeap(target.getTotalHeap() + sd.getTotalHeap());
        target.setUsedHeap(target.getUsedHeap() + sd.getUsedHeap());
        target.setMaxHeap(target.getMaxHeap() + sd.getMaxHeap());
        target.setTotalNonHeap(target.getTotalNonHeap() + sd.getTotalNonHeap());
        target.setUsedNonHeap(target.getUsedNonHeap() + sd.getUsedNonHeap());
        target.setMaxNonHeap(target.getMaxNonHeap() + sd.getMaxNonHeap());
        target.setAvailableProcessors(target.getAvailableProcessors() + sd.getAvailableProcessors());
        if (sd.getProcessorLoadAverage() != null) {
            if (target.getProcessorLoadAverage() != null) {
                target.setProcessorLoadAverage(Double.valueOf(target.getProcessorLoadAverage() + sd.getProcessorLoadAverage()));
            } else {
                target.setProcessorLoadAverage(sd.getProcessorLoadAverage());
            }
        }
        this.merge(target.getFlowFileRepositoryStorageUsage(), sd.getFlowFileRepositoryStorageUsage());
        if (target.getContentRepositoryStorageUsage() == null) {
            targetContentRepoMap = new LinkedHashMap();
            target.setContentRepositoryStorageUsage(targetContentRepoMap);
        } else {
            targetContentRepoMap = target.getContentRepositoryStorageUsage();
        }
        if (sd.getContentRepositoryStorageUsage() != null) {
            for (Map.Entry sdEntry : sd.getContentRepositoryStorageUsage().entrySet()) {
                StorageUsage mergedDiskUsage = (StorageUsage)targetContentRepoMap.get(sdEntry.getKey());
                if (mergedDiskUsage == null) {
                    targetContentRepoMap.put(sdEntry.getKey(), sdEntry.getValue());
                    continue;
                }
                this.merge(mergedDiskUsage, (StorageUsage)sdEntry.getValue());
            }
        }
        if (target.getGarbageCollection() == null) {
            targetGarbageCollection = new LinkedHashMap();
            target.setGarbageCollection(targetGarbageCollection);
        } else {
            targetGarbageCollection = target.getGarbageCollection();
        }
        if (sd.getGarbageCollection() != null) {
            for (Map.Entry gcEntry : sd.getGarbageCollection().entrySet()) {
                GarbageCollection mergedGarbageCollection = (GarbageCollection)targetGarbageCollection.get(gcEntry.getKey());
                if (mergedGarbageCollection == null) {
                    targetGarbageCollection.put(gcEntry.getKey(), ((GarbageCollection)gcEntry.getValue()).clone());
                    continue;
                }
                this.merge(mergedGarbageCollection, (GarbageCollection)gcEntry.getValue());
            }
        }
    }

    private void merge(StorageUsage target, StorageUsage du) {
        target.setFreeSpace(target.getFreeSpace() + du.getFreeSpace());
        target.setTotalSpace(target.getTotalSpace() + du.getTotalSpace());
    }

    private void merge(GarbageCollection target, GarbageCollection gc) {
        target.setCollectionCount(target.getCollectionCount() + gc.getCollectionCount());
        target.setCollectionTime(target.getCollectionTime() + gc.getCollectionTime());
    }

    public static Date normalizeStatusSnapshotDate(Date toNormalize, long numMillis) {
        long time = toNormalize.getTime();
        return new Date(time - time % numMillis);
    }

    private NodeDTO createNodeDTO(Node node) {
        NodeDTO nodeDto = new NodeDTO();
        NodeIdentifier nodeId = node.getNodeId();
        nodeDto.setNodeId(nodeId.getId());
        nodeDto.setAddress(nodeId.getApiAddress());
        nodeDto.setApiPort(Integer.valueOf(nodeId.getApiPort()));
        nodeDto.setStatus(node.getStatus().name());
        nodeDto.setPrimary(Boolean.valueOf(node.equals(this.getPrimaryNode())));
        Date connectionRequested = new Date(node.getConnectionRequestedTimestamp());
        nodeDto.setConnectionRequested(connectionRequested);
        return nodeDto;
    }

    private List<StatusSnapshotDTO> aggregate(Map<Date, List<StatusSnapshot>> snapshotsToAggregate) {
        ArrayList<StatusSnapshotDTO> aggregatedSnapshotDtos = new ArrayList<StatusSnapshotDTO>();
        for (Map.Entry<Date, List<StatusSnapshot>> entry : snapshotsToAggregate.entrySet()) {
            List<StatusSnapshot> snapshots = entry.getValue();
            StatusSnapshot reducedSnapshot = (StatusSnapshot)snapshots.get(0).getValueReducer().reduce(snapshots);
            StatusSnapshotDTO dto = new StatusSnapshotDTO();
            dto.setTimestamp(reducedSnapshot.getTimestamp());
            dto.setStatusMetrics(StatusHistoryUtil.createStatusSnapshotDto((StatusSnapshot)reducedSnapshot).getStatusMetrics());
            aggregatedSnapshotDtos.add(dto);
        }
        return aggregatedSnapshotDtos;
    }

    public ClusterStatusHistoryDTO getProcessorStatusHistory(String processorId) {
        return this.getProcessorStatusHistory(processorId, null, null, Integer.MAX_VALUE);
    }

    public ClusterStatusHistoryDTO getProcessorStatusHistory(String processorId, Date startDate, Date endDate, int preferredDataPoints) {
        ArrayList<NodeStatusHistoryDTO> nodeHistories = new ArrayList<NodeStatusHistoryDTO>();
        StatusHistoryDTO lastStatusHistory = null;
        LinkedHashSet processorDescriptors = new LinkedHashSet();
        TreeMap<Date, List<StatusSnapshot>> snapshotsToAggregate = new TreeMap<Date, List<StatusSnapshot>>();
        for (Node node : this.getRawNodes(new Node.Status[0])) {
            StatusHistoryDTO statusHistoryDto;
            StatusHistory statusHistory;
            ComponentStatusRepository statusRepository = this.componentMetricsRepositoryMap.get(node.getNodeId());
            if (statusRepository == null || (statusHistory = statusRepository.getProcessorStatusHistory(processorId, startDate, endDate, preferredDataPoints)) == null) continue;
            processorDescriptors.addAll(statusRepository.getProcessorMetricDescriptors());
            lastStatusHistory = statusHistoryDto = this.createStatusHistoryDto(statusHistory);
            NodeStatusHistoryDTO nodeHistory = new NodeStatusHistoryDTO();
            nodeHistory.setStatusHistory(statusHistoryDto);
            nodeHistory.setNode(this.createNodeDTO(node));
            nodeHistories.add(nodeHistory);
            for (StatusSnapshot snapshot : statusHistory.getStatusSnapshots()) {
                Date normalizedDate = WebClusterManager.normalizeStatusSnapshotDate(snapshot.getTimestamp(), this.componentStatusSnapshotMillis);
                ArrayList<StatusSnapshot> snapshots = (ArrayList<StatusSnapshot>)snapshotsToAggregate.get(normalizedDate);
                if (snapshots == null) {
                    snapshots = new ArrayList<StatusSnapshot>();
                    snapshotsToAggregate.put(normalizedDate, snapshots);
                }
                snapshots.add(snapshot);
            }
        }
        List<StatusSnapshotDTO> aggregatedSnapshotDtos = this.aggregate(snapshotsToAggregate);
        LinkedHashMap clusterStatusHistoryDetails = new LinkedHashMap();
        clusterStatusHistoryDetails.putAll(lastStatusHistory.getDetails());
        StatusHistoryDTO clusterStatusHistory = new StatusHistoryDTO();
        clusterStatusHistory.setGenerated(new Date());
        clusterStatusHistory.setFieldDescriptors(StatusHistoryUtil.createFieldDescriptorDtos(processorDescriptors));
        clusterStatusHistory.setDetails(clusterStatusHistoryDetails);
        clusterStatusHistory.setStatusSnapshots(aggregatedSnapshotDtos);
        ClusterStatusHistoryDTO history = new ClusterStatusHistoryDTO();
        history.setGenerated(new Date());
        history.setNodeStatusHistory(nodeHistories);
        history.setClusterStatusHistory(clusterStatusHistory);
        return history;
    }

    public StatusHistoryDTO createStatusHistoryDto(StatusHistory statusHistory) {
        StatusHistoryDTO dto = new StatusHistoryDTO();
        dto.setDetails(new LinkedHashMap(statusHistory.getComponentDetails()));
        dto.setFieldDescriptors(StatusHistoryUtil.createFieldDescriptorDtos((StatusHistory)statusHistory));
        dto.setGenerated(statusHistory.getDateGenerated());
        ArrayList<StatusSnapshotDTO> statusSnapshots = new ArrayList<StatusSnapshotDTO>();
        for (StatusSnapshot statusSnapshot : statusHistory.getStatusSnapshots()) {
            statusSnapshots.add(StatusHistoryUtil.createStatusSnapshotDto((StatusSnapshot)statusSnapshot));
        }
        dto.setStatusSnapshots(statusSnapshots);
        return dto;
    }

    public ClusterStatusHistoryDTO getConnectionStatusHistory(String connectionId) {
        return this.getConnectionStatusHistory(connectionId, null, null, Integer.MAX_VALUE);
    }

    public ClusterStatusHistoryDTO getConnectionStatusHistory(String connectionId, Date startDate, Date endDate, int preferredDataPoints) {
        ArrayList<NodeStatusHistoryDTO> nodeHistories = new ArrayList<NodeStatusHistoryDTO>();
        StatusHistoryDTO lastStatusHistory = null;
        LinkedHashSet connectionDescriptors = new LinkedHashSet();
        TreeMap<Date, List<StatusSnapshot>> snapshotsToAggregate = new TreeMap<Date, List<StatusSnapshot>>();
        for (Node node : this.getRawNodes(new Node.Status[0])) {
            StatusHistoryDTO statusHistoryDto;
            StatusHistory statusHistory;
            ComponentStatusRepository statusRepository = this.componentMetricsRepositoryMap.get(node.getNodeId());
            if (statusRepository == null || (statusHistory = statusRepository.getConnectionStatusHistory(connectionId, startDate, endDate, preferredDataPoints)) == null) continue;
            lastStatusHistory = statusHistoryDto = this.createStatusHistoryDto(statusHistory);
            connectionDescriptors.addAll(statusRepository.getConnectionMetricDescriptors());
            NodeStatusHistoryDTO nodeHistory = new NodeStatusHistoryDTO();
            nodeHistory.setStatusHistory(statusHistoryDto);
            nodeHistory.setNode(this.createNodeDTO(node));
            nodeHistories.add(nodeHistory);
            for (StatusSnapshot snapshot : statusHistory.getStatusSnapshots()) {
                Date normalizedDate = WebClusterManager.normalizeStatusSnapshotDate(snapshot.getTimestamp(), this.componentStatusSnapshotMillis);
                ArrayList<StatusSnapshot> snapshots = (ArrayList<StatusSnapshot>)snapshotsToAggregate.get(normalizedDate);
                if (snapshots == null) {
                    snapshots = new ArrayList<StatusSnapshot>();
                    snapshotsToAggregate.put(normalizedDate, snapshots);
                }
                snapshots.add(snapshot);
            }
        }
        List<StatusSnapshotDTO> aggregatedSnapshotDtos = this.aggregate(snapshotsToAggregate);
        LinkedHashMap clusterStatusHistoryDetails = new LinkedHashMap();
        clusterStatusHistoryDetails.putAll(lastStatusHistory.getDetails());
        StatusHistoryDTO clusterStatusHistory = new StatusHistoryDTO();
        clusterStatusHistory.setGenerated(new Date());
        clusterStatusHistory.setFieldDescriptors(StatusHistoryUtil.createFieldDescriptorDtos(connectionDescriptors));
        clusterStatusHistory.setDetails(clusterStatusHistoryDetails);
        clusterStatusHistory.setStatusSnapshots(aggregatedSnapshotDtos);
        ClusterStatusHistoryDTO history = new ClusterStatusHistoryDTO();
        history.setGenerated(new Date());
        history.setNodeStatusHistory(nodeHistories);
        history.setClusterStatusHistory(clusterStatusHistory);
        return history;
    }

    public ClusterStatusHistoryDTO getProcessGroupStatusHistory(String processGroupId) {
        return this.getProcessGroupStatusHistory(processGroupId, null, null, Integer.MAX_VALUE);
    }

    public ClusterStatusHistoryDTO getProcessGroupStatusHistory(String processGroupId, Date startDate, Date endDate, int preferredDataPoints) {
        ArrayList<NodeStatusHistoryDTO> nodeHistories = new ArrayList<NodeStatusHistoryDTO>();
        StatusHistoryDTO lastStatusHistory = null;
        LinkedHashSet processGroupDescriptors = new LinkedHashSet();
        TreeMap<Date, List<StatusSnapshot>> snapshotsToAggregate = new TreeMap<Date, List<StatusSnapshot>>();
        for (Node node : this.getRawNodes(new Node.Status[0])) {
            StatusHistoryDTO statusHistoryDto;
            StatusHistory statusHistory;
            ComponentStatusRepository statusRepository = this.componentMetricsRepositoryMap.get(node.getNodeId());
            if (statusRepository == null || (statusHistory = statusRepository.getProcessGroupStatusHistory(processGroupId, startDate, endDate, preferredDataPoints)) == null) continue;
            lastStatusHistory = statusHistoryDto = this.createStatusHistoryDto(statusHistory);
            processGroupDescriptors.addAll(statusRepository.getProcessGroupMetricDescriptors());
            NodeStatusHistoryDTO nodeHistory = new NodeStatusHistoryDTO();
            nodeHistory.setStatusHistory(statusHistoryDto);
            nodeHistory.setNode(this.createNodeDTO(node));
            nodeHistories.add(nodeHistory);
            for (StatusSnapshot snapshot : statusHistory.getStatusSnapshots()) {
                Date normalizedDate = WebClusterManager.normalizeStatusSnapshotDate(snapshot.getTimestamp(), this.componentStatusSnapshotMillis);
                ArrayList<StatusSnapshot> snapshots = (ArrayList<StatusSnapshot>)snapshotsToAggregate.get(normalizedDate);
                if (snapshots == null) {
                    snapshots = new ArrayList<StatusSnapshot>();
                    snapshotsToAggregate.put(normalizedDate, snapshots);
                }
                snapshots.add(snapshot);
            }
        }
        List<StatusSnapshotDTO> aggregatedSnapshotDtos = this.aggregate(snapshotsToAggregate);
        LinkedHashMap clusterStatusHistoryDetails = new LinkedHashMap();
        clusterStatusHistoryDetails.putAll(lastStatusHistory.getDetails());
        StatusHistoryDTO clusterStatusHistory = new StatusHistoryDTO();
        clusterStatusHistory.setGenerated(new Date());
        clusterStatusHistory.setDetails(clusterStatusHistoryDetails);
        clusterStatusHistory.setFieldDescriptors(StatusHistoryUtil.createFieldDescriptorDtos(processGroupDescriptors));
        clusterStatusHistory.setStatusSnapshots(aggregatedSnapshotDtos);
        ClusterStatusHistoryDTO history = new ClusterStatusHistoryDTO();
        history.setGenerated(new Date());
        history.setNodeStatusHistory(nodeHistories);
        history.setClusterStatusHistory(clusterStatusHistory);
        return history;
    }

    public ClusterStatusHistoryDTO getRemoteProcessGroupStatusHistory(String remoteGroupId) {
        return this.getRemoteProcessGroupStatusHistory(remoteGroupId, null, null, Integer.MAX_VALUE);
    }

    public ClusterStatusHistoryDTO getRemoteProcessGroupStatusHistory(String remoteGroupId, Date startDate, Date endDate, int preferredDataPoints) {
        ArrayList<NodeStatusHistoryDTO> nodeHistories = new ArrayList<NodeStatusHistoryDTO>();
        StatusHistoryDTO lastStatusHistory = null;
        LinkedHashSet remoteProcessGroupDescriptors = new LinkedHashSet();
        TreeMap<Date, List<StatusSnapshot>> snapshotsToAggregate = new TreeMap<Date, List<StatusSnapshot>>();
        for (Node node : this.getRawNodes(new Node.Status[0])) {
            StatusHistoryDTO statusHistoryDto;
            StatusHistory statusHistory;
            ComponentStatusRepository statusRepository = this.componentMetricsRepositoryMap.get(node.getNodeId());
            if (statusRepository == null || (statusHistory = statusRepository.getRemoteProcessGroupStatusHistory(remoteGroupId, startDate, endDate, preferredDataPoints)) == null) continue;
            lastStatusHistory = statusHistoryDto = this.createStatusHistoryDto(statusHistory);
            remoteProcessGroupDescriptors.addAll(statusRepository.getRemoteProcessGroupMetricDescriptors());
            NodeStatusHistoryDTO nodeHistory = new NodeStatusHistoryDTO();
            nodeHistory.setStatusHistory(statusHistoryDto);
            nodeHistory.setNode(this.createNodeDTO(node));
            nodeHistories.add(nodeHistory);
            for (StatusSnapshot snapshot : statusHistory.getStatusSnapshots()) {
                Date normalizedDate = WebClusterManager.normalizeStatusSnapshotDate(snapshot.getTimestamp(), this.componentStatusSnapshotMillis);
                ArrayList<StatusSnapshot> snapshots = (ArrayList<StatusSnapshot>)snapshotsToAggregate.get(normalizedDate);
                if (snapshots == null) {
                    snapshots = new ArrayList<StatusSnapshot>();
                    snapshotsToAggregate.put(normalizedDate, snapshots);
                }
                snapshots.add(snapshot);
            }
        }
        List<StatusSnapshotDTO> aggregatedSnapshotDtos = this.aggregate(snapshotsToAggregate);
        LinkedHashMap clusterStatusHistoryDetails = new LinkedHashMap();
        clusterStatusHistoryDetails.putAll(lastStatusHistory.getDetails());
        StatusHistoryDTO clusterStatusHistory = new StatusHistoryDTO();
        clusterStatusHistory.setGenerated(new Date());
        clusterStatusHistory.setDetails(clusterStatusHistoryDetails);
        clusterStatusHistory.setFieldDescriptors(StatusHistoryUtil.createFieldDescriptorDtos(remoteProcessGroupDescriptors));
        clusterStatusHistory.setStatusSnapshots(aggregatedSnapshotDtos);
        ClusterStatusHistoryDTO history = new ClusterStatusHistoryDTO();
        history.setGenerated(new Date());
        history.setNodeStatusHistory(nodeHistories);
        history.setClusterStatusHistory(clusterStatusHistory);
        return history;
    }

    public Set<String> getControllerServiceIdentifiers(Class<? extends ControllerService> serviceType) {
        return this.controllerServiceProvider.getControllerServiceIdentifiers(serviceType);
    }

    private class CaptureComponentMetrics
    implements Runnable {
        private CaptureComponentMetrics() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            WebClusterManager.this.readLock.lock();
            try {
                for (Node node : WebClusterManager.this.nodes) {
                    if (!Node.Status.CONNECTED.equals((Object)node.getStatus())) continue;
                    ComponentStatusRepository statusRepository = (ComponentStatusRepository)WebClusterManager.this.componentMetricsRepositoryMap.get(node.getNodeId());
                    if (statusRepository == null) {
                        statusRepository = WebClusterManager.this.createComponentStatusRepository();
                        WebClusterManager.this.componentMetricsRepositoryMap.put(node.getNodeId(), statusRepository);
                    }
                    if (node.getHeartbeat() == null || node.getHeartbeatPayload() == null || statusRepository.getLastCaptureDate() != null && node.getHeartbeat().getCreatedTimestamp() <= statusRepository.getLastCaptureDate().getTime()) continue;
                    statusRepository.capture(node.getHeartbeatPayload().getProcessGroupStatus());
                }
            }
            catch (Throwable t) {
                logger.warn("Unable to capture component metrics from Node heartbeats: " + t);
                if (logger.isDebugEnabled()) {
                    logger.warn("", t);
                }
            }
            finally {
                WebClusterManager.this.readLock.unlock("capture component metrics from node heartbeats");
            }
        }
    }

    private static class ClusterManagerLock {
        private final Lock lock;
        private static final Logger logger = LoggerFactory.getLogger((String)"cluster.lock");
        private long lockTime;
        private final String name;

        public ClusterManagerLock(Lock lock, String name) {
            this.lock = lock;
            this.name = name;
        }

        public boolean tryLock() {
            logger.trace("Trying to obtain Cluster Manager Lock: {}", (Object)this.name);
            boolean success = this.lock.tryLock();
            if (!success) {
                logger.trace("TryLock failed for Cluster Manager Lock: {}", (Object)this.name);
                return false;
            }
            logger.trace("TryLock successful");
            return true;
        }

        public boolean tryLock(long timeout, TimeUnit timeUnit) {
            boolean success;
            logger.trace("Trying to obtain Cluster Manager Lock {} with a timeout of {} {}", new Object[]{this.name, timeout, timeUnit});
            try {
                success = this.lock.tryLock(timeout, timeUnit);
            }
            catch (InterruptedException ie) {
                return false;
            }
            if (!success) {
                logger.trace("TryLock failed for Cluster Manager Lock {} with a timeout of {} {}", new Object[]{this.name, timeout, timeUnit});
                return false;
            }
            logger.trace("TryLock successful");
            return true;
        }

        public void lock() {
            logger.trace("Obtaining Cluster Manager Lock {}", (Object)this.name);
            this.lock.lock();
            this.lockTime = System.nanoTime();
            logger.trace("Obtained Cluster Manager Lock {}", (Object)this.name);
        }

        public void unlock(String task) {
            logger.trace("Releasing Cluster Manager Lock {}", (Object)this.name);
            long nanosLocked = System.nanoTime() - this.lockTime;
            this.lock.unlock();
            logger.trace("Released Cluster Manager Lock {}", (Object)this.name);
            long millisLocked = TimeUnit.MILLISECONDS.convert(nanosLocked, TimeUnit.NANOSECONDS);
            if (millisLocked > 100L) {
                logger.debug("Cluster Manager Lock {} held for {} milliseconds for task: {}", new Object[]{this.name, millisLocked, task});
            }
        }
    }

    private class HeartbeatMonitoringTimerTask
    extends TimerTask {
        private HeartbeatMonitoringTimerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean statusChanged = false;
            WebClusterManager.this.writeLock.lock();
            try {
                logger.debug("Processing pending heartbeats...");
                WebClusterManager.this.processPendingHeartbeats();
                logger.debug("Executing heartbeat monitoring");
                for (Node node : WebClusterManager.this.getRawNodes(new Node.Status[]{Node.Status.CONNECTED})) {
                    if (Thread.currentThread().isInterrupted()) {
                        return;
                    }
                    long lastHeardTimestamp = node.getHeartbeat().getCreatedTimestamp();
                    int heartbeatGapSeconds = (int)(new Date().getTime() - lastHeardTimestamp) / 1000;
                    if (heartbeatGapSeconds <= WebClusterManager.this.getMaxHeartbeatGapSeconds()) continue;
                    node.setHeartbeatDisconnection();
                    WebClusterManager.this.addEvent(node.getNodeId(), "Node disconnected due to lack of heartbeat.");
                    WebClusterManager.this.addBulletin(node, Severity.WARNING, "Node disconnected due to lack of heartbeat");
                    statusChanged = true;
                }
                if (statusChanged) {
                    WebClusterManager.this.logNodes("Heartbeat Monitoring disconnected node(s)", logger);
                    WebClusterManager.this.notifyDataFlowManagementServiceOfNodeStatusChange();
                } else {
                    WebClusterManager.this.logNodes("Heartbeat Monitoring determined all nodes are healthy", logger);
                }
            }
            catch (Exception ex) {
                logger.warn("Heartbeat monitor experienced exception while monitoring: " + ex, (Throwable)ex);
            }
            finally {
                WebClusterManager.this.writeLock.unlock("HeartbeatMonitoringTimerTask");
            }
        }
    }

    private class ProcessPendingHeartbeatsTask
    extends TimerTask {
        private ProcessPendingHeartbeatsTask() {
        }

        @Override
        public void run() {
            WebClusterManager.this.writeLock.lock();
            try {
                WebClusterManager.this.processPendingHeartbeats();
            }
            finally {
                WebClusterManager.this.writeLock.unlock("Process Pending Heartbeats Task");
            }
        }
    }
}

