/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.manager.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.nifi.attribute.expression.language.PreparedQuery;
import org.apache.nifi.attribute.expression.language.Query;
import org.apache.nifi.attribute.expression.language.StandardPropertyValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.state.StateManager;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.controller.status.PortStatus;
import org.apache.nifi.controller.status.ProcessGroupStatus;
import org.apache.nifi.controller.status.ProcessorStatus;
import org.apache.nifi.controller.status.RemoteProcessGroupStatus;
import org.apache.nifi.events.BulletinFactory;
import org.apache.nifi.registry.VariableRegistry;
import org.apache.nifi.reporting.Bulletin;
import org.apache.nifi.reporting.BulletinRepository;
import org.apache.nifi.reporting.ComponentType;
import org.apache.nifi.reporting.EventAccess;
import org.apache.nifi.reporting.ReportingContext;
import org.apache.nifi.reporting.Severity;

public class ClusteredReportingContext
implements ReportingContext {
    private final EventAccess eventAccess;
    private final BulletinRepository bulletinRepository;
    private final ControllerServiceProvider serviceProvider;
    private final Map<PropertyDescriptor, String> properties;
    private final Map<PropertyDescriptor, PreparedQuery> preparedQueries;
    private final StateManager stateManager;
    private final VariableRegistry variableRegistry;

    public ClusteredReportingContext(EventAccess eventAccess, BulletinRepository bulletinRepository, Map<PropertyDescriptor, String> properties, ControllerServiceProvider serviceProvider, StateManager stateManager, VariableRegistry variableRegistry) {
        this.eventAccess = eventAccess;
        this.bulletinRepository = bulletinRepository;
        this.properties = Collections.unmodifiableMap(properties);
        this.serviceProvider = serviceProvider;
        this.stateManager = stateManager;
        this.variableRegistry = variableRegistry;
        this.preparedQueries = new HashMap<PropertyDescriptor, PreparedQuery>();
        for (Map.Entry<PropertyDescriptor, String> entry : properties.entrySet()) {
            PropertyDescriptor desc = entry.getKey();
            String value = entry.getValue();
            if (value == null) {
                value = desc.getDefaultValue();
            }
            PreparedQuery pq = Query.prepare((String)value);
            this.preparedQueries.put(desc, pq);
        }
    }

    public EventAccess getEventAccess() {
        return this.eventAccess;
    }

    public BulletinRepository getBulletinRepository() {
        return this.bulletinRepository;
    }

    public Bulletin createBulletin(String category, Severity severity, String message) {
        return BulletinFactory.createBulletin((String)category, (String)severity.name(), (String)message);
    }

    public Bulletin createBulletin(String componentId, String category, Severity severity, String message) {
        ProcessGroupStatus rootGroupStatus = this.eventAccess.getControllerStatus();
        String groupId = this.findGroupId(rootGroupStatus, componentId);
        String componentName = this.findComponentName(rootGroupStatus, componentId);
        ComponentType componentType = this.findComponentType(rootGroupStatus, componentId);
        return BulletinFactory.createBulletin((String)groupId, (String)componentId, (ComponentType)componentType, (String)componentName, (String)category, (String)severity.name(), (String)message);
    }

    public Map<PropertyDescriptor, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public PropertyValue getProperty(PropertyDescriptor property) {
        String configuredValue = this.properties.get(property);
        return new StandardPropertyValue(configuredValue == null ? property.getDefaultValue() : configuredValue, (ControllerServiceLookup)this.serviceProvider, this.preparedQueries.get(property), this.variableRegistry);
    }

    public ControllerServiceLookup getControllerServiceLookup() {
        return this.serviceProvider;
    }

    String findGroupId(ProcessGroupStatus groupStatus, String componentId) {
        for (ProcessorStatus procStatus : groupStatus.getProcessorStatus()) {
            if (!procStatus.getId().equals(componentId)) continue;
            return groupStatus.getId();
        }
        for (PortStatus portStatus : groupStatus.getInputPortStatus()) {
            if (!portStatus.getId().equals(componentId)) continue;
            return groupStatus.getId();
        }
        for (PortStatus portStatus : groupStatus.getOutputPortStatus()) {
            if (!portStatus.getId().equals(componentId)) continue;
            return groupStatus.getId();
        }
        for (ProcessGroupStatus childGroup : groupStatus.getProcessGroupStatus()) {
            String groupId = this.findGroupId(childGroup, componentId);
            if (groupId == null) continue;
            return groupId;
        }
        return null;
    }

    private ComponentType findComponentType(ProcessGroupStatus groupStatus, String componentId) {
        for (ProcessorStatus procStatus : groupStatus.getProcessorStatus()) {
            if (!procStatus.getId().equals(componentId)) continue;
            return ComponentType.PROCESSOR;
        }
        for (PortStatus portStatus : groupStatus.getInputPortStatus()) {
            if (!portStatus.getId().equals(componentId)) continue;
            return ComponentType.INPUT_PORT;
        }
        for (PortStatus portStatus : groupStatus.getOutputPortStatus()) {
            if (!portStatus.getId().equals(componentId)) continue;
            return ComponentType.OUTPUT_PORT;
        }
        for (RemoteProcessGroupStatus remoteStatus : groupStatus.getRemoteProcessGroupStatus()) {
            if (!remoteStatus.getId().equals(componentId)) continue;
            return ComponentType.REMOTE_PROCESS_GROUP;
        }
        for (ProcessGroupStatus childGroup : groupStatus.getProcessGroupStatus()) {
            ComponentType type = this.findComponentType(childGroup, componentId);
            if (type == null) continue;
            return type;
        }
        ControllerService service = this.serviceProvider.getControllerService(componentId);
        if (service != null) {
            return ComponentType.CONTROLLER_SERVICE;
        }
        return null;
    }

    private String findComponentName(ProcessGroupStatus groupStatus, String componentId) {
        for (ProcessorStatus procStatus : groupStatus.getProcessorStatus()) {
            if (!procStatus.getId().equals(componentId)) continue;
            return procStatus.getName();
        }
        for (PortStatus portStatus : groupStatus.getInputPortStatus()) {
            if (!portStatus.getId().equals(componentId)) continue;
            return groupStatus.getName();
        }
        for (PortStatus portStatus : groupStatus.getOutputPortStatus()) {
            if (!portStatus.getId().equals(componentId)) continue;
            return groupStatus.getName();
        }
        for (ProcessGroupStatus childGroup : groupStatus.getProcessGroupStatus()) {
            String componentName = this.findComponentName(childGroup, componentId);
            if (componentName == null) continue;
            return componentName;
        }
        return null;
    }

    public StateManager getStateManager() {
        return this.stateManager;
    }
}

