/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination.heartbeat;

import org.apache.nifi.cluster.coordination.heartbeat.NodeHeartbeat;
import org.apache.nifi.cluster.coordination.node.NodeConnectionStatus;
import org.apache.nifi.cluster.protocol.Heartbeat;
import org.apache.nifi.cluster.protocol.HeartbeatPayload;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.cluster.protocol.message.HeartbeatMessage;

public class StandardNodeHeartbeat
implements NodeHeartbeat {
    private final NodeIdentifier nodeId;
    private final long timestamp;
    private final NodeConnectionStatus connectionStatus;
    private final int flowFileCount;
    private final long flowFileBytes;
    private final int activeThreadCount;
    private final long systemStartTime;

    public StandardNodeHeartbeat(NodeIdentifier nodeId, long timestamp, NodeConnectionStatus connectionStatus, int flowFileCount, long flowFileBytes, int activeThreadCount, long systemStartTime) {
        this.timestamp = timestamp;
        this.nodeId = nodeId;
        this.connectionStatus = connectionStatus;
        this.flowFileCount = flowFileCount;
        this.flowFileBytes = flowFileBytes;
        this.activeThreadCount = activeThreadCount;
        this.systemStartTime = systemStartTime;
    }

    public NodeIdentifier getNodeIdentifier() {
        return this.nodeId;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public NodeConnectionStatus getConnectionStatus() {
        return this.connectionStatus;
    }

    public int getFlowFileCount() {
        return this.flowFileCount;
    }

    public long getFlowFileBytes() {
        return this.flowFileBytes;
    }

    public int getActiveThreadCount() {
        return this.activeThreadCount;
    }

    public long getSystemStartTime() {
        return this.systemStartTime;
    }

    public static StandardNodeHeartbeat fromHeartbeatMessage(HeartbeatMessage message, long timestamp) {
        Heartbeat heartbeat = message.getHeartbeat();
        HeartbeatPayload payload = HeartbeatPayload.unmarshal((byte[])heartbeat.getPayload());
        return new StandardNodeHeartbeat(heartbeat.getNodeIdentifier(), timestamp, heartbeat.getConnectionStatus(), (int)payload.getTotalFlowFileCount(), payload.getTotalFlowFileBytes(), payload.getActiveThreadCount(), payload.getSystemStartTime());
    }
}

