/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.manager;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.cluster.manager.ComponentEntityMerger;
import org.apache.nifi.cluster.manager.ComponentEntityStatusMerger;
import org.apache.nifi.cluster.manager.ErrorMerger;
import org.apache.nifi.cluster.manager.PropertyDescriptorDtoMerger;
import org.apache.nifi.cluster.manager.StatusMerger;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.web.api.dto.ProcessorDTO;
import org.apache.nifi.web.api.dto.PropertyDescriptorDTO;
import org.apache.nifi.web.api.dto.status.ProcessorStatusDTO;
import org.apache.nifi.web.api.entity.ProcessorEntity;

public class ProcessorEntityMerger
implements ComponentEntityMerger<ProcessorEntity>,
ComponentEntityStatusMerger<ProcessorStatusDTO> {
    @Override
    public void merge(ProcessorEntity clientEntity, Map<NodeIdentifier, ProcessorEntity> entityMap) {
        ComponentEntityMerger.super.merge(clientEntity, entityMap);
        for (Map.Entry<NodeIdentifier, ProcessorEntity> entry : entityMap.entrySet()) {
            NodeIdentifier nodeId = entry.getKey();
            ProcessorEntity entityStatus = entry.getValue();
            if (entityStatus == clientEntity) continue;
            this.mergeStatus(clientEntity.getStatus(), (boolean)clientEntity.getPermissions().getCanRead(), entry.getValue().getStatus(), (boolean)entry.getValue().getPermissions().getCanRead(), entry.getKey());
        }
    }

    @Override
    public void mergeComponents(ProcessorEntity clientEntity, Map<NodeIdentifier, ProcessorEntity> entityMap) {
        ProcessorDTO clientDto = clientEntity.getComponent();
        HashMap<NodeIdentifier, ProcessorDTO> dtoMap = new HashMap<NodeIdentifier, ProcessorDTO>();
        for (Map.Entry<NodeIdentifier, ProcessorEntity> entry : entityMap.entrySet()) {
            ProcessorEntity nodeProcEntity = entry.getValue();
            ProcessorDTO nodeProcDto = nodeProcEntity.getComponent();
            dtoMap.put(entry.getKey(), nodeProcDto);
        }
        ProcessorEntityMerger.mergeDtos(clientDto, dtoMap);
    }

    @Override
    public void mergeStatus(ProcessorStatusDTO clientStatus, boolean clientStatusReadablePermission, ProcessorStatusDTO status, boolean statusReadablePermission, NodeIdentifier statusNodeIdentifier) {
        StatusMerger.merge(clientStatus, clientStatusReadablePermission, status, statusReadablePermission, statusNodeIdentifier.getId(), statusNodeIdentifier.getApiAddress(), (Integer)statusNodeIdentifier.getApiPort());
    }

    private static void mergeDtos(ProcessorDTO clientDto, Map<NodeIdentifier, ProcessorDTO> dtoMap) {
        if (clientDto == null) {
            return;
        }
        HashMap<String, Set<NodeIdentifier>> validationErrorMap = new HashMap<String, Set<NodeIdentifier>>();
        HashMap propertyDescriptorMap = new HashMap();
        for (Map.Entry<NodeIdentifier, ProcessorDTO> nodeEntry : dtoMap.entrySet()) {
            ProcessorDTO nodeProcessor = nodeEntry.getValue();
            if (nodeProcessor == null) continue;
            NodeIdentifier nodeId = nodeEntry.getKey();
            ErrorMerger.mergeErrors(validationErrorMap, nodeId, nodeProcessor.getValidationErrors());
            nodeProcessor.getConfig().getDescriptors().values().stream().forEach(propertyDescriptor -> propertyDescriptorMap.computeIfAbsent(propertyDescriptor.getName(), nodeIdToPropertyDescriptor -> new HashMap()).put(nodeId, propertyDescriptor));
        }
        for (Map propertyDescriptorByNodeId : propertyDescriptorMap.values()) {
            Collection nodePropertyDescriptors = propertyDescriptorByNodeId.values();
            if (nodePropertyDescriptors.isEmpty()) continue;
            PropertyDescriptorDTO propertyDescriptor2 = (PropertyDescriptorDTO)nodePropertyDescriptors.iterator().next();
            PropertyDescriptorDTO clientPropertyDescriptor = (PropertyDescriptorDTO)clientDto.getConfig().getDescriptors().get(propertyDescriptor2.getName());
            PropertyDescriptorDtoMerger.merge(clientPropertyDescriptor, propertyDescriptorByNodeId);
        }
        clientDto.setValidationErrors(ErrorMerger.normalizedMergedErrors(validationErrorMap, dtoMap.size()));
    }
}

