/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination.http.endpoints;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.nifi.cluster.coordination.http.endpoints.AbstractSingleDTOEndpoint;
import org.apache.nifi.cluster.manager.ConnectionsEntityMerger;
import org.apache.nifi.cluster.manager.FunnelsEntityMerger;
import org.apache.nifi.cluster.manager.LabelsEntityMerger;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.cluster.manager.PortsEntityMerger;
import org.apache.nifi.cluster.manager.ProcessGroupsEntityMerger;
import org.apache.nifi.cluster.manager.ProcessorsEntityMerger;
import org.apache.nifi.cluster.manager.RemoteProcessGroupsEntityMerger;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.web.api.dto.flow.FlowDTO;
import org.apache.nifi.web.api.dto.flow.ProcessGroupFlowDTO;
import org.apache.nifi.web.api.entity.ConnectionEntity;
import org.apache.nifi.web.api.entity.FunnelEntity;
import org.apache.nifi.web.api.entity.LabelEntity;
import org.apache.nifi.web.api.entity.PortEntity;
import org.apache.nifi.web.api.entity.ProcessGroupEntity;
import org.apache.nifi.web.api.entity.ProcessGroupFlowEntity;
import org.apache.nifi.web.api.entity.ProcessorEntity;
import org.apache.nifi.web.api.entity.RemoteProcessGroupEntity;

public class FlowMerger
extends AbstractSingleDTOEndpoint<ProcessGroupFlowEntity, ProcessGroupFlowDTO> {
    public static final Pattern FLOW_URI_PATTERN = Pattern.compile("/nifi-api/flow/process-groups/(?:(?:root)|(?:[a-f0-9\\-]{36}))");

    @Override
    public boolean canHandle(URI uri, String method) {
        return "GET".equalsIgnoreCase(method) && FLOW_URI_PATTERN.matcher(uri.getPath()).matches();
    }

    @Override
    protected Class<ProcessGroupFlowEntity> getEntityClass() {
        return ProcessGroupFlowEntity.class;
    }

    @Override
    protected ProcessGroupFlowDTO getDto(ProcessGroupFlowEntity entity) {
        return entity.getProcessGroupFlow();
    }

    @Override
    protected void mergeResponses(ProcessGroupFlowDTO clientDto, Map<NodeIdentifier, ProcessGroupFlowDTO> dtoMap, Set<NodeResponse> successfulResponses, Set<NodeResponse> problematicResponses) {
        FlowDTO flowDto = clientDto.getFlow();
        Set clientConnections = flowDto.getConnections();
        Set clientProcessors = flowDto.getProcessors();
        Set clientInputPorts = flowDto.getInputPorts();
        Set clientOutputPorts = flowDto.getOutputPorts();
        Set clientRemoteProcessGroups = flowDto.getRemoteProcessGroups();
        Set clientProcessGroups = flowDto.getProcessGroups();
        Set clientLabels = flowDto.getLabels();
        Set clientFunnels = flowDto.getFunnels();
        HashMap<String, Map<NodeIdentifier, ConnectionEntity>> connections = new HashMap<String, Map<NodeIdentifier, ConnectionEntity>>();
        HashMap<String, Map<NodeIdentifier, FunnelEntity>> funnels = new HashMap<String, Map<NodeIdentifier, FunnelEntity>>();
        HashMap<String, Map<NodeIdentifier, PortEntity>> inputPorts = new HashMap<String, Map<NodeIdentifier, PortEntity>>();
        HashMap<String, Map<NodeIdentifier, LabelEntity>> labels = new HashMap<String, Map<NodeIdentifier, LabelEntity>>();
        HashMap<String, Map<NodeIdentifier, PortEntity>> outputPorts = new HashMap<String, Map<NodeIdentifier, PortEntity>>();
        HashMap<String, Map<NodeIdentifier, ProcessorEntity>> processors = new HashMap<String, Map<NodeIdentifier, ProcessorEntity>>();
        HashMap<String, Map<NodeIdentifier, RemoteProcessGroupEntity>> rpgs = new HashMap<String, Map<NodeIdentifier, RemoteProcessGroupEntity>>();
        HashMap<String, Map<NodeIdentifier, ProcessGroupEntity>> processGroups = new HashMap<String, Map<NodeIdentifier, ProcessGroupEntity>>();
        for (Map.Entry<NodeIdentifier, ProcessGroupFlowDTO> nodeGroupFlowEntry : dtoMap.entrySet()) {
            NodeIdentifier nodeIdentifier = nodeGroupFlowEntry.getKey();
            ProcessGroupFlowDTO nodeGroupFlowDto = nodeGroupFlowEntry.getValue();
            FlowDTO nodeFlowDto = nodeGroupFlowDto.getFlow();
            for (ConnectionEntity entity : nodeFlowDto.getConnections()) {
                connections.computeIfAbsent(entity.getId(), id -> new HashMap()).computeIfAbsent(nodeIdentifier, nodeId -> entity);
            }
            for (ConnectionEntity entity : nodeFlowDto.getFunnels()) {
                funnels.computeIfAbsent(entity.getId(), id -> new HashMap()).computeIfAbsent(nodeIdentifier, arg_0 -> FlowMerger.lambda$mergeResponses$3((FunnelEntity)entity, arg_0));
            }
            for (ConnectionEntity entity : nodeFlowDto.getInputPorts()) {
                inputPorts.computeIfAbsent(entity.getId(), id -> new HashMap()).computeIfAbsent(nodeIdentifier, arg_0 -> FlowMerger.lambda$mergeResponses$5((PortEntity)entity, arg_0));
            }
            for (ConnectionEntity entity : nodeFlowDto.getOutputPorts()) {
                outputPorts.computeIfAbsent(entity.getId(), id -> new HashMap()).computeIfAbsent(nodeIdentifier, arg_0 -> FlowMerger.lambda$mergeResponses$7((PortEntity)entity, arg_0));
            }
            for (ConnectionEntity entity : nodeFlowDto.getLabels()) {
                labels.computeIfAbsent(entity.getId(), id -> new HashMap()).computeIfAbsent(nodeIdentifier, arg_0 -> FlowMerger.lambda$mergeResponses$9((LabelEntity)entity, arg_0));
            }
            for (ConnectionEntity entity : nodeFlowDto.getProcessors()) {
                processors.computeIfAbsent(entity.getId(), id -> new HashMap()).computeIfAbsent(nodeIdentifier, arg_0 -> FlowMerger.lambda$mergeResponses$11((ProcessorEntity)entity, arg_0));
            }
            for (ConnectionEntity entity : nodeFlowDto.getRemoteProcessGroups()) {
                rpgs.computeIfAbsent(entity.getId(), id -> new HashMap()).computeIfAbsent(nodeIdentifier, arg_0 -> FlowMerger.lambda$mergeResponses$13((RemoteProcessGroupEntity)entity, arg_0));
            }
            for (ConnectionEntity entity : nodeFlowDto.getProcessGroups()) {
                processGroups.computeIfAbsent(entity.getId(), id -> new HashMap()).computeIfAbsent(nodeIdentifier, arg_0 -> FlowMerger.lambda$mergeResponses$15((ProcessGroupEntity)entity, arg_0));
            }
        }
        ConnectionsEntityMerger.mergeConnections(clientConnections, connections);
        FunnelsEntityMerger.mergeFunnels(clientFunnels, funnels);
        PortsEntityMerger.mergePorts(clientInputPorts, inputPorts);
        PortsEntityMerger.mergePorts(clientOutputPorts, outputPorts);
        LabelsEntityMerger.mergeLabels(clientLabels, labels);
        ProcessorsEntityMerger.mergeProcessors(clientProcessors, processors);
        RemoteProcessGroupsEntityMerger.mergeRemoteProcessGroups(clientRemoteProcessGroups, rpgs);
        ProcessGroupsEntityMerger.mergeProcessGroups(clientProcessGroups, processGroups);
    }

    private static /* synthetic */ ProcessGroupEntity lambda$mergeResponses$15(ProcessGroupEntity entity, NodeIdentifier nodeId) {
        return entity;
    }

    private static /* synthetic */ RemoteProcessGroupEntity lambda$mergeResponses$13(RemoteProcessGroupEntity entity, NodeIdentifier nodeId) {
        return entity;
    }

    private static /* synthetic */ ProcessorEntity lambda$mergeResponses$11(ProcessorEntity entity, NodeIdentifier nodeId) {
        return entity;
    }

    private static /* synthetic */ LabelEntity lambda$mergeResponses$9(LabelEntity entity, NodeIdentifier nodeId) {
        return entity;
    }

    private static /* synthetic */ PortEntity lambda$mergeResponses$7(PortEntity entity, NodeIdentifier nodeId) {
        return entity;
    }

    private static /* synthetic */ PortEntity lambda$mergeResponses$5(PortEntity entity, NodeIdentifier nodeId) {
        return entity;
    }

    private static /* synthetic */ FunnelEntity lambda$mergeResponses$3(FunnelEntity entity, NodeIdentifier nodeId) {
        return entity;
    }
}

