/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination.http.endpoints;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.nifi.cluster.coordination.http.EndpointResponseMerger;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.cluster.manager.PortsEntityMerger;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.web.api.entity.Entity;
import org.apache.nifi.web.api.entity.OutputPortsEntity;
import org.apache.nifi.web.api.entity.PortEntity;

public class OutputPortsEndpointMerger
implements EndpointResponseMerger {
    public static final Pattern OUTPUT_PORTS_URI_PATTERN = Pattern.compile("/nifi-api/process-groups/(?:(?:root)|(?:[a-f0-9\\-]{36}))/output-ports");

    @Override
    public boolean canHandle(URI uri, String method) {
        return "GET".equalsIgnoreCase(method) && OUTPUT_PORTS_URI_PATTERN.matcher(uri.getPath()).matches();
    }

    @Override
    public final NodeResponse merge(URI uri, String method, Set<NodeResponse> successfulResponses, Set<NodeResponse> problematicResponses, NodeResponse clientResponse) {
        if (!this.canHandle(uri, method)) {
            throw new IllegalArgumentException("Cannot use Endpoint Mapper of type " + this.getClass().getSimpleName() + " to map responses for URI " + uri + ", HTTP Method " + method);
        }
        OutputPortsEntity responseEntity = (OutputPortsEntity)clientResponse.getClientResponse().readEntity(OutputPortsEntity.class);
        Set portEntities = responseEntity.getOutputPorts();
        HashMap<String, Map<NodeIdentifier, PortEntity>> entityMap = new HashMap<String, Map<NodeIdentifier, PortEntity>>();
        for (NodeResponse nodeResponse : successfulResponses) {
            OutputPortsEntity nodeResponseEntity = nodeResponse == clientResponse ? responseEntity : (OutputPortsEntity)nodeResponse.getClientResponse().readEntity(OutputPortsEntity.class);
            Set nodePortEntities = nodeResponseEntity.getOutputPorts();
            for (PortEntity nodePortEntity : nodePortEntities) {
                NodeIdentifier nodeId = nodeResponse.getNodeId();
                HashMap<NodeIdentifier, PortEntity> innerMap = (HashMap<NodeIdentifier, PortEntity>)entityMap.get(nodeId);
                if (innerMap == null) {
                    innerMap = new HashMap<NodeIdentifier, PortEntity>();
                    entityMap.put(nodePortEntity.getId(), innerMap);
                }
                innerMap.put(nodeResponse.getNodeId(), nodePortEntity);
            }
        }
        PortsEntityMerger.mergePorts(portEntities, entityMap);
        return new NodeResponse(clientResponse, (Entity)responseEntity);
    }
}

