/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination.http.endpoints;

import java.net.URI;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.nifi.cluster.coordination.http.endpoints.AbstractSingleDTOEndpoint;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.cluster.manager.StatusMerger;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.web.api.dto.status.ControllerStatusDTO;
import org.apache.nifi.web.api.entity.ControllerStatusEntity;

public class ControllerStatusEndpointMerger
extends AbstractSingleDTOEndpoint<ControllerStatusEntity, ControllerStatusDTO> {
    public static final Pattern CONTROLLER_STATUS_URI_PATTERN = Pattern.compile("/nifi-api/flow/status");

    @Override
    public boolean canHandle(URI uri, String method) {
        return "GET".equalsIgnoreCase(method) && CONTROLLER_STATUS_URI_PATTERN.matcher(uri.getPath()).matches();
    }

    @Override
    protected Class<ControllerStatusEntity> getEntityClass() {
        return ControllerStatusEntity.class;
    }

    @Override
    protected ControllerStatusDTO getDto(ControllerStatusEntity entity) {
        return entity.getControllerStatus();
    }

    @Override
    protected void mergeResponses(ControllerStatusDTO clientDto, Map<NodeIdentifier, ControllerStatusDTO> dtoMap, Set<NodeResponse> successfulResponses, Set<NodeResponse> problematicResponses) {
        ControllerStatusDTO mergedStatus = clientDto;
        for (Map.Entry<NodeIdentifier, ControllerStatusDTO> entry : dtoMap.entrySet()) {
            ControllerStatusDTO nodeStatus = entry.getValue();
            if (nodeStatus == mergedStatus) continue;
            StatusMerger.merge(mergedStatus, nodeStatus);
        }
    }
}

