/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.manager;

import com.sun.jersey.api.client.ClientResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.stream.io.StreamUtils;
import org.apache.nifi.web.api.entity.Entity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeResponse {
    private static final Logger logger = LoggerFactory.getLogger(NodeResponse.class);
    private final String httpMethod;
    private final URI requestUri;
    private final ClientResponse clientResponse;
    private final NodeIdentifier nodeId;
    private Throwable throwable;
    private boolean hasCreatedResponse = false;
    private final Entity updatedEntity;
    private final long requestDurationNanos;
    private final String requestId;
    private byte[] bufferedResponse;

    public NodeResponse(NodeIdentifier nodeId, String httpMethod, URI requestUri, ClientResponse clientResponse, long requestDurationNanos, String requestId) {
        if (nodeId == null) {
            throw new IllegalArgumentException("Node identifier may not be null.");
        }
        if (StringUtils.isBlank((CharSequence)httpMethod)) {
            throw new IllegalArgumentException("Http method may not be null or empty.");
        }
        if (requestUri == null) {
            throw new IllegalArgumentException("Request URI may not be null.");
        }
        if (clientResponse == null) {
            throw new IllegalArgumentException("ClientResponse may not be null.");
        }
        this.nodeId = nodeId;
        this.httpMethod = httpMethod;
        this.requestUri = requestUri;
        this.clientResponse = clientResponse;
        this.throwable = null;
        this.updatedEntity = null;
        this.requestDurationNanos = requestDurationNanos;
        this.requestId = requestId;
    }

    public NodeResponse(NodeIdentifier nodeId, String httpMethod, URI requestUri, Throwable throwable) {
        if (nodeId == null) {
            throw new IllegalArgumentException("Node identifier may not be null.");
        }
        if (StringUtils.isBlank((CharSequence)httpMethod)) {
            throw new IllegalArgumentException("Http method may not be null or empty.");
        }
        if (requestUri == null) {
            throw new IllegalArgumentException("Request URI may not be null.");
        }
        if (throwable == null) {
            throw new IllegalArgumentException("Throwable may not be null.");
        }
        this.nodeId = nodeId;
        this.httpMethod = httpMethod;
        this.requestUri = requestUri;
        this.clientResponse = null;
        this.throwable = throwable;
        this.updatedEntity = null;
        this.requestDurationNanos = -1L;
        this.requestId = null;
    }

    public NodeResponse(NodeResponse example, Entity updatedEntity) {
        Objects.requireNonNull(example, "NodeResponse cannot be null");
        Objects.requireNonNull(updatedEntity, "UpdatedEntity cannot be null");
        this.nodeId = example.nodeId;
        this.httpMethod = example.httpMethod;
        this.requestUri = example.requestUri;
        this.clientResponse = example.clientResponse;
        this.throwable = example.throwable;
        this.updatedEntity = updatedEntity;
        this.requestDurationNanos = example.requestDurationNanos;
        this.requestId = null;
    }

    public NodeIdentifier getNodeId() {
        return this.nodeId;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public URI getRequestUri() {
        return this.requestUri;
    }

    public int getStatus() {
        if (this.hasThrowable()) {
            return this.getResponse().getStatus();
        }
        return this.clientResponse.getStatus();
    }

    public boolean is2xx() {
        int statusCode = this.getStatus();
        return 200 <= statusCode && statusCode <= 299;
    }

    public boolean is5xx() {
        int statusCode = this.getStatus();
        return 500 <= statusCode && statusCode <= 599;
    }

    public synchronized void bufferResponse() {
        this.bufferedResponse = new byte[this.clientResponse.getLength()];
        try {
            StreamUtils.fillBuffer((InputStream)this.clientResponse.getEntityInputStream(), (byte[])this.bufferedResponse);
        }
        catch (IOException e) {
            this.throwable = e;
        }
    }

    private synchronized InputStream getInputStream() {
        if (this.bufferedResponse == null) {
            return this.clientResponse.getEntityInputStream();
        }
        return new ByteArrayInputStream(this.bufferedResponse);
    }

    public ClientResponse getClientResponse() {
        return this.clientResponse;
    }

    public Entity getUpdatedEntity() {
        return this.updatedEntity;
    }

    public Response getResponse() {
        if (this.hasCreatedResponse && !this.hasThrowable()) {
            logger.warn("ClientResponse's input stream has already been read.  The created response will not contain this data.");
        }
        this.hasCreatedResponse = true;
        return this.createResponse();
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public boolean hasThrowable() {
        return this.getThrowable() != null;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NodeResponse other = (NodeResponse)obj;
        return this.nodeId == other.nodeId || this.nodeId != null && this.nodeId.equals((Object)other.nodeId);
    }

    public int hashCode() {
        int hash = 7;
        hash = 13 * hash + (this.nodeId != null ? this.nodeId.hashCode() : 0);
        return hash;
    }

    public long getRequestDuration(TimeUnit timeUnit) {
        return timeUnit.convert(this.requestDurationNanos, TimeUnit.NANOSECONDS);
    }

    public String getRequestId() {
        return this.requestId;
    }

    private Response createResponse() {
        if (this.hasThrowable()) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.getThrowable().toString()).build();
        }
        Response.ResponseBuilder responseBuilder = Response.status((int)this.clientResponse.getStatus());
        for (String key : this.clientResponse.getHeaders().keySet()) {
            List values = (List)this.clientResponse.getHeaders().get((Object)key);
            for (String value : values) {
                if (key.equalsIgnoreCase("transfer-encoding") || key.equalsIgnoreCase("content-length") || key.equals("X-ClusterContext")) continue;
                responseBuilder.header(key, (Object)value);
            }
        }
        if (!"HEAD".equalsIgnoreCase(this.httpMethod)) {
            if (this.updatedEntity == null) {
                responseBuilder.entity((Object)new StreamingOutput(){

                    public void write(OutputStream output) throws IOException, WebApplicationException {
                        IOUtils.copy((InputStream)NodeResponse.this.getInputStream(), (OutputStream)output);
                    }
                });
            } else {
                responseBuilder.entity((Object)this.updatedEntity);
            }
        }
        return responseBuilder.build();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("NodeResponse[nodeUri=").append(this.nodeId.getApiAddress()).append(":").append(this.nodeId.getApiPort()).append(",").append("method=").append(this.httpMethod).append(",URI=").append(this.requestUri).append(",ResponseCode=").append(this.getStatus()).append(",Duration=").append(TimeUnit.MILLISECONDS.convert(this.requestDurationNanos, TimeUnit.NANOSECONDS)).append(" ms]");
        return sb.toString();
    }
}

