/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.manager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.nifi.cluster.manager.BulletinMerger;
import org.apache.nifi.cluster.manager.PermissionsDtoMerger;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.web.api.entity.BulletinEntity;
import org.apache.nifi.web.api.entity.ComponentEntity;
import org.apache.nifi.web.api.entity.Permissible;

public interface ComponentEntityMerger<EntityType extends ComponentEntity> {
    default public void merge(EntityType clientEntity, Map<NodeIdentifier, EntityType> entityMap) {
        for (Map.Entry<NodeIdentifier, EntityType> entry : entityMap.entrySet()) {
            ComponentEntity entity = (ComponentEntity)entry.getValue();
            PermissionsDtoMerger.mergePermissions(clientEntity.getPermissions(), entity.getPermissions());
        }
        if (clientEntity.getPermissions().getCanRead().booleanValue()) {
            HashMap<NodeIdentifier, List<BulletinEntity>> bulletinEntities = new HashMap<NodeIdentifier, List<BulletinEntity>>();
            for (Map.Entry<NodeIdentifier, EntityType> entry : entityMap.entrySet()) {
                NodeIdentifier nodeIdentifier = entry.getKey();
                ComponentEntity entity = (ComponentEntity)entry.getValue();
                if (entity.getBulletins() == null) continue;
                entity.getBulletins().forEach(bulletin -> bulletinEntities.computeIfAbsent(nodeIdentifier, nodeId -> new ArrayList()).add(bulletin));
            }
            clientEntity.setBulletins(BulletinMerger.mergeBulletins(bulletinEntities, entityMap.size()));
            Collections.sort(clientEntity.getBulletins(), BulletinMerger.BULLETIN_COMPARATOR);
            if (clientEntity.getBulletins().size() > 5) {
                clientEntity.setBulletins(clientEntity.getBulletins().subList(0, 5));
            }
            this.mergeComponents(clientEntity, entityMap);
        } else {
            clientEntity.setBulletins(null);
            ((Permissible)clientEntity).setComponent(null);
        }
    }

    default public void mergeComponents(EntityType clientEntity, Map<NodeIdentifier, EntityType> entityMap) {
    }
}

