/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.manager;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.nifi.cluster.manager.ComponentEntityMerger;
import org.apache.nifi.cluster.manager.PermissionsDtoMerger;
import org.apache.nifi.cluster.manager.StatusMerger;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.web.api.dto.diagnostics.ControllerServiceDiagnosticsDTO;
import org.apache.nifi.web.api.dto.diagnostics.JVMDiagnosticsSnapshotDTO;
import org.apache.nifi.web.api.dto.diagnostics.NodeJVMDiagnosticsSnapshotDTO;
import org.apache.nifi.web.api.dto.diagnostics.ProcessorDiagnosticsDTO;
import org.apache.nifi.web.api.dto.diagnostics.ThreadDumpDTO;
import org.apache.nifi.web.api.entity.ComponentEntity;
import org.apache.nifi.web.api.entity.ControllerServiceEntity;
import org.apache.nifi.web.api.entity.ProcessorDiagnosticsEntity;

public class ProcessorDiagnosticsEntityMerger
implements ComponentEntityMerger<ProcessorDiagnosticsEntity> {
    private final long componentStatusSnapshotMillis;

    public ProcessorDiagnosticsEntityMerger(long componentStatusSnapshotMillis) {
        this.componentStatusSnapshotMillis = componentStatusSnapshotMillis;
    }

    @Override
    public void mergeComponents(ProcessorDiagnosticsEntity clientEntity, Map<NodeIdentifier, ProcessorDiagnosticsEntity> entityMap) {
        ProcessorDiagnosticsDTO clientDto = clientEntity.getComponent();
        ArrayList<NodeJVMDiagnosticsSnapshotDTO> nodeJvmDiagnosticsSnapshots = new ArrayList<NodeJVMDiagnosticsSnapshotDTO>(entityMap.size());
        for (Map.Entry<NodeIdentifier, ProcessorDiagnosticsEntity> entry : entityMap.entrySet()) {
            NodeIdentifier nodeIdentifier = entry.getKey();
            ProcessorDiagnosticsEntity diagnosticsEntity = entry.getValue();
            ProcessorDiagnosticsDTO diagnosticsDto2 = diagnosticsEntity.getComponent();
            StatusMerger.merge(clientDto.getProcessorStatus(), (boolean)clientEntity.getPermissions().getCanRead(), diagnosticsDto2.getProcessorStatus(), (boolean)diagnosticsEntity.getPermissions().getCanRead(), nodeIdentifier.getId(), nodeIdentifier.getApiAddress(), (Integer)nodeIdentifier.getApiPort());
            NodeJVMDiagnosticsSnapshotDTO nodeJvmDiagnosticsSnapshot = new NodeJVMDiagnosticsSnapshotDTO();
            nodeJvmDiagnosticsSnapshot.setAddress(nodeIdentifier.getApiAddress());
            nodeJvmDiagnosticsSnapshot.setApiPort(Integer.valueOf(nodeIdentifier.getApiPort()));
            nodeJvmDiagnosticsSnapshot.setNodeId(nodeIdentifier.getId());
            nodeJvmDiagnosticsSnapshot.setSnapshot(diagnosticsDto2.getJvmDiagnostics().getAggregateSnapshot());
            nodeJvmDiagnosticsSnapshots.add(nodeJvmDiagnosticsSnapshot);
        }
        clientDto.getJvmDiagnostics().setNodeSnapshots(nodeJvmDiagnosticsSnapshots);
        JVMDiagnosticsSnapshotDTO mergedJvmDiagnosticsSnapshot = clientDto.getJvmDiagnostics().getAggregateSnapshot().clone();
        for (Map.Entry<NodeIdentifier, ProcessorDiagnosticsEntity> entry : entityMap.entrySet()) {
            NodeIdentifier nodeId = entry.getKey();
            ProcessorDiagnosticsEntity diagnosticsEntity = entry.getValue();
            if (diagnosticsEntity == clientEntity) {
                for (ThreadDumpDTO threadDump : clientDto.getThreadDumps()) {
                    threadDump.setNodeAddress(nodeId.getApiAddress());
                    threadDump.setApiPort(Integer.valueOf(nodeId.getApiPort()));
                    threadDump.setNodeId(nodeId.getId());
                }
                continue;
            }
            ProcessorDiagnosticsDTO diagnosticsDto3 = diagnosticsEntity.getComponent();
            JVMDiagnosticsSnapshotDTO snapshot = diagnosticsDto3.getJvmDiagnostics().getAggregateSnapshot();
            StatusMerger.merge(mergedJvmDiagnosticsSnapshot, snapshot, this.componentStatusSnapshotMillis);
            List threadDumps = diagnosticsEntity.getComponent().getThreadDumps();
            for (ThreadDumpDTO threadDump : threadDumps) {
                threadDump.setNodeAddress(nodeId.getApiAddress());
                threadDump.setApiPort(Integer.valueOf(nodeId.getApiPort()));
                threadDump.setNodeId(nodeId.getId());
                clientDto.getThreadDumps().add(threadDump);
            }
        }
        clientDto.getJvmDiagnostics().setAggregateSnapshot(mergedJvmDiagnosticsSnapshot);
        Map map = clientDto.getReferencedControllerServices().stream().map(diagnosticsDto -> diagnosticsDto.getControllerService()).collect(Collectors.toMap(ComponentEntity::getId, Function.identity()));
        for (Map.Entry<NodeIdentifier, ProcessorDiagnosticsEntity> entry : entityMap.entrySet()) {
            ProcessorDiagnosticsEntity procDiagnostics = entry.getValue();
            Set serviceDtos = procDiagnostics.getComponent().getReferencedControllerServices();
            for (ControllerServiceDiagnosticsDTO serviceDto : serviceDtos) {
                ControllerServiceEntity serviceEntity = serviceDto.getControllerService();
                ControllerServiceEntity targetEntity = (ControllerServiceEntity)map.get(serviceEntity.getId());
                if (targetEntity == null) continue;
                PermissionsDtoMerger.mergePermissions(targetEntity.getPermissions(), serviceEntity.getPermissions());
            }
        }
    }
}

