/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.coordination.http.endpoints;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.nifi.cluster.coordination.http.EndpointResponseMerger;
import org.apache.nifi.cluster.manager.LabelsEntityMerger;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.web.api.entity.Entity;
import org.apache.nifi.web.api.entity.LabelEntity;
import org.apache.nifi.web.api.entity.LabelsEntity;

public class LabelsEndpointMerger
implements EndpointResponseMerger {
    public static final Pattern LABELS_URI_PATTERN = Pattern.compile("/nifi-api/process-groups/(?:(?:root)|(?:[a-f0-9\\-]{36}))/labels");

    @Override
    public boolean canHandle(URI uri, String method) {
        return "GET".equalsIgnoreCase(method) && LABELS_URI_PATTERN.matcher(uri.getPath()).matches();
    }

    @Override
    public NodeResponse merge(URI uri, String method, Set<NodeResponse> successfulResponses, Set<NodeResponse> problematicResponses, NodeResponse clientResponse) {
        if (!this.canHandle(uri, method)) {
            throw new IllegalArgumentException("Cannot use Endpoint Mapper of type " + this.getClass().getSimpleName() + " to map responses for URI " + uri + ", HTTP Method " + method);
        }
        LabelsEntity responseEntity = (LabelsEntity)clientResponse.getClientResponse().readEntity(LabelsEntity.class);
        Set labelEntities = responseEntity.getLabels();
        HashMap<String, Map<NodeIdentifier, LabelEntity>> entityMap = new HashMap<String, Map<NodeIdentifier, LabelEntity>>();
        for (NodeResponse nodeResponse : successfulResponses) {
            LabelsEntity nodeResponseEntity = nodeResponse == clientResponse ? responseEntity : (LabelsEntity)nodeResponse.getClientResponse().readEntity(LabelsEntity.class);
            Set nodeLabelEntities = nodeResponseEntity.getLabels();
            for (LabelEntity nodeLabelEntity : nodeLabelEntities) {
                String nodeLabelEntityId = nodeLabelEntity.getId();
                HashMap<NodeIdentifier, LabelEntity> innerMap = (HashMap<NodeIdentifier, LabelEntity>)entityMap.get(nodeLabelEntityId);
                if (innerMap == null) {
                    innerMap = new HashMap<NodeIdentifier, LabelEntity>();
                    entityMap.put(nodeLabelEntityId, innerMap);
                }
                innerMap.put(nodeResponse.getNodeId(), nodeLabelEntity);
            }
        }
        LabelsEntityMerger.mergeLabels(labelEntities, entityMap);
        return new NodeResponse(clientResponse, (Entity)responseEntity);
    }
}

