/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.gcp.storage;

import com.google.cloud.ReadChannel;
import com.google.cloud.storage.Acl;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageException;
import com.google.common.collect.ImmutableList;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.gcp.storage.AbstractGCSProcessor;
import org.apache.nifi.processors.gcp.storage.DeleteGCSObject;
import org.apache.nifi.processors.gcp.storage.ListGCSBucket;
import org.apache.nifi.processors.gcp.storage.PutGCSObject;
import org.apache.nifi.processors.gcp.storage.Util;

@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"google cloud", "google", "storage", "gcs", "fetch"})
@CapabilityDescription(value="Fetches a file from a Google Cloud Bucket. Designed to be used in tandem with ListGCSBucket.")
@SeeAlso(value={ListGCSBucket.class, PutGCSObject.class, DeleteGCSObject.class})
@WritesAttributes(value={@WritesAttribute(attribute="filename", description="The name of the file, parsed if possible from the Content-Disposition response header"), @WritesAttribute(attribute="gcs.bucket", description="Bucket of the object."), @WritesAttribute(attribute="gcs.key", description="Name of the object."), @WritesAttribute(attribute="gcs.size", description="Size of the object."), @WritesAttribute(attribute="gcs.cache.control", description="Data cache control of the object."), @WritesAttribute(attribute="gcs.component.count", description="The number of components which make up the object."), @WritesAttribute(attribute="gcs.content.disposition", description="The data content disposition of the object."), @WritesAttribute(attribute="gcs.content.encoding", description="The content encoding of the object."), @WritesAttribute(attribute="gcs.content.language", description="The content language of the object."), @WritesAttribute(attribute="mime.type", description="The MIME/Content-Type of the object"), @WritesAttribute(attribute="gcs.crc32c", description="The CRC32C checksum of object's data, encoded in base64 in big-endian order."), @WritesAttribute(attribute="gcs.create.time", description="The creation time of the object (milliseconds)"), @WritesAttribute(attribute="gcs.update.time", description="The last modification time of the object (milliseconds)"), @WritesAttribute(attribute="gcs.encryption.algorithm", description="The algorithm used to encrypt the object."), @WritesAttribute(attribute="gcs.encryption.sha256", description="The SHA256 hash of the key used to encrypt the object"), @WritesAttribute(attribute="gcs.etag", description="The HTTP 1.1 Entity tag for the object."), @WritesAttribute(attribute="gcs.generated.id", description="The service-generated for the object"), @WritesAttribute(attribute="gcs.generation", description="The data generation of the object."), @WritesAttribute(attribute="gcs.md5", description="The MD5 hash of the object's data encoded in base64."), @WritesAttribute(attribute="gcs.media.link", description="The media download link to the object."), @WritesAttribute(attribute="gcs.metageneration", description="The metageneration of the object."), @WritesAttribute(attribute="gcs.owner", description="The owner (uploader) of the object."), @WritesAttribute(attribute="gcs.owner.type", description="The ACL entity type of the uploader of the object."), @WritesAttribute(attribute="gcs.uri", description="The URI of the object as a string.")})
public class FetchGCSObject
extends AbstractGCSProcessor {
    public static final PropertyDescriptor BUCKET = new PropertyDescriptor.Builder().name("gcs-bucket").displayName("Bucket").description("Bucket of the object.").required(true).defaultValue("${gcs.bucket}").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor KEY = new PropertyDescriptor.Builder().name("gcs-key").displayName("Key").description("Name of the object.").required(true).defaultValue("${" + CoreAttributes.FILENAME.key() + "}").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor GENERATION = new PropertyDescriptor.Builder().name("gcs-generation").displayName("Object Generation").description("The generation of the Object to download. If null, will download latest generation.").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.POSITIVE_LONG_VALIDATOR).required(false).build();
    public static final PropertyDescriptor ENCRYPTION_KEY = new PropertyDescriptor.Builder().name("gcs-server-side-encryption-key").displayName("Server Side Encryption Key").description("An AES256 Key (encoded in base64) which the object has been encrypted in.").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).sensitive(true).build();

    @Override
    public List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return ImmutableList.builder().addAll(super.getSupportedPropertyDescriptors()).add((Object)BUCKET).add((Object)KEY).add((Object)GENERATION).add((Object)ENCRYPTION_KEY).build();
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        long startNanos = System.nanoTime();
        String bucketName = context.getProperty(BUCKET).evaluateAttributeExpressions(flowFile).getValue();
        String key = context.getProperty(KEY).evaluateAttributeExpressions(flowFile).getValue();
        Long generation = context.getProperty(GENERATION).evaluateAttributeExpressions(flowFile).asLong();
        String encryptionKey = context.getProperty(ENCRYPTION_KEY).evaluateAttributeExpressions(flowFile).getValue();
        Storage storage = (Storage)this.getCloudService();
        HashMap<String, String> attributes = new HashMap<String, String>();
        BlobId blobId = BlobId.of((String)bucketName, (String)key, (Long)generation);
        try {
            Blob blob;
            ArrayList<Storage.BlobSourceOption> blobSourceOptions = new ArrayList<Storage.BlobSourceOption>(2);
            if (encryptionKey != null) {
                blobSourceOptions.add(Storage.BlobSourceOption.decryptionKey((String)encryptionKey));
            }
            if (generation != null) {
                blobSourceOptions.add(Storage.BlobSourceOption.generationMatch());
            }
            if ((blob = storage.get(blobId)) == null) {
                throw new StorageException(404, "Blob " + blobId + " not found");
            }
            ReadChannel reader = storage.reader(blobId, blobSourceOptions.toArray(new Storage.BlobSourceOption[blobSourceOptions.size()]));
            flowFile = session.importFrom(Channels.newInputStream((ReadableByteChannel)reader), flowFile);
            attributes.put("gcs.bucket", blob.getBucket());
            attributes.put("gcs.key", blob.getName());
            if (blob.getSize() != null) {
                attributes.put("gcs.size", String.valueOf(blob.getSize()));
            }
            if (blob.getCacheControl() != null) {
                attributes.put("gcs.cache.control", blob.getCacheControl());
            }
            if (blob.getComponentCount() != null) {
                attributes.put("gcs.component.count", String.valueOf(blob.getComponentCount()));
            }
            if (blob.getContentEncoding() != null) {
                attributes.put("gcs.content.encoding", blob.getContentEncoding());
            }
            if (blob.getContentLanguage() != null) {
                attributes.put("gcs.content.language", blob.getContentLanguage());
            }
            if (blob.getContentType() != null) {
                attributes.put(CoreAttributes.MIME_TYPE.key(), blob.getContentType());
            }
            if (blob.getCrc32c() != null) {
                attributes.put("gcs.crc32c", blob.getCrc32c());
            }
            if (blob.getCustomerEncryption() != null) {
                BlobInfo.CustomerEncryption encryption = blob.getCustomerEncryption();
                attributes.put("gcs.encryption.algorithm", encryption.getEncryptionAlgorithm());
                attributes.put("gcs.encryption.sha256", encryption.getKeySha256());
            }
            if (blob.getEtag() != null) {
                attributes.put("gcs.etag", blob.getEtag());
            }
            if (blob.getGeneratedId() != null) {
                attributes.put("gcs.generated.id", blob.getGeneratedId());
            }
            if (blob.getGeneration() != null) {
                attributes.put("gcs.generation", String.valueOf(blob.getGeneration()));
            }
            if (blob.getMd5() != null) {
                attributes.put("gcs.md5", blob.getMd5());
            }
            if (blob.getMediaLink() != null) {
                attributes.put("gcs.media.link", blob.getMediaLink());
            }
            if (blob.getMetageneration() != null) {
                attributes.put("gcs.metageneration", String.valueOf(blob.getMetageneration()));
            }
            if (blob.getOwner() != null) {
                Acl.Entity entity = blob.getOwner();
                if (entity instanceof Acl.User) {
                    attributes.put("gcs.owner", ((Acl.User)entity).getEmail());
                    attributes.put("gcs.owner.type", "user");
                } else if (entity instanceof Acl.Group) {
                    attributes.put("gcs.owner", ((Acl.Group)entity).getEmail());
                    attributes.put("gcs.owner.type", "group");
                } else if (entity instanceof Acl.Domain) {
                    attributes.put("gcs.owner", ((Acl.Domain)entity).getDomain());
                    attributes.put("gcs.owner.type", "domain");
                } else if (entity instanceof Acl.Project) {
                    attributes.put("gcs.owner", ((Acl.Project)entity).getProjectId());
                    attributes.put("gcs.owner.type", "project");
                }
            }
            if (blob.getSelfLink() != null) {
                attributes.put("gcs.uri", blob.getSelfLink());
            }
            if (blob.getContentDisposition() != null) {
                attributes.put("gcs.content.disposition", blob.getContentDisposition());
                Util.ParsedContentDisposition parsedContentDisposition = Util.parseContentDisposition(blob.getContentDisposition());
                if (parsedContentDisposition != null) {
                    attributes.put(CoreAttributes.FILENAME.key(), parsedContentDisposition.getFileName());
                }
            }
            if (blob.getCreateTime() != null) {
                attributes.put("gcs.create.time", String.valueOf(blob.getCreateTime()));
            }
            if (blob.getUpdateTime() != null) {
                attributes.put("gcs.update.time", String.valueOf(blob.getUpdateTime()));
            }
        }
        catch (StorageException e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
            flowFile = session.penalize(flowFile);
            session.transfer(flowFile, REL_FAILURE);
            return;
        }
        if (!attributes.isEmpty()) {
            flowFile = session.putAllAttributes(flowFile, attributes);
        }
        session.transfer(flowFile, REL_SUCCESS);
        long millis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNanos);
        this.getLogger().info("Successfully retrieved GCS Object for {} in {} millis; routing to success", new Object[]{flowFile, millis});
        session.getProvenanceReporter().fetch(flowFile, "https://" + bucketName + ".storage.googleapis.com/" + key, millis);
    }
}

