/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.groovyx;

import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.behavior.EventDriven;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.Restricted;
import org.apache.nifi.annotation.behavior.Restriction;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.RequiredPermission;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.dbcp.DBCPService;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.groovyx.GroovyMethods;
import org.apache.nifi.processors.groovyx.flow.GroovyProcessSessionWrap;
import org.apache.nifi.processors.groovyx.sql.OSql;
import org.apache.nifi.processors.groovyx.util.Files;
import org.apache.nifi.processors.groovyx.util.Validators;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.runtime.ResourceGroovyMethods;
import org.codehaus.groovy.runtime.StackTraceUtils;

@EventDriven
@InputRequirement(value=InputRequirement.Requirement.INPUT_ALLOWED)
@Tags(value={"script", "groovy", "groovyx"})
@CapabilityDescription(value="Experimental Extended Groovy script processor. The script is responsible for handling the incoming flow file (transfer to SUCCESS or remove, e.g.) as well as any flow files created by the script. If the handling is incomplete or incorrect, the session will be rolled back.")
@Restricted(restrictions={@Restriction(requiredPermission=RequiredPermission.EXECUTE_CODE, explanation="Provides operator the ability to execute arbitrary code assuming all permissions that NiFi has.")})
@SeeAlso(classNames={"org.apache.nifi.processors.script.ExecuteScript"})
@DynamicProperty(name="A script engine property to update", value="The value to set it to", expressionLanguageScope=ExpressionLanguageScope.FLOWFILE_ATTRIBUTES, description="Updates a script engine property specified by the Dynamic Property's key with the value specified by the Dynamic Property's value. Use `CTL.` to access any controller services.")
public class ExecuteGroovyScript
extends AbstractProcessor {
    public static final String GROOVY_CLASSPATH = "${groovy.classes.path}";
    private static final String PRELOADS = "import org.apache.nifi.components.*;import org.apache.nifi.flowfile.FlowFile;import org.apache.nifi.processor.*;import org.apache.nifi.processor.FlowFileFilter.FlowFileFilterResult;import org.apache.nifi.processor.exception.*;import org.apache.nifi.processor.io.*;import org.apache.nifi.processor.util.*;import org.apache.nifi.processors.script.*;import org.apache.nifi.logging.ComponentLog;";
    public static final PropertyDescriptor SCRIPT_FILE = new PropertyDescriptor.Builder().name("groovyx-script-file").displayName("Script File").required(false).description("Path to script file to execute. Only one of Script File or Script Body may be used").addValidator(Validators.createFileExistsAndReadableValidator()).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    public static final PropertyDescriptor SCRIPT_BODY = new PropertyDescriptor.Builder().name("groovyx-script-body").displayName("Script Body").required(false).description("Body of script to execute. Only one of Script File or Script Body may be used").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.NONE).build();
    public static String[] VALID_FAIL_STRATEGY = new String[]{"rollback", "transfer to failure"};
    public static final PropertyDescriptor FAIL_STRATEGY = new PropertyDescriptor.Builder().name("groovyx-failure-strategy").displayName("Failure strategy").description("What to do with unhandled exceptions. If you want to manage exception by code then keep the default value `rollback`. If `transfer to failure` selected and unhandled exception occurred then all flowFiles received from incoming queues in this session will be transferred to `failure` relationship with additional attributes set: ERROR_MESSAGE and ERROR_STACKTRACE. If `rollback` selected and unhandled exception occurred then all flowFiles received from incoming queues will be penalized and returned. If the processor has no incoming connections then this parameter has no effect.").required(true).expressionLanguageSupported(ExpressionLanguageScope.NONE).allowableValues(VALID_FAIL_STRATEGY).defaultValue(VALID_FAIL_STRATEGY[0]).build();
    public static final PropertyDescriptor ADD_CLASSPATH = new PropertyDescriptor.Builder().name("groovyx-additional-classpath").displayName("Additional classpath").required(false).description("Classpath list separated by semicolon. You can use masks like `*`, `*.jar` in file name.").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("FlowFiles that were successfully processed").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("FlowFiles that failed to be processed").build();
    private List<PropertyDescriptor> descriptors;
    private Set<Relationship> relationships;
    File scriptFile = null;
    String scriptBody = null;
    String addClasspath = null;
    String groovyClasspath = null;
    volatile GroovyShell shell = null;
    volatile Class<Script> compiled = null;
    volatile long scriptLastModified = 0L;

    protected void init(ProcessorInitializationContext context) {
        ArrayList<PropertyDescriptor> descriptors = new ArrayList<PropertyDescriptor>();
        descriptors.add(SCRIPT_FILE);
        descriptors.add(SCRIPT_BODY);
        descriptors.add(FAIL_STRATEGY);
        descriptors.add(ADD_CLASSPATH);
        this.descriptors = Collections.unmodifiableList(descriptors);
        HashSet<Relationship> relationshipSet = new HashSet<Relationship>();
        relationshipSet.add(REL_SUCCESS);
        relationshipSet.add(REL_FAILURE);
        this.relationships = Collections.unmodifiableSet(relationshipSet);
    }

    public Set<Relationship> getRelationships() {
        return this.relationships;
    }

    public final List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.descriptors;
    }

    private File asFile(String f) {
        if (f == null || f.length() == 0) {
            return null;
        }
        return new File(f);
    }

    private void callScriptStatic(String method, ProcessContext context) throws IllegalAccessException, InvocationTargetException {
        if (this.compiled != null) {
            Method m = null;
            try {
                m = this.compiled.getDeclaredMethod(method, ProcessContext.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (m == null) {
                try {
                    m = this.compiled.getDeclaredMethod(method, Object.class);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            if (m != null) {
                m.invoke(null, context);
            }
        }
    }

    protected Collection<ValidationResult> customValidate(ValidationContext context) {
        this.scriptFile = this.asFile(context.getProperty(SCRIPT_FILE).evaluateAttributeExpressions().getValue());
        this.scriptBody = context.getProperty(SCRIPT_BODY).getValue();
        this.addClasspath = context.getProperty(ADD_CLASSPATH).evaluateAttributeExpressions().getValue();
        this.groovyClasspath = context.newPropertyValue(GROOVY_CLASSPATH).evaluateAttributeExpressions().getValue();
        HashSet<ValidationResult> results = new HashSet<ValidationResult>();
        try {
            this.getGroovyScript();
        }
        catch (Throwable t) {
            results.add(new ValidationResult.Builder().subject("GroovyScript").input(this.scriptFile != null ? this.scriptFile.toString() : null).valid(false).explanation(t.toString()).build());
        }
        return results;
    }

    public void onPropertyModified(PropertyDescriptor descriptor, String oldValue, String newValue) {
        this.shell = null;
        this.compiled = null;
        this.scriptLastModified = 0L;
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) {
        this.scriptFile = this.asFile(context.getProperty(SCRIPT_FILE).evaluateAttributeExpressions().getValue());
        this.scriptBody = context.getProperty(SCRIPT_BODY).getValue();
        this.addClasspath = context.getProperty(ADD_CLASSPATH).evaluateAttributeExpressions().getValue();
        this.groovyClasspath = context.newPropertyValue(GROOVY_CLASSPATH).evaluateAttributeExpressions().getValue();
        try {
            this.getGroovyScript();
        }
        catch (Throwable t) {
            this.getLogger().error("Load script failed: " + t);
            throw new ProcessException("Load script failed: " + t, t);
        }
        try {
            this.callScriptStatic("onStart", context);
        }
        catch (Throwable t) {
            this.getLogger().error("onStart failed: " + t);
            throw new ProcessException("onStart failed: " + t, t);
        }
    }

    @OnStopped
    public void onStopped(ProcessContext context) {
        try {
            this.callScriptStatic("onStop", context);
        }
        catch (Throwable t) {
            throw new ProcessException("Failed to finalize groovy script:\n" + t, t);
        }
    }

    Script getGroovyScript() throws Throwable {
        GroovyMethods.init();
        if (this.scriptBody != null && this.scriptFile != null) {
            throw new ProcessException("Only one parameter accepted: `" + SCRIPT_BODY.getDisplayName() + "` or `" + SCRIPT_FILE.getDisplayName() + "`");
        }
        if (this.scriptBody == null && this.scriptFile == null) {
            throw new ProcessException("At least one parameter required: `" + SCRIPT_BODY.getDisplayName() + "` or `" + SCRIPT_FILE.getDisplayName() + "`");
        }
        if (this.shell == null) {
            CompilerConfiguration conf = new CompilerConfiguration();
            conf.setDebug(true);
            this.shell = new GroovyShell(conf);
            if (this.addClasspath != null && this.addClasspath.length() > 0) {
                for (File fcp : Files.listPathsFiles(this.addClasspath)) {
                    if (!fcp.exists()) {
                        throw new ProcessException("Path not found `" + fcp + "` for `" + ADD_CLASSPATH.getDisplayName() + "`");
                    }
                    this.shell.getClassLoader().addClasspath(fcp.toString());
                }
            }
            if (this.groovyClasspath != null && this.groovyClasspath.length() > 0) {
                this.shell.getClassLoader().addClasspath(this.groovyClasspath);
            }
        }
        Script script = null;
        if (this.compiled != null && this.scriptFile != null && this.scriptLastModified != this.scriptFile.lastModified() && System.currentTimeMillis() - this.scriptFile.lastModified() > 3000L) {
            this.compiled = null;
        }
        if (this.compiled == null) {
            String scriptText;
            String scriptName;
            if (this.scriptFile != null) {
                scriptName = this.scriptFile.getName();
                this.scriptLastModified = this.scriptFile.lastModified();
                scriptText = ResourceGroovyMethods.getText((File)this.scriptFile, (String)"UTF-8");
            } else {
                scriptName = "Script" + Long.toHexString(this.scriptBody.hashCode()) + ".groovy";
                scriptText = this.scriptBody;
            }
            script = this.shell.parse(PRELOADS + scriptText, scriptName);
            this.compiled = script.getClass();
        }
        if (script == null) {
            script = this.compiled.newInstance();
        }
        Thread.currentThread().setContextClassLoader((ClassLoader)this.shell.getClassLoader());
        return script;
    }

    private void onInitSQL(HashMap SQL) throws SQLException {
        for (Map.Entry entry : SQL.entrySet()) {
            DBCPService s = (DBCPService)entry.getValue();
            OSql sql = new OSql(s.getConnection(Collections.emptyMap()));
            try {
                if (sql.getConnection().getAutoCommit()) {
                    sql.getConnection().setAutoCommit(false);
                }
            }
            catch (Throwable ei) {
                this.getLogger().warn("Failed to set autocommit=false for `" + entry.getKey() + "`", ei);
            }
            entry.setValue(sql);
        }
    }

    private void onCommitSQL(HashMap SQL) throws SQLException {
        for (Map.Entry e : SQL.entrySet()) {
            OSql sql = (OSql)((Object)e.getValue());
            if (sql.getConnection().getAutoCommit()) continue;
            sql.commit();
        }
    }

    private void onFinitSQL(HashMap SQL) {
        for (Map.Entry e : SQL.entrySet()) {
            OSql sql = (OSql)((Object)e.getValue());
            try {
                if (!sql.getConnection().getAutoCommit()) {
                    sql.getConnection().setAutoCommit(true);
                }
            }
            catch (Throwable ei) {
                this.getLogger().warn("Failed to set autocommit=true for `" + e.getKey() + "`", ei);
            }
            try {
                sql.close();
                sql = null;
            }
            catch (Throwable throwable) {}
        }
    }

    private void onFailSQL(HashMap SQL) {
        for (Map.Entry e : SQL.entrySet()) {
            OSql sql = (OSql)((Object)e.getValue());
            try {
                if (sql.getConnection().getAutoCommit()) continue;
                sql.rollback();
            }
            catch (Throwable throwable) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTrigger(ProcessContext context, ProcessSession _session) throws ProcessException {
        boolean toFailureOnError = VALID_FAIL_STRATEGY[1].equals(context.getProperty(FAIL_STRATEGY).getValue());
        GroovyProcessSessionWrap session = new GroovyProcessSessionWrap(_session, toFailureOnError);
        AccessMap CTL = new AccessMap("CTL");
        AccessMap SQL = new AccessMap("SQL");
        try {
            Script script = this.getGroovyScript();
            Map bindings = script.getBinding().getVariables();
            bindings.clear();
            for (Map.Entry property : context.getProperties().entrySet()) {
                if (!((PropertyDescriptor)property.getKey()).isDynamic()) continue;
                if (((PropertyDescriptor)property.getKey()).getName().startsWith("CTL.")) {
                    ControllerService ctl = context.getProperty((PropertyDescriptor)property.getKey()).asControllerService(ControllerService.class);
                    CTL.put(((PropertyDescriptor)property.getKey()).getName().substring(4), ctl);
                    continue;
                }
                if (((PropertyDescriptor)property.getKey()).getName().startsWith("SQL.")) {
                    DBCPService dbcp = (DBCPService)context.getProperty((PropertyDescriptor)property.getKey()).asControllerService(DBCPService.class);
                    SQL.put(((PropertyDescriptor)property.getKey()).getName().substring(4), dbcp);
                    continue;
                }
                if (property.getValue() == null) continue;
                bindings.put(((PropertyDescriptor)property.getKey()).getName(), context.getProperty((PropertyDescriptor)property.getKey()));
            }
            this.onInitSQL(SQL);
            bindings.put("session", session);
            bindings.put("context", context);
            bindings.put("log", this.getLogger());
            bindings.put("REL_SUCCESS", REL_SUCCESS);
            bindings.put("REL_FAILURE", REL_FAILURE);
            bindings.put("CTL", CTL);
            bindings.put("SQL", SQL);
            script.run();
            bindings.clear();
            this.onCommitSQL(SQL);
            session.commit();
        }
        catch (Throwable t) {
            this.getLogger().error(t.toString(), t);
            this.onFailSQL(SQL);
            if (toFailureOnError) {
                session.revertReceivedTo(REL_FAILURE, StackTraceUtils.deepSanitize((Throwable)t));
            } else {
                session.rollback(true);
            }
        }
        finally {
            this.onFinitSQL(SQL);
        }
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        if (propertyDescriptorName.startsWith("CTL.")) {
            return new PropertyDescriptor.Builder().name(propertyDescriptorName).required(false).description("Controller service accessible from code as `" + propertyDescriptorName + "`").dynamic(true).identifiesControllerService(ControllerService.class).build();
        }
        if (propertyDescriptorName.startsWith("SQL.")) {
            return new PropertyDescriptor.Builder().name(propertyDescriptorName).required(false).description("The `groovy.sql.Sql` object created from DBCP Controller service and accessible from code as `" + propertyDescriptorName + "`").dynamic(true).identifiesControllerService(DBCPService.class).build();
        }
        return new PropertyDescriptor.Builder().name(propertyDescriptorName).required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).dynamic(true).build();
    }

    private class AccessMap
    extends HashMap {
        private String parentKey;

        AccessMap(String parentKey) {
            this.parentKey = parentKey;
        }

        @Override
        public Object get(Object key) {
            if (!this.containsKey(key)) {
                throw new RuntimeException("The `" + this.parentKey + "." + key + "` not defined in processor properties");
            }
            return super.get(key);
        }
    }
}

