/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.groovyx.flow;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Writable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.io.InputStreamCallback;
import org.apache.nifi.processor.io.OutputStreamCallback;
import org.apache.nifi.processor.io.StreamCallback;
import org.apache.nifi.processors.groovyx.flow.ProcessSessionWrap;
import org.apache.nifi.processors.groovyx.flow.SessionFile;
import org.codehaus.groovy.runtime.InvokerHelper;

public class GroovySessionFile
extends SessionFile
implements GroovyObject {
    private transient MetaClass metaClass;

    protected GroovySessionFile(ProcessSessionWrap session, FlowFile f) {
        super(session, f);
        this.setMetaClass(null);
    }

    public Object getProperty(String key) {
        if ("size".equals(key)) {
            return this.getSize();
        }
        if ("attributes".equals(key)) {
            return this.getAttributes();
        }
        return this.getAttribute(key);
    }

    public void setProperty(String key, Object value) {
        if (value == null) {
            this.removeAttribute(key);
        } else if (value instanceof String) {
            this.putAttribute(key, (String)value);
        } else {
            this.putAttribute(key, value.toString());
        }
    }

    public MetaClass getMetaClass() {
        return this.metaClass;
    }

    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass == null ? InvokerHelper.getMetaClass(this.getClass()) : metaClass;
    }

    public Object invokeMethod(String name, Object args) {
        return this.metaClass.invokeMethod((Object)this, name, args);
    }

    public GroovySessionFile write(final String charset, final Closure c) {
        this.write(new OutputStreamCallback(){

            public void process(OutputStream out) throws IOException {
                OutputStreamWriter w = new OutputStreamWriter(out, charset);
                c.call((Object)w);
                ((Writer)w).flush();
                ((Writer)w).close();
            }
        });
        return this;
    }

    public GroovySessionFile write(final String charset, final CharSequence c) {
        this.write(new OutputStreamCallback(){

            public void process(OutputStream out) throws IOException {
                OutputStreamWriter w = new OutputStreamWriter(out, charset);
                ((Writer)w).append(c);
                ((Writer)w).flush();
                ((Writer)w).close();
            }
        });
        return this;
    }

    public GroovySessionFile write(final String charset, final Writable c) {
        this.write(new OutputStreamCallback(){

            public void process(OutputStream out) throws IOException {
                OutputStreamWriter w = new OutputStreamWriter(out, charset);
                c.writeTo((Writer)w);
                ((Writer)w).flush();
                ((Writer)w).close();
            }
        });
        return this;
    }

    public GroovySessionFile write(final Closure c) {
        if (c.getMaximumNumberOfParameters() == 1) {
            this.write(new OutputStreamCallback(){

                public void process(OutputStream out) throws IOException {
                    c.call((Object)out);
                }
            });
        } else {
            this.write(new StreamCallback(){

                public void process(InputStream in, OutputStream out) throws IOException {
                    c.call(new Object[]{in, out});
                }
            });
        }
        return this;
    }

    public GroovySessionFile append(final Closure c) {
        this.append(new OutputStreamCallback(){

            public void process(OutputStream out) throws IOException {
                c.call((Object)out);
            }
        });
        return this;
    }

    public GroovySessionFile append(final String charset, final Writable c) {
        this.append(new OutputStreamCallback(){

            public void process(OutputStream out) throws IOException {
                OutputStreamWriter w = new OutputStreamWriter(out, charset);
                c.writeTo((Writer)w);
                ((Writer)w).flush();
                ((Writer)w).close();
            }
        });
        return this;
    }

    public GroovySessionFile append(final String charset, final Closure c) {
        this.append(new OutputStreamCallback(){

            public void process(OutputStream out) throws IOException {
                OutputStreamWriter w = new OutputStreamWriter(out, charset);
                c.call((Object)w);
                ((Writer)w).flush();
                ((Writer)w).close();
            }
        });
        return this;
    }

    public GroovySessionFile append(final String charset, final CharSequence c) {
        this.append(new OutputStreamCallback(){

            public void process(OutputStream out) throws IOException {
                OutputStreamWriter w = new OutputStreamWriter(out, charset);
                ((Writer)w).append(c);
                ((Writer)w).flush();
                ((Writer)w).close();
            }
        });
        return this;
    }

    public void read(final Closure c) {
        this.read(new InputStreamCallback(){

            public void process(InputStream in) throws IOException {
                c.call((Object)in);
            }
        });
    }

    public void read(final String charset, final Closure c) {
        this.read(new InputStreamCallback(){

            public void process(InputStream in) throws IOException {
                InputStreamReader r = new InputStreamReader(in, charset);
                c.call((Object)r);
                r.close();
            }
        });
    }
}

