/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.mongodb;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoClientURI;
import com.mongodb.WriteConcern;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.authentication.exception.ProviderCreationException;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.security.util.SslContextFactory;
import org.apache.nifi.ssl.SSLContextService;
import org.bson.Document;

public abstract class AbstractMongoProcessor
extends AbstractProcessor {
    static final String WRITE_CONCERN_ACKNOWLEDGED = "ACKNOWLEDGED";
    static final String WRITE_CONCERN_UNACKNOWLEDGED = "UNACKNOWLEDGED";
    static final String WRITE_CONCERN_FSYNCED = "FSYNCED";
    static final String WRITE_CONCERN_JOURNALED = "JOURNALED";
    static final String WRITE_CONCERN_REPLICA_ACKNOWLEDGED = "REPLICA_ACKNOWLEDGED";
    static final String WRITE_CONCERN_MAJORITY = "MAJORITY";
    protected static final PropertyDescriptor URI = new PropertyDescriptor.Builder().name("Mongo URI").description("MongoURI, typically of the form: mongodb://host1[:port1][,host2[:port2],...]").required(true).expressionLanguageSupported(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    protected static final PropertyDescriptor DATABASE_NAME = new PropertyDescriptor.Builder().name("Mongo Database Name").description("The name of the database to use").required(true).expressionLanguageSupported(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    protected static final PropertyDescriptor COLLECTION_NAME = new PropertyDescriptor.Builder().name("Mongo Collection Name").description("The name of the collection to use").required(true).expressionLanguageSupported(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor SSL_CONTEXT_SERVICE = new PropertyDescriptor.Builder().name("ssl-context-service").displayName("SSL Context Service").description("The SSL Context Service used to provide client certificate information for TLS/SSL connections.").required(false).identifiesControllerService(SSLContextService.class).build();
    public static final PropertyDescriptor CLIENT_AUTH = new PropertyDescriptor.Builder().name("ssl-client-auth").displayName("Client Auth").description("Client authentication policy when connecting to secure (TLS/SSL) cluster. Possible values are REQUIRED, WANT, NONE. This property is only used when an SSL Context has been defined and enabled.").required(false).allowableValues((Enum[])SSLContextService.ClientAuth.values()).defaultValue("REQUIRED").build();
    public static final PropertyDescriptor WRITE_CONCERN = new PropertyDescriptor.Builder().name("Write Concern").description("The write concern to use").required(true).allowableValues(new String[]{"ACKNOWLEDGED", "UNACKNOWLEDGED", "FSYNCED", "JOURNALED", "REPLICA_ACKNOWLEDGED", "MAJORITY"}).defaultValue("ACKNOWLEDGED").build();
    static List<PropertyDescriptor> descriptors = new ArrayList<PropertyDescriptor>();
    protected MongoClient mongoClient;

    @OnScheduled
    public final void createClient(ProcessContext context) throws IOException {
        SSLContext sslContext;
        if (this.mongoClient != null) {
            this.closeClient();
        }
        this.getLogger().info("Creating MongoClient");
        SSLContextService sslService = (SSLContextService)context.getProperty(SSL_CONTEXT_SERVICE).asControllerService(SSLContextService.class);
        String rawClientAuth = context.getProperty(CLIENT_AUTH).getValue();
        if (sslService != null) {
            SSLContextService.ClientAuth clientAuth;
            if (StringUtils.isBlank((CharSequence)rawClientAuth)) {
                clientAuth = SSLContextService.ClientAuth.REQUIRED;
            } else {
                try {
                    clientAuth = SSLContextService.ClientAuth.valueOf((String)rawClientAuth);
                }
                catch (IllegalArgumentException iae) {
                    throw new ProviderCreationException(String.format("Unrecognized client auth '%s'. Possible values are [%s]", rawClientAuth, StringUtils.join((Object[])SslContextFactory.ClientAuth.values(), (String)", ")));
                }
            }
            sslContext = sslService.createSSLContext(clientAuth);
        } else {
            sslContext = null;
        }
        try {
            this.mongoClient = sslContext == null ? new MongoClient(new MongoClientURI(this.getURI(context))) : new MongoClient(new MongoClientURI(this.getURI(context), this.getClientOptions(sslContext)));
        }
        catch (Exception e) {
            this.getLogger().error("Failed to schedule {} due to {}", new Object[]{((Object)((Object)this)).getClass().getName(), e}, (Throwable)e);
            throw e;
        }
    }

    protected MongoClientOptions.Builder getClientOptions(SSLContext sslContext) {
        MongoClientOptions.Builder builder = MongoClientOptions.builder();
        builder.sslEnabled(true);
        builder.socketFactory((SocketFactory)sslContext.getSocketFactory());
        return builder;
    }

    @OnStopped
    public final void closeClient() {
        if (this.mongoClient != null) {
            this.getLogger().info("Closing MongoClient");
            this.mongoClient.close();
            this.mongoClient = null;
        }
    }

    protected MongoDatabase getDatabase(ProcessContext context) {
        return this.getDatabase(context, null);
    }

    protected MongoDatabase getDatabase(ProcessContext context, FlowFile flowFile) {
        String databaseName = context.getProperty(DATABASE_NAME).evaluateAttributeExpressions(flowFile).getValue();
        return this.mongoClient.getDatabase(databaseName);
    }

    protected MongoCollection<Document> getCollection(ProcessContext context) {
        return this.getCollection(context, null);
    }

    protected MongoCollection<Document> getCollection(ProcessContext context, FlowFile flowFile) {
        String collectionName = context.getProperty(COLLECTION_NAME).evaluateAttributeExpressions(flowFile).getValue();
        return this.getDatabase(context, flowFile).getCollection(collectionName);
    }

    protected String getURI(ProcessContext context) {
        return context.getProperty(URI).evaluateAttributeExpressions().getValue();
    }

    protected WriteConcern getWriteConcern(ProcessContext context) {
        String writeConcernProperty = context.getProperty(WRITE_CONCERN).getValue();
        WriteConcern writeConcern = null;
        switch (writeConcernProperty) {
            case "ACKNOWLEDGED": {
                writeConcern = WriteConcern.ACKNOWLEDGED;
                break;
            }
            case "UNACKNOWLEDGED": {
                writeConcern = WriteConcern.UNACKNOWLEDGED;
                break;
            }
            case "FSYNCED": {
                writeConcern = WriteConcern.FSYNCED;
                break;
            }
            case "JOURNALED": {
                writeConcern = WriteConcern.JOURNALED;
                break;
            }
            case "REPLICA_ACKNOWLEDGED": {
                writeConcern = WriteConcern.REPLICA_ACKNOWLEDGED;
                break;
            }
            case "MAJORITY": {
                writeConcern = WriteConcern.MAJORITY;
                break;
            }
            default: {
                writeConcern = WriteConcern.ACKNOWLEDGED;
            }
        }
        return writeConcern;
    }

    static {
        descriptors.add(URI);
        descriptors.add(DATABASE_NAME);
        descriptors.add(COLLECTION_NAME);
        descriptors.add(SSL_CONTEXT_SERVICE);
        descriptors.add(CLIENT_AUTH);
    }
}

