/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.mongodb;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.io.OutputStreamCallback;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.mongodb.AbstractMongoProcessor;
import org.apache.nifi.processors.mongodb.ObjectIdSerializer;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.json.JsonWriterSettings;

@Tags(value={"mongodb", "read", "get"})
@InputRequirement(value=InputRequirement.Requirement.INPUT_FORBIDDEN)
@CapabilityDescription(value="Creates FlowFiles from documents in MongoDB")
public class GetMongo
extends AbstractMongoProcessor {
    public static final Validator DOCUMENT_VALIDATOR = new Validator(){

        public ValidationResult validate(String subject, String value, ValidationContext context) {
            ValidationResult.Builder builder = new ValidationResult.Builder();
            builder.subject(subject).input(value);
            if (context.isExpressionLanguageSupported(subject) && context.isExpressionLanguagePresent(value)) {
                return builder.valid(true).explanation("Contains Expression Language").build();
            }
            String reason = null;
            try {
                Document.parse((String)value);
            }
            catch (RuntimeException e) {
                reason = e.getLocalizedMessage();
            }
            return builder.explanation(reason).valid(reason == null).build();
        }
    };
    static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("All files are routed to success").build();
    static final PropertyDescriptor QUERY = new PropertyDescriptor.Builder().name("Query").description("The selection criteria; must be a valid MongoDB Extended JSON format; if omitted the entire collection will be queried").required(false).expressionLanguageSupported(true).addValidator(DOCUMENT_VALIDATOR).build();
    static final PropertyDescriptor PROJECTION = new PropertyDescriptor.Builder().name("Projection").description("The fields to be returned from the documents in the result set; must be a valid BSON document").required(false).expressionLanguageSupported(true).addValidator(DOCUMENT_VALIDATOR).build();
    static final PropertyDescriptor SORT = new PropertyDescriptor.Builder().name("Sort").description("The fields by which to sort; must be a valid BSON document").required(false).expressionLanguageSupported(true).addValidator(DOCUMENT_VALIDATOR).build();
    static final PropertyDescriptor LIMIT = new PropertyDescriptor.Builder().name("Limit").description("The maximum number of elements to return").required(false).expressionLanguageSupported(true).addValidator(StandardValidators.POSITIVE_INTEGER_VALIDATOR).build();
    static final PropertyDescriptor BATCH_SIZE = new PropertyDescriptor.Builder().name("Batch Size").description("The number of elements returned from the server in one batch").required(false).expressionLanguageSupported(true).addValidator(StandardValidators.POSITIVE_INTEGER_VALIDATOR).build();
    static final PropertyDescriptor RESULTS_PER_FLOWFILE = new PropertyDescriptor.Builder().name("results-per-flowfile").displayName("Results Per FlowFile").description("How many results to put into a flowfile at once. The whole body will be treated as a JSON array of results.").required(false).expressionLanguageSupported(true).addValidator(StandardValidators.POSITIVE_INTEGER_VALIDATOR).build();
    static final String JSON_TYPE_EXTENDED = "Extended";
    static final String JSON_TYPE_STANDARD = "Standard";
    static final AllowableValue JSON_EXTENDED = new AllowableValue("Extended", "Extended JSON", "Use MongoDB's \"extended JSON\". This is the JSON generated with toJson() on a MongoDB Document from the Java driver");
    static final AllowableValue JSON_STANDARD = new AllowableValue("Standard", "Standard JSON", "Generate a JSON document that conforms to typical JSON conventions instead of Mongo-specific conventions.");
    static final PropertyDescriptor JSON_TYPE = new PropertyDescriptor.Builder().allowableValues(new AllowableValue[]{JSON_EXTENDED, JSON_STANDARD}).defaultValue("Extended").displayName("JSON Type").name("json-type").description("By default, MongoDB's Java driver returns \"extended JSON\". Some of the features of this variant of JSON may cause problems for other JSON parsers that expect only standard JSON types and conventions. This configuration setting  controls whether to use extended JSON or provide a clean view that conforms to standard JSON.").expressionLanguageSupported(false).required(true).build();
    private static final Set<Relationship> relationships;
    private static final List<PropertyDescriptor> propertyDescriptors;
    private ObjectMapper mapper;

    public Set<Relationship> getRelationships() {
        return relationships;
    }

    public final List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return propertyDescriptors;
    }

    private String buildBatch(List<Document> documents, String jsonTypeSetting) throws IOException {
        StringBuilder builder = new StringBuilder();
        for (int index = 0; index < documents.size(); ++index) {
            Document document = documents.get(index);
            String asJson = jsonTypeSetting.equals(JSON_TYPE_STANDARD) ? this.mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)document) : document.toJson(new JsonWriterSettings(true));
            builder.append(asJson).append(documents.size() > 1 && index + 1 < documents.size() ? ", " : "");
        }
        return "[" + builder.toString() + "]";
    }

    private void configureMapper(String setting) {
        this.mapper = new ObjectMapper();
        if (setting.equals(JSON_TYPE_STANDARD)) {
            this.mapper.registerModule((Module)ObjectIdSerializer.getModule());
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            this.mapper.setDateFormat((DateFormat)df);
        }
    }

    private void writeBatch(final String payload, ProcessContext context, ProcessSession session) {
        FlowFile flowFile = session.create();
        flowFile = session.write(flowFile, new OutputStreamCallback(){

            public void process(OutputStream out) throws IOException {
                out.write(payload.getBytes("UTF-8"));
            }
        });
        flowFile = session.putAttribute(flowFile, CoreAttributes.MIME_TYPE.key(), "application/json");
        session.getProvenanceReporter().receive(flowFile, this.getURI(context));
        session.transfer(flowFile, REL_SUCCESS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        ComponentLog logger = this.getLogger();
        Document query = context.getProperty(QUERY).isSet() ? Document.parse((String)context.getProperty(QUERY).evaluateAttributeExpressions().getValue()) : null;
        Document projection = context.getProperty(PROJECTION).isSet() ? Document.parse((String)context.getProperty(PROJECTION).evaluateAttributeExpressions().getValue()) : null;
        Document sort = context.getProperty(SORT).isSet() ? Document.parse((String)context.getProperty(SORT).evaluateAttributeExpressions().getValue()) : null;
        final String jsonTypeSetting = context.getProperty(JSON_TYPE).getValue();
        this.configureMapper(jsonTypeSetting);
        MongoCollection<Document> collection = this.getCollection(context);
        try {
            FindIterable it;
            FindIterable findIterable = it = query != null ? collection.find((Bson)query) : collection.find();
            if (projection != null) {
                it.projection((Bson)projection);
            }
            if (sort != null) {
                it.sort((Bson)sort);
            }
            if (context.getProperty(LIMIT).isSet()) {
                it.limit(context.getProperty(LIMIT).evaluateAttributeExpressions().asInteger().intValue());
            }
            if (context.getProperty(BATCH_SIZE).isSet()) {
                it.batchSize(context.getProperty(BATCH_SIZE).evaluateAttributeExpressions().asInteger().intValue());
            }
            ComponentLog log = this.getLogger();
            try (final MongoCursor cursor = it.iterator();){
                FlowFile flowFile = null;
                if (context.getProperty(RESULTS_PER_FLOWFILE).isSet()) {
                    int ceiling = context.getProperty(RESULTS_PER_FLOWFILE).evaluateAttributeExpressions().asInteger();
                    ArrayList<Object> batch = new ArrayList<Document>();
                    while (cursor.hasNext()) {
                        batch.add((Document)cursor.next());
                        if (batch.size() != ceiling) continue;
                        try {
                            if (log.isDebugEnabled()) {
                                log.debug("Writing batch...");
                            }
                            String payload = this.buildBatch(batch, jsonTypeSetting);
                            this.writeBatch(payload, context, session);
                            batch = new ArrayList();
                        }
                        catch (IOException ex) {
                            this.getLogger().error("Error building batch", (Throwable)ex);
                        }
                    }
                    if (batch.size() > 0) {
                        try {
                            this.writeBatch(this.buildBatch(batch, jsonTypeSetting), context, session);
                        }
                        catch (IOException ex) {
                            this.getLogger().error("Error sending remainder of batch", (Throwable)ex);
                        }
                    }
                } else {
                    while (cursor.hasNext()) {
                        flowFile = session.create();
                        flowFile = session.write(flowFile, new OutputStreamCallback(){

                            public void process(OutputStream out) throws IOException {
                                String json = jsonTypeSetting.equals(GetMongo.JSON_TYPE_STANDARD) ? GetMongo.this.mapper.writerWithDefaultPrettyPrinter().writeValueAsString(cursor.next()) : ((Document)cursor.next()).toJson();
                                IOUtils.write((String)json, (OutputStream)out);
                            }
                        });
                        flowFile = session.putAttribute(flowFile, CoreAttributes.MIME_TYPE.key(), "application/json");
                        session.getProvenanceReporter().receive(flowFile, this.getURI(context));
                        session.transfer(flowFile, REL_SUCCESS);
                    }
                }
                session.commit();
            }
        }
        catch (RuntimeException e) {
            context.yield();
            session.rollback();
            logger.error("Failed to execute query {} due to {}", new Object[]{query, e}, (Throwable)e);
        }
    }

    static {
        ArrayList<PropertyDescriptor> _propertyDescriptors = new ArrayList<PropertyDescriptor>();
        _propertyDescriptors.addAll(descriptors);
        _propertyDescriptors.add(JSON_TYPE);
        _propertyDescriptors.add(QUERY);
        _propertyDescriptors.add(PROJECTION);
        _propertyDescriptors.add(SORT);
        _propertyDescriptors.add(LIMIT);
        _propertyDescriptors.add(BATCH_SIZE);
        _propertyDescriptors.add(RESULTS_PER_FLOWFILE);
        _propertyDescriptors.add(SSL_CONTEXT_SERVICE);
        _propertyDescriptors.add(CLIENT_AUTH);
        propertyDescriptors = Collections.unmodifiableList(_propertyDescriptors);
        HashSet<Relationship> _relationships = new HashSet<Relationship>();
        _relationships.add(REL_SUCCESS);
        relationships = Collections.unmodifiableSet(_relationships);
    }
}

