/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.mongodb;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.nifi.annotation.behavior.EventDriven;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.mongodb.AbstractMongoProcessor;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.serialization.MalformedRecordException;
import org.apache.nifi.serialization.RecordReaderFactory;
import org.bson.Document;

@EventDriven
@Tags(value={"mongodb", "insert", "record", "put"})
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@CapabilityDescription(value="Bulk ingest documents into MongoDB using a configured record reader.")
public class PutMongoRecord
extends AbstractMongoProcessor {
    static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("All FlowFiles that are written to MongoDB are routed to this relationship").build();
    static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("All FlowFiles that cannot be written to MongoDB are routed to this relationship").build();
    static final PropertyDescriptor RECORD_READER_FACTORY = new PropertyDescriptor.Builder().name("record-reader").displayName("Record Reader").description("Specifies the Controller Service to use for parsing incoming data and determining the data's schema").identifiesControllerService(RecordReaderFactory.class).required(true).build();
    static final PropertyDescriptor INSERT_COUNT = new PropertyDescriptor.Builder().name("insert_count").displayName("Insert Batch Size").description("The number of records to group together for one single insert operation against MongoDB.").defaultValue("100").required(true).addValidator(StandardValidators.POSITIVE_INTEGER_VALIDATOR).build();
    private static final Set<Relationship> relationships;
    private static final List<PropertyDescriptor> propertyDescriptors;

    public Set<Relationship> getRelationships() {
        return relationships;
    }

    public List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return propertyDescriptors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        recordParserFactory = (RecordReaderFactory)context.getProperty(PutMongoRecord.RECORD_READER_FACTORY).asControllerService(RecordReaderFactory.class);
        writeConcern = this.getWriteConcern(context);
        collection = this.getCollection(context).withWriteConcern(writeConcern);
        inserts = new ArrayList<Document>();
        ceiling = context.getProperty(PutMongoRecord.INSERT_COUNT).asInteger();
        added = 0;
        error = false;
        try {
            reader = recordParserFactory.createRecordReader(flowFile, session.read(flowFile), this.getLogger());
            var12_13 = null;
            try {
                schema = reader.getSchema();
                while ((record = reader.nextRecord()) != null) {
                    document = new Document();
                    for (String name : schema.getFieldNames()) {
                        document.put(name, record.getValue(name));
                    }
                    inserts.add(document);
                    if (inserts.size() != ceiling) continue;
                    collection.insertMany(inserts);
                    added += inserts.size();
                    inserts = new ArrayList<E>();
                }
                if (inserts.size() > 0) {
                    collection.insertMany(inserts);
                }
            }
            catch (Throwable var13_16) {
                var12_13 = var13_16;
                throw var13_16;
            }
            finally {
                if (reader != null) {
                    if (var12_13 != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable var13_15) {
                            var12_13.addSuppressed(var13_15);
                        }
                    } else {
                        reader.close();
                    }
                }
            }
            ** if (error) goto lbl-1000
        }
        catch (IOException | SchemaNotFoundException | MalformedRecordException e) {
            try {
                this.getLogger().error("PutMongoRecord failed with error:", e);
                session.transfer(flowFile, PutMongoRecord.REL_FAILURE);
                error = true;
                ** if (error) goto lbl-1000
            }
            catch (Throwable var20_23) {
                if (!error) {
                    session.getProvenanceReporter().send(flowFile, context.getProperty(PutMongoRecord.URI).getValue(), String.format("Added %d documents to MongoDB.", new Object[]{added}));
                    session.transfer(flowFile, PutMongoRecord.REL_SUCCESS);
                    this.getLogger().info("Inserted {} records into MongoDB", new Object[]{added});
                }
                throw var20_23;
            }
lbl-1000:
            // 1 sources

            {
                session.getProvenanceReporter().send(flowFile, context.getProperty(PutMongoRecord.URI).getValue(), String.format("Added %d documents to MongoDB.", new Object[]{added}));
                session.transfer(flowFile, PutMongoRecord.REL_SUCCESS);
                this.getLogger().info("Inserted {} records into MongoDB", new Object[]{added});
            }
lbl-1000:
            // 2 sources

            {
            }
        }
lbl-1000:
        // 1 sources

        {
            session.getProvenanceReporter().send(flowFile, context.getProperty(PutMongoRecord.URI).getValue(), String.format("Added %d documents to MongoDB.", new Object[]{added}));
            session.transfer(flowFile, PutMongoRecord.REL_SUCCESS);
            this.getLogger().info("Inserted {} records into MongoDB", new Object[]{added});
        }
lbl-1000:
        // 2 sources

        {
        }
        session.commit();
    }

    static {
        ArrayList<PropertyDescriptor> _propertyDescriptors = new ArrayList<PropertyDescriptor>();
        _propertyDescriptors.addAll(descriptors);
        _propertyDescriptors.add(WRITE_CONCERN);
        _propertyDescriptors.add(RECORD_READER_FACTORY);
        _propertyDescriptors.add(INSERT_COUNT);
        propertyDescriptors = Collections.unmodifiableList(_propertyDescriptors);
        HashSet<Relationship> _relationships = new HashSet<Relationship>();
        _relationships.add(REL_SUCCESS);
        _relationships.add(REL_FAILURE);
        relationships = Collections.unmodifiableSet(_relationships);
    }
}

