/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.mongodb.gridfs;

import com.mongodb.client.MongoDatabase;
import com.mongodb.client.gridfs.GridFSBucket;
import com.mongodb.client.gridfs.GridFSBuckets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.Validator;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.mongodb.MongoDBClientService;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.util.StringUtils;
import org.bson.types.ObjectId;

public abstract class AbstractGridFSProcessor
extends AbstractProcessor {
    static final PropertyDescriptor CLIENT_SERVICE = new PropertyDescriptor.Builder().name("gridfs-client-service").displayName("Client Service").description("The MongoDB client service to use for database connections.").expressionLanguageSupported(ExpressionLanguageScope.NONE).required(true).identifiesControllerService(MongoDBClientService.class).build();
    static final PropertyDescriptor DATABASE_NAME = new PropertyDescriptor.Builder().name("gridfs-database-name").displayName("Mongo Database Name").description("The name of the database to use").required(true).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    static final PropertyDescriptor BUCKET_NAME = new PropertyDescriptor.Builder().name("gridfs-bucket-name").displayName("Bucket Name").description("The GridFS bucket where the files will be stored. If left blank, it will use the default value 'fs' that the MongoDB client driver uses.").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(false).addValidator(Validator.VALID).build();
    static final PropertyDescriptor FILE_NAME = new PropertyDescriptor.Builder().name("gridfs-file-name").displayName("File Name").description("The name of the file in the bucket that is the target of this processor.").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    static final PropertyDescriptor QUERY_ATTRIBUTE = new PropertyDescriptor.Builder().name("mongo-query-attribute").displayName("Query Output Attribute").description("If set, the query will be written to a specified attribute on the output flowfiles.").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.ATTRIBUTE_KEY_PROPERTY_NAME_VALIDATOR).required(false).build();
    static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("When there is a failure processing the flowfile, it goes to this relationship.").build();
    static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("When the operation succeeds, the flowfile is sent to this relationship.").build();
    static final List<PropertyDescriptor> PARENT_PROPERTIES;
    static final Set<Relationship> PARENT_RELATIONSHIPS;
    protected volatile MongoDBClientService clientService;

    protected MongoDatabase getDatabase(FlowFile input, ProcessContext context) {
        return this.clientService.getDatabase(context.getProperty(DATABASE_NAME).evaluateAttributeExpressions(input).getValue());
    }

    protected GridFSBucket getBucket(FlowFile input, ProcessContext context) {
        String name = this.getBucketName(input, context);
        if (StringUtils.isEmpty((String)name)) {
            return GridFSBuckets.create((MongoDatabase)this.getDatabase(input, context));
        }
        return GridFSBuckets.create((MongoDatabase)this.getDatabase(input, context), (String)name);
    }

    protected String getBucketName(FlowFile input, ProcessContext context) {
        return context.getProperty(BUCKET_NAME).isSet() ? context.getProperty(BUCKET_NAME).evaluateAttributeExpressions(input).getValue() : null;
    }

    protected String getTransitUri(ObjectId id, FlowFile input, ProcessContext context) {
        String bucket = this.getBucketName(input, context);
        String uri = this.clientService.getURI();
        return uri + (uri.endsWith("/") ? "" : "/") + bucket + "/" + id.toString();
    }

    static {
        ArrayList<PropertyDescriptor> _temp = new ArrayList<PropertyDescriptor>();
        _temp.add(CLIENT_SERVICE);
        _temp.add(DATABASE_NAME);
        _temp.add(BUCKET_NAME);
        PARENT_PROPERTIES = Collections.unmodifiableList(_temp);
        HashSet<Relationship> _rels = new HashSet<Relationship>();
        _rels.add(REL_SUCCESS);
        _rels.add(REL_FAILURE);
        PARENT_RELATIONSHIPS = Collections.unmodifiableSet(_rels);
    }
}

