/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.properties;

import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.properties.SensitivePropertyProtectionException;
import org.apache.nifi.properties.SensitivePropertyProvider;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.DecoderException;
import org.bouncycastle.util.encoders.EncoderException;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AESSensitivePropertyProvider
implements SensitivePropertyProvider {
    private static final Logger logger = LoggerFactory.getLogger(AESSensitivePropertyProvider.class);
    private static final String IMPLEMENTATION_NAME = "AES Sensitive Property Provider";
    private static final String IMPLEMENTATION_KEY = "aes/gcm/";
    private static final String ALGORITHM = "AES/GCM/NoPadding";
    private static final String PROVIDER = "BC";
    private static final String DELIMITER = "||";
    private static final int IV_LENGTH = 12;
    private static final int MIN_CIPHER_TEXT_LENGTH = 16 + "||".length() + 1;
    private Cipher cipher;
    private final SecretKey key;

    public AESSensitivePropertyProvider(String keyHex) throws NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException {
        byte[] key = this.validateKey(keyHex);
        try {
            this.cipher = Cipher.getInstance(ALGORITHM, PROVIDER);
            this.key = new SecretKeySpec(key, "AES");
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException | NoSuchPaddingException e) {
            logger.error("Encountered an error initializing the {}: {}", (Object)IMPLEMENTATION_NAME, (Object)e.getMessage());
            throw new SensitivePropertyProtectionException("Error initializing the protection cipher", e);
        }
    }

    private byte[] validateKey(String keyHex) {
        if (keyHex == null || StringUtils.isBlank((CharSequence)keyHex)) {
            throw new SensitivePropertyProtectionException("The key cannot be empty");
        }
        if (!AESSensitivePropertyProvider.isHexKeyValid(keyHex = AESSensitivePropertyProvider.formatHexKey(keyHex))) {
            throw new SensitivePropertyProtectionException("The key must be a valid hexadecimal key");
        }
        byte[] key = Hex.decode((String)keyHex);
        List<Integer> validKeyLengths = AESSensitivePropertyProvider.getValidKeyLengths();
        if (!validKeyLengths.contains(key.length * 8)) {
            List validKeyLengthsAsStrings = validKeyLengths.stream().map(i -> Integer.toString(i)).collect(Collectors.toList());
            throw new SensitivePropertyProtectionException("The key (" + key.length * 8 + " bits) must be a valid length: " + StringUtils.join(validKeyLengthsAsStrings, (String)", "));
        }
        return key;
    }

    public AESSensitivePropertyProvider(byte[] key) throws NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException {
        this(key == null ? "" : Hex.toHexString((byte[])key));
    }

    private static String formatHexKey(String input) {
        if (input == null || StringUtils.isBlank((CharSequence)input)) {
            return "";
        }
        return input.replaceAll("[^0-9a-fA-F]", "").toLowerCase();
    }

    private static boolean isHexKeyValid(String key) {
        if (key == null || StringUtils.isBlank((CharSequence)key)) {
            return false;
        }
        return AESSensitivePropertyProvider.getValidKeyLengths().contains(key.length() * 4) && key.matches("^[0-9a-fA-F]*$");
    }

    private static List<Integer> getValidKeyLengths() {
        ArrayList<Integer> validLengths = new ArrayList<Integer>();
        validLengths.add(128);
        try {
            if (Cipher.getMaxAllowedKeyLength("AES") > 128) {
                validLengths.add(192);
                validLengths.add(256);
            } else {
                logger.warn("JCE Unlimited Strength Cryptography Jurisdiction policies are not available, so the max key length is 128 bits");
            }
        }
        catch (NoSuchAlgorithmException e) {
            logger.warn("Encountered an error determining the max key length", (Throwable)e);
        }
        return validLengths;
    }

    @Override
    public String getName() {
        return IMPLEMENTATION_NAME;
    }

    @Override
    public String getIdentifierKey() {
        return IMPLEMENTATION_KEY + this.getKeySize(Hex.toHexString((byte[])this.key.getEncoded()));
    }

    private int getKeySize(String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return 0;
        }
        return AESSensitivePropertyProvider.formatHexKey(key).length() * 4;
    }

    @Override
    public String protect(String unprotectedValue) throws SensitivePropertyProtectionException {
        if (unprotectedValue == null || unprotectedValue.trim().length() == 0) {
            throw new IllegalArgumentException("Cannot encrypt an empty value");
        }
        byte[] iv = this.generateIV();
        if (iv.length < 12) {
            throw new IllegalArgumentException("The IV (" + iv.length + " bytes) must be at least " + 12 + " bytes");
        }
        try {
            this.cipher.init(1, (Key)this.key, new IvParameterSpec(iv));
            byte[] plainBytes = unprotectedValue.getBytes(StandardCharsets.UTF_8);
            byte[] cipherBytes = this.cipher.doFinal(plainBytes);
            logger.info(this.getName() + " encrypted a sensitive value successfully");
            return this.base64Encode(iv) + DELIMITER + this.base64Encode(cipherBytes);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | BadPaddingException | IllegalBlockSizeException | EncoderException e) {
            String msg = "Error encrypting a protected value";
            logger.error("Error encrypting a protected value", e);
            throw new SensitivePropertyProtectionException("Error encrypting a protected value", e);
        }
    }

    private String base64Encode(byte[] input) {
        return Base64.toBase64String((byte[])input).replaceAll("=", "");
    }

    private byte[] generateIV() {
        byte[] iv = new byte[12];
        new SecureRandom().nextBytes(iv);
        return iv;
    }

    @Override
    public String unprotect(String protectedValue) throws SensitivePropertyProtectionException {
        if (protectedValue == null || protectedValue.trim().length() < MIN_CIPHER_TEXT_LENGTH) {
            throw new IllegalArgumentException("Cannot decrypt a cipher text shorter than " + MIN_CIPHER_TEXT_LENGTH + " chars");
        }
        if (!protectedValue.contains(DELIMITER)) {
            throw new IllegalArgumentException("The cipher text does not contain the delimiter || -- it should be of the form Base64(IV) || Base64(cipherText)");
        }
        String IV_B64 = (protectedValue = protectedValue.trim()).substring(0, protectedValue.indexOf(DELIMITER));
        byte[] iv = Base64.decode((String)IV_B64);
        if (iv.length < 12) {
            throw new IllegalArgumentException("The IV (" + iv.length + " bytes) must be at least " + 12 + " bytes");
        }
        String CIPHERTEXT_B64 = protectedValue.substring(protectedValue.indexOf(DELIMITER) + 2);
        if (CIPHERTEXT_B64.length() % 4 != 0) {
            int paddedLength = CIPHERTEXT_B64.length() + 4 - CIPHERTEXT_B64.length() % 4;
            CIPHERTEXT_B64 = StringUtils.rightPad((String)CIPHERTEXT_B64, (int)paddedLength, (char)'=');
        }
        try {
            byte[] cipherBytes = Base64.decode((String)CIPHERTEXT_B64);
            this.cipher.init(2, (Key)this.key, new IvParameterSpec(iv));
            byte[] plainBytes = this.cipher.doFinal(cipherBytes);
            logger.info(this.getName() + " decrypted a sensitive value successfully");
            return new String(plainBytes, StandardCharsets.UTF_8);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | BadPaddingException | IllegalBlockSizeException | DecoderException e) {
            String msg = "Error decrypting a protected value";
            logger.error("Error decrypting a protected value", e);
            throw new SensitivePropertyProtectionException("Error decrypting a protected value", e);
        }
    }

    public static int getIvLength() {
        return 12;
    }

    public static int getMinCipherTextLength() {
        return MIN_CIPHER_TEXT_LENGTH;
    }

    public static String getDelimiter() {
        return DELIMITER;
    }
}

