/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.remote.io.socket.ssl;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.SocketChannel;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.apache.nifi.remote.exception.TransmissionDisabledException;
import org.apache.nifi.remote.io.socket.BufferStateManager;
import org.apache.nifi.security.util.CertificateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLSocketChannel
implements Closeable {
    public static final int MAX_WRITE_SIZE = 65536;
    private static final Logger logger = LoggerFactory.getLogger(SSLSocketChannel.class);
    private static final long BUFFER_FULL_EMPTY_WAIT_NANOS = TimeUnit.NANOSECONDS.convert(1L, TimeUnit.MILLISECONDS);
    private final String hostname;
    private final int port;
    private final SSLEngine engine;
    private final SocketAddress socketAddress;
    private BufferStateManager streamInManager;
    private BufferStateManager streamOutManager;
    private BufferStateManager appDataManager;
    private SocketChannel channel;
    private final byte[] oneByteBuffer = new byte[1];
    private int timeoutMillis = 30000;
    private volatile boolean connected = false;
    private boolean handshaking = false;
    private boolean closed = false;
    private volatile boolean interrupted = false;

    public SSLSocketChannel(SSLContext sslContext, String hostname, int port, InetAddress localAddress, boolean client) throws IOException {
        this.socketAddress = new InetSocketAddress(hostname, port);
        this.channel = SocketChannel.open();
        if (localAddress != null) {
            InetSocketAddress localSocketAddress = new InetSocketAddress(localAddress, 0);
            this.channel.bind(localSocketAddress);
        }
        this.hostname = hostname;
        this.port = port;
        this.engine = sslContext.createSSLEngine();
        this.engine.setUseClientMode(client);
        this.engine.setNeedClientAuth(true);
        this.streamInManager = new BufferStateManager(ByteBuffer.allocate(this.engine.getSession().getPacketBufferSize()));
        this.streamOutManager = new BufferStateManager(ByteBuffer.allocate(this.engine.getSession().getPacketBufferSize()));
        this.appDataManager = new BufferStateManager(ByteBuffer.allocate(this.engine.getSession().getApplicationBufferSize()));
    }

    public SSLSocketChannel(SSLContext sslContext, SocketChannel socketChannel, boolean client) throws IOException {
        if (!socketChannel.isConnected()) {
            throw new IllegalArgumentException("Cannot pass an un-connected SocketChannel");
        }
        this.channel = socketChannel;
        this.socketAddress = socketChannel.getRemoteAddress();
        Socket socket = socketChannel.socket();
        this.hostname = socket.getInetAddress().getHostName();
        this.port = socket.getPort();
        this.engine = sslContext.createSSLEngine();
        this.engine.setUseClientMode(client);
        this.engine.setNeedClientAuth(true);
        this.streamInManager = new BufferStateManager(ByteBuffer.allocate(this.engine.getSession().getPacketBufferSize()));
        this.streamOutManager = new BufferStateManager(ByteBuffer.allocate(this.engine.getSession().getPacketBufferSize()));
        this.appDataManager = new BufferStateManager(ByteBuffer.allocate(this.engine.getSession().getApplicationBufferSize()));
    }

    public SSLSocketChannel(SSLEngine sslEngine, SocketChannel socketChannel) throws IOException {
        if (!socketChannel.isConnected()) {
            throw new IllegalArgumentException("Cannot pass an un-connected SocketChannel");
        }
        this.channel = socketChannel;
        this.socketAddress = socketChannel.getRemoteAddress();
        Socket socket = socketChannel.socket();
        this.hostname = socket.getInetAddress().getHostName();
        this.port = socket.getPort();
        this.engine = sslEngine;
        this.streamInManager = new BufferStateManager(ByteBuffer.allocate(this.engine.getSession().getPacketBufferSize()));
        this.streamOutManager = new BufferStateManager(ByteBuffer.allocate(this.engine.getSession().getPacketBufferSize()));
        this.appDataManager = new BufferStateManager(ByteBuffer.allocate(this.engine.getSession().getApplicationBufferSize()));
    }

    public void setTimeout(int millis) {
        this.timeoutMillis = millis;
    }

    public int getTimeout() {
        return this.timeoutMillis;
    }

    public void connect() throws IOException {
        try {
            this.channel.configureBlocking(false);
            if (!this.channel.isConnected()) {
                long startTime = System.currentTimeMillis();
                if (!this.channel.connect(this.socketAddress)) {
                    while (!this.channel.finishConnect()) {
                        if (this.interrupted) {
                            throw new TransmissionDisabledException();
                        }
                        if (System.currentTimeMillis() > startTime + (long)this.timeoutMillis) {
                            throw new SocketTimeoutException("Timed out connecting to " + this.hostname + ":" + this.port);
                        }
                        try {
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
            this.engine.beginHandshake();
            this.performHandshake();
            logger.debug("{} Successfully completed SSL handshake", (Object)this);
            this.streamInManager.clear();
            this.streamOutManager.clear();
            this.appDataManager.clear();
            this.connected = true;
        }
        catch (Exception e) {
            logger.error("{} Failed to connect due to {}", (Object)this, (Object)e);
            if (logger.isDebugEnabled()) {
                logger.error("", (Throwable)e);
            }
            this.closeQuietly(this.channel);
            this.engine.closeInbound();
            this.engine.closeOutbound();
            throw e;
        }
    }

    public String getDn() throws CertificateException, SSLPeerUnverifiedException {
        Certificate[] certs = this.engine.getSession().getPeerCertificates();
        if (certs == null || certs.length == 0) {
            throw new SSLPeerUnverifiedException("No certificates found");
        }
        X509Certificate cert = CertificateUtils.convertAbstractX509Certificate(certs[0]);
        cert.checkValidity();
        return cert.getSubjectDN().getName().trim();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void performHandshake() throws IOException {
        byte[] emptyMessage = new byte[]{};
        this.handshaking = true;
        logger.debug("{} Performing Handshake", (Object)this);
        try {
            block12: while (true) {
                switch (this.engine.getHandshakeStatus()) {
                    case FINISHED: {
                        return;
                    }
                    case NEED_WRAP: {
                        ByteBuffer appDataOut = ByteBuffer.wrap(emptyMessage);
                        ByteBuffer outboundBuffer = this.streamOutManager.prepareForWrite(this.engine.getSession().getApplicationBufferSize());
                        SSLEngineResult wrapHelloResult = this.engine.wrap(appDataOut, outboundBuffer);
                        if (wrapHelloResult.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                            this.streamOutManager.prepareForWrite(this.engine.getSession().getApplicationBufferSize());
                            continue block12;
                        }
                        if (wrapHelloResult.getStatus() != SSLEngineResult.Status.OK) {
                            throw new SSLHandshakeException("Could not generate SSL Handshake information: SSLEngineResult: " + wrapHelloResult.toString());
                        }
                        logger.trace("{} Handshake response after wrapping: {}", (Object)this, (Object)wrapHelloResult);
                        ByteBuffer readableStreamOut = this.streamOutManager.prepareForRead(1);
                        int bytesToSend = readableStreamOut.remaining();
                        this.writeFully(readableStreamOut);
                        logger.trace("{} Sent {} bytes of wrapped data for handshake", (Object)this, (Object)bytesToSend);
                        this.streamOutManager.clear();
                        continue block12;
                    }
                    case NEED_UNWRAP: {
                        ByteBuffer readableDataIn = this.streamInManager.prepareForRead(0);
                        ByteBuffer appData = this.appDataManager.prepareForWrite(this.engine.getSession().getApplicationBufferSize());
                        logger.trace("{} Unwrapping: {} to {}", new Object[]{this, readableDataIn, appData});
                        SSLEngineResult handshakeResponseResult = this.engine.unwrap(readableDataIn, appData);
                        logger.trace("{} Handshake response after unwrapping: {}", (Object)this, (Object)handshakeResponseResult);
                        if (handshakeResponseResult.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                            ByteBuffer writableDataIn = this.streamInManager.prepareForWrite(this.engine.getSession().getPacketBufferSize());
                            int bytesRead = this.readData(writableDataIn);
                            if (bytesRead > 0) {
                                logger.trace("{} Read {} bytes for handshake", (Object)this, (Object)bytesRead);
                            }
                            if (bytesRead >= 0) continue block12;
                            throw new SSLHandshakeException("Reached End-of-File marker while performing handshake");
                        }
                        if (handshakeResponseResult.getStatus() == SSLEngineResult.Status.CLOSED) {
                            throw new IOException("Channel was closed by peer during handshake");
                        }
                        this.streamInManager.compact();
                        this.appDataManager.clear();
                        break;
                    }
                    case NEED_TASK: {
                        this.performTasks();
                        continue block12;
                    }
                    case NOT_HANDSHAKING: {
                        return;
                    }
                }
            }
        }
        finally {
            this.handshaking = false;
        }
    }

    private void performTasks() {
        Runnable runnable;
        while ((runnable = this.engine.getDelegatedTask()) != null) {
            runnable.run();
        }
    }

    private void closeQuietly(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void consume() throws IOException {
        int readCount;
        this.channel.shutdownInput();
        byte[] b = new byte[4096];
        ByteBuffer buffer = ByteBuffer.wrap(b);
        do {
            readCount = this.channel.read(buffer);
            buffer.flip();
        } while (readCount > 0);
    }

    private int readData(ByteBuffer dest) throws IOException {
        int readCount;
        long startTime = System.currentTimeMillis();
        while (true) {
            if (this.interrupted) {
                throw new TransmissionDisabledException();
            }
            if (dest.remaining() == 0) {
                return 0;
            }
            readCount = this.channel.read(dest);
            long sleepNanos = 1L;
            if (readCount != 0) break;
            if (System.currentTimeMillis() > startTime + (long)this.timeoutMillis) {
                throw new SocketTimeoutException("Timed out reading from socket connected to " + this.hostname + ":" + this.port);
            }
            try {
                TimeUnit.NANOSECONDS.sleep(sleepNanos);
            }
            catch (InterruptedException e) {
                this.close();
                Thread.currentThread().interrupt();
                throw new ClosedByInterruptException();
            }
            sleepNanos = Math.min(sleepNanos * 2L, BUFFER_FULL_EMPTY_WAIT_NANOS);
        }
        logger.trace("{} Read {} bytes", (Object)this, (Object)readCount);
        return readCount;
    }

    private SSLEngineResult.Status encryptAndWriteFully(BufferStateManager src) throws IOException {
        SSLEngineResult result = null;
        ByteBuffer buff = src.prepareForRead(0);
        ByteBuffer outBuff = this.streamOutManager.prepareForWrite(this.engine.getSession().getApplicationBufferSize());
        logger.trace("{} Encrypting {} bytes", (Object)this, (Object)buff.remaining());
        while (buff.remaining() > 0) {
            result = this.engine.wrap(buff, outBuff);
            if (result.getStatus() == SSLEngineResult.Status.OK) {
                ByteBuffer readableOutBuff = this.streamOutManager.prepareForRead(0);
                this.writeFully(readableOutBuff);
                this.streamOutManager.clear();
                continue;
            }
            return result.getStatus();
        }
        return result.getStatus();
    }

    private void writeFully(ByteBuffer src) throws IOException {
        long lastByteWrittenTime = System.currentTimeMillis();
        int bytesWritten = 0;
        while (src.hasRemaining()) {
            if (this.interrupted) {
                throw new TransmissionDisabledException();
            }
            int written = this.channel.write(src);
            bytesWritten += written;
            long now = System.currentTimeMillis();
            long sleepNanos = 1L;
            if (written > 0) {
                lastByteWrittenTime = now;
                continue;
            }
            if (now > lastByteWrittenTime + (long)this.timeoutMillis) {
                throw new SocketTimeoutException("Timed out writing to socket connected to " + this.hostname + ":" + this.port);
            }
            try {
                TimeUnit.NANOSECONDS.sleep(sleepNanos);
            }
            catch (InterruptedException e) {
                this.close();
                Thread.currentThread().interrupt();
                throw new ClosedByInterruptException();
            }
            sleepNanos = Math.min(sleepNanos * 2L, BUFFER_FULL_EMPTY_WAIT_NANOS);
        }
        logger.trace("{} Wrote {} bytes", (Object)this, (Object)bytesWritten);
    }

    public boolean isClosed() {
        block11: {
            if (this.closed) {
                return true;
            }
            ByteBuffer writableInBuffer = this.streamInManager.prepareForWrite(this.engine.getSession().getPacketBufferSize());
            int readCount = 0;
            try {
                readCount = this.channel.read(writableInBuffer);
            }
            catch (IOException e) {
                logger.error("{} Failed to readData due to {}", new Object[]{this, e});
                if (logger.isDebugEnabled()) {
                    logger.error("", (Throwable)e);
                }
                readCount = -1;
            }
            if (readCount == 0) {
                return false;
            }
            if (readCount > 0) {
                logger.trace("{} Read {} bytes", (Object)this, (Object)readCount);
                ByteBuffer streamInBuffer = this.streamInManager.prepareForRead(1);
                ByteBuffer appDataBuffer = this.appDataManager.prepareForWrite(this.engine.getSession().getApplicationBufferSize());
                try {
                    SSLEngineResult unwrapResponse = this.engine.unwrap(streamInBuffer, appDataBuffer);
                    logger.trace("{} When checking if closed, (handshake={}) Unwrap response: {}", new Object[]{this, this.handshaking, unwrapResponse});
                    if (unwrapResponse.getStatus().equals((Object)SSLEngineResult.Status.CLOSED)) {
                        ByteBuffer discardBuffer = ByteBuffer.allocate(8192);
                        int bytesDiscarded = this.channel.read(discardBuffer);
                        while (bytesDiscarded > 0) {
                            discardBuffer.clear();
                            bytesDiscarded = this.channel.read(discardBuffer);
                        }
                    } else {
                        this.streamInManager.compact();
                        return false;
                    }
                    this.engine.closeInbound();
                }
                catch (IOException e) {
                    logger.error("{} Failed to check if closed due to {}. Closing channel.", new Object[]{this, e});
                    if (!logger.isDebugEnabled()) break block11;
                    logger.error("", (Throwable)e);
                }
            }
        }
        this.closeQuietly(this.channel.socket());
        this.closeQuietly(this.channel);
        this.closed = true;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        logger.debug("{} Closing Connection", (Object)this);
        if (this.channel == null) {
            return;
        }
        if (this.closed) {
            return;
        }
        try {
            this.engine.closeOutbound();
            byte[] emptyMessage = new byte[]{};
            ByteBuffer appDataOut = ByteBuffer.wrap(emptyMessage);
            ByteBuffer outboundBuffer = this.streamOutManager.prepareForWrite(this.engine.getSession().getApplicationBufferSize());
            SSLEngineResult handshakeResult = this.engine.wrap(appDataOut, outboundBuffer);
            if (handshakeResult.getStatus() != SSLEngineResult.Status.CLOSED) {
                throw new IOException("Invalid close state - will not send network data");
            }
            ByteBuffer readableStreamOut = this.streamOutManager.prepareForRead(1);
            this.writeFully(readableStreamOut);
        }
        finally {
            ByteBuffer discardBuffer = ByteBuffer.allocate(8192);
            try {
                int bytesDiscarded = this.channel.read(discardBuffer);
                while (bytesDiscarded > 0) {
                    discardBuffer.clear();
                    bytesDiscarded = this.channel.read(discardBuffer);
                }
            }
            catch (Exception exception) {}
            this.closeQuietly(this.channel.socket());
            this.closeQuietly(this.channel);
            this.closed = true;
        }
    }

    private int copyFromAppDataBuffer(byte[] buffer, int offset, int len) {
        ByteBuffer appDataBuffer = this.appDataManager.prepareForRead(1);
        int appDataRemaining = appDataBuffer.remaining();
        if (appDataRemaining > 0) {
            int bytesToCopy = Math.min(len, appDataBuffer.remaining());
            appDataBuffer.get(buffer, offset, bytesToCopy);
            int bytesCopied = appDataRemaining - appDataBuffer.remaining();
            logger.trace("{} Copied {} ({}) bytes from unencrypted application buffer to user space", new Object[]{this, bytesToCopy, bytesCopied});
            return bytesCopied;
        }
        return 0;
    }

    public int available() throws IOException {
        ByteBuffer appDataBuffer = this.appDataManager.prepareForRead(1);
        ByteBuffer streamDataBuffer = this.streamInManager.prepareForRead(1);
        int buffered = appDataBuffer.remaining() + streamDataBuffer.remaining();
        if (buffered > 0) {
            return buffered;
        }
        boolean wasAbleToRead = this.isDataAvailable();
        if (!wasAbleToRead) {
            return 0;
        }
        appDataBuffer = this.appDataManager.prepareForRead(1);
        streamDataBuffer = this.streamInManager.prepareForRead(1);
        return appDataBuffer.remaining() + streamDataBuffer.remaining();
    }

    public boolean isDataAvailable() throws IOException {
        ByteBuffer appDataBuffer = this.appDataManager.prepareForRead(1);
        ByteBuffer streamDataBuffer = this.streamInManager.prepareForRead(1);
        if (appDataBuffer.remaining() > 0 || streamDataBuffer.remaining() > 0) {
            return true;
        }
        ByteBuffer writableBuffer = this.streamInManager.prepareForWrite(this.engine.getSession().getPacketBufferSize());
        int bytesRead = this.channel.read(writableBuffer);
        return bytesRead > 0;
    }

    public int read() throws IOException {
        int bytesRead = this.read(this.oneByteBuffer);
        if (bytesRead == -1) {
            return -1;
        }
        return this.oneByteBuffer[0] & 0xFF;
    }

    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    public int read(byte[] buffer, int offset, int len) throws IOException {
        int copied;
        logger.debug("{} Reading up to {} bytes of data", (Object)this, (Object)len);
        if (!this.connected) {
            this.connect();
        }
        if ((copied = this.copyFromAppDataBuffer(buffer, offset, len)) > 0) {
            return copied;
        }
        this.appDataManager.clear();
        block6: while (true) {
            ByteBuffer streamInBuffer = this.streamInManager.prepareForRead(1);
            SSLEngineResult unwrapResponse = null;
            ByteBuffer appDataBuffer = this.appDataManager.prepareForWrite(this.engine.getSession().getApplicationBufferSize());
            unwrapResponse = this.engine.unwrap(streamInBuffer, appDataBuffer);
            logger.trace("{} When reading data, (handshake={}) Unwrap response: {}", new Object[]{this, this.handshaking, unwrapResponse});
            switch (unwrapResponse.getStatus()) {
                case BUFFER_OVERFLOW: {
                    throw new SSLHandshakeException("Buffer Overflow, which is not allowed to happen from an unwrap");
                }
                case BUFFER_UNDERFLOW: {
                    ByteBuffer writableInBuffer = this.streamInManager.prepareForWrite(this.engine.getSession().getPacketBufferSize());
                    int bytesRead = this.readData(writableInBuffer);
                    if (bytesRead >= 0) continue block6;
                    return -1;
                }
                case CLOSED: {
                    throw new IOException("Channel is closed");
                }
                case OK: {
                    copied = this.copyFromAppDataBuffer(buffer, offset, len);
                    if (copied == 0) {
                        throw new IOException("Failed to decrypt data");
                    }
                    this.streamInManager.compact();
                    return copied;
                }
            }
        }
    }

    public void write(int data) throws IOException {
        this.write(new byte[]{(byte)data}, 0, 1);
    }

    public void write(byte[] data) throws IOException {
        this.write(data, 0, data.length);
    }

    public void write(byte[] data, int offset, int len) throws IOException {
        logger.debug("{} Writing {} bytes of data", (Object)this, (Object)len);
        if (!this.connected) {
            this.connect();
        }
        int iterations = len / 65536;
        if (len % 65536 > 0) {
            ++iterations;
        }
        block6: for (int i = 0; i < iterations; ++i) {
            this.streamOutManager.clear();
            int itrOffset = offset + i * 65536;
            int itrLen = Math.min(len - itrOffset, 65536);
            ByteBuffer byteBuffer = ByteBuffer.wrap(data, itrOffset, itrLen);
            BufferStateManager buffMan = new BufferStateManager(byteBuffer, BufferStateManager.Direction.READ);
            SSLEngineResult.Status status = this.encryptAndWriteFully(buffMan);
            switch (status) {
                case BUFFER_OVERFLOW: {
                    this.streamOutManager.ensureSize(this.engine.getSession().getPacketBufferSize());
                    this.appDataManager.ensureSize(this.engine.getSession().getApplicationBufferSize());
                    continue block6;
                }
                case OK: {
                    continue block6;
                }
                case CLOSED: {
                    throw new IOException("Channel is closed");
                }
                case BUFFER_UNDERFLOW: {
                    throw new AssertionError((Object)"Got Buffer Underflow but should not have...");
                }
            }
        }
    }

    public void interrupt() {
        this.interrupted = true;
    }
}

