/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.InvalidJsonException;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.behavior.EventDriven;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.ProcessorLog;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.io.OutputStreamCallback;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.standard.AbstractJsonPathProcessor;

@EventDriven
@SideEffectFree
@SupportsBatching
@Tags(value={"json", "split", "jsonpath"})
@CapabilityDescription(value="Splits a JSON File into multiple, separate FlowFiles for an array element specified by a JsonPath expression. Each generated FlowFile is comprised of an element of the specified array and transferred to relationship 'split,' with the original file transferred to the 'original' relationship. If the specified JsonPath is not found or does not evaluate to an array element, the original file is routed to 'failure' and no files are generated.")
public class SplitJson
extends AbstractJsonPathProcessor {
    public static final PropertyDescriptor ARRAY_JSON_PATH_EXPRESSION = new PropertyDescriptor.Builder().name("JsonPath Expression").description("A JsonPath expression that indicates the array element to split into JSON/scalar fragments.").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).required(true).build();
    public static final Relationship REL_ORIGINAL = new Relationship.Builder().name("original").description("The original FlowFile that was split into segments. If the FlowFile fails processing, nothing will be sent to this relationship").build();
    public static final Relationship REL_SPLIT = new Relationship.Builder().name("split").description("All segments of the original FlowFile will be routed to this relationship").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("If a FlowFile fails processing for any reason (for example, the FlowFile is not valid JSON or the specified path does not exist), it will be routed to this relationship").build();
    private List<PropertyDescriptor> properties;
    private Set<Relationship> relationships;
    private final AtomicReference<JsonPath> JSON_PATH_REF = new AtomicReference();

    protected void init(ProcessorInitializationContext context) {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(ARRAY_JSON_PATH_EXPRESSION);
        properties.add(NULL_VALUE_DEFAULT_REPRESENTATION);
        this.properties = Collections.unmodifiableList(properties);
        HashSet<Relationship> relationships = new HashSet<Relationship>();
        relationships.add(REL_ORIGINAL);
        relationships.add(REL_SPLIT);
        relationships.add(REL_FAILURE);
        this.relationships = Collections.unmodifiableSet(relationships);
    }

    public Set<Relationship> getRelationships() {
        return this.relationships;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.properties;
    }

    public void onPropertyModified(PropertyDescriptor descriptor, String oldValue, String newValue) {
        if (descriptor.equals((Object)ARRAY_JSON_PATH_EXPRESSION) && !StringUtils.equals((CharSequence)oldValue, (CharSequence)newValue) && oldValue != null) {
            this.JSON_PATH_REF.set(null);
        }
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        AbstractJsonPathProcessor.JsonPathValidator validator = new AbstractJsonPathProcessor.JsonPathValidator(){

            @Override
            public void cacheComputedValue(String subject, String input, JsonPath computedJson) {
                SplitJson.this.JSON_PATH_REF.set(computedJson);
            }

            @Override
            public boolean isStale(String subject, String input) {
                return SplitJson.this.JSON_PATH_REF.get() == null;
            }
        };
        String value = validationContext.getProperty(ARRAY_JSON_PATH_EXPRESSION).getValue();
        return Collections.singleton(validator.validate(ARRAY_JSON_PATH_EXPRESSION.getName(), value, validationContext));
    }

    public void onTrigger(ProcessContext processContext, ProcessSession processSession) {
        Object jsonPathResult;
        FlowFile original = processSession.get();
        if (original == null) {
            return;
        }
        ProcessorLog logger = this.getLogger();
        DocumentContext documentContext = null;
        try {
            documentContext = SplitJson.validateAndEstablishJsonContext(processSession, original);
        }
        catch (InvalidJsonException e) {
            logger.error("FlowFile {} did not have valid JSON content.", new Object[]{original});
            processSession.transfer(original, REL_FAILURE);
            return;
        }
        JsonPath jsonPath = this.JSON_PATH_REF.get();
        String representationOption = processContext.getProperty(NULL_VALUE_DEFAULT_REPRESENTATION).getValue();
        final String nullDefaultValue = (String)NULL_REPRESENTATION_MAP.get(representationOption);
        ArrayList<FlowFile> segments = new ArrayList<FlowFile>();
        try {
            jsonPathResult = documentContext.read(jsonPath);
        }
        catch (PathNotFoundException e) {
            logger.warn("JsonPath {} could not be found for FlowFile {}", new Object[]{jsonPath.getPath(), original});
            processSession.transfer(original, REL_FAILURE);
            return;
        }
        if (!(jsonPathResult instanceof List)) {
            logger.error("The evaluated value {} of {} was not a JSON Array compatible type and cannot be split.", new Object[]{jsonPathResult, jsonPath.getPath()});
            processSession.transfer(original, REL_FAILURE);
            return;
        }
        List resultList = (List)jsonPathResult;
        for (final Object resultSegment : resultList) {
            FlowFile split = processSession.create(original);
            split = processSession.write(split, new OutputStreamCallback(){

                public void process(OutputStream out) throws IOException {
                    String resultSegmentContent = AbstractJsonPathProcessor.getResultRepresentation(resultSegment, nullDefaultValue);
                    out.write(resultSegmentContent.getBytes(StandardCharsets.UTF_8));
                }
            });
            segments.add(split);
        }
        processSession.transfer(segments, REL_SPLIT);
        processSession.transfer(original, REL_ORIGINAL);
        logger.info("Split {} into {} FlowFiles", new Object[]{original, segments.size()});
    }
}

