/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.util;

import com.jayway.jsonpath.Filter;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.internal.Utils;
import com.jayway.jsonpath.internal.token.ArrayPathToken;
import com.jayway.jsonpath.internal.token.PathToken;
import com.jayway.jsonpath.internal.token.PredicatePathToken;
import com.jayway.jsonpath.internal.token.PropertyPathToken;
import com.jayway.jsonpath.internal.token.RootPathToken;
import com.jayway.jsonpath.internal.token.ScanPathToken;
import com.jayway.jsonpath.internal.token.WildcardPathToken;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.regex.Pattern;
import org.apache.nifi.util.StringUtils;

public class JsonPathExpressionValidator {
    private static final String PROPERTY_OPEN = "['";
    private static final String PROPERTY_CLOSE = "']";
    private static final char DOCUMENT = '$';
    private static final char ANY = '*';
    private static final char PERIOD = '.';
    private static final char BRACKET_OPEN = '[';
    private static final char BRACKET_CLOSE = ']';
    private static final char SPACE = ' ';

    public static boolean isValidExpression(String path, Predicate ... filters) {
        if (StringUtils.isBlank((String)(path = path.trim()))) {
            return false;
        }
        if (path.endsWith("..")) {
            return false;
        }
        LinkedList<Predicate> filterList = new LinkedList<Predicate>(Arrays.asList(filters));
        if (path.charAt(0) != '$' && path.charAt(0) != '@') {
            path = "$." + path;
        }
        if (path.charAt(0) == '@') {
            path = "$" + path.substring(1);
        }
        if (path.length() > 1 && path.charAt(1) != '.' && path.charAt(1) != '[') {
            return false;
        }
        RootPathToken root = null;
        int i = 0;
        String fragment = "";
        block7: do {
            char current = path.charAt(i);
            switch (current) {
                case ' ': {
                    return false;
                }
                case '$': {
                    fragment = "$";
                    ++i;
                    break;
                }
                case '[': {
                    int positions = JsonPathExpressionValidator.fastForwardUntilClosed(path, i);
                    fragment = path.substring(i, i + positions);
                    i += positions;
                    break;
                }
                case '.': {
                    if (path.charAt(++i) == '.') {
                        fragment = "..";
                        ++i;
                        break;
                    }
                    int positions = JsonPathExpressionValidator.fastForward(path, i);
                    if (positions == 0) continue block7;
                    fragment = positions == 1 && path.charAt(i) == '*' ? "[*]" : PROPERTY_OPEN + path.substring(i, i + positions) + PROPERTY_CLOSE;
                    i += positions;
                    break;
                }
                case '*': {
                    fragment = "[*]";
                    ++i;
                    break;
                }
                default: {
                    int positions = JsonPathExpressionValidator.fastForward(path, i);
                    fragment = PROPERTY_OPEN + path.substring(i, i + positions) + PROPERTY_CLOSE;
                    i += positions;
                }
            }
            PathToken analyzedComponent = PathComponentAnalyzer.analyze(fragment, filterList);
            if (analyzedComponent == null) {
                return false;
            }
            if (root == null) {
                root = (RootPathToken)analyzedComponent;
                continue;
            }
            root.append(analyzedComponent);
        } while (i < path.length());
        return true;
    }

    private static int fastForward(String s, int index) {
        char current;
        int skipCount = 0;
        while (index < s.length() && (current = s.charAt(index)) != '.' && current != '[' && current != ' ') {
            ++index;
            ++skipCount;
        }
        return skipCount;
    }

    private static int fastForwardUntilClosed(String s, int index) {
        int skipCount = 0;
        int nestedBrackets = 0;
        ++index;
        ++skipCount;
        while (index < s.length()) {
            char current = s.charAt(index);
            ++index;
            ++skipCount;
            if (current == ']' && nestedBrackets == 0) break;
            if (current == '[') {
                ++nestedBrackets;
            }
            if (current != ']') continue;
            --nestedBrackets;
        }
        return skipCount;
    }

    static class PathComponentAnalyzer {
        private static final Pattern FILTER_PATTERN = Pattern.compile("^\\[\\s*\\?\\s*[,\\s*\\?]*?\\s*]$");
        private int i;
        private char current;
        private final LinkedList<Predicate> filterList;
        private final String pathFragment;

        PathComponentAnalyzer(String pathFragment, LinkedList<Predicate> filterList) {
            this.pathFragment = pathFragment;
            this.filterList = filterList;
        }

        static PathToken analyze(String pathFragment, LinkedList<Predicate> filterList) {
            return new PathComponentAnalyzer(pathFragment, filterList).analyze();
        }

        public PathToken analyze() {
            if ("$".equals(this.pathFragment)) {
                return new RootPathToken();
            }
            if ("..".equals(this.pathFragment)) {
                return new ScanPathToken();
            }
            if ("[*]".equals(this.pathFragment)) {
                return new WildcardPathToken();
            }
            if (".*".equals(this.pathFragment)) {
                return new WildcardPathToken();
            }
            if ("[?]".equals(this.pathFragment)) {
                return new PredicatePathToken(this.filterList.poll());
            }
            if (FILTER_PATTERN.matcher(this.pathFragment).matches()) {
                int criteriaCount = Utils.countMatches((CharSequence)this.pathFragment, (CharSequence)"?");
                ArrayList<Predicate> filters = new ArrayList<Predicate>(criteriaCount);
                for (int i = 0; i < criteriaCount; ++i) {
                    filters.add(this.filterList.poll());
                }
                return new PredicatePathToken(filters);
            }
            this.i = 0;
            do {
                this.current = this.pathFragment.charAt(this.i);
                switch (this.current) {
                    case '?': {
                        return this.analyzeCriteriaSequence4();
                    }
                    case '\'': {
                        return this.analyzeProperty();
                    }
                }
                if (Character.isDigit(this.current) || this.current == ':' || this.current == '-' || this.current == '@') {
                    return this.analyzeArraySequence();
                }
                ++this.i;
            } while (this.i < this.pathFragment.length());
            return null;
        }

        public PathToken analyzeCriteriaSequence4() {
            int[] bounds = this.findFilterBounds();
            if (bounds == null) {
                return null;
            }
            this.i = bounds[1];
            return new PredicatePathToken((Predicate)Filter.parse((String)this.pathFragment.substring(bounds[0], bounds[1])));
        }

        int[] findFilterBounds() {
            int end = 0;
            int start = this.i;
            while (this.pathFragment.charAt(start) != '[') {
                --start;
            }
            int mem = 32;
            int curr = start;
            boolean inProp = false;
            int openSquareBracket = 0;
            int openBrackets = 0;
            while (end == 0) {
                char c = this.pathFragment.charAt(curr);
                switch (c) {
                    case '(': {
                        if (inProp) break;
                        ++openBrackets;
                        break;
                    }
                    case ')': {
                        if (inProp) break;
                        --openBrackets;
                        break;
                    }
                    case '[': {
                        if (inProp) break;
                        ++openSquareBracket;
                        break;
                    }
                    case ']': {
                        if (inProp) break;
                        --openSquareBracket;
                        if (openBrackets != 0) break;
                        end = curr + 1;
                        break;
                    }
                    case '\'': {
                        if (mem == 92) break;
                        inProp = !inProp;
                        break;
                    }
                }
                mem = c;
                ++curr;
            }
            if (openBrackets != 0 || openSquareBracket != 0) {
                return null;
            }
            return new int[]{start, end};
        }

        private PathToken analyzeProperty() {
            ArrayList<String> properties = new ArrayList<String>();
            StringBuilder buffer = new StringBuilder();
            boolean propertyIsOpen = false;
            while (this.current != ']') {
                switch (this.current) {
                    case '\'': {
                        if (propertyIsOpen) {
                            properties.add(buffer.toString());
                            buffer.setLength(0);
                            propertyIsOpen = false;
                            break;
                        }
                        propertyIsOpen = true;
                        break;
                    }
                    default: {
                        if (!propertyIsOpen) break;
                        buffer.append(this.current);
                    }
                }
                this.current = this.pathFragment.charAt(++this.i);
            }
            return new PropertyPathToken(properties);
        }

        private PathToken analyzeArraySequence() {
            StringBuilder buffer = new StringBuilder();
            ArrayList<Integer> numbers = new ArrayList<Integer>();
            boolean contextSize = this.current == '@';
            boolean sliceTo = false;
            boolean sliceFrom = false;
            boolean sliceBetween = false;
            boolean indexSequence = false;
            boolean singleIndex = false;
            if (contextSize) {
                this.current = this.pathFragment.charAt(++this.i);
                this.current = this.pathFragment.charAt(++this.i);
                while (this.current != '-') {
                    if (this.current == ' ' || this.current == '(' || this.current == ')') {
                        this.current = this.pathFragment.charAt(++this.i);
                        continue;
                    }
                    buffer.append(this.current);
                    this.current = this.pathFragment.charAt(++this.i);
                }
                String function = buffer.toString();
                buffer.setLength(0);
                if (!function.equals("size") && !function.equals("length")) {
                    return null;
                }
                while (this.current != ')') {
                    if (this.current == ' ') {
                        this.current = this.pathFragment.charAt(++this.i);
                        continue;
                    }
                    buffer.append(this.current);
                    this.current = this.pathFragment.charAt(++this.i);
                }
            } else {
                while (Character.isDigit(this.current) || this.current == ',' || this.current == ' ' || this.current == ':' || this.current == '-') {
                    switch (this.current) {
                        case ' ': {
                            break;
                        }
                        case ':': {
                            if (buffer.length() == 0) {
                                sliceTo = true;
                                this.current = this.pathFragment.charAt(++this.i);
                                while (Character.isDigit(this.current) || this.current == ' ' || this.current == '-') {
                                    if (this.current != ' ') {
                                        buffer.append(this.current);
                                    }
                                    this.current = this.pathFragment.charAt(++this.i);
                                }
                                numbers.add(Integer.parseInt(buffer.toString()));
                                buffer.setLength(0);
                                break;
                            }
                            numbers.add(Integer.parseInt(buffer.toString()));
                            buffer.setLength(0);
                            this.current = this.pathFragment.charAt(++this.i);
                            while (Character.isDigit(this.current) || this.current == ' ' || this.current == '-') {
                                if (this.current != ' ') {
                                    buffer.append(this.current);
                                }
                                this.current = this.pathFragment.charAt(++this.i);
                            }
                            if (buffer.length() == 0) {
                                sliceFrom = true;
                                break;
                            }
                            sliceBetween = true;
                            numbers.add(Integer.parseInt(buffer.toString()));
                            buffer.setLength(0);
                            break;
                        }
                        case ',': {
                            numbers.add(Integer.parseInt(buffer.toString()));
                            buffer.setLength(0);
                            indexSequence = true;
                            break;
                        }
                        default: {
                            buffer.append(this.current);
                        }
                    }
                    if (this.current != ']') {
                        this.current = this.pathFragment.charAt(++this.i);
                        continue;
                    }
                    break;
                }
            }
            if (buffer.length() > 0) {
                numbers.add(Integer.parseInt(buffer.toString()));
            }
            singleIndex = numbers.size() == 1 && !sliceTo && !sliceFrom && !contextSize;
            ArrayPathToken.Operation operation = null;
            if (singleIndex) {
                operation = ArrayPathToken.Operation.SINGLE_INDEX;
            } else if (indexSequence) {
                operation = ArrayPathToken.Operation.INDEX_SEQUENCE;
            } else if (sliceFrom) {
                operation = ArrayPathToken.Operation.SLICE_FROM;
            } else if (sliceTo) {
                operation = ArrayPathToken.Operation.SLICE_TO;
            } else if (sliceBetween) {
                operation = ArrayPathToken.Operation.SLICE_BETWEEN;
            } else if (contextSize) {
                operation = ArrayPathToken.Operation.CONTEXT_SIZE;
            }
            assert (operation != null);
            return new ArrayPathToken(numbers, operation);
        }
    }
}

