/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.InvalidJsonException;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.behavior.EventDriven;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnRemoved;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.ProcessorLog;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.io.OutputStreamCallback;
import org.apache.nifi.processors.standard.AbstractJsonPathProcessor;
import org.apache.nifi.stream.io.BufferedOutputStream;
import org.apache.nifi.util.ObjectHolder;

@EventDriven
@SideEffectFree
@SupportsBatching
@Tags(value={"JSON", "evaluate", "JsonPath"})
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@CapabilityDescription(value="Evaluates one or more JsonPath expressions against the content of a FlowFile. The results of those expressions are assigned to FlowFile Attributes or are written to the content of the FlowFile itself, depending on configuration of the Processor. JsonPaths are entered by adding user-defined properties; the name of the property maps to the Attribute Name into which the result will be placed (if the Destination is flowfile-attribute; otherwise, the property name is ignored). The value of the property must be a valid JsonPath expression. A Return Type of 'auto-detect' will make a determination based off the configured destination. When 'Destination' is set to 'flowfile-attribute,' a return type of 'scalar' will be used. When 'Destination' is set to 'flowfile-content,' a return type of 'JSON' will be used.If the JsonPath evaluates to a JSON array or JSON object and the Return Type is set to 'scalar' the FlowFile will be unmodified and will be routed to failure. A Return Type of JSON can return scalar values if the provided JsonPath evaluates to the specified value and will be routed as a match.If Destination is 'flowfile-content' and the JsonPath does not evaluate to a defined path, the FlowFile will be routed to 'unmatched' without having its contents modified. If Destination is flowfile-attribute and the expression matches nothing, attributes will be created with empty strings as the value, and the FlowFile will always be routed to 'matched.'")
@DynamicProperty(name="A FlowFile attribute(if <Destination> is set to 'flowfile-attribute')", value="A JsonPath expression", description="If <Destination>='flowfile-attribute' then that FlowFile attribute will be set to any JSON objects that match the JsonPath.  If <Destination>='flowfile-content' then the FlowFile content will be updated to any JSON objects that match the JsonPath.")
public class EvaluateJsonPath
extends AbstractJsonPathProcessor {
    public static final String DESTINATION_ATTRIBUTE = "flowfile-attribute";
    public static final String DESTINATION_CONTENT = "flowfile-content";
    public static final String RETURN_TYPE_AUTO = "auto-detect";
    public static final String RETURN_TYPE_JSON = "json";
    public static final String RETURN_TYPE_SCALAR = "scalar";
    public static final String PATH_NOT_FOUND_IGNORE = "ignore";
    public static final String PATH_NOT_FOUND_WARN = "warn";
    public static final PropertyDescriptor DESTINATION = new PropertyDescriptor.Builder().name("Destination").description("Indicates whether the results of the JsonPath evaluation are written to the FlowFile content or a FlowFile attribute; if using attribute, must specify the Attribute Name property. If set to flowfile-content, only one JsonPath may be specified, and the property name is ignored.").required(true).allowableValues(new String[]{"flowfile-content", "flowfile-attribute"}).defaultValue("flowfile-content").build();
    public static final PropertyDescriptor RETURN_TYPE = new PropertyDescriptor.Builder().name("Return Type").description("Indicates the desired return type of the JSON Path expressions.  Selecting 'auto-detect' will set the return type to 'json' for a Destination of 'flowfile-content', and 'scalar' for a Destination of 'flowfile-attribute'.").required(true).allowableValues(new String[]{"auto-detect", "json", "scalar"}).defaultValue("auto-detect").build();
    public static final PropertyDescriptor PATH_NOT_FOUND = new PropertyDescriptor.Builder().name("Path Not Found Behavior").description("Indicates how to handle missing JSON path expressions when destination is set to 'flowfile-attribute'. Selecting 'warn' will generate a warning when a JSON path expression is not found.").required(true).allowableValues(new String[]{"warn", "ignore"}).defaultValue("ignore").build();
    public static final Relationship REL_MATCH = new Relationship.Builder().name("matched").description("FlowFiles are routed to this relationship when the JsonPath is successfully evaluated and the FlowFile is modified as a result").build();
    public static final Relationship REL_NO_MATCH = new Relationship.Builder().name("unmatched").description("FlowFiles are routed to this relationship when the JsonPath does not match the content of the FlowFile and the Destination is set to flowfile-content").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("FlowFiles are routed to this relationship when the JsonPath cannot be evaluated against the content of the FlowFile; for instance, if the FlowFile is not valid JSON").build();
    private Set<Relationship> relationships;
    private List<PropertyDescriptor> properties;
    private final ConcurrentMap<String, JsonPath> cachedJsonPathMap = new ConcurrentHashMap<String, JsonPath>();

    protected void init(ProcessorInitializationContext context) {
        HashSet<Relationship> relationships = new HashSet<Relationship>();
        relationships.add(REL_MATCH);
        relationships.add(REL_NO_MATCH);
        relationships.add(REL_FAILURE);
        this.relationships = Collections.unmodifiableSet(relationships);
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(DESTINATION);
        properties.add(RETURN_TYPE);
        properties.add(PATH_NOT_FOUND);
        properties.add(NULL_VALUE_DEFAULT_REPRESENTATION);
        this.properties = Collections.unmodifiableList(properties);
    }

    protected Collection<ValidationResult> customValidate(ValidationContext context) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>(super.customValidate(context));
        String destination = context.getProperty(DESTINATION).getValue();
        if (DESTINATION_CONTENT.equals(destination)) {
            int jsonPathCount = 0;
            for (PropertyDescriptor desc : context.getProperties().keySet()) {
                if (!desc.isDynamic()) continue;
                ++jsonPathCount;
            }
            if (jsonPathCount != 1) {
                results.add(new ValidationResult.Builder().subject("JsonPaths").valid(false).explanation("Exactly one JsonPath must be set if using destination of flowfile-content").build());
            }
        }
        return results;
    }

    public Set<Relationship> getRelationships() {
        return this.relationships;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.properties;
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return new PropertyDescriptor.Builder().name(propertyDescriptorName).expressionLanguageSupported(false).addValidator((Validator)new AbstractJsonPathProcessor.JsonPathValidator(){

            @Override
            public void cacheComputedValue(String subject, String input, JsonPath computedJsonPath) {
                EvaluateJsonPath.this.cachedJsonPathMap.put(input, computedJsonPath);
            }

            @Override
            public boolean isStale(String subject, String input) {
                return EvaluateJsonPath.this.cachedJsonPathMap.get(input) == null;
            }
        }).required(false).dynamic(true).build();
    }

    public void onPropertyModified(PropertyDescriptor descriptor, String oldValue, String newValue) {
        if (descriptor.isDynamic() && !StringUtils.equals((CharSequence)oldValue, (CharSequence)newValue) && oldValue != null) {
            this.cachedJsonPathMap.remove(oldValue);
        }
    }

    @OnRemoved
    public void onRemoved(ProcessContext processContext) {
        for (PropertyDescriptor propertyDescriptor : this.getPropertyDescriptors()) {
            if (!propertyDescriptor.isDynamic()) continue;
            this.cachedJsonPathMap.remove(processContext.getProperty(propertyDescriptor).getValue());
        }
    }

    public void onTrigger(ProcessContext processContext, ProcessSession processSession) throws ProcessException {
        FlowFile flowFile = processSession.get();
        if (flowFile == null) {
            return;
        }
        ProcessorLog logger = this.getLogger();
        String representationOption = processContext.getProperty(NULL_VALUE_DEFAULT_REPRESENTATION).getValue();
        String nullDefaultValue = (String)NULL_REPRESENTATION_MAP.get(representationOption);
        HashMap<String, JsonPath> attributeToJsonPathMap = new HashMap<String, JsonPath>();
        for (Map.Entry entry : processContext.getProperties().entrySet()) {
            if (!((PropertyDescriptor)entry.getKey()).isDynamic()) continue;
            JsonPath jsonPath = JsonPath.compile((String)((String)entry.getValue()), (Predicate[])new Predicate[0]);
            attributeToJsonPathMap.put(((PropertyDescriptor)entry.getKey()).getName(), jsonPath);
        }
        String destination = processContext.getProperty(DESTINATION).getValue();
        String returnType = processContext.getProperty(RETURN_TYPE).getValue();
        if (returnType.equals(RETURN_TYPE_AUTO)) {
            returnType = destination.equals(DESTINATION_CONTENT) ? RETURN_TYPE_JSON : RETURN_TYPE_SCALAR;
        }
        DocumentContext documentContext = null;
        try {
            documentContext = EvaluateJsonPath.validateAndEstablishJsonContext(processSession, flowFile);
        }
        catch (InvalidJsonException e) {
            logger.error("FlowFile {} did not have valid JSON content.", new Object[]{flowFile});
            processSession.transfer(flowFile, REL_FAILURE);
            return;
        }
        HashMap<String, String> jsonPathResults = new HashMap<String, String>();
        for (Map.Entry attributeJsonPathEntry : attributeToJsonPathMap.entrySet()) {
            String jsonPathAttrKey = (String)attributeJsonPathEntry.getKey();
            JsonPath jsonPathExp = (JsonPath)attributeJsonPathEntry.getValue();
            String pathNotFound = processContext.getProperty(PATH_NOT_FOUND).getValue();
            ObjectHolder resultHolder = new ObjectHolder(null);
            try {
                Object result = documentContext.read(jsonPathExp);
                if (returnType.equals(RETURN_TYPE_SCALAR) && !EvaluateJsonPath.isJsonScalar(result)) {
                    logger.error("Unable to return a scalar value for the expression {} for FlowFile {}. Evaluated value was {}. Transferring to {}.", new Object[]{jsonPathExp.getPath(), flowFile.getId(), result.toString(), REL_FAILURE.getName()});
                    processSession.transfer(flowFile, REL_FAILURE);
                    return;
                }
                resultHolder.set(result);
            }
            catch (PathNotFoundException e) {
                if (pathNotFound.equals(PATH_NOT_FOUND_WARN)) {
                    logger.warn("FlowFile {} could not find path {} for attribute key {}.", new Object[]{flowFile.getId(), jsonPathExp.getPath(), jsonPathAttrKey}, (Throwable)e);
                }
                if (destination.equals(DESTINATION_ATTRIBUTE)) {
                    jsonPathResults.put(jsonPathAttrKey, "");
                    continue;
                }
                processSession.transfer(flowFile, REL_NO_MATCH);
                return;
            }
            final String resultRepresentation = EvaluateJsonPath.getResultRepresentation(resultHolder.get(), nullDefaultValue);
            switch (destination) {
                case "flowfile-attribute": {
                    jsonPathResults.put(jsonPathAttrKey, resultRepresentation);
                    break;
                }
                case "flowfile-content": {
                    flowFile = processSession.write(flowFile, new OutputStreamCallback(){

                        public void process(OutputStream out) throws IOException {
                            try (BufferedOutputStream outputStream = new BufferedOutputStream(out);){
                                outputStream.write(resultRepresentation.getBytes(StandardCharsets.UTF_8));
                            }
                        }
                    });
                    processSession.getProvenanceReporter().modifyContent(flowFile, "Replaced content with result of expression " + jsonPathExp.getPath());
                }
            }
        }
        flowFile = processSession.putAllAttributes(flowFile, jsonPathResults);
        processSession.transfer(flowFile, REL_MATCH);
    }
}

