/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.flowfile.attributes.FlowFileAttributeKey;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.util.StandardValidators;

public abstract class AbstractSyslogProcessor
extends AbstractProcessor {
    public static final AllowableValue TCP_VALUE = new AllowableValue("TCP", "TCP");
    public static final AllowableValue UDP_VALUE = new AllowableValue("UDP", "UDP");
    public static final PropertyDescriptor PROTOCOL = new PropertyDescriptor.Builder().name("Protocol").description("The protocol for Syslog communication, either TCP or UDP.").required(true).allowableValues(new AllowableValue[]{TCP_VALUE, UDP_VALUE}).defaultValue(UDP_VALUE.getValue()).build();
    public static final PropertyDescriptor PORT = new PropertyDescriptor.Builder().name("Port").description("The port for Syslog communication.").required(true).addValidator(StandardValidators.PORT_VALIDATOR).build();
    public static final PropertyDescriptor CHARSET = new PropertyDescriptor.Builder().name("Character Set").description("Specifies which character set of the Syslog messages").required(true).defaultValue("UTF-8").addValidator(StandardValidators.CHARACTER_SET_VALIDATOR).build();

    public static enum SyslogAttributes implements FlowFileAttributeKey
    {
        PRIORITY("syslog.priority"),
        SEVERITY("syslog.severity"),
        FACILITY("syslog.facility"),
        VERSION("syslog.version"),
        TIMESTAMP("syslog.timestamp"),
        HOSTNAME("syslog.hostname"),
        SENDER("syslog.sender"),
        BODY("syslog.body"),
        VALID("syslog.valid"),
        PROTOCOL("syslog.protocol"),
        PORT("syslog.port");

        private String key;

        private SyslogAttributes(String key) {
            this.key = key;
        }

        public String key() {
            return this.key;
        }
    }
}

