/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.util;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.DatumWriter;
import org.apache.commons.lang3.StringUtils;

public class JdbcCommon {
    public static long convertToAvroStream(ResultSet rs, OutputStream outStream) throws SQLException, IOException {
        Schema schema = JdbcCommon.createSchema(rs);
        GenericData.Record rec = new GenericData.Record(schema);
        GenericDatumWriter datumWriter = new GenericDatumWriter(schema);
        try (DataFileWriter dataFileWriter = new DataFileWriter((DatumWriter)datumWriter);){
            dataFileWriter.create(schema, outStream);
            ResultSetMetaData meta = rs.getMetaData();
            int nrOfColumns = meta.getColumnCount();
            long nrOfRows = 0L;
            while (rs.next()) {
                for (int i = 1; i <= nrOfColumns; ++i) {
                    int javaSqlType = meta.getColumnType(i);
                    Object value = rs.getObject(i);
                    if (value == null) {
                        rec.put(i - 1, null);
                        continue;
                    }
                    if (javaSqlType == -2 || javaSqlType == -3 || javaSqlType == -4 || javaSqlType == 2003 || javaSqlType == 2004 || javaSqlType == 2005) {
                        byte[] bytes = rs.getBytes(i);
                        ByteBuffer bb = ByteBuffer.wrap(bytes);
                        rec.put(i - 1, (Object)bb);
                        continue;
                    }
                    if (value instanceof Byte) {
                        rec.put(i - 1, (Object)((Byte)value).intValue());
                        continue;
                    }
                    if (value instanceof BigDecimal || value instanceof BigInteger) {
                        rec.put(i - 1, (Object)value.toString());
                        continue;
                    }
                    if (value instanceof Number || value instanceof Boolean) {
                        rec.put(i - 1, value);
                        continue;
                    }
                    rec.put(i - 1, (Object)value.toString());
                }
                dataFileWriter.append((Object)rec);
                ++nrOfRows;
            }
            long l = nrOfRows;
            return l;
        }
    }

    public static Schema createSchema(ResultSet rs) throws SQLException {
        ResultSetMetaData meta = rs.getMetaData();
        int nrOfColumns = meta.getColumnCount();
        String tableName = meta.getTableName(1);
        if (StringUtils.isBlank((CharSequence)tableName)) {
            tableName = "NiFi_ExecuteSQL_Record";
        }
        SchemaBuilder.FieldAssembler builder = ((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)tableName).namespace("any.data")).fields();
        block12: for (int i = 1; i <= nrOfColumns; ++i) {
            switch (meta.getColumnType(i)) {
                case -16: 
                case -15: 
                case -9: 
                case -1: 
                case 1: 
                case 12: {
                    ((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)builder.name(meta.getColumnName(i)).type().unionOf().nullBuilder().endNull()).and().stringType()).endUnion()).noDefault();
                    continue block12;
                }
                case -7: 
                case 16: {
                    ((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)builder.name(meta.getColumnName(i)).type().unionOf().nullBuilder().endNull()).and().booleanType()).endUnion()).noDefault();
                    continue block12;
                }
                case -6: 
                case 4: 
                case 5: {
                    ((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)builder.name(meta.getColumnName(i)).type().unionOf().nullBuilder().endNull()).and().intType()).endUnion()).noDefault();
                    continue block12;
                }
                case -5: {
                    ((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)builder.name(meta.getColumnName(i)).type().unionOf().nullBuilder().endNull()).and().longType()).endUnion()).noDefault();
                    continue block12;
                }
                case -8: {
                    ((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)builder.name(meta.getColumnName(i)).type().unionOf().nullBuilder().endNull()).and().stringType()).endUnion()).noDefault();
                    continue block12;
                }
                case 6: 
                case 7: {
                    ((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)builder.name(meta.getColumnName(i)).type().unionOf().nullBuilder().endNull()).and().floatType()).endUnion()).noDefault();
                    continue block12;
                }
                case 8: {
                    ((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)builder.name(meta.getColumnName(i)).type().unionOf().nullBuilder().endNull()).and().doubleType()).endUnion()).noDefault();
                    continue block12;
                }
                case 2: 
                case 3: {
                    ((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)builder.name(meta.getColumnName(i)).type().unionOf().nullBuilder().endNull()).and().stringType()).endUnion()).noDefault();
                    continue block12;
                }
                case 91: 
                case 92: 
                case 93: {
                    ((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)builder.name(meta.getColumnName(i)).type().unionOf().nullBuilder().endNull()).and().stringType()).endUnion()).noDefault();
                    continue block12;
                }
                case -4: 
                case -3: 
                case -2: 
                case 2003: 
                case 2004: 
                case 2005: {
                    ((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)builder.name(meta.getColumnName(i)).type().unionOf().nullBuilder().endNull()).and().bytesType()).endUnion()).noDefault();
                    continue block12;
                }
                default: {
                    throw new IllegalArgumentException("createSchema: Unknown SQL type " + meta.getColumnType(i) + " cannot be converted to Avro type");
                }
            }
        }
        return (Schema)builder.endRecord();
    }
}

