/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

public class NLKBufferedReader
extends BufferedReader {
    private Reader in;
    private char[] cb;
    private int nChars;
    private int nextChar;
    private static final int INVALIDATED = -2;
    private static final int UNMARKED = -1;
    private int markedChar = -1;
    private int readAheadLimit = 0;
    private static int defaultCharBufferSize = 8192;
    private static int defaultExpectedLineLength = 80;

    public NLKBufferedReader(Reader in, int sz) {
        super(in, sz);
        this.in = in;
        this.cb = new char[sz];
        this.nChars = 0;
        this.nextChar = 0;
    }

    public NLKBufferedReader(Reader in) {
        this(in, defaultCharBufferSize);
    }

    @Override
    public String readLine() throws IOException {
        StringBuffer s = null;
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            while (true) {
                int i;
                if (this.nextChar >= this.nChars) {
                    this.fill();
                }
                if (this.nextChar >= this.nChars) {
                    if (s != null && s.length() > 0) {
                        return s.toString();
                    }
                    return null;
                }
                boolean eol = false;
                char c = '\u0000';
                for (i = this.nextChar; i < this.nChars; ++i) {
                    c = this.cb[i];
                    if (c != '\n' && c != '\r') continue;
                    if (c != '\r' || this.cb.length <= i + 1 || this.cb[i + 1] == '\n') {
                        // empty if block
                    }
                    eol = true;
                    break;
                }
                int startChar = this.nextChar;
                this.nextChar = ++i;
                if (eol) {
                    String str;
                    if (s == null) {
                        str = new String(this.cb, startChar, i + 1 - startChar);
                    } else {
                        s.append(this.cb, startChar, i + 1 - startChar);
                        str = s.toString();
                    }
                    ++this.nextChar;
                    return str;
                }
                if (s == null) {
                    s = new StringBuffer(defaultExpectedLineLength);
                }
                s.append(this.cb, startChar, i - startChar);
            }
        }
    }

    private void ensureOpen() throws IOException {
        if (this.in == null) {
            throw new IOException("Stream closed");
        }
    }

    private void fill() throws IOException {
        int n;
        int dst;
        if (this.markedChar <= -1) {
            dst = 0;
        } else {
            int delta = this.nextChar - this.markedChar;
            if (delta >= this.readAheadLimit) {
                this.markedChar = -2;
                this.readAheadLimit = 0;
                dst = 0;
            } else {
                if (this.readAheadLimit <= this.cb.length) {
                    System.arraycopy(this.cb, this.markedChar, this.cb, 0, delta);
                    this.markedChar = 0;
                    dst = delta;
                } else {
                    char[] ncb = new char[this.readAheadLimit];
                    System.arraycopy(this.cb, this.markedChar, ncb, 0, delta);
                    this.cb = ncb;
                    this.markedChar = 0;
                    dst = delta;
                }
                this.nextChar = this.nChars = delta;
            }
        }
        while ((n = this.in.read(this.cb, dst, this.cb.length - dst)) == 0) {
        }
        if (n > 0) {
            this.nChars = dst + n;
            this.nextChar = dst;
        }
    }
}

