/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.behavior.EventDriven;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.ProcessorLog;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.io.InputStreamCallback;
import org.apache.nifi.processor.util.StandardValidators;
import org.eclipse.jetty.util.StringUtil;

@EventDriven
@SideEffectFree
@SupportsBatching
@Tags(value={"attributes", "logging"})
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
public class LogAttribute
extends AbstractProcessor {
    public static final PropertyDescriptor LOG_LEVEL = new PropertyDescriptor.Builder().name("Log Level").required(true).description("The Log Level to use when logging the Attributes").allowableValues((Enum[])DebugLevels.values()).defaultValue("info").build();
    public static final PropertyDescriptor ATTRIBUTES_TO_LOG_CSV = new PropertyDescriptor.Builder().name("Attributes to Log").required(false).description("A comma-separated list of Attributes to Log. If not specified, all attributes will be logged.").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor ATTRIBUTES_TO_IGNORE_CSV = new PropertyDescriptor.Builder().name("Attributes to Ignore").description("A comma-separated list of Attributes to ignore. If not specified, no attributes will be ignored.").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor LOG_PAYLOAD = new PropertyDescriptor.Builder().name("Log Payload").required(true).description("If true, the FlowFile's payload will be logged, in addition to its attributes; otherwise, just the Attributes will be logged.").defaultValue("false").allowableValues(new String[]{"true", "false"}).build();
    public static final PropertyDescriptor LOG_PREFIX = new PropertyDescriptor.Builder().name("Log prefix").required(false).description("Log prefix appended to the log lines. It helps to distinguish the output of multiple LogAttribute processors.").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(true).build();
    public static final String FIFTY_DASHES = "--------------------------------------------------";
    public static final long ONE_MB = 0x100000L;
    private Set<Relationship> relationships;
    private List<PropertyDescriptor> supportedDescriptors;
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("All FlowFiles are routed to this relationship").build();

    protected void init(ProcessorInitializationContext context) {
        HashSet<Relationship> procRels = new HashSet<Relationship>();
        procRels.add(REL_SUCCESS);
        this.relationships = Collections.unmodifiableSet(procRels);
        ArrayList<PropertyDescriptor> supDescriptors = new ArrayList<PropertyDescriptor>();
        supDescriptors.add(LOG_LEVEL);
        supDescriptors.add(LOG_PAYLOAD);
        supDescriptors.add(ATTRIBUTES_TO_LOG_CSV);
        supDescriptors.add(ATTRIBUTES_TO_IGNORE_CSV);
        supDescriptors.add(LOG_PREFIX);
        this.supportedDescriptors = Collections.unmodifiableList(supDescriptors);
    }

    public Set<Relationship> getRelationships() {
        return this.relationships;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.supportedDescriptors;
    }

    protected String processFlowFile(ProcessorLog logger, DebugLevels logLevel, FlowFile flowFile, ProcessSession session, ProcessContext context) {
        String dashedLine;
        Set<String> attributeKeys = this.getAttributesToLog(flowFile.getAttributes().keySet(), context);
        ProcessorLog LOG = this.getLogger();
        String logPrefix = context.getProperty(LOG_PREFIX).evaluateAttributeExpressions(flowFile).getValue();
        if (StringUtil.isBlank((String)logPrefix)) {
            dashedLine = StringUtils.repeat((char)'-', (int)50);
        } else {
            logPrefix = StringUtils.abbreviate((String)logPrefix, (int)40);
            logPrefix = StringUtils.center((String)logPrefix, (int)40, (char)'-');
            dashedLine = StringUtils.repeat((char)'-', (int)5) + logPrefix + StringUtils.repeat((char)'-', (int)5);
        }
        StringBuilder message = new StringBuilder();
        message.append("logging for flow file ").append(flowFile);
        message.append("\n");
        message.append(dashedLine);
        message.append("\nStandard FlowFile Attributes");
        message.append(String.format("\nKey: '%1$s'\n\tValue: '%2$s'", "entryDate", new Date(flowFile.getEntryDate())));
        message.append(String.format("\nKey: '%1$s'\n\tValue: '%2$s'", "lineageStartDate", new Date(flowFile.getLineageStartDate())));
        message.append(String.format("\nKey: '%1$s'\n\tValue: '%2$s'", "fileSize", flowFile.getSize()));
        message.append("\nFlowFile Attribute Map Content");
        for (String key : attributeKeys) {
            message.append(String.format("\nKey: '%1$s'\n\tValue: '%2$s'", key, flowFile.getAttribute(key)));
        }
        message.append("\n");
        message.append(dashedLine);
        boolean logPayload = context.getProperty(LOG_PAYLOAD).asBoolean();
        if (logPayload) {
            message.append("\n");
            if (flowFile.getSize() < 0x100000L) {
                FlowFilePayloadCallback callback = new FlowFilePayloadCallback();
                session.read(flowFile, (InputStreamCallback)callback);
                message.append(callback.getContents());
            } else {
                message.append("\n Not including payload since it is larger than one mb.");
            }
        }
        String outputMessage = message.toString().trim();
        switch (logLevel) {
            case info: {
                LOG.info(outputMessage);
                break;
            }
            case debug: {
                LOG.debug(outputMessage);
                break;
            }
            case warn: {
                LOG.warn(outputMessage);
                break;
            }
            case trace: {
                LOG.trace(outputMessage);
                break;
            }
            case error: {
                LOG.error(outputMessage);
                break;
            }
            default: {
                LOG.debug(outputMessage);
            }
        }
        return outputMessage;
    }

    private Set<String> getAttributesToLog(Set<String> flowFileAttrKeys, ProcessContext context) {
        TreeSet<String> result = new TreeSet<String>();
        String attrsToLogValue = context.getProperty(ATTRIBUTES_TO_LOG_CSV).getValue();
        if (StringUtils.isBlank((CharSequence)attrsToLogValue)) {
            result.addAll(flowFileAttrKeys);
        } else {
            result.addAll(Arrays.asList(attrsToLogValue.split("\\s*,\\s*")));
        }
        String attrsToRemoveValue = context.getProperty(ATTRIBUTES_TO_IGNORE_CSV).getValue();
        if (StringUtils.isNotBlank((CharSequence)attrsToRemoveValue)) {
            result.removeAll(Arrays.asList(attrsToRemoveValue.split("\\s*,\\s*")));
        }
        return result;
    }

    private void transferChunk(ProcessSession session) {
        List flowFiles = session.get(50);
        if (!flowFiles.isEmpty()) {
            session.transfer((Collection)flowFiles, REL_SUCCESS);
        }
    }

    public void onTrigger(ProcessContext context, ProcessSession session) {
        DebugLevels logLevel;
        String logLevelValue = context.getProperty(LOG_LEVEL).getValue().toLowerCase();
        try {
            logLevel = DebugLevels.valueOf(logLevelValue);
        }
        catch (Exception e) {
            throw new ProcessException((Throwable)e);
        }
        ProcessorLog LOG = this.getLogger();
        boolean isLogLevelEnabled = false;
        switch (logLevel) {
            case trace: {
                isLogLevelEnabled = LOG.isTraceEnabled();
                break;
            }
            case debug: {
                isLogLevelEnabled = LOG.isDebugEnabled();
                break;
            }
            case info: {
                isLogLevelEnabled = LOG.isInfoEnabled();
                break;
            }
            case warn: {
                isLogLevelEnabled = LOG.isWarnEnabled();
                break;
            }
            case error: {
                isLogLevelEnabled = LOG.isErrorEnabled();
            }
        }
        if (!isLogLevelEnabled) {
            this.transferChunk(session);
            return;
        }
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        this.processFlowFile(LOG, logLevel, flowFile, session, context);
        session.transfer(flowFile, REL_SUCCESS);
    }

    protected static class FlowFilePayloadCallback
    implements InputStreamCallback {
        private String contents = "";

        protected FlowFilePayloadCallback() {
        }

        public void process(InputStream in) throws IOException {
            this.contents = IOUtils.toString((InputStream)in);
        }

        public String getContents() {
            return this.contents;
        }
    }

    public static enum DebugLevels {
        trace,
        debug,
        info,
        warn,
        error;

    }
}

