/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.behavior.EventDriven;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.Stateful;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.state.Scope;
import org.apache.nifi.components.state.StateManager;
import org.apache.nifi.components.state.StateMap;
import org.apache.nifi.dbcp.DBCPService;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.ProcessorLog;
import org.apache.nifi.processor.AbstractSessionFactoryProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessSessionFactory;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.io.OutputStreamCallback;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.standard.util.JdbcCommon;
import org.apache.nifi.util.LongHolder;
import org.apache.nifi.util.StopWatch;

@EventDriven
@InputRequirement(value=InputRequirement.Requirement.INPUT_FORBIDDEN)
@Tags(value={"sql", "select", "jdbc", "query", "database"})
@CapabilityDescription(value="Execute provided SQL select query. Query result will be converted to Avro format. Streaming is used so arbitrarily large result sets are supported. This processor can be scheduled to run on a timer, or cron expression, using the standard scheduling methods, or it can be triggered by an incoming FlowFile. If it is triggered by an incoming FlowFile, then attributes of that FlowFile will be available when evaluating the select query. FlowFile attribute 'querydbtable.row.count' indicates how many rows were selected.")
@Stateful(scopes={Scope.CLUSTER}, description="After performing a query on the specified table, the maximum values for the specified column(s) will be retained for use in future executions of the query. This allows the Processor to fetch only those records that have max values greater than the retained values. This can be used for incremental fetching, fetching of newly added rows, etc. To clear the maximum values, clear the state of the processor per the State Management documentation")
@WritesAttribute(attribute="querydbtable.row.count")
public class QueryDatabaseTable
extends AbstractSessionFactoryProcessor {
    public static final String RESULT_ROW_COUNT = "querydbtable.row.count";
    public static final String SQL_PREPROCESS_STRATEGY_NONE = "None";
    public static final String SQL_PREPROCESS_STRATEGY_ORACLE = "Oracle";
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("Successfully created FlowFile from SQL query result set.").build();
    private final Set<Relationship> relationships;
    public static final PropertyDescriptor DBCP_SERVICE = new PropertyDescriptor.Builder().name("Database Connection Pooling Service").description("The Controller Service that is used to obtain a connection to the database.").required(true).identifiesControllerService(DBCPService.class).build();
    public static final PropertyDescriptor TABLE_NAME = new PropertyDescriptor.Builder().name("Table Name").description("The name of the database table to be queried.").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor COLUMN_NAMES = new PropertyDescriptor.Builder().name("Columns to Return").description("A comma-separated list of column names to be used in the query. If your database requires special treatment of the names (quoting, e.g.), each name should include such treatment. If no column names are supplied, all columns in the specified table will be returned.").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor MAX_VALUE_COLUMN_NAMES = new PropertyDescriptor.Builder().name("Maximum-value Columns").description("A comma-separated list of column names. The processor will keep track of the maximum value for each column that has been returned since the processor started running. This can be used to retrieve only those rows that have been added/updated since the last retrieval. Note that some JDBC types such as bit/boolean are not conducive to maintaining maximum value, so columns of these types should not be listed in this property, and will result in error(s) during processing.").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor QUERY_TIMEOUT = new PropertyDescriptor.Builder().name("Max Wait Time").description("The maximum amount of time allowed for a running SQL select query , zero means there is no limit. Max time less than 1 second will be equal to zero.").defaultValue("0 seconds").required(true).addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).build();
    public static final PropertyDescriptor SQL_PREPROCESS_STRATEGY = new PropertyDescriptor.Builder().name("SQL Pre-processing Strategy").description("The strategy to employ when generating the SQL for querying the table. A strategy may include custom or database-specific code, such as the treatment of time/date formats.").required(true).allowableValues(new String[]{"None", "Oracle"}).defaultValue("None").build();
    public static final PropertyDescriptor FETCH_SIZE = new PropertyDescriptor.Builder().name("Fetch Size").description("The number of result rows to be fetched from the result set at a time. This is a hint to the driver and may not be honored and/or exact. If the value specified is zero, then the hint is ignored.").defaultValue("0").required(true).addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).build();
    private final List<PropertyDescriptor> propDescriptors;
    protected final Map<String, Integer> columnTypeMap = new HashMap<String, Integer>();

    public QueryDatabaseTable() {
        HashSet<Relationship> r = new HashSet<Relationship>();
        r.add(REL_SUCCESS);
        this.relationships = Collections.unmodifiableSet(r);
        ArrayList<PropertyDescriptor> pds = new ArrayList<PropertyDescriptor>();
        pds.add(DBCP_SERVICE);
        pds.add(TABLE_NAME);
        pds.add(COLUMN_NAMES);
        pds.add(MAX_VALUE_COLUMN_NAMES);
        pds.add(QUERY_TIMEOUT);
        pds.add(SQL_PREPROCESS_STRATEGY);
        pds.add(FETCH_SIZE);
        this.propDescriptors = Collections.unmodifiableList(pds);
    }

    public Set<Relationship> getRelationships() {
        return this.relationships;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.propDescriptors;
    }

    @OnScheduled
    public void setup(ProcessContext context) {
        block28: {
            DBCPService dbcpService = (DBCPService)context.getProperty(DBCP_SERVICE).asControllerService(DBCPService.class);
            String tableName = context.getProperty(TABLE_NAME).getValue();
            String maxValueColumnNames = context.getProperty(MAX_VALUE_COLUMN_NAMES).getValue();
            try (Connection con = dbcpService.getConnection();
                 Statement st = con.createStatement();){
                String query = this.getSelectFromClause(tableName, maxValueColumnNames).append(" WHERE 1 = 0").toString();
                ResultSet resultSet = st.executeQuery(query);
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                int numCols = resultSetMetaData.getColumnCount();
                if (numCols > 0) {
                    this.columnTypeMap.clear();
                    for (int i = 1; i <= numCols; ++i) {
                        String colName = resultSetMetaData.getColumnName(i).toLowerCase();
                        int colType = resultSetMetaData.getColumnType(i);
                        this.columnTypeMap.put(colName, colType);
                    }
                    break block28;
                }
                throw new ProcessException("No columns found in table from those specified: " + maxValueColumnNames);
            }
            catch (SQLException e) {
                throw new ProcessException("Unable to communicate with database in order to determine column types", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void onTrigger(ProcessContext context, ProcessSessionFactory sessionFactory) throws ProcessException {
        block45: {
            String selectQuery;
            HashMap statePropertyMap;
            StateManager stateManager;
            ProcessorLog logger;
            FlowFile fileToProcess;
            ProcessSession session;
            block44: {
                StateMap stateMap;
                session = sessionFactory.createSession();
                fileToProcess = null;
                logger = this.getLogger();
                DBCPService dbcpService = (DBCPService)context.getProperty(DBCP_SERVICE).asControllerService(DBCPService.class);
                final String tableName = context.getProperty(TABLE_NAME).getValue();
                String columnNames = context.getProperty(COLUMN_NAMES).getValue();
                String maxValueColumnNames = context.getProperty(MAX_VALUE_COLUMN_NAMES).getValue();
                final String preProcessStrategy = context.getProperty(SQL_PREPROCESS_STRATEGY).getValue();
                Integer fetchSize = context.getProperty(FETCH_SIZE).asInteger();
                stateManager = context.getStateManager();
                try {
                    stateMap = stateManager.getState(Scope.CLUSTER);
                }
                catch (IOException ioe) {
                    this.getLogger().error("Failed to retrieve observed maximum values from the State Manager. Will not perform query until this is accomplished.", (Throwable)ioe);
                    context.yield();
                    return;
                }
                statePropertyMap = new HashMap(stateMap.toMap());
                selectQuery = this.getQuery(tableName, columnNames, this.getColumns(maxValueColumnNames), stateMap, preProcessStrategy);
                StopWatch stopWatch = new StopWatch(true);
                try (Connection con = dbcpService.getConnection();
                     final Statement st = con.createStatement();){
                    if (fetchSize != null && fetchSize > 0) {
                        try {
                            st.setFetchSize(fetchSize);
                        }
                        catch (SQLException se) {
                            logger.debug("Cannot set fetch size to {} due to {}", new Object[]{fetchSize, se.getLocalizedMessage()}, (Throwable)se);
                        }
                    }
                    Integer queryTimeout = context.getProperty(QUERY_TIMEOUT).asTimePeriod(TimeUnit.SECONDS).intValue();
                    st.setQueryTimeout(queryTimeout);
                    final LongHolder nrOfRows = new LongHolder(0L);
                    fileToProcess = session.create();
                    fileToProcess = session.write(fileToProcess, new OutputStreamCallback(){

                        public void process(OutputStream out) throws IOException {
                            try {
                                logger.debug("Executing query {}", new Object[]{selectQuery});
                                ResultSet resultSet = st.executeQuery(selectQuery);
                                MaxValueResultSetRowCollector maxValCollector = new MaxValueResultSetRowCollector(statePropertyMap, preProcessStrategy);
                                nrOfRows.set((Object)JdbcCommon.convertToAvroStream(resultSet, out, tableName, maxValCollector));
                            }
                            catch (SQLException e) {
                                throw new ProcessException("Error during database query or conversion of records to Avro", (Throwable)e);
                            }
                        }
                    });
                    if ((Long)nrOfRows.get() > 0L) {
                        fileToProcess = session.putAttribute(fileToProcess, RESULT_ROW_COUNT, ((Long)nrOfRows.get()).toString());
                        logger.info("{} contains {} Avro records; transferring to 'success'", new Object[]{fileToProcess, nrOfRows.get()});
                        String jdbcURL = "DBCPService";
                        try {
                            DatabaseMetaData databaseMetaData = con.getMetaData();
                            if (databaseMetaData != null) {
                                jdbcURL = databaseMetaData.getURL();
                            }
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                        session.getProvenanceReporter().receive(fileToProcess, jdbcURL, stopWatch.getElapsed(TimeUnit.MILLISECONDS));
                        session.transfer(fileToProcess, REL_SUCCESS);
                        break block44;
                    }
                    session.remove(fileToProcess);
                    context.yield();
                }
            }
            session.commit();
            try {
                stateManager.setState(statePropertyMap, Scope.CLUSTER);
            }
            catch (IOException ioe) {
                this.getLogger().error("{} failed to update State Manager, maximum observed values will not be recorded", new Object[]{this, ioe});
            }
            break block45;
            catch (SQLException | ProcessException e) {
                try {
                    logger.error("Unable to execute SQL select query {} due to {}", new Object[]{selectQuery, e});
                    if (fileToProcess != null) {
                        session.remove(fileToProcess);
                    }
                    context.yield();
                }
                catch (Throwable throwable) {
                    session.commit();
                    try {
                        stateManager.setState(statePropertyMap, Scope.CLUSTER);
                    }
                    catch (IOException ioe) {
                        this.getLogger().error("{} failed to update State Manager, maximum observed values will not be recorded", new Object[]{this, ioe});
                    }
                    throw throwable;
                }
                session.commit();
                try {
                    stateManager.setState(statePropertyMap, Scope.CLUSTER);
                }
                catch (IOException ioe) {
                    this.getLogger().error("{} failed to update State Manager, maximum observed values will not be recorded", new Object[]{this, ioe});
                }
            }
        }
    }

    protected List<String> getColumns(String commaSeparatedColumnList) {
        if (StringUtils.isEmpty((CharSequence)commaSeparatedColumnList)) {
            return Collections.emptyList();
        }
        String[] columns = commaSeparatedColumnList.split(",");
        ArrayList<String> columnList = new ArrayList<String>(columns.length);
        for (String column : columns) {
            String trimmedColumn;
            if (column == null || StringUtils.isEmpty((CharSequence)(trimmedColumn = column.trim()))) continue;
            columnList.add(trimmedColumn);
        }
        return columnList;
    }

    protected String getQuery(String tableName, String columnNames, List<String> maxValColumnNames, StateMap stateMap, String preProcessStrategy) {
        if (StringUtils.isEmpty((CharSequence)tableName)) {
            throw new IllegalArgumentException("Table name must be specified");
        }
        StringBuilder query = new StringBuilder(this.getSelectFromClause(tableName, columnNames));
        if (stateMap != null && stateMap.getVersion() != -1L && maxValColumnNames != null) {
            Map stateProperties = stateMap.toMap();
            ArrayList<String> whereClauses = new ArrayList<String>(maxValColumnNames.size());
            for (String colName : maxValColumnNames) {
                String maxValue = (String)stateProperties.get(colName.toLowerCase());
                if (StringUtils.isEmpty((CharSequence)maxValue)) continue;
                Integer type = this.columnTypeMap.get(colName.toLowerCase());
                if (type == null) {
                    throw new IllegalArgumentException("No column type found for: " + colName);
                }
                whereClauses.add(colName + " > " + this.getLiteralByType(type, maxValue, preProcessStrategy));
            }
            if (!whereClauses.isEmpty()) {
                query.append(" WHERE ");
                query.append(StringUtils.join(whereClauses, (String)" AND "));
            }
        }
        return query.toString();
    }

    protected StringBuilder getSelectFromClause(String tableName, String columnNames) {
        StringBuilder query = new StringBuilder("SELECT ");
        if (StringUtils.isEmpty((CharSequence)columnNames) || columnNames.trim().equals("*")) {
            query.append("*");
        } else {
            query.append(columnNames);
        }
        query.append(" FROM ");
        query.append(tableName);
        return query;
    }

    protected String getLiteralByType(int type, String value, String preProcessStrategy) {
        switch (type) {
            case -16: 
            case -15: 
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 12: 
            case 91: 
            case 92: {
                return "'" + value + "'";
            }
            case 93: {
                if (SQL_PREPROCESS_STRATEGY_ORACLE.equals(preProcessStrategy)) {
                    return "to_date('" + value + "', 'yyyy-mm-dd HH24:MI:SS')";
                }
                return "'" + value + "'";
            }
        }
        return value;
    }

    protected class MaxValueResultSetRowCollector
    implements JdbcCommon.ResultSetRowCallback {
        String preProcessStrategy;
        Map<String, String> newColMap;

        public MaxValueResultSetRowCollector(Map<String, String> stateMap, String preProcessStrategy) {
            this.preProcessStrategy = preProcessStrategy;
            this.newColMap = stateMap;
        }

        @Override
        public void processRow(ResultSet resultSet) throws IOException {
            if (resultSet == null) {
                return;
            }
            try {
                ResultSetMetaData meta = resultSet.getMetaData();
                int nrOfColumns = meta.getColumnCount();
                if (nrOfColumns > 0) {
                    block12: for (int i = 1; i <= nrOfColumns; ++i) {
                        String colName = meta.getColumnName(i).toLowerCase();
                        Integer type = QueryDatabaseTable.this.columnTypeMap.get(colName);
                        if (type == null || resultSet.getObject(i) == null) continue;
                        String maxValueString = this.newColMap.get(colName);
                        switch (type) {
                            case -16: 
                            case -15: 
                            case -9: 
                            case -8: 
                            case -1: 
                            case 1: 
                            case 12: {
                                String colStringValue = resultSet.getString(i);
                                if (maxValueString != null && colStringValue.compareTo(maxValueString) <= 0) continue block12;
                                this.newColMap.put(colName, colStringValue);
                                continue block12;
                            }
                            case -6: 
                            case 4: 
                            case 5: {
                                Integer colIntValue = resultSet.getInt(i);
                                Integer maxIntValue = null;
                                if (maxValueString != null) {
                                    maxIntValue = Integer.valueOf(maxValueString);
                                }
                                if (maxIntValue != null && colIntValue <= maxIntValue) continue block12;
                                this.newColMap.put(colName, colIntValue.toString());
                                continue block12;
                            }
                            case -5: {
                                Long colLongValue = resultSet.getLong(i);
                                Long maxLongValue = null;
                                if (maxValueString != null) {
                                    maxLongValue = Long.valueOf(maxValueString);
                                }
                                if (maxLongValue != null && colLongValue <= maxLongValue) continue block12;
                                this.newColMap.put(colName, colLongValue.toString());
                                continue block12;
                            }
                            case 6: 
                            case 7: 
                            case 8: {
                                Double colDoubleValue = resultSet.getDouble(i);
                                Double maxDoubleValue = null;
                                if (maxValueString != null) {
                                    maxDoubleValue = Double.valueOf(maxValueString);
                                }
                                if (maxDoubleValue != null && !(colDoubleValue > maxDoubleValue)) continue block12;
                                this.newColMap.put(colName, colDoubleValue.toString());
                                continue block12;
                            }
                            case 2: 
                            case 3: {
                                BigDecimal colBigDecimalValue = resultSet.getBigDecimal(i);
                                BigDecimal maxBigDecimalValue = null;
                                if (maxValueString != null) {
                                    DecimalFormat df = new DecimalFormat();
                                    df.setParseBigDecimal(true);
                                    maxBigDecimalValue = (BigDecimal)df.parse(maxValueString);
                                }
                                if (maxBigDecimalValue != null && colBigDecimalValue.compareTo(maxBigDecimalValue) <= 0) continue block12;
                                this.newColMap.put(colName, colBigDecimalValue.toString());
                                continue block12;
                            }
                            case 91: {
                                Date rawColDateValue = resultSet.getDate(i);
                                Date colDateValue = new Date(rawColDateValue.getTime());
                                Date maxDateValue = null;
                                if (maxValueString != null) {
                                    maxDateValue = Date.valueOf(maxValueString);
                                }
                                if (maxDateValue != null && !colDateValue.after(maxDateValue)) continue block12;
                                this.newColMap.put(colName, colDateValue.toString());
                                continue block12;
                            }
                            case 92: {
                                Date rawColTimeValue = resultSet.getDate(i);
                                Time colTimeValue = new Time(rawColTimeValue.getTime());
                                Time maxTimeValue = null;
                                if (maxValueString != null) {
                                    maxTimeValue = Time.valueOf(maxValueString);
                                }
                                if (maxTimeValue != null && !colTimeValue.after(maxTimeValue)) continue block12;
                                this.newColMap.put(colName, colTimeValue.toString());
                                continue block12;
                            }
                            case 93: {
                                if (QueryDatabaseTable.SQL_PREPROCESS_STRATEGY_ORACLE.equals(this.preProcessStrategy)) {
                                    Date rawColOracleTimestampValue = resultSet.getDate(i);
                                    Date oracleTimestampValue = new Date(rawColOracleTimestampValue.getTime());
                                    Date maxOracleTimestampValue = null;
                                    if (maxValueString != null) {
                                        maxOracleTimestampValue = Date.valueOf(maxValueString);
                                    }
                                    if (maxOracleTimestampValue != null && !oracleTimestampValue.after(maxOracleTimestampValue)) continue block12;
                                    this.newColMap.put(colName, oracleTimestampValue.toString());
                                    continue block12;
                                }
                                Timestamp rawColTimestampValue = resultSet.getTimestamp(i);
                                Timestamp colTimestampValue = new Timestamp(rawColTimestampValue.getTime());
                                Timestamp maxTimestampValue = null;
                                if (maxValueString != null) {
                                    maxTimestampValue = Timestamp.valueOf(maxValueString);
                                }
                                if (maxTimestampValue != null && !colTimestampValue.after(maxTimestampValue)) continue block12;
                                this.newColMap.put(colName, colTimestampValue.toString());
                                continue block12;
                            }
                            default: {
                                throw new IOException("Type " + meta.getColumnTypeName(i) + " is not valid for maintaining maximum value");
                            }
                        }
                    }
                }
            }
            catch (SQLException | ParseException e) {
                throw new IOException(e);
            }
        }
    }
}

