/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.util.crypto;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processors.standard.util.crypto.OpenSSLPKCS5CipherProvider;
import org.apache.nifi.processors.standard.util.crypto.PBECipherProvider;
import org.apache.nifi.security.util.EncryptionMethod;
import org.apache.nifi.stream.io.StreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class NiFiLegacyCipherProvider
extends OpenSSLPKCS5CipherProvider
implements PBECipherProvider {
    private static final Logger logger = LoggerFactory.getLogger(NiFiLegacyCipherProvider.class);
    private static final int ITERATION_COUNT = 1000;

    @Override
    @Deprecated
    public Cipher getCipher(EncryptionMethod encryptionMethod, String password, int keyLength, boolean encryptMode) throws Exception {
        return this.getCipher(encryptionMethod, password, new byte[0], keyLength, encryptMode);
    }

    @Override
    public Cipher getCipher(EncryptionMethod encryptionMethod, String password, byte[] salt, int keyLength, boolean encryptMode) throws Exception {
        try {
            return this.getInitializedCipher(encryptionMethod, password, salt, encryptMode);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ProcessException("Error initializing the cipher", (Throwable)e);
        }
    }

    public byte[] generateSalt(EncryptionMethod encryptionMethod) {
        byte[] salt = new byte[this.calculateSaltLength(encryptionMethod)];
        new SecureRandom().nextBytes(salt);
        return salt;
    }

    @Override
    protected void validateSalt(EncryptionMethod encryptionMethod, byte[] salt) {
        int saltLength = this.calculateSaltLength(encryptionMethod);
        if (salt.length != saltLength && salt.length != 0) {
            throw new IllegalArgumentException("Salt must be " + saltLength + " bytes or empty");
        }
    }

    private int calculateSaltLength(EncryptionMethod encryptionMethod) {
        try {
            Cipher cipher = Cipher.getInstance(encryptionMethod.getAlgorithm(), encryptionMethod.getProvider());
            return cipher.getBlockSize() > 0 ? cipher.getBlockSize() : this.getDefaultSaltLength();
        }
        catch (Exception e) {
            logger.warn("Encountered exception determining salt length from encryption method {}", (Object)encryptionMethod.getAlgorithm(), (Object)e);
            int defaultSaltLength = this.getDefaultSaltLength();
            logger.warn("Returning default length: {} bytes", (Object)defaultSaltLength);
            return defaultSaltLength;
        }
    }

    @Override
    public byte[] readSalt(InputStream in) throws IOException, ProcessException {
        return this.readSalt(EncryptionMethod.AES_CBC, in);
    }

    public byte[] readSalt(EncryptionMethod encryptionMethod, InputStream in) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException("Cannot read salt from null InputStream");
        }
        int saltLength = this.calculateSaltLength(encryptionMethod);
        if (in.available() < saltLength) {
            throw new ProcessException("The cipher stream is too small to contain the salt");
        }
        byte[] salt = new byte[saltLength];
        StreamUtils.fillBuffer((InputStream)in, (byte[])salt);
        return salt;
    }

    @Override
    public void writeSalt(byte[] salt, OutputStream out) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException("Cannot write salt to null OutputStream");
        }
        out.write(salt);
    }

    @Override
    protected int getIterationCount() {
        return 1000;
    }
}

