/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.relp.handler;

import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import java.util.concurrent.BlockingQueue;
import org.apache.nifi.logging.ProcessorLog;
import org.apache.nifi.processor.util.listen.dispatcher.AsyncChannelDispatcher;
import org.apache.nifi.processor.util.listen.event.Event;
import org.apache.nifi.processor.util.listen.event.EventFactory;
import org.apache.nifi.processor.util.listen.handler.socket.StandardSocketChannelHandler;
import org.apache.nifi.processor.util.listen.response.ChannelResponder;
import org.apache.nifi.processor.util.listen.response.socket.SocketChannelResponder;
import org.apache.nifi.processors.standard.relp.frame.RELPDecoder;
import org.apache.nifi.processors.standard.relp.frame.RELPFrame;
import org.apache.nifi.processors.standard.relp.frame.RELPFrameException;
import org.apache.nifi.processors.standard.relp.handler.RELPFrameHandler;

public class RELPSocketChannelHandler<E extends Event<SocketChannel>>
extends StandardSocketChannelHandler<E> {
    private RELPDecoder decoder;
    private RELPFrameHandler<E> frameHandler;

    public RELPSocketChannelHandler(SelectionKey key, AsyncChannelDispatcher dispatcher, Charset charset, EventFactory<E> eventFactory, BlockingQueue<E> events, ProcessorLog logger) {
        super(key, dispatcher, charset, eventFactory, events, logger);
        this.decoder = new RELPDecoder(charset);
        this.frameHandler = new RELPFrameHandler<E>(key, charset, eventFactory, events, dispatcher, logger);
    }

    protected void processBuffer(SocketChannel socketChannel, ByteBuffer socketBuffer) throws InterruptedException, IOException {
        int total = socketBuffer.remaining();
        InetAddress sender = socketChannel.socket().getInetAddress();
        try {
            for (int i = 0; i < total; ++i) {
                byte currByte = socketBuffer.get();
                if (!this.decoder.process(currByte)) continue;
                RELPFrame frame = this.decoder.getFrame();
                this.logger.debug("Received RELP frame with transaction {} and command {}", new Object[]{frame.getTxnr(), frame.getCommand()});
                SocketChannelResponder responder = new SocketChannelResponder(socketChannel);
                this.frameHandler.handle(frame, (ChannelResponder<SocketChannel>)responder, sender.toString());
                socketBuffer.mark();
            }
            this.logger.debug("Done processing buffer");
        }
        catch (RELPFrameException rfe) {
            this.logger.error("Error reading RELP frames due to {}", new Object[]{rfe.getMessage()}, (Throwable)rfe);
            ((AsyncChannelDispatcher)this.dispatcher).completeConnection(this.key);
        }
    }

    public byte getDelimiter() {
        return 10;
    }
}

