/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.behavior.EventDriven;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.Stateful;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.state.Scope;
import org.apache.nifi.components.state.StateManager;
import org.apache.nifi.components.state.StateMap;
import org.apache.nifi.dbcp.DBCPService;
import org.apache.nifi.expression.AttributeExpression;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessSessionFactory;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.standard.AbstractDatabaseFetchProcessor;
import org.apache.nifi.processors.standard.db.DatabaseAdapter;
import org.apache.nifi.processors.standard.util.JdbcCommon;
import org.apache.nifi.util.StopWatch;

@EventDriven
@InputRequirement(value=InputRequirement.Requirement.INPUT_FORBIDDEN)
@Tags(value={"sql", "select", "jdbc", "query", "database"})
@CapabilityDescription(value="Execute provided SQL select query. Query result will be converted to Avro format. Streaming is used so arbitrarily large result sets are supported. This processor can be scheduled to run on a timer, or cron expression, using the standard scheduling methods, or it can be triggered by an incoming FlowFile. If it is triggered by an incoming FlowFile, then attributes of that FlowFile will be available when evaluating the select query. FlowFile attribute 'querydbtable.row.count' indicates how many rows were selected.")
@Stateful(scopes={Scope.CLUSTER}, description="After performing a query on the specified table, the maximum values for the specified column(s) will be retained for use in future executions of the query. This allows the Processor to fetch only those records that have max values greater than the retained values. This can be used for incremental fetching, fetching of newly added rows, etc. To clear the maximum values, clear the state of the processor per the State Management documentation")
@WritesAttributes(value={@WritesAttribute(attribute="querydbtable.row.count"), @WritesAttribute(attribute="fragment.identifier", description="If 'Max Rows Per Flow File' is set then all FlowFiles from the same query result set will have the same value for the fragment.identifier attribute. This can then be used to correlate the results."), @WritesAttribute(attribute="fragment.count", description="If 'Max Rows Per Flow File' is set then this is the total number of  FlowFiles produced by a single ResultSet. This can be used in conjunction with the fragment.identifier attribute in order to know how many FlowFiles belonged to the same incoming ResultSet."), @WritesAttribute(attribute="fragment.index", description="If 'Max Rows Per Flow File' is set then the position of this FlowFile in the list of outgoing FlowFiles that were all derived from the same result set FlowFile. This can be used in conjunction with the fragment.identifier attribute to know which FlowFiles originated from the same query result set and in what order  FlowFiles were produced"), @WritesAttribute(attribute="maxvalue.*", description="Each attribute contains the observed maximum value of a specified 'Maximum-value Column'. The suffix of the attribute is the name of the column")})
@DynamicProperty(name="Initial Max Value", value="Attribute Expression Language", supportsExpressionLanguage=false, description="Specifies an initial max value for max value columns. Properties should be added in the format `initial.maxvalue.{max_value_column}`.")
public class QueryDatabaseTable
extends AbstractDatabaseFetchProcessor {
    public static final String RESULT_ROW_COUNT = "querydbtable.row.count";
    public static final String INTIIAL_MAX_VALUE_PROP_START = "initial.maxvalue.";
    public static final PropertyDescriptor FETCH_SIZE = new PropertyDescriptor.Builder().name("Fetch Size").description("The number of result rows to be fetched from the result set at a time. This is a hint to the driver and may not be honored and/or exact. If the value specified is zero, then the hint is ignored.").defaultValue("0").required(true).addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).build();
    public static final PropertyDescriptor MAX_ROWS_PER_FLOW_FILE = new PropertyDescriptor.Builder().name("qdbt-max-rows").displayName("Max Rows Per Flow File").description("The maximum number of result rows that will be included in a single FlowFile. This will allow you to break up very large result sets into multiple FlowFiles. If the value specified is zero, then all rows are returned in a single FlowFile.").defaultValue("0").required(true).addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).build();

    public QueryDatabaseTable() {
        HashSet<Relationship> r = new HashSet<Relationship>();
        r.add(REL_SUCCESS);
        this.relationships = Collections.unmodifiableSet(r);
        ArrayList<PropertyDescriptor> pds = new ArrayList<PropertyDescriptor>();
        pds.add(DBCP_SERVICE);
        pds.add(DB_TYPE);
        pds.add(TABLE_NAME);
        pds.add(COLUMN_NAMES);
        pds.add(MAX_VALUE_COLUMN_NAMES);
        pds.add(QUERY_TIMEOUT);
        pds.add(FETCH_SIZE);
        pds.add(MAX_ROWS_PER_FLOW_FILE);
        pds.add(NORMALIZE_NAMES_FOR_AVRO);
        this.propDescriptors = Collections.unmodifiableList(pds);
    }

    public Set<Relationship> getRelationships() {
        return this.relationships;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.propDescriptors;
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return new PropertyDescriptor.Builder().name(propertyDescriptorName).required(false).addValidator(StandardValidators.createAttributeExpressionLanguageValidator((AttributeExpression.ResultType)AttributeExpression.ResultType.STRING, (boolean)true)).addValidator(StandardValidators.ATTRIBUTE_KEY_PROPERTY_NAME_VALIDATOR).expressionLanguageSupported(true).dynamic(true).build();
    }

    @Override
    @OnScheduled
    public void setup(ProcessContext context) {
        super.setup(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void onTrigger(ProcessContext context, ProcessSessionFactory sessionFactory) throws ProcessException {
        block53: {
            StateMap stateMap;
            ProcessSession session = sessionFactory.createSession();
            ArrayList<FlowFile> resultSetFlowFiles = new ArrayList<FlowFile>();
            ComponentLog logger = this.getLogger();
            DBCPService dbcpService = (DBCPService)context.getProperty(DBCP_SERVICE).asControllerService(DBCPService.class);
            DatabaseAdapter dbAdapter = (DatabaseAdapter)dbAdapters.get(context.getProperty(DB_TYPE).getValue());
            String tableName = context.getProperty(TABLE_NAME).getValue();
            String columnNames = context.getProperty(COLUMN_NAMES).getValue();
            String maxValueColumnNames = context.getProperty(MAX_VALUE_COLUMN_NAMES).getValue();
            Integer fetchSize = context.getProperty(FETCH_SIZE).asInteger();
            Integer maxRowsPerFlowFile = context.getProperty(MAX_ROWS_PER_FLOW_FILE).asInteger();
            boolean convertNamesForAvro = context.getProperty(NORMALIZE_NAMES_FOR_AVRO).asBoolean();
            Map<String, String> maxValueProperties = this.getDefaultMaxValueProperties(context.getProperties());
            StateManager stateManager = context.getStateManager();
            try {
                stateMap = stateManager.getState(Scope.CLUSTER);
            }
            catch (IOException ioe) {
                this.getLogger().error("Failed to retrieve observed maximum values from the State Manager. Will not perform query until this is accomplished.", (Throwable)ioe);
                context.yield();
                return;
            }
            HashMap<String, String> statePropertyMap = new HashMap<String, String>(stateMap.toMap());
            for (Map.Entry<String, String> maxProp : maxValueProperties.entrySet()) {
                if (statePropertyMap.containsKey(maxProp.getKey())) continue;
                statePropertyMap.put(maxProp.getKey(), maxProp.getValue());
            }
            List<String> maxValueColumnNameList = StringUtils.isEmpty((CharSequence)maxValueColumnNames) ? null : Arrays.asList(maxValueColumnNames.split("\\s*,\\s*"));
            String selectQuery = this.getQuery(dbAdapter, tableName, columnNames, maxValueColumnNameList, statePropertyMap);
            StopWatch stopWatch = new StopWatch(true);
            String fragmentIdentifier = UUID.randomUUID().toString();
            try (Connection con = dbcpService.getConnection();
                 Statement st = con.createStatement();){
                FlowFile fileToProcess;
                if (fetchSize != null && fetchSize > 0) {
                    try {
                        st.setFetchSize(fetchSize);
                    }
                    catch (SQLException se) {
                        logger.debug("Cannot set fetch size to {} due to {}", new Object[]{fetchSize, se.getLocalizedMessage()}, (Throwable)se);
                    }
                }
                String jdbcURL = "DBCPService";
                try {
                    DatabaseMetaData databaseMetaData = con.getMetaData();
                    if (databaseMetaData != null) {
                        jdbcURL = databaseMetaData.getURL();
                    }
                }
                catch (SQLException databaseMetaData) {
                    // empty catch block
                }
                Integer queryTimeout = context.getProperty(QUERY_TIMEOUT).asTimePeriod(TimeUnit.SECONDS).intValue();
                st.setQueryTimeout(queryTimeout);
                logger.debug("Executing query {}", new Object[]{selectQuery});
                ResultSet resultSet = st.executeQuery(selectQuery);
                int fragmentIndex = 0;
                while (true) {
                    AtomicLong nrOfRows = new AtomicLong(0L);
                    fileToProcess = session.create();
                    try {
                        fileToProcess = session.write(fileToProcess, out -> {
                            MaxValueResultSetRowCollector maxValCollector = new MaxValueResultSetRowCollector(statePropertyMap, dbAdapter);
                            try {
                                nrOfRows.set(JdbcCommon.convertToAvroStream(resultSet, out, tableName, maxValCollector, maxRowsPerFlowFile, convertNamesForAvro));
                            }
                            catch (RuntimeException | SQLException e) {
                                throw new ProcessException("Error during database query or conversion of records to Avro.", (Throwable)e);
                            }
                        });
                    }
                    catch (ProcessException e) {
                        resultSetFlowFiles.add(fileToProcess);
                        throw e;
                    }
                    if (nrOfRows.get() <= 0L) break;
                    fileToProcess = session.putAttribute(fileToProcess, RESULT_ROW_COUNT, String.valueOf(nrOfRows.get()));
                    if (maxRowsPerFlowFile > 0) {
                        fileToProcess = session.putAttribute(fileToProcess, "fragment.identifier", fragmentIdentifier);
                        fileToProcess = session.putAttribute(fileToProcess, "fragment.index", String.valueOf(fragmentIndex));
                    }
                    logger.info("{} contains {} Avro records; transferring to 'success'", new Object[]{fileToProcess, nrOfRows.get()});
                    session.getProvenanceReporter().receive(fileToProcess, jdbcURL, stopWatch.getElapsed(TimeUnit.MILLISECONDS));
                    resultSetFlowFiles.add(fileToProcess);
                    ++fragmentIndex;
                }
                session.remove(fileToProcess);
                context.yield();
                for (int i = 0; i < resultSetFlowFiles.size(); ++i) {
                    for (Map.Entry entry : statePropertyMap.entrySet()) {
                        resultSetFlowFiles.set(i, session.putAttribute((FlowFile)resultSetFlowFiles.get(i), "maxvalue." + (String)entry.getKey(), (String)entry.getValue()));
                    }
                    if (maxRowsPerFlowFile <= 0) continue;
                    resultSetFlowFiles.set(i, session.putAttribute((FlowFile)resultSetFlowFiles.get(i), "fragment.count", Integer.toString(fragmentIndex)));
                }
                session.transfer(resultSetFlowFiles, REL_SUCCESS);
            }
            session.commit();
            try {
                stateManager.setState(statePropertyMap, Scope.CLUSTER);
            }
            catch (IOException ioe) {
                this.getLogger().error("{} failed to update State Manager, maximum observed values will not be recorded", new Object[]{this, ioe});
            }
            break block53;
            catch (SQLException | ProcessException e) {
                try {
                    logger.error("Unable to execute SQL select query {} due to {}", new Object[]{selectQuery, e});
                    if (!resultSetFlowFiles.isEmpty()) {
                        session.remove(resultSetFlowFiles);
                    }
                    context.yield();
                }
                catch (Throwable throwable) {
                    session.commit();
                    try {
                        stateManager.setState(statePropertyMap, Scope.CLUSTER);
                    }
                    catch (IOException ioe) {
                        this.getLogger().error("{} failed to update State Manager, maximum observed values will not be recorded", new Object[]{this, ioe});
                    }
                    throw throwable;
                }
                session.commit();
                try {
                    stateManager.setState(statePropertyMap, Scope.CLUSTER);
                }
                catch (IOException ioe) {
                    this.getLogger().error("{} failed to update State Manager, maximum observed values will not be recorded", new Object[]{this, ioe});
                }
            }
        }
    }

    protected String getQuery(DatabaseAdapter dbAdapter, String tableName, String columnNames, List<String> maxValColumnNames, Map<String, String> stateMap) {
        if (StringUtils.isEmpty((CharSequence)tableName)) {
            throw new IllegalArgumentException("Table name must be specified");
        }
        StringBuilder query = new StringBuilder(dbAdapter.getSelectStatement(tableName, columnNames, null, null, null, null));
        if (stateMap != null && !stateMap.isEmpty() && maxValColumnNames != null) {
            ArrayList whereClauses = new ArrayList(maxValColumnNames.size());
            IntStream.range(0, maxValColumnNames.size()).forEach(index -> {
                String colName = (String)maxValColumnNames.get(index);
                String maxValue = (String)stateMap.get(colName.toLowerCase());
                if (!StringUtils.isEmpty((CharSequence)maxValue)) {
                    Integer type = (Integer)this.columnTypeMap.get(colName.toLowerCase());
                    if (type == null) {
                        throw new IllegalArgumentException("No column type found for: " + colName);
                    }
                    whereClauses.add(colName + (index == 0 ? " > " : " >= ") + QueryDatabaseTable.getLiteralByType(type, maxValue, dbAdapter.getName()));
                }
            });
            if (!whereClauses.isEmpty()) {
                query.append(" WHERE ");
                query.append(StringUtils.join(whereClauses, (String)" AND "));
            }
        }
        return query.toString();
    }

    protected Map<String, String> getDefaultMaxValueProperties(Map<PropertyDescriptor, String> properties) {
        HashMap<String, String> defaultMaxValues = new HashMap<String, String>();
        for (Map.Entry<PropertyDescriptor, String> entry : properties.entrySet()) {
            String key = entry.getKey().getName();
            if (!key.startsWith(INTIIAL_MAX_VALUE_PROP_START)) continue;
            defaultMaxValues.put(key.substring(INTIIAL_MAX_VALUE_PROP_START.length()), entry.getValue());
        }
        return defaultMaxValues;
    }

    protected class MaxValueResultSetRowCollector
    implements JdbcCommon.ResultSetRowCallback {
        DatabaseAdapter dbAdapter;
        Map<String, String> newColMap;

        public MaxValueResultSetRowCollector(Map<String, String> stateMap, DatabaseAdapter dbAdapter) {
            this.dbAdapter = dbAdapter;
            this.newColMap = stateMap;
        }

        @Override
        public void processRow(ResultSet resultSet) throws IOException {
            if (resultSet == null) {
                return;
            }
            try {
                ResultSetMetaData meta = resultSet.getMetaData();
                int nrOfColumns = meta.getColumnCount();
                if (nrOfColumns > 0) {
                    for (int i = 1; i <= nrOfColumns; ++i) {
                        String maxValueString;
                        String newMaxValueString;
                        String colName = meta.getColumnName(i).toLowerCase();
                        Integer type = (Integer)QueryDatabaseTable.this.columnTypeMap.get(colName);
                        if (type == null || resultSet.getObject(i) == null || (newMaxValueString = AbstractDatabaseFetchProcessor.getMaxValueFromRow(resultSet, i, type, maxValueString = this.newColMap.get(colName), this.dbAdapter.getName())) == null) continue;
                        this.newColMap.put(colName, newMaxValueString);
                    }
                }
            }
            catch (SQLException | ParseException e) {
                throw new IOException(e);
            }
        }
    }
}

